/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import com.tc.object.bytecode.NotClearable;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.TerracottaDistributedCache;
import org.terracotta.cache.TimeSource;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.collections.ClusteredMap;
import org.terracotta.collections.MutatedObjectHandle;
import org.terracotta.collections.MutationCallback;
import org.terracotta.locking.ClusteredLock;
import org.terracotta.meta.MetaData;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.modules.ehcache.store.ClusteredStoreBackend;
import org.terracotta.modules.ehcache.store.SearchConstants;
import org.terracotta.modules.ehcache.store.ValueModeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredStoreBackendImpl<K, V>
implements ClusteredStoreBackend<K, V>,
NotClearable {
    private final TerracottaDistributedCache<K, V> tdc;
    private final ValueModeHandler valueModeHandler;
    private final String cacheName;
    private transient RegisteredEventListeners registeredEventListeners;
    private volatile transient ClusteredStore clusteredStore;

    public ClusteredStoreBackendImpl(CacheConfig config, ClusteredMap cdm, ValueModeHandler valueModeHandler, RegisteredEventListeners listeners, String cacheName, ClusteredStore clusteredStore) {
        this.cacheName = cacheName;
        this.tdc = new TDCWithEvents(config, cdm);
        this.valueModeHandler = valueModeHandler;
        this.initializeTransients(listeners, clusteredStore);
    }

    @Override
    public void loadReferences() {
        this.tdc.initializeLocalCache();
        this.valueModeHandler.getClass();
    }

    public TerracottaDistributedCache<K, V> getTerracottaDistributedCache() {
        return this.tdc;
    }

    @Override
    public final void initializeTransients(RegisteredEventListeners listeners, ClusteredStore store) {
        this.registeredEventListeners = listeners;
        this.clusteredStore = store;
    }

    @Override
    public void clearLocalCache() {
        this.tdc.clearLocalCache();
    }

    @Override
    public void unpinAll() {
        this.tdc.unpinAll();
    }

    @Override
    public boolean isPinned(Object key) {
        return this.tdc.isPinned(key);
    }

    @Override
    public void setPinned(Object key, boolean pinned) {
        this.tdc.setPinned(key, pinned);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.tdc.containsKey(key);
    }

    @Override
    public boolean containsLocalKey(K key) {
        return this.tdc.containsLocalKey(key);
    }

    @Override
    public boolean unlockedContainsLocalKey(K key) {
        return this.containsLocalKey(key);
    }

    @Override
    public TimestampedValue<V> getTimestampedValue(K key) {
        return this.tdc.getTimestampedValue(key);
    }

    @Override
    public TimestampedValue<V> getTimestampedValueQuiet(K key) {
        return this.tdc.getTimestampedValueQuiet(key);
    }

    @Override
    public Map<K, TimestampedValue<V>> getTimestampedValues(Set<K> keys, boolean quiet) {
        return this.tdc.getTimestampedValues(keys, quiet);
    }

    @Override
    public TimestampedValue<V> removeTimestampedValue(K key, MetaData searchMetaData) {
        if (searchMetaData != null) {
            return this.tdc.removeTimestampedValueWithCallback(key, this.createCallback(searchMetaData));
        }
        return this.tdc.removeTimestampedValue(key);
    }

    @Override
    public Set<K> keySet() {
        return this.tdc.keySet();
    }

    @Override
    public Set<K> localKeySet() {
        return this.tdc.localKeySet();
    }

    @Override
    public void clear(MetaData searchMetaData) {
        if (searchMetaData != null) {
            this.tdc.clearWithCallback(this.createCallback(searchMetaData));
        } else {
            this.tdc.clear();
        }
    }

    @Override
    public int size() {
        return this.tdc.size();
    }

    @Override
    public int localSize() {
        return this.tdc.localSize();
    }

    @Override
    public void shutdown() {
        this.tdc.shutdown();
    }

    @Override
    public TimeSource getTimeSource() {
        return this.tdc.getTimeSource();
    }

    @Override
    public void unlockedReplaceNoReturn(K key, V currentValue, V newValue, MetaData searchMetaData) {
        if (searchMetaData != null) {
            this.tdc.unlockedReplaceNoReturnWithCallback(key, currentValue, newValue, this.createCallback(searchMetaData));
        } else {
            this.tdc.unlockedReplaceNoReturn(key, currentValue, newValue);
        }
    }

    @Override
    public void unlockedRemoveNoReturn(K key, V oldValue, MetaData searchMetaData) {
        if (searchMetaData != null) {
            this.tdc.unlockedRemoveNoReturnWithCallback(key, oldValue, this.createCallback(searchMetaData));
        } else {
            this.tdc.unlockedRemoveNoReturn(key, oldValue);
        }
    }

    @Override
    public void unlockedPutIfAbsentNoReturn(K key, V value, MetaData searchMetaData) {
        if (searchMetaData != null) {
            this.tdc.unlockedPutIfAbsentNoReturnWithCallback(key, value, this.createCallback(searchMetaData));
        } else {
            this.tdc.unlockedPutIfAbsentNoReturn(key, value);
        }
    }

    @Override
    public void putNoReturn(K key, V value, MetaData searchMetaData) {
        if (searchMetaData != null) {
            this.tdc.putNoReturnWithCallback(key, value, this.createCallback(searchMetaData));
        } else {
            this.tdc.putNoReturn(key, value);
        }
    }

    @Override
    public void unlockedPutNoReturn(K key, V value, MetaData searchMetaData) {
        if (searchMetaData != null) {
            this.tdc.unlockedPutNoReturnWithCallback(key, value, this.createCallback(searchMetaData));
        } else {
            this.tdc.unlockedPutNoReturn(key, value);
        }
    }

    @Override
    public TimestampedValue<V> unsafeGetTimestampedValue(K key, boolean quiet) {
        return this.tdc.unsafeGetTimestampedValue(key, quiet);
    }

    @Override
    public TimestampedValue<V> unlockedGetTimestampedValue(K key, boolean quiet) {
        return this.tdc.unlockedGetTimestampedValue(key, quiet);
    }

    @Override
    public Map<K, TimestampedValue<V>> unlockedGetAllTimeStampedValues(Set<K> keys, boolean quiet) {
        return this.tdc.unlockedGetAllTimestampedValue(keys, quiet);
    }

    @Override
    public boolean unlockedContainsKey(Object key) {
        return this.tdc.unlockedContainsKey(key);
    }

    @Override
    public void removeNoReturn(K key, MetaData searchMetaData) {
        if (searchMetaData != null) {
            this.tdc.removeNoReturnWithCallback(key, this.createCallback(searchMetaData));
        } else {
            this.tdc.removeNoReturn(key);
        }
    }

    @Override
    public void unlockedRemoveNoReturn(Object key, MetaData searchMetaData) {
        if (searchMetaData != null) {
            this.tdc.unlockedRemoveNoReturnWithCallback(key, this.createCallback(searchMetaData));
        } else {
            this.tdc.unlockedRemoveNoReturn(key);
        }
    }

    @Override
    public CacheConfig getConfig() {
        return this.tdc.getConfig();
    }

    @Override
    public ClusteredLock createFinegrainedLock(K key) {
        return this.tdc.createFinegrainedLock(key);
    }

    private MutationCallback<K, TimestampedValue<V>> createCallback(MetaData metaData) {
        if (metaData == null) {
            throw new AssertionError();
        }
        return new MetaDataCallback(metaData);
    }

    @Override
    public void recalculateLocalCacheSize(Object key) {
        this.tdc.recalculateLocalCacheSize(key);
    }

    @Override
    public long localOnHeapSizeInBytes() {
        return this.tdc.localOnHeapSizeInBytes();
    }

    @Override
    public long localOffHeapSizeInBytes() {
        return this.tdc.localOffHeapSizeInBytes();
    }

    @Override
    public int localOnHeapSize() {
        return this.tdc.localOnHeapSize();
    }

    @Override
    public int localOffHeapSize() {
        return this.tdc.localOffHeapSize();
    }

    @Override
    public boolean containsKeyLocalOnHeap(K key) {
        return this.tdc.containsKeyLocalOnHeap(key);
    }

    @Override
    public boolean containsKeyLocalOffHeap(K key) {
        return this.tdc.containsKeyLocalOffHeap(key);
    }

    @Override
    public void setTargetMaxTotalCount(int targetMaxTotalCount) {
        this.tdc.setTargetMaxTotalCount(targetMaxTotalCount);
        this.getConfig().setTargetMaxTotalCount(targetMaxTotalCount);
    }

    @Override
    public void setMaxTTI(int maxTTI) {
        this.tdc.setMaxTTI(maxTTI);
        this.getConfig().setMaxTTISeconds(maxTTI);
    }

    @Override
    public void setMaxTTL(int maxTTL) {
        this.tdc.setMaxTTL(maxTTL);
        this.getConfig().setMaxTTLSeconds(maxTTL);
    }

    @Override
    public void setTargetMaxInMemoryCount(int targetMaxInMemoryCount) {
        this.tdc.setMaxEntriesLocalHeap(targetMaxInMemoryCount);
    }

    @Override
    public void setLoggingEnabled(boolean loggingEnabled) {
        this.getConfig().setLoggingEnabled(loggingEnabled);
    }

    @Override
    public void setMaxBytesLocalHeap(long maxBytesLocalHeap) {
        this.tdc.setMaxBytesLocalHeap(maxBytesLocalHeap);
    }

    @Override
    public void setLocalCacheEnabled(boolean enabled) {
        this.tdc.setLocalCacheEnabled(enabled);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MetaDataCallback
    implements MutationCallback<K, TimestampedValue<V>> {
        private final MetaData metaData;

        MetaDataCallback(MetaData metaData) {
            this.metaData = metaData;
        }

        public void putEvent(K key, TimestampedValue<V> value, MutatedObjectHandle handle) {
            this.metaData.set("COMMAND@", (Object)"PUT");
            this.metaData.addOidFor("VALUE@", value);
            handle.addMetaData(this.metaData);
        }

        public void clearEvent(MutatedObjectHandle handle) {
            this.metaData.set("COMMAND@", SearchConstants.CLEAR_COMMAND);
            handle.addMetaData(this.metaData);
        }

        public void removeEvent(K key, MutatedObjectHandle handle) {
            this.metaData.set("COMMAND@", SearchConstants.REMOVE_COMMAND);
            this.metaData.add("KEY@", key.toString());
            handle.addMetaData(this.metaData);
        }

        public void replaceEvent(K key, TimestampedValue<V> currentValue, TimestampedValue<V> newValue, MutatedObjectHandle handle) {
            this.metaData.set("COMMAND@", SearchConstants.REPLACE_COMMAND);
            this.metaData.addOidFor("VALUE@", newValue);
            this.metaData.addOidFor("PREV_VALUE@", currentValue);
            handle.addMetaData(this.metaData);
        }

        public void putIfAbsentEvent(K key, TimestampedValue<V> value, MutatedObjectHandle handle) {
            this.metaData.set("COMMAND@", (Object)"PUT_IF_ABSENT");
            this.metaData.addOidFor("VALUE@", value);
            handle.addMetaData(this.metaData);
        }

        public void removeIfValueEqualEvent(K key, TimestampedValue<V> value, MutatedObjectHandle handle) {
            this.metaData.set("COMMAND@", SearchConstants.REMOVE_IF_VALUE_EQUAL_COMMAND);
            this.metaData.add("", 1);
            this.metaData.add("", key);
            this.metaData.addOidFor("", value);
            handle.addMetaData(this.metaData);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TDCWithEvents
    extends TerracottaDistributedCache<K, V> {
        public TDCWithEvents(CacheConfig config, ClusteredMap cdm) {
            super(config, cdm);
        }

        protected void onEvict(K key, TimestampedValue<V> value) {
            Element element = null;
            element = value == null ? new Element(ClusteredStoreBackendImpl.this.valueModeHandler.getRealKeyObject(key), null) : ClusteredStoreBackendImpl.this.valueModeHandler.createElement(ClusteredStoreBackendImpl.this.valueModeHandler.getRealKeyObject(key), value);
            ClusteredStoreBackendImpl.this.registeredEventListeners.notifyElementEvicted(element, false);
        }

        protected void onExpiry(K key, TimestampedValue<V> value) {
            Element element = null;
            element = value == null ? new Element(ClusteredStoreBackendImpl.this.valueModeHandler.getRealKeyObject(key), null) : ClusteredStoreBackendImpl.this.valueModeHandler.createElement(ClusteredStoreBackendImpl.this.valueModeHandler.getRealKeyObject(key), value);
            ClusteredStoreBackendImpl.this.registeredEventListeners.notifyElementExpiry(element, false);
        }

        protected MutationCallback<K, TimestampedValue<V>> getEvictRemoveCallback() {
            if (!ClusteredStoreBackendImpl.this.clusteredStore.isSearchable()) {
                return null;
            }
            MetaData metaData = MetaData.create((String)"SEARCH");
            metaData.add("CACHENAME@", ClusteredStoreBackendImpl.this.cacheName);
            metaData.add("COMMAND@", "NOT-SET");
            return new MetaDataCallback(metaData);
        }
    }
}

