/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.event.EventListenerList;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.ElementEvictionData;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.SizeOfPolicyConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.FifoPolicy;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.LruPolicy;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreListener;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TerracottaStore;
import net.sf.ehcache.util.lang.VicariousThreadLocal;
import net.sf.ehcache.writer.CacheWriterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.api.Terracotta;
import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.MutableConfig;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.cache.evictor.CapacityEvictionPolicyData;
import org.terracotta.cache.evictor.LFUCapacityEvictionPolicyData;
import org.terracotta.cache.evictor.LRUCapacityEvictionPolicyData;
import org.terracotta.cache.logging.ConfigChangeListener;
import org.terracotta.cluster.ClusterLogger;
import org.terracotta.cluster.TerracottaLogger;
import org.terracotta.cluster.TerracottaProperties;
import org.terracotta.collections.ClusteredMap;
import org.terracotta.collections.ConcurrentDistributedMap;
import org.terracotta.collections.ConcurrentDistributedServerMap;
import org.terracotta.collections.ConcurrentDistributedServerMapParameters;
import org.terracotta.collections.servermap.ServerMapLocalStoreConfig;
import org.terracotta.collections.servermap.ServerMapLocalStoreConfigParameters;
import org.terracotta.locking.ClusteredLock;
import org.terracotta.locking.GenericLockStrategy;
import org.terracotta.locking.LockType;
import org.terracotta.locking.strategy.LongLockStrategy;
import org.terracotta.meta.MetaData;
import org.terracotta.modules.ehcache.coherence.CacheCoherence;
import org.terracotta.modules.ehcache.coherence.CacheShutdownHook;
import org.terracotta.modules.ehcache.coherence.IncoherentNodesSet;
import org.terracotta.modules.ehcache.concurrency.TcCacheLockProvider;
import org.terracotta.modules.ehcache.store.ClusteredElementEvictionData;
import org.terracotta.modules.ehcache.store.ClusteredStoreBackend;
import org.terracotta.modules.ehcache.store.ClusteredStoreBackendImpl;
import org.terracotta.modules.ehcache.store.LocalBufferedMap;
import org.terracotta.modules.ehcache.store.ValueModeHandler;
import org.terracotta.modules.ehcache.store.ValueModeHandlerFactory;
import org.terracotta.modules.ehcache.store.backend.BackendStore;
import org.terracotta.modules.ehcache.store.backend.BulkLoadBackend;
import org.terracotta.modules.ehcache.store.backend.NonStrictBackend;
import org.terracotta.modules.ehcache.store.backend.StrictBackend;
import org.terracotta.modules.ehcache.store.servermap.ServerMapLocalStoreFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredStore
implements TerracottaStore,
CacheConfigurationListener,
ConfigChangeListener {
    private static final Policy LFU_POLICY_INSTANCE = new LfuPolicy();
    private static final Policy LRU_POLICY_INSTANCE = new LruPolicy();
    private static final Logger LOG = LoggerFactory.getLogger((String)ClusteredStore.class.getName());
    private static final ClusterLogger TC_LOGGER = new TerracottaLogger(ClusteredStore.class.getName());
    private static final TerracottaProperties TC_PROPERTIES = new TerracottaProperties();
    private static final String CHECK_CONTAINS_KEY_ON_PUT = "ehcache.clusteredStore.checkContainsKeyOnPut";
    private static final ThreadLocal<SyncLockState> syncLockState = new VicariousThreadLocal<SyncLockState>(){

        protected SyncLockState initialValue() {
            return SyncLockState.UNLOCKED;
        }
    };
    private final ClusteredStoreBackend<Object, Object> backend;
    protected final ValueModeHandler valueModeHandler;
    private final int localKeyCacheMaxsize;
    private final CacheCoherence cacheCoherence;
    protected final String qualifiedCacheName;
    private final boolean isIdentity;
    private final boolean isClassic;
    private final TerracottaConfiguration.Consistency initialCoherenceMode;
    private final CacheConfiguration.TransactionalMode transactionalMode;
    protected transient Ehcache cache;
    private volatile transient Map<Object, Object> keyLookupCache;
    private volatile transient Set<CacheConfiguration> linkedConfigurations = new CopyOnWriteArraySet<CacheConfiguration>();
    private volatile transient LocalBufferedMap<Object, TimestampedValue<Object>> localBufferedMap;
    private volatile transient boolean checkContainsKeyOnPut;
    private transient EventListenerList listenerList;
    private transient NonStrictBackend nonStrictBackend;
    private transient StrictBackend strictBackend;
    private transient BulkLoadBackend bulkLoadBackend;
    private transient boolean cachePinned;
    private final boolean localCacheEnabled;

    public ClusteredStore(Ehcache cache, long uniqueID) {
        this.qualifiedCacheName = cache.getCacheManager().getName() + "_" + cache.getName() + "_" + uniqueID;
        MutableConfig config = new MutableConfig();
        CacheConfiguration ehcacheConfig = cache.getCacheConfiguration();
        TerracottaConfiguration terracottaConfiguration = ehcacheConfig.getTerracottaConfiguration();
        if (terracottaConfiguration == null || !terracottaConfiguration.isClustered()) {
            throw new IllegalArgumentException("Cannot create clustered store for non-terracotta clustered caches");
        }
        this.localCacheEnabled = terracottaConfiguration.isLocalCacheEnabled();
        this.initialCoherenceMode = terracottaConfiguration.getConsistency();
        this.transactionalMode = ehcacheConfig.getTransactionalMode();
        if (ehcacheConfig.isOverflowToDisk() && LOG.isWarnEnabled()) {
            LOG.warn("Persistence on disk on the local node is not supported with a Terracotta clustered ehcache store. Configure the Terracotta server array to be persistent instead.");
        }
        this.valueModeHandler = ValueModeHandlerFactory.createValueModeHandler(this, ehcacheConfig);
        config.setMaxTTLSeconds((int)ehcacheConfig.getTimeToLiveSeconds());
        config.setMaxTTISeconds((int)ehcacheConfig.getTimeToIdleSeconds());
        config.setName(this.qualifiedCacheName);
        config.setCapacityEvictionPolicyDataFactory(ClusteredStore.determineCapacityEvictionPolicyDataFactory(ClusteredStore.determineEvictionPolicy(cache)));
        config.setTargetMaxInMemoryCount((int)ehcacheConfig.getMaxEntriesLocalHeap());
        this.cachePinned = cache.getCacheConfiguration().getPinningConfiguration() != null && cache.getCacheConfiguration().getPinningConfiguration().getStore() == PinningConfiguration.Store.INCACHE;
        config.setTargetMaxTotalCount(this.cachePinned ? 0 : ehcacheConfig.getMaxElementsOnDisk());
        config.setOrphanEvictionEnabled(terracottaConfiguration.getOrphanEviction());
        config.setOrphanEvictionPeriod(terracottaConfiguration.getOrphanEvictionPeriod());
        config.setLoggingEnabled(ehcacheConfig.getLogging());
        config.setServerMap(TerracottaConfiguration.StorageStrategy.DCV2.equals((Object)terracottaConfiguration.getStorageStrategy()));
        config.setLocalCacheEnabled(this.localCacheEnabled);
        if (terracottaConfiguration.getLocalKeyCache()) {
            this.localKeyCacheMaxsize = terracottaConfiguration.getLocalKeyCacheSize();
            this.keyLookupCache = new ConcurrentHashMap<Object, Object>();
        } else {
            this.localKeyCacheMaxsize = -1;
            this.keyLookupCache = null;
        }
        LockType lockType = terracottaConfiguration.isSynchronousWrites() ? LockType.SYNCHRONOUS_WRITE : LockType.WRITE;
        ClusteredMap<Object, TimestampedValue<Object>> map = this.createConcurrentDistributedMap(cache, lockType, (CacheConfig)config);
        this.backend = new ClusteredStoreBackendImpl<Object, Object>((CacheConfig)config, map, this.valueModeHandler, cache.getCacheEventNotificationService(), this.qualifiedCacheName, this);
        this.cacheCoherence = new IncoherentNodesSet(cache.getName(), this);
        this.initalizeTransients(cache);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialized " + this.getClass().getName() + " for " + cache.getName());
        }
        this.isIdentity = terracottaConfiguration.getValueMode() == TerracottaConfiguration.ValueMode.IDENTITY;
        this.isClassic = TerracottaConfiguration.StorageStrategy.CLASSIC.equals((Object)terracottaConfiguration.getStorageStrategy());
    }

    protected ClusteredMap<Object, TimestampedValue<Object>> createConcurrentDistributedMap(Ehcache ehcache, LockType lockType, CacheConfig config) {
        ConcurrentDistributedMap clusteredMap;
        TerracottaConfiguration.StorageStrategy storageStrategy = ehcache.getCacheConfiguration().getTerracottaConfiguration().getStorageStrategy();
        boolean serverMap = TerracottaConfiguration.StorageStrategy.DCV2.equals((Object)storageStrategy);
        int configuredStoreConcurrency = ehcache.getCacheConfiguration().getTerracottaConfiguration().getConcurrency();
        if (serverMap) {
            configuredStoreConcurrency = configuredStoreConcurrency == 0 ? this.calculateCorrectConcurrency(ehcache.getCacheConfiguration()) : configuredStoreConcurrency;
            boolean invalidateOnChange = ehcache.getCacheConfiguration().getTerracottaConfiguration().getConsistency() == TerracottaConfiguration.Consistency.EVENTUAL;
            boolean deleteValueOnRemove = ehcache.getCacheConfiguration().getTerracottaConfiguration().getValueMode() == TerracottaConfiguration.ValueMode.SERIALIZATION;
            String cmName = ehcache.getCacheManager().isNamed() ? ehcache.getCacheManager().getName() : "__DEFAULT__";
            ServerMapLocalStoreConfigParameters serverMapLocalStoreConfigParams = new ServerMapLocalStoreConfigParameters().localStoreManagerName(cmName).localStoreName(ehcache.getName()).serverMapLocalStoreFactoryClassName(ServerMapLocalStoreFactoryImpl.class.getName());
            ConcurrentDistributedServerMapParameters cdsmParameters = new ConcurrentDistributedServerMapParameters();
            cdsmParameters.cacheConfig(config).lockType(lockType).lockStrategy((GenericLockStrategy)new LongLockStrategy()).concurrency(configuredStoreConcurrency).invalidateOnChange(invalidateOnChange).deleteValueOnRemove(deleteValueOnRemove).serverMapLocalStoreConfig(new ServerMapLocalStoreConfig(serverMapLocalStoreConfigParams));
            clusteredMap = new ConcurrentDistributedServerMap(cdsmParameters);
        } else {
            configuredStoreConcurrency = configuredStoreConcurrency == 0 ? 128 : configuredStoreConcurrency;
            clusteredMap = new ConcurrentDistributedMap(lockType, (GenericLockStrategy)new LongLockStrategy(), configuredStoreConcurrency);
        }
        LOG.info(ClusteredStore.getConcurrencyValueLogMsg(ehcache.getName(), configuredStoreConcurrency));
        return clusteredMap;
    }

    private int calculateCorrectConcurrency(CacheConfiguration cacheConfiguration) {
        int maxElementOnDisk = cacheConfiguration.getMaxElementsOnDisk();
        if (maxElementOnDisk <= 0 || maxElementOnDisk >= 256) {
            return 256;
        }
        int concurrency = 1;
        while (concurrency * 2 <= maxElementOnDisk) {
            concurrency *= 2;
        }
        return concurrency;
    }

    static String getConcurrencyValueLogMsg(String name, int concurrency) {
        return "Cache [" + name + "] using concurrency: " + concurrency;
    }

    ClusteredStoreBackend getBackend() {
        return this.backend;
    }

    public TerracottaConfiguration.Consistency getInitialCoherenceMode() {
        return this.initialCoherenceMode;
    }

    public CacheConfiguration.TransactionalMode getTransactionalMode() {
        return this.transactionalMode;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public void initalizeTransients(Ehcache ehcache) {
        this.cache = ehcache;
        this.cachePinned = this.cache.getCacheConfiguration().getPinningConfiguration() != null && this.cache.getCacheConfiguration().getPinningConfiguration().getStore() == PinningConfiguration.Store.INCACHE;
        this.keyLookupCache = this.localKeyCacheMaxsize > 0 ? new ConcurrentHashMap<Object, Object>() : null;
        this.linkedConfigurations = new CopyOnWriteArraySet<CacheConfiguration>();
        ((MutableConfig)this.backend.getConfig()).addConfigChangeListener((ConfigChangeListener)this);
        this.backend.initializeTransients(this.cache.getCacheEventNotificationService(), this);
        if (this.localBufferedMap == null) {
            this.localBufferedMap = new LocalBufferedMap(this.backend, this.cacheCoherence, this.valueModeHandler);
        }
        this.checkContainsKeyOnPut = TerracottaConfiguration.StorageStrategy.DCV2.equals((Object)this.cache.getCacheConfiguration().getTerracottaConfiguration().getStorageStrategy()) ? TC_PROPERTIES.getBoolean(CHECK_CONTAINS_KEY_ON_PUT, Boolean.valueOf(false)).booleanValue() : TC_PROPERTIES.getBoolean(CHECK_CONTAINS_KEY_ON_PUT, Boolean.valueOf(true)).booleanValue();
        CacheShutdownHook.INSTANCE.registerCache(this.cache);
        this.strictBackend = new StrictBackend(this, this.backend, this.valueModeHandler, this.cacheCoherence);
        this.bulkLoadBackend = new BulkLoadBackend(this, this.backend, this.valueModeHandler, this.localBufferedMap, this.cacheCoherence);
        this.nonStrictBackend = new NonStrictBackend(this, this.backend, this.valueModeHandler, syncLockState, this.cacheCoherence, SizeOfPolicyConfiguration.resolveMaxDepth((Ehcache)this.cache), SizeOfPolicyConfiguration.resolveBehavior((Ehcache)this.cache).equals((Object)SizeOfPolicyConfiguration.MaxDepthExceededBehavior.ABORT));
        TC_LOGGER.info((Object)("Clustered Store [cache=" + ehcache.getName() + "] with checkContainsKeyOnPut: " + this.checkContainsKeyOnPut));
        TC_LOGGER.info((Object)("Clustered Store [cache=" + ehcache.getName() + "] with storageStrategy: " + ehcache.getCacheConfiguration().getTerracottaConfiguration().getStorageStrategy().name()));
        this.backend.loadReferences();
        this.valueModeHandler.loadReferences();
        this.cacheCoherence.loadReferences();
    }

    public boolean put(Element element) throws CacheException {
        return this.putInternal(element, null);
    }

    public void putAll(Collection<Element> elements) {
        this.getCurrentBackendStore().putAllNoReturn(elements);
    }

    public boolean putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        return this.putInternal(element, writerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putInternal(Element element, CacheWriterManager writerManager) throws CacheException {
        if (element != null) {
            Object pKey = this.generatePortableKeyFor(element.getObjectKey());
            this.cacheCoherence.acquireReadLock();
            try {
                boolean bl;
                block10: {
                    MetaData searchMetaData = this.createPutSearchMetaData(pKey, element);
                    boolean takeLock = this.cacheCoherence.isNodeCoherent() && writerManager != null;
                    ClusteredLock lock = null;
                    if (takeLock) {
                        lock = this.backend.createFinegrainedLock(pKey);
                        lock.lock();
                    }
                    try {
                        boolean newPut;
                        boolean bl2 = this.checkContainsKeyOnPut ? !this.internalContainsKey(pKey) : (newPut = true);
                        if (writerManager != null) {
                            writerManager.put(element);
                        }
                        TimestampedValue value = this.valueModeHandler.createTimestampedValue(element);
                        this.doPut(pKey, value, searchMetaData);
                        element.setElementEvictionData((ElementEvictionData)new ClusteredElementEvictionData((Store)this, value));
                        bl = newPut;
                        if (!takeLock) break block10;
                    }
                    catch (Throwable throwable) {
                        if (takeLock) {
                            lock.unlock();
                        }
                        throw throwable;
                    }
                    lock.unlock();
                }
                return bl;
            }
            finally {
                this.cacheCoherence.releaseReadLock();
            }
        }
        return true;
    }

    private BackendStore getCurrentBackendStore() {
        if (!this.cacheCoherence.isNodeCoherent()) {
            return this.bulkLoadBackend;
        }
        switch (this.initialCoherenceMode) {
            case STRONG: {
                return this.strictBackend;
            }
            case EVENTUAL: {
                return this.nonStrictBackend;
            }
        }
        throw new IllegalStateException("Unknown consistency: " + this.initialCoherenceMode);
    }

    private void doPut(Object portableKey, TimestampedValue value, MetaData searchMetaData) {
        this.getCurrentBackendStore().putNoReturn(portableKey, value, searchMetaData);
    }

    public MetaData createPutSearchMetaData(Object portableKey, Element element) {
        return null;
    }

    public MetaData createRemoveSearchMetaData(Object key) {
        return null;
    }

    protected MetaData createClearSearchMetaData() {
        return null;
    }

    public Element get(Object key) {
        return this.doGet(key, false);
    }

    public Element getQuiet(Object key) {
        return this.doGet(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element doGet(Object key, boolean quiet) {
        if (key == null) {
            return null;
        }
        Object pKey = this.generatePortableKeyFor(key);
        this.cacheCoherence.acquireReadLock();
        try {
            Element element = this.getCurrentBackendStore().get(key, pKey, quiet);
            return element;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    public Map<Object, Element> getAllQuiet(Collection<?> keys) {
        return this.doGetAll(keys, true);
    }

    public Map<Object, Element> getAll(Collection<?> keys) {
        return this.doGetAll(keys, false);
    }

    private Map<Object, Element> doGetAll(Collection<?> keys, boolean quiet) {
        return this.getCurrentBackendStore().getAll(keys, quiet);
    }

    public Element unlockedGet(Object key) {
        return this.doUnlockedGet(key, false);
    }

    public Element unlockedGetQuiet(Object key) {
        return this.doUnlockedGet(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element doUnlockedGet(Object key, boolean quiet) {
        if (key == null) {
            return null;
        }
        Object pKey = this.generatePortableKeyFor(key);
        this.cacheCoherence.acquireReadLock();
        try {
            Element element = this.getCurrentBackendStore().unlockedGet(key, pKey, quiet);
            return element;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    public Element unsafeGetQuiet(Object key) {
        return this.doUnsafeGet(key, true);
    }

    public Element unsafeGet(Object key) {
        return this.doUnsafeGet(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element doUnsafeGet(Object key, boolean quiet) {
        if (key == null) {
            return null;
        }
        Object pKey = this.generatePortableKeyFor(key);
        this.cacheCoherence.acquireReadLock();
        try {
            Element element = this.getCurrentBackendStore().unsafeGet(key, pKey, quiet);
            return element;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    public void removeAll(Collection<?> keys) {
        this.getCurrentBackendStore().removeAll(keys, this.keyLookupCache);
    }

    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        Element element = this.removeFromBackend(key);
        if (element != null) {
            return element;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.cache.getName() + " Cache: Cannot remove entry as key " + key + " was not found");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        if (key == null) {
            return null;
        }
        Object pKey = this.generatePortableKeyFor(key);
        ClusteredLock lock = this.backend.createFinegrainedLock(pKey);
        lock.lock();
        try {
            Element element;
            if (writerManager != null) {
                writerManager.remove(new CacheEntry(key, this.get(key)));
            }
            if ((element = this.removeFromBackend(key)) != null) {
                Element element2 = element;
                return element2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.cache.getName() + " Cache: Cannot remove entry as key " + key + " was not found");
            }
            Element element3 = null;
            return element3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element removeFromBackend(Object key) {
        Object pKey = this.generatePortableKeyFor(key);
        this.cacheCoherence.acquireReadLock();
        try {
            Element element = this.getCurrentBackendStore().remove(key, pKey, this.createRemoveSearchMetaData(pKey));
            return element;
        }
        finally {
            if (this.keyLookupCache != null) {
                this.keyLookupCache.remove(key);
            }
            this.cacheCoherence.releaseReadLock();
        }
    }

    public final boolean bufferFull() {
        return false;
    }

    public final void expireElements() {
    }

    protected static final Policy determineEvictionPolicy(Ehcache cache) {
        MemoryStoreEvictionPolicy policySelection = cache.getCacheConfiguration().getMemoryStoreEvictionPolicy();
        if (policySelection.equals(MemoryStoreEvictionPolicy.LRU)) {
            return new LruPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.FIFO)) {
            return new FifoPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.LFU)) {
            return new LfuPolicy();
        }
        throw new IllegalArgumentException(policySelection + " isn't a valid eviction policy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        this.cacheCoherence.acquireReadLock();
        try {
            boolean bl = this.internalContainsKey(this.generatePortableKeyFor(key));
            return bl;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsLocalKey(Object key) {
        this.cacheCoherence.acquireReadLock();
        try {
            boolean bl = this.internalContainsLocalKey(this.generatePortableKeyFor(key));
            return bl;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKeyInMemory(Object key) {
        Object portableKey = this.generatePortableKeyFor(key);
        this.cacheCoherence.acquireReadLock();
        try {
            boolean bl = this.getCurrentBackendStore().containsKeyLocalOnHeap(portableKey);
            return bl;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    public boolean containsKeyOnDisk(Object key) {
        return false;
    }

    private boolean internalContainsKey(Object internalKey) {
        return this.getCurrentBackendStore().containsKey(internalKey);
    }

    private boolean internalContainsLocalKey(Object internalKey) {
        return this.getCurrentBackendStore().containsLocalKey(internalKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        this.cacheCoherence.acquireReadLock();
        try {
            int n = this.getCurrentBackendStore().getSize();
            return n;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInMemorySize() {
        this.cacheCoherence.acquireReadLock();
        try {
            int n = this.getCurrentBackendStore().getLocalOnHeapSize();
            return n;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInMemorySizeInBytes() {
        this.cacheCoherence.acquireReadLock();
        try {
            long l = this.getCurrentBackendStore().getLocalHeapSizeInBytes();
            return l;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    public int getOnDiskSize() {
        return 0;
    }

    public long getOnDiskSizeInBytes() {
        return 0L;
    }

    public boolean hasAbortedSizeOf() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTerracottaClusteredSize() {
        this.cacheCoherence.acquireReadLock();
        try {
            int n = this.getCurrentBackendStore().getTerracottaClusteredSize();
            return n;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    public void removeAll() throws CacheException {
        this.clear();
    }

    public Status getStatus() {
        return Status.STATUS_ALIVE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clear() {
        this.cacheCoherence.acquireWriteLock();
        try {
            this.getCurrentBackendStore().clear(this.createClearSearchMetaData());
            if (this.keyLookupCache != null) {
                this.keyLookupCache.clear();
            }
        }
        finally {
            this.cacheCoherence.releaseWriteLock();
        }
    }

    public void flush() {
        if (this.cache.getCacheConfiguration().isClearOnFlush()) {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        block12: {
            try {
                if (this.cacheCoherence.isClusterOnline()) {
                    this.cacheCoherence.acquireWriteLock();
                    try {
                        this.localBufferedMap.dispose();
                        break block12;
                    }
                    finally {
                        this.cacheCoherence.releaseWriteLock();
                    }
                }
                this.localBufferedMap.shutdown();
            }
            finally {
                try {
                    this.backend.shutdown();
                }
                finally {
                    CacheShutdownHook.INSTANCE.unregisterCache(this.cache);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getKeys() {
        this.cacheCoherence.acquireReadLock();
        try {
            List list = this.getCurrentBackendStore().getKeys();
            return list;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getLocalKeys() {
        this.cacheCoherence.acquireReadLock();
        try {
            Set set = this.getCurrentBackendStore().getLocalKeys();
            return set;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    public Object generatePortableKeyFor(Object obj) {
        Object key;
        Object value;
        boolean useCache = this.shouldUseCache(obj);
        if (useCache && (value = this.keyLookupCache.get(obj)) != null) {
            return value;
        }
        try {
            key = this.valueModeHandler.createPortableKey(obj);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        if (useCache && this.keyLookupCache.size() < this.localKeyCacheMaxsize) {
            this.keyLookupCache.put(obj, key);
        }
        return key;
    }

    private boolean shouldUseCache(Object obj) {
        return this.keyLookupCache != null && !(obj instanceof String);
    }

    public Policy getInMemoryEvictionPolicy() {
        CapacityEvictionPolicyData.Factory factory = this.backend.getConfig().getCapacityEvictionPolicyDataFactory();
        if (factory instanceof LFUCapacityEvictionPolicyData.Factory) {
            return LFU_POLICY_INSTANCE;
        }
        if (factory instanceof LRUCapacityEvictionPolicyData.Factory) {
            return LRU_POLICY_INSTANCE;
        }
        throw new AssertionError((Object)("An instance of " + factory + " isn't supposed to be set in the config of the clustered store as it's not understood by Ehcache"));
    }

    public void setInMemoryEvictionPolicy(Policy policy) {
        this.backend.getConfig().setCapacityEvictionPolicyDataFactory(ClusteredStore.determineCapacityEvictionPolicyDataFactory(policy));
    }

    public Object getInternalContext() {
        return new TcCacheLockProvider(syncLockState, this.backend, this.valueModeHandler);
    }

    private static CapacityEvictionPolicyData.Factory determineCapacityEvictionPolicyDataFactory(Policy policy) {
        if ("LFU".equals(policy.getName())) {
            return new LFUCapacityEvictionPolicyData.Factory();
        }
        if ("LRU".equals(policy.getName())) {
            return new LRUCapacityEvictionPolicyData.Factory();
        }
        throw new IllegalArgumentException("Cache eviction policy " + policy.getName() + " isn't supported by the clustered store.");
    }

    public boolean isCacheCoherent() {
        return this.isClusterCoherent();
    }

    public boolean isClusterCoherent() {
        return this.cacheCoherence.isClusterCoherent();
    }

    public boolean isNodeCoherent() {
        return this.cacheCoherence.isNodeCoherent();
    }

    public void timeToIdleChanged(long oldTti, long newTti) {
        this.backend.setMaxTTI((int)newTti);
    }

    public void timeToLiveChanged(long oldTtl, long newTtl) {
        this.backend.setMaxTTL((int)newTtl);
    }

    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
        if (!this.cachePinned) {
            this.backend.setTargetMaxTotalCount(newCapacity);
        }
    }

    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        this.backend.setTargetMaxInMemoryCount(newCapacity);
    }

    public void loggingChanged(boolean oldValue, boolean newValue) {
        this.backend.setLoggingEnabled(newValue);
    }

    public void registered(CacheConfiguration config) {
        this.linkedConfigurations.add(config);
    }

    public void deregistered(CacheConfiguration config) {
        this.linkedConfigurations.remove(config);
    }

    public void maxBytesLocalHeapChanged(long oldValue, long newValue) {
        this.backend.setMaxBytesLocalHeap(newValue);
    }

    public void maxBytesLocalDiskChanged(long oldValue, long newValue) {
    }

    public void configChanged(String cacheName, String configName, Object oldValue, Object newValue) {
        Set<CacheConfiguration> configs = this.linkedConfigurations;
        if (configs == null) {
            TC_LOGGER.info((Object)("config changed but no linked configurations present [" + cacheName + " " + configName + "]"));
            return;
        }
        if ("maxTTISeconds".equals(configName)) {
            for (CacheConfiguration c : configs) {
                c.internalSetTimeToIdle(((Number)newValue).longValue());
            }
        } else if ("maxTTLSeconds".equals(configName)) {
            for (CacheConfiguration c : configs) {
                c.internalSetTimeToLive(((Number)newValue).longValue());
            }
        } else if ("targetMaxInMemoryCount".equals(configName)) {
            for (CacheConfiguration c : configs) {
                c.internalSetMemCapacity(((Number)newValue).intValue());
            }
        } else if ("targetMaxTotalCount".equals(configName)) {
            for (CacheConfiguration c : configs) {
                c.internalSetDiskCapacity(((Number)newValue).intValue());
            }
        } else if ("loggingEnabled".equals(configName)) {
            for (CacheConfiguration c : configs) {
                c.internalSetLogging(((Boolean)newValue).booleanValue());
            }
        } else {
            LOG.error("changing " + configName + " dynamically is not allwoed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeCoherent(boolean coherent) {
        if (!coherent) {
            this.localBufferedMap.startThreadIfNecessary();
        }
        this.cacheCoherence.acquireWriteLock();
        try {
            boolean oldValue = this.isNodeCoherent();
            if (coherent != oldValue) {
                if (coherent) {
                    this.localBufferedMap.flushAndStopBuffering();
                } else {
                    this.localBufferedMap.startBuffering();
                    this.backend.clearLocalCache();
                    this.backend.setLocalCacheEnabled(false);
                }
                if (!oldValue && coherent) {
                    this.backend.clearLocalCache();
                    Terracotta.waitForAllCurrentTransactionsToComplete();
                    this.backend.setLocalCacheEnabled(true);
                }
                this.cacheCoherence.setNodeCoherent(coherent);
            }
        }
        finally {
            this.cacheCoherence.releaseWriteLock();
        }
    }

    public void waitUntilClusterCoherent() {
        this.cacheCoherence.waitUntilClusterCoherent();
    }

    private synchronized EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public synchronized void addStoreListener(StoreListener listener) {
        this.removeStoreListener(listener);
        this.getEventListenerList().add(StoreListener.class, listener);
    }

    public synchronized void removeStoreListener(StoreListener listener) {
        this.getEventListenerList().remove(StoreListener.class, listener);
    }

    public void fireClusterCoherent(boolean clusterCoherent) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != StoreListener.class) continue;
            ((StoreListener)listeners[i + 1]).clusterCoherent(clusterCoherent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element putIfAbsent(Element element) {
        Object pKey = this.generatePortableKeyFor(element.getObjectKey());
        this.cacheCoherence.acquireReadLock();
        try {
            Element element2 = this.getCurrentBackendStore().putIfAbsent(pKey, element, this.createPutSearchMetaData(pKey, element));
            return element2;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element removeElement(Element element, ElementValueComparator comparator) {
        Object pKey = this.generatePortableKeyFor(element.getObjectKey());
        this.cacheCoherence.acquireReadLock();
        try {
            Element removedElement = null;
            try {
                removedElement = this.getCurrentBackendStore().removeElement(pKey, element, comparator, this.createRemoveSearchMetaData(pKey));
            }
            finally {
                if (removedElement != null && this.keyLookupCache != null) {
                    this.keyLookupCache.remove(element.getObjectKey());
                }
            }
            Element element2 = removedElement;
            return element2;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Element old, Element element, ElementValueComparator comparator) {
        Object pKey = this.generatePortableKeyFor(element.getObjectKey());
        this.cacheCoherence.acquireReadLock();
        try {
            boolean bl = this.getCurrentBackendStore().replace(pKey, old, element, comparator, this.createPutSearchMetaData(pKey, element));
            return bl;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element replace(Element element) {
        Object pKey = this.generatePortableKeyFor(element.getObjectKey());
        this.cacheCoherence.acquireReadLock();
        try {
            Element element2 = this.getCurrentBackendStore().replace(pKey, element, this.createPutSearchMetaData(pKey, element));
            return element2;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOffHeapSize() {
        this.cacheCoherence.acquireReadLock();
        try {
            int n = this.getCurrentBackendStore().getLocalOffHeapSize();
            return n;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOffHeapSizeInBytes() {
        this.cacheCoherence.acquireReadLock();
        try {
            long l = this.getCurrentBackendStore().getOffHeapSizeInBytse();
            return l;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKeyOffHeap(Object key) {
        Object portableKey = this.generatePortableKeyFor(key);
        this.cacheCoherence.acquireReadLock();
        try {
            boolean bl = this.getCurrentBackendStore().containsKeyLocalOffHeap(portableKey);
            return bl;
        }
        finally {
            this.cacheCoherence.releaseReadLock();
        }
    }

    public Object getMBean() {
        return null;
    }

    public boolean isSearchable() {
        return false;
    }

    public boolean isClassic() {
        return this.isClassic;
    }

    public void setAttributeExtractors(Map<String, AttributeExtractor> extractors) {
        if (!extractors.isEmpty()) {
            throw new CacheException("Search attributes only supported in enterprise edition");
        }
    }

    public Results executeQuery(StoreQuery query) {
        throw new UnsupportedOperationException("Search execution unsupported in non-enterprise edition");
    }

    public <T> Attribute<T> getSearchAttribute(String attributeName) {
        return null;
    }

    public int getPinnedCount() {
        return 0;
    }

    public void unpinAll() {
        if (!this.localCacheEnabled) {
            throw new UnsupportedOperationException("unpinAll is not supported when local cache is disabled");
        }
        this.backend.unpinAll();
    }

    public boolean isPinned(Object key) {
        if (!this.localCacheEnabled) {
            throw new UnsupportedOperationException("Pinning is not supported when local cache is disabled");
        }
        return this.backend.isPinned(key);
    }

    public void setPinned(Object key, boolean pinned) {
        if (!this.localCacheEnabled) {
            throw new UnsupportedOperationException("Pinning is not supported when local cache is disabled");
        }
        this.backend.setPinned(key, pinned);
    }

    public void recalculateSize(Object key) {
        throw new UnsupportedOperationException("Recalculate size is not supported for Terracotta clustered caches.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SyncLockState {
        LOCKED{

            public boolean isLocked() {
                return true;
            }

            public SyncLockState lockAcquired() {
                return LOCKED;
            }

            public SyncLockState lockReleased() {
                return UNLOCKED;
            }
        }
        ,
        UNLOCKED{

            public boolean isLocked() {
                return false;
            }

            public SyncLockState lockAcquired() {
                return LOCKED;
            }

            public SyncLockState lockReleased() {
                return UNLOCKED;
            }
        };


        public abstract boolean isLocked();

        public abstract SyncLockState lockAcquired();

        public abstract SyncLockState lockReleased();
    }
}

