/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.SearchException;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.StoreListener;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TerracottaStore;
import net.sf.ehcache.terracotta.TerracottaNotRunningException;
import net.sf.ehcache.writer.CacheWriterManager;
import org.terracotta.cache.logging.ConfigChangeListener;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.modules.ehcache.store.ClusteredStoreBackend;
import org.terracotta.modules.ehcache.store.ClusteredStoreExceptionHandler;

public class ClusteredSafeStore
implements TerracottaStore,
CacheConfigurationListener,
ConfigChangeListener {
    private static final ClusteredStoreExceptionHandler EXCEPTION_HANDLER = new ClusteredSafeStoreExceptionHandler();
    private final ClusteredStore delegateClusteredStore;

    public ClusteredSafeStore(ClusteredStore delegateClusteredStore) {
        this.delegateClusteredStore = delegateClusteredStore;
    }

    public static void main(String[] args) {
        Class[] classes;
        PrintStream out = System.out;
        for (Class c : classes = new Class[]{TerracottaStore.class, CacheConfigurationListener.class, ConfigChangeListener.class}) {
            for (Method m : c.getMethods()) {
                int i;
                out.println("/**");
                out.println("* {@inheritDoc}");
                out.println("*/");
                out.print("public " + m.getReturnType().getSimpleName() + " " + m.getName() + "(");
                Class<?>[] params = m.getParameterTypes();
                for (int i2 = 0; i2 < params.length; ++i2) {
                    out.print(params[i2].getSimpleName() + " arg" + i2);
                    if (i2 >= params.length - 1) continue;
                    out.print(", ");
                }
                out.print(")");
                Class<?>[] exceptions = m.getExceptionTypes();
                if (exceptions.length > 0) {
                    out.print(" throws ");
                }
                for (i = 0; i < exceptions.length; ++i) {
                    out.print(exceptions[i].getSimpleName());
                    if (i >= exceptions.length - 1) continue;
                    out.print(", ");
                }
                out.println(" {");
                out.println("    // THIS IS GENERATED CODE -- DO NOT HAND MODIFY!");
                out.println("    try {");
                out.print("        ");
                if (m.getReturnType() != Void.TYPE) {
                    out.print("return ");
                }
                out.print("this.delegateClusteredStore." + m.getName() + "(");
                for (i = 0; i < params.length; ++i) {
                    out.print("arg" + i);
                    if (i >= params.length - 1) continue;
                    out.print(", ");
                }
                out.println(");");
                if (exceptions.length > 0) {
                    for (i = 0; i < exceptions.length; ++i) {
                        Class<?> e = exceptions[i];
                        out.println("    } catch(" + e.getSimpleName() + " e) {");
                        out.println("      throw e;");
                        if (i >= exceptions.length - 1) continue;
                    }
                }
                out.println("    } catch (Throwable t) {");
                out.println("        EXCEPTION_HANDLER.handleException(t);");
                out.println("        throw new CacheException(\"Uncaught exception in " + m.getName() + "() - \" + t.getMessage(), t);");
                out.println("    }");
                out.println("}");
                out.println("");
            }
        }
    }

    ClusteredStoreBackend getBackend() {
        return this.delegateClusteredStore.getBackend();
    }

    ClusteredStore getClusteredStore() {
        return this.delegateClusteredStore;
    }

    public Element unsafeGet(Object arg0) {
        try {
            return this.delegateClusteredStore.unsafeGet(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in unsafeGet() - " + t.getMessage(), t);
        }
    }

    public Element unsafeGetQuiet(Object arg0) {
        try {
            return this.delegateClusteredStore.unsafeGetQuiet(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in unsafeGetQuiet() - " + t.getMessage(), t);
        }
    }

    public Element unlockedGet(Object arg0) {
        try {
            return this.delegateClusteredStore.unlockedGet(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in unlockedGet() - " + t.getMessage(), t);
        }
    }

    public Element unlockedGetQuiet(Object arg0) {
        try {
            return this.delegateClusteredStore.unlockedGetQuiet(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in unlockedGetQuiet() - " + t.getMessage(), t);
        }
    }

    public Set getLocalKeys() {
        try {
            return this.delegateClusteredStore.getLocalKeys();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getLocalKeys() - " + t.getMessage(), t);
        }
    }

    public CacheConfiguration.TransactionalMode getTransactionalMode() {
        try {
            return this.delegateClusteredStore.getTransactionalMode();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getTransactionalMode() - " + t.getMessage(), t);
        }
    }

    public void setPinned(Object arg0, boolean arg1) {
        try {
            this.delegateClusteredStore.setPinned(arg0, arg1);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in setPinned() - " + t.getMessage(), t);
        }
    }

    public void unpinAll() {
        try {
            this.delegateClusteredStore.unpinAll();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in unpinAll() - " + t.getMessage(), t);
        }
    }

    public boolean isPinned(Object arg0) {
        try {
            return this.delegateClusteredStore.isPinned(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in isPinned() - " + t.getMessage(), t);
        }
    }

    public void addStoreListener(StoreListener arg0) {
        try {
            this.delegateClusteredStore.addStoreListener(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in addStoreListener() - " + t.getMessage(), t);
        }
    }

    public void removeStoreListener(StoreListener arg0) {
        try {
            this.delegateClusteredStore.removeStoreListener(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in removeStoreListener() - " + t.getMessage(), t);
        }
    }

    public boolean putWithWriter(Element arg0, CacheWriterManager arg1) throws CacheException {
        try {
            return this.delegateClusteredStore.putWithWriter(arg0, arg1);
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in putWithWriter() - " + t.getMessage(), t);
        }
    }

    public Element getQuiet(Object arg0) {
        try {
            return this.delegateClusteredStore.getQuiet(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getQuiet() - " + t.getMessage(), t);
        }
    }

    public Element removeWithWriter(Object arg0, CacheWriterManager arg1) throws CacheException {
        try {
            return this.delegateClusteredStore.removeWithWriter(arg0, arg1);
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in removeWithWriter() - " + t.getMessage(), t);
        }
    }

    public int getInMemorySize() {
        try {
            return this.delegateClusteredStore.getInMemorySize();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getInMemorySize() - " + t.getMessage(), t);
        }
    }

    public int getOffHeapSize() {
        try {
            return this.delegateClusteredStore.getOffHeapSize();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getOffHeapSize() - " + t.getMessage(), t);
        }
    }

    public int getOnDiskSize() {
        try {
            return this.delegateClusteredStore.getOnDiskSize();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getOnDiskSize() - " + t.getMessage(), t);
        }
    }

    public int getTerracottaClusteredSize() {
        try {
            return this.delegateClusteredStore.getTerracottaClusteredSize();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getTerracottaClusteredSize() - " + t.getMessage(), t);
        }
    }

    public long getInMemorySizeInBytes() {
        try {
            return this.delegateClusteredStore.getInMemorySizeInBytes();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getInMemorySizeInBytes() - " + t.getMessage(), t);
        }
    }

    public long getOffHeapSizeInBytes() {
        try {
            return this.delegateClusteredStore.getOffHeapSizeInBytes();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getOffHeapSizeInBytes() - " + t.getMessage(), t);
        }
    }

    public long getOnDiskSizeInBytes() {
        try {
            return this.delegateClusteredStore.getOnDiskSizeInBytes();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getOnDiskSizeInBytes() - " + t.getMessage(), t);
        }
    }

    public boolean hasAbortedSizeOf() {
        try {
            return this.delegateClusteredStore.hasAbortedSizeOf();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in hasAbortedSizeOf() - " + t.getMessage(), t);
        }
    }

    public boolean containsKeyOnDisk(Object arg0) {
        try {
            return this.delegateClusteredStore.containsKeyOnDisk(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in containsKeyOnDisk() - " + t.getMessage(), t);
        }
    }

    public boolean containsKeyOffHeap(Object arg0) {
        try {
            return this.delegateClusteredStore.containsKeyOffHeap(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in containsKeyOffHeap() - " + t.getMessage(), t);
        }
    }

    public boolean containsKeyInMemory(Object arg0) {
        try {
            return this.delegateClusteredStore.containsKeyInMemory(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in containsKeyInMemory() - " + t.getMessage(), t);
        }
    }

    public void expireElements() {
        try {
            this.delegateClusteredStore.expireElements();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in expireElements() - " + t.getMessage(), t);
        }
    }

    public boolean bufferFull() {
        try {
            return this.delegateClusteredStore.bufferFull();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in bufferFull() - " + t.getMessage(), t);
        }
    }

    public Policy getInMemoryEvictionPolicy() {
        try {
            return this.delegateClusteredStore.getInMemoryEvictionPolicy();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getInMemoryEvictionPolicy() - " + t.getMessage(), t);
        }
    }

    public void setInMemoryEvictionPolicy(Policy arg0) {
        try {
            this.delegateClusteredStore.setInMemoryEvictionPolicy(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in setInMemoryEvictionPolicy() - " + t.getMessage(), t);
        }
    }

    public Object getInternalContext() {
        try {
            return this.delegateClusteredStore.getInternalContext();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getInternalContext() - " + t.getMessage(), t);
        }
    }

    public boolean isCacheCoherent() {
        try {
            return this.delegateClusteredStore.isCacheCoherent();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in isCacheCoherent() - " + t.getMessage(), t);
        }
    }

    public boolean isClusterCoherent() throws TerracottaNotRunningException {
        try {
            return this.delegateClusteredStore.isClusterCoherent();
        }
        catch (TerracottaNotRunningException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in isClusterCoherent() - " + t.getMessage(), t);
        }
    }

    public boolean isNodeCoherent() throws TerracottaNotRunningException {
        try {
            return this.delegateClusteredStore.isNodeCoherent();
        }
        catch (TerracottaNotRunningException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in isNodeCoherent() - " + t.getMessage(), t);
        }
    }

    public void setNodeCoherent(boolean arg0) throws UnsupportedOperationException, TerracottaNotRunningException {
        try {
            this.delegateClusteredStore.setNodeCoherent(arg0);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (TerracottaNotRunningException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in setNodeCoherent() - " + t.getMessage(), t);
        }
    }

    public void waitUntilClusterCoherent() throws UnsupportedOperationException, TerracottaNotRunningException {
        try {
            this.delegateClusteredStore.waitUntilClusterCoherent();
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (TerracottaNotRunningException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in waitUntilClusterCoherent() - " + t.getMessage(), t);
        }
    }

    public Object getMBean() {
        try {
            return this.delegateClusteredStore.getMBean();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getMBean() - " + t.getMessage(), t);
        }
    }

    public void setAttributeExtractors(Map arg0) {
        try {
            this.delegateClusteredStore.setAttributeExtractors(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in setAttributeExtractors() - " + t.getMessage(), t);
        }
    }

    public Results executeQuery(StoreQuery arg0) throws SearchException {
        try {
            return this.delegateClusteredStore.executeQuery(arg0);
        }
        catch (SearchException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in executeQuery() - " + t.getMessage(), t);
        }
    }

    public Attribute getSearchAttribute(String arg0) {
        try {
            return this.delegateClusteredStore.getSearchAttribute(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getSearchAttribute() - " + t.getMessage(), t);
        }
    }

    public Map getAllQuiet(Collection arg0) {
        try {
            return this.delegateClusteredStore.getAllQuiet(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getAllQuiet() - " + t.getMessage(), t);
        }
    }

    public Map getAll(Collection arg0) {
        try {
            return this.delegateClusteredStore.getAll(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getAll() - " + t.getMessage(), t);
        }
    }

    public Element get(Object arg0) {
        try {
            return this.delegateClusteredStore.get(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in get() - " + t.getMessage(), t);
        }
    }

    public boolean put(Element arg0) throws CacheException {
        try {
            return this.delegateClusteredStore.put(arg0);
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in put() - " + t.getMessage(), t);
        }
    }

    public Element replace(Element arg0) throws NullPointerException {
        try {
            return this.delegateClusteredStore.replace(arg0);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in replace() - " + t.getMessage(), t);
        }
    }

    public boolean replace(Element arg0, Element arg1, ElementValueComparator arg2) throws NullPointerException, IllegalArgumentException {
        try {
            return this.delegateClusteredStore.replace(arg0, arg1, arg2);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in replace() - " + t.getMessage(), t);
        }
    }

    public void putAll(Collection arg0) throws CacheException {
        try {
            this.delegateClusteredStore.putAll(arg0);
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in putAll() - " + t.getMessage(), t);
        }
    }

    public Element remove(Object arg0) {
        try {
            return this.delegateClusteredStore.remove(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in remove() - " + t.getMessage(), t);
        }
    }

    public void flush() {
        try {
            this.delegateClusteredStore.flush();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in flush() - " + t.getMessage(), t);
        }
    }

    public boolean containsKey(Object arg0) {
        try {
            return this.delegateClusteredStore.containsKey(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in containsKey() - " + t.getMessage(), t);
        }
    }

    public int getSize() {
        try {
            return this.delegateClusteredStore.getSize();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getSize() - " + t.getMessage(), t);
        }
    }

    public Element removeElement(Element arg0, ElementValueComparator arg1) throws NullPointerException {
        try {
            return this.delegateClusteredStore.removeElement(arg0, arg1);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in removeElement() - " + t.getMessage(), t);
        }
    }

    public void removeAll() throws CacheException {
        try {
            this.delegateClusteredStore.removeAll();
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in removeAll() - " + t.getMessage(), t);
        }
    }

    public void removeAll(Collection arg0) {
        try {
            this.delegateClusteredStore.removeAll(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in removeAll() - " + t.getMessage(), t);
        }
    }

    public Element putIfAbsent(Element arg0) throws NullPointerException {
        try {
            return this.delegateClusteredStore.putIfAbsent(arg0);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in putIfAbsent() - " + t.getMessage(), t);
        }
    }

    public void dispose() {
        try {
            this.delegateClusteredStore.dispose();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in dispose() - " + t.getMessage(), t);
        }
    }

    public List getKeys() {
        try {
            return this.delegateClusteredStore.getKeys();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getKeys() - " + t.getMessage(), t);
        }
    }

    public Status getStatus() {
        try {
            return this.delegateClusteredStore.getStatus();
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in getStatus() - " + t.getMessage(), t);
        }
    }

    public void timeToIdleChanged(long arg0, long arg1) {
        try {
            this.delegateClusteredStore.timeToIdleChanged(arg0, arg1);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in timeToIdleChanged() - " + t.getMessage(), t);
        }
    }

    public void timeToLiveChanged(long arg0, long arg1) {
        try {
            this.delegateClusteredStore.timeToLiveChanged(arg0, arg1);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in timeToLiveChanged() - " + t.getMessage(), t);
        }
    }

    public void diskCapacityChanged(int arg0, int arg1) {
        try {
            this.delegateClusteredStore.diskCapacityChanged(arg0, arg1);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in diskCapacityChanged() - " + t.getMessage(), t);
        }
    }

    public void memoryCapacityChanged(int arg0, int arg1) {
        try {
            this.delegateClusteredStore.memoryCapacityChanged(arg0, arg1);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in memoryCapacityChanged() - " + t.getMessage(), t);
        }
    }

    public void loggingChanged(boolean arg0, boolean arg1) {
        try {
            this.delegateClusteredStore.loggingChanged(arg0, arg1);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in loggingChanged() - " + t.getMessage(), t);
        }
    }

    public void deregistered(CacheConfiguration arg0) {
        try {
            this.delegateClusteredStore.deregistered(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in deregistered() - " + t.getMessage(), t);
        }
    }

    public void maxBytesLocalHeapChanged(long arg0, long arg1) {
        try {
            this.delegateClusteredStore.maxBytesLocalHeapChanged(arg0, arg1);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in maxBytesLocalHeapChanged() - " + t.getMessage(), t);
        }
    }

    public void maxBytesLocalDiskChanged(long arg0, long arg1) {
        try {
            this.delegateClusteredStore.maxBytesLocalDiskChanged(arg0, arg1);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in maxBytesLocalDiskChanged() - " + t.getMessage(), t);
        }
    }

    public void registered(CacheConfiguration arg0) {
        try {
            this.delegateClusteredStore.registered(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in registered() - " + t.getMessage(), t);
        }
    }

    public void configChanged(String arg0, String arg1, Object arg2, Object arg3) {
        try {
            this.delegateClusteredStore.configChanged(arg0, arg1, arg2, arg3);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in configChanged() - " + t.getMessage(), t);
        }
    }

    public void recalculateSize(Object arg0) {
        try {
            this.delegateClusteredStore.recalculateSize(arg0);
        }
        catch (Throwable t) {
            EXCEPTION_HANDLER.handleException(t);
            throw new CacheException("Uncaught exception in recalculateSize() - " + t.getMessage(), t);
        }
    }

    private static class ClusteredSafeStoreExceptionHandler
    implements ClusteredStoreExceptionHandler {
        private ClusteredSafeStoreExceptionHandler() {
        }

        public void handleException(Throwable t) {
            if (t.getClass().getSimpleName().equals("TCNotRunningException")) {
                throw new TerracottaNotRunningException("Clustered Cache is probably shutdown or Terracotta backend is down.", t);
            }
        }
    }
}

