/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store;

import net.sf.ehcache.Element;
import net.sf.ehcache.ElementEvictionData;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.cache.TimestampedValue;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.modules.ehcache.store.ClusteredStoreBackend;

public class ClusteredElementEvictionData
implements ElementEvictionData {
    private static final Logger LOG = LoggerFactory.getLogger((String)ClusteredElementEvictionData.class.getName());
    private final transient Store store;
    private final TimestampedValue value;

    public ClusteredElementEvictionData(Store store, TimestampedValue timestampedValue) {
        this.store = store;
        this.value = timestampedValue;
    }

    public void setCreationTime(long creationTime) {
    }

    public long getCreationTime() {
        return TimeUtil.toMillis((int)this.value.getCreateTime());
    }

    public long getLastAccessTime() {
        return TimeUtil.toMillis((int)this.value.getLastAccessedTime());
    }

    public void updateLastAccessTime(long time, Element element) {
        this.setLastAccessTime(TimeUtil.toSecs((long)time), element, this.store);
    }

    public void resetLastAccessTime(Element element) {
        this.setLastAccessTime(this.value.getCreateTime(), element, this.store);
    }

    private void setLastAccessTime(int time, Element element, Store store) {
        if (null == store) {
            throw new IllegalArgumentException("store can't be null");
        }
        if (!(store instanceof ClusteredStore)) {
            throw new IllegalArgumentException("store is expected to be a ClusteredStore");
        }
        if (time < this.value.getCreateTime()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Last access time " + time + " of element with key '" + element.getObjectKey() + "' is earlier than its creation time " + this.value.getCreateTime() + ". Setting it to the creation time.");
            }
            time = this.value.getCreateTime();
        }
        ClusteredStore clusteredStore = (ClusteredStore)store;
        ClusteredStoreBackend backend = clusteredStore.getBackend();
        this.value.markUsed(time, backend.createFinegrainedLock(clusteredStore.generatePortableKeyFor(element.getObjectKey())), backend.getConfig());
    }

    public final ElementEvictionData clone() throws CloneNotSupportedException {
        return (ClusteredElementEvictionData)super.clone();
    }

    public boolean canParticipateInSerialization() {
        return true;
    }
}

