/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.cluster.ClusterNode;
import net.sf.ehcache.cluster.ClusterScheme;
import net.sf.ehcache.cluster.ClusterTopologyListener;
import org.terracotta.cluster.ClusterInfo;
import org.terracotta.cluster.ClusterListener;
import org.terracotta.modules.ehcache.event.ClusterListenerAdapter;
import org.terracotta.modules.ehcache.event.TerracottaNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaTopologyImpl
implements CacheCluster {
    private final ClusterInfo cluster;
    private final CopyOnWriteArrayList<ClusterTopologyListener> listeners = new CopyOnWriteArrayList();
    private final ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock().writeLock();

    public TerracottaTopologyImpl(ClusterInfo cluster) {
        this.cluster = cluster;
    }

    public ClusterScheme getScheme() {
        return ClusterScheme.TERRACOTTA;
    }

    public ClusterNode getCurrentNode() {
        return new TerracottaNodeImpl(this.cluster.getCurrentNode());
    }

    public ClusterNode waitUntilNodeJoinsCluster() {
        return new TerracottaNodeImpl(this.cluster.waitUntilNodeJoinsCluster());
    }

    public Collection<ClusterNode> getNodes() {
        Collection dsoNodes = this.cluster.getClusterTopology().getNodes();
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
        for (org.terracotta.cluster.ClusterNode node : dsoNodes) {
            nodes.add(new TerracottaNodeImpl(node));
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTopologyListener(ClusterTopologyListener listener) {
        boolean rv;
        this.writeLock.lock();
        try {
            rv = this.listeners.add(listener);
            if (rv) {
                this.addInternal(listener);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTopologyListener(ClusterTopologyListener listener) {
        boolean rv;
        this.writeLock.lock();
        try {
            rv = this.listeners.remove(listener);
            if (rv) {
                this.removeInternal(listener);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return rv;
    }

    private void addInternal(ClusterTopologyListener listener) {
        this.cluster.addClusterListener((ClusterListener)new ClusterListenerAdapter(listener));
    }

    private void removeInternal(ClusterTopologyListener listener) {
        this.cluster.removeClusterListener((ClusterListener)new ClusterListenerAdapter(listener));
    }

    public boolean isClusterOnline() {
        return this.cluster.areOperationsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClusterTopologyListener> getTopologyListeners() {
        this.writeLock.lock();
        try {
            CopyOnWriteArrayList<ClusterTopologyListener> copyOnWriteArrayList = this.listeners;
            return copyOnWriteArrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

