/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.event;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.AbstractElementData;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.IdentityModeElementData;
import net.sf.ehcache.SerializationModeElementData;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.RegisteredEventListeners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.cache.serialization.DsoSerializationStrategy;
import org.terracotta.cache.serialization.SerializationStrategy;
import org.terracotta.cluster.TerracottaClusterInfo;
import org.terracotta.modules.ehcache.store.ElementSerializationStrategy;

public class ClusteredEventReplicator
implements CacheEventListener {
    private static final Collection UNFLUSHABLE_STATE = Collections.synchronizedCollection(new HashSet());
    private static final Logger LOG = LoggerFactory.getLogger((String)ClusteredEventReplicator.class.getName());
    private static final int MS_WAIT_FOR_TRANSIENT_INITIALISATION = 5000;
    private final TerracottaConfiguration.ValueMode valueMode;
    private final SerializationStrategy dsoSerialization;
    private final SerializationStrategy elementSerialization;
    private volatile transient ReentrantReadWriteLock transientLock;
    private volatile transient ReentrantReadWriteLock.WriteLock transientWriteLock;
    private volatile transient Condition transientCondition;
    private volatile transient ReentrantReadWriteLock.ReadLock transientReadLock;
    private transient Ehcache cache;

    public ClusteredEventReplicator(Ehcache cache, TerracottaConfiguration tcConfig) {
        this.valueMode = tcConfig.getValueMode();
        switch (this.valueMode) {
            case IDENTITY: {
                this.dsoSerialization = null;
                this.elementSerialization = null;
                break;
            }
            case SERIALIZATION: {
                this.dsoSerialization = new DsoSerializationStrategy();
                this.elementSerialization = new ElementSerializationStrategy(tcConfig.isCompressionEnabled());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Value mode " + this.valueMode + " isn't supported");
            }
        }
        this.initializeOnLoad();
        this.initializeTransients(cache);
    }

    public synchronized void initializeOnLoad() {
        if (null == this.transientLock) {
            this.transientLock = new ReentrantReadWriteLock();
            this.transientWriteLock = this.transientLock.writeLock();
            this.transientCondition = this.transientWriteLock.newCondition();
            this.transientReadLock = this.transientLock.readLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTransients(Ehcache theCache) {
        this.transientWriteLock.lock();
        try {
            this.cache = theCache;
            UNFLUSHABLE_STATE.add(this);
            this.transientCondition.signalAll();
        }
        finally {
            this.transientWriteLock.unlock();
        }
    }

    public void notifyElementRemoved(Ehcache theCache, Element element) throws CacheException {
        this.dmiNotifyElementRemoved(this.getKeyForDMI(element), this.getElementDataForDMI(element), this.getClientID());
    }

    public void notifyElementPut(Ehcache theCache, Element element) throws CacheException {
        this.dmiNotifyElementPut(this.getKeyForDMI(element), this.getElementDataForDMI(element), this.getClientID());
    }

    public void notifyElementUpdated(Ehcache theCache, Element element) throws CacheException {
        this.dmiNotifyElementUpdated(this.getKeyForDMI(element), this.getElementDataForDMI(element), this.getClientID());
    }

    public void notifyElementExpired(Ehcache theCache, Element element) throws CacheException {
        this.dmiNotifyElementExpired(this.getKeyForDMI(element), this.getElementDataForDMI(element), this.getClientID());
    }

    public void notifyElementEvicted(Ehcache theCache, Element element) throws CacheException {
        this.dmiNotifyElementEvicted(this.getKeyForDMI(element), this.getElementDataForDMI(element), this.getClientID());
    }

    public void notifyRemoveAll(Ehcache theCache) {
        this.dmiNotifyRemoveAll(this.getClientID());
    }

    private String getClientID() {
        return new TerracottaClusterInfo().getCurrentNode().getId();
    }

    public void dispose() {
    }

    public ClusteredEventReplicator clone() throws CloneNotSupportedException {
        return (ClusteredEventReplicator)super.clone();
    }

    private Object getKeyForDMI(Element element) throws CacheException {
        switch (this.valueMode) {
            case IDENTITY: {
                return element.getObjectKey();
            }
            case SERIALIZATION: {
                try {
                    return this.dsoSerialization.serialize(element.getObjectKey());
                }
                catch (IOException e) {
                    throw new CacheException("Unexpected error while serializing the key " + element.getObjectKey(), (Throwable)e);
                }
            }
        }
        throw new UnsupportedOperationException("Value mode " + this.valueMode + " isn't supported");
    }

    private Object getElementDataForDMI(Element element) throws CacheException {
        switch (this.valueMode) {
            case IDENTITY: {
                return new IdentityModeElementData(element, Integer.MIN_VALUE);
            }
            case SERIALIZATION: {
                SerializationModeElementData elementData = new SerializationModeElementData(element);
                try {
                    return this.elementSerialization.serialize((Object)elementData);
                }
                catch (IOException e) {
                    throw new CacheException("Unexpected error while serializing the value " + element.getObjectValue(), (Throwable)e);
                }
            }
        }
        throw new UnsupportedOperationException("Value mode " + this.valueMode + " isn't supported");
    }

    private Object getKeyFromDMI(Object key, ClassLoader loader) throws CacheException {
        switch (this.valueMode) {
            case IDENTITY: {
                return key;
            }
            case SERIALIZATION: {
                try {
                    return this.dsoSerialization.deserialize((byte[])key, loader);
                }
                catch (Exception e) {
                    throw new CacheException("Unexpected error while deserializing a key from a DMI call.", (Throwable)e);
                }
            }
        }
        throw new UnsupportedOperationException("Value mode " + this.valueMode + " isn't supported");
    }

    private Element getElementFromDMI(Object key, Object element, ClassLoader loader) throws CacheException {
        AbstractElementData elementData;
        switch (this.valueMode) {
            case IDENTITY: {
                elementData = (AbstractElementData)((Object)element);
                break;
            }
            case SERIALIZATION: {
                try {
                    elementData = (AbstractElementData)((Object)this.elementSerialization.deserialize((byte[])element, loader));
                    break;
                }
                catch (Exception e) {
                    throw new CacheException("Unexpected error while deserializing an element from a DMI call.", (Throwable)e);
                }
            }
            default: {
                throw new UnsupportedOperationException("Value mode " + this.valueMode + " isn't supported");
            }
        }
        return elementData.createElement(this.getKeyFromDMI(key, loader));
    }

    private boolean isRemote(String clientID) {
        return !this.getClientID().equals(clientID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void giveTransientInitializationTime() {
        this.transientReadLock.lock();
        try {
            if (this.cache != null) {
                return;
            }
        }
        finally {
            this.transientReadLock.unlock();
        }
        this.transientWriteLock.lock();
        try {
            if (this.cache != null) {
                return;
            }
            try {
                this.transientCondition.await(5000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.transientWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ehcache getCache() {
        this.giveTransientInitializationTime();
        this.transientReadLock.lock();
        try {
            Ehcache ehcache = this.cache;
            return ehcache;
        }
        finally {
            this.transientReadLock.unlock();
        }
    }

    private boolean isInitialized() {
        return this.getCache() != null;
    }

    public void dmiNotifyElementPut(Object key, Object elementData, String clientID) throws CacheException {
        if (this.isRemote(clientID)) {
            if (!this.isInitialized()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Received a replicated put event for an uninitialized cache event replicator, events will be ignored while initialization is in progress.");
                }
                return;
            }
            this.getCache().getCacheEventNotificationService().notifyElementPut((RegisteredEventListeners.ElementCreationCallback)new CreateCallback(key, elementData), true);
        }
    }

    public void dmiNotifyElementUpdated(Object key, Object elementData, String clientID) {
        if (this.isRemote(clientID)) {
            if (!this.isInitialized()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Received a replicated update event for an uninitialized cache event replicator, events will be ignored while initialization is in progress.");
                }
                return;
            }
            this.getCache().getCacheEventNotificationService().notifyElementUpdated((RegisteredEventListeners.ElementCreationCallback)new CreateCallback(key, elementData), true);
        }
    }

    public void dmiNotifyElementExpired(Object key, Object elementData, String clientID) {
        if (this.isRemote(clientID)) {
            if (!this.isInitialized()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Received a replicated expiration event for an uninitialized cache event replicator, events will be ignored while initialization is in progress.");
                }
                return;
            }
            this.getCache().getCacheEventNotificationService().notifyElementExpiry((RegisteredEventListeners.ElementCreationCallback)new CreateCallback(key, elementData), true);
        }
    }

    public void dmiNotifyElementEvicted(Object key, Object elementData, String clientID) {
        if (this.isRemote(clientID)) {
            if (!this.isInitialized()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Received a replicated eviction event for an uninitialized cache event replicator, events will be ignored while initialization is in progress.");
                }
                return;
            }
            this.getCache().getCacheEventNotificationService().notifyElementEvicted((RegisteredEventListeners.ElementCreationCallback)new CreateCallback(key, elementData), true);
        }
    }

    public void dmiNotifyElementRemoved(Object key, Object elementData, String clientID) throws CacheException {
        if (this.isRemote(clientID)) {
            if (!this.isInitialized()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Received a replicated remove event for an uninitialized cache event replicator, events will be ignored while initialization is in progress.");
                }
                return;
            }
            this.getCache().getCacheEventNotificationService().notifyElementRemoved((RegisteredEventListeners.ElementCreationCallback)new CreateCallback(key, elementData), true);
        }
    }

    public void dmiNotifyRemoveAll(String clientID) {
        if (this.isRemote(clientID)) {
            if (!this.isInitialized()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Received a replicated removeAll event for an uninitialized cache event replicator, events will be ignored while initialization is in progress.");
                }
                return;
            }
            this.getCache().getCacheEventNotificationService().notifyRemoveAll(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementLoader
    extends ClassLoader {
        private final ClassLoader listenerLoader;

        ElementLoader(ClassLoader listenerLoader) {
            super(null);
            this.listenerLoader = listenerLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return this.listenerLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return this.getClass().getClassLoader().loadClass(name);
            }
        }
    }

    private class CreateCallback
    implements RegisteredEventListeners.ElementCreationCallback {
        private final Object key;
        private final Object elementData;

        CreateCallback(Object key, Object elementData) {
            this.key = key;
            this.elementData = elementData;
        }

        public Element createElement(ClassLoader loader) {
            return ClusteredEventReplicator.this.getElementFromDMI(this.key, this.elementData, new ElementLoader(loader));
        }
    }
}

