/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.event;

import net.sf.ehcache.cluster.ClusterNode;
import net.sf.ehcache.cluster.ClusterTopologyListener;
import org.terracotta.cluster.ClusterEvent;
import org.terracotta.cluster.OutOfBandClusterListener;
import org.terracotta.modules.ehcache.event.TerracottaNodeImpl;

public class ClusterListenerAdapter
implements OutOfBandClusterListener {
    private static final String EHCACHE_TERRACOTTA_PACKAGE_NAME = "net.sf.ehcache.terracotta";
    private final ClusterTopologyListener topologyListener;

    public ClusterListenerAdapter(ClusterTopologyListener topologyListener) {
        this.topologyListener = topologyListener;
    }

    public void nodeJoined(ClusterEvent event) {
        this.topologyListener.nodeJoined((ClusterNode)new TerracottaNodeImpl(event.getNode()));
    }

    public void nodeLeft(ClusterEvent event) {
        this.topologyListener.nodeLeft((ClusterNode)new TerracottaNodeImpl(event.getNode()));
    }

    public void operationsDisabled(ClusterEvent event) {
        this.topologyListener.clusterOffline((ClusterNode)new TerracottaNodeImpl(event.getNode()));
    }

    public void operationsEnabled(ClusterEvent event) {
        this.topologyListener.clusterOnline((ClusterNode)new TerracottaNodeImpl(event.getNode()));
    }

    public boolean useOutOfBandNotification(ClusterEvent event) {
        return this.topologyListener.getClass().getName().startsWith(EHCACHE_TERRACOTTA_PACKAGE_NAME) && (event.getType() == ClusterEvent.Type.NODE_LEFT || event.getType() == ClusterEvent.Type.OPERATIONS_DISABLED);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.topologyListener == null ? 0 : this.topologyListener.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterListenerAdapter other = (ClusterListenerAdapter)obj;
        return !(this.topologyListener == null ? other.topologyListener != null : !this.topologyListener.equals(other.topologyListener));
    }
}

