/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.concurrency;

import java.util.concurrent.TimeUnit;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;
import org.terracotta.locking.ClusteredLock;
import org.terracotta.modules.ehcache.store.ClusteredStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcSync
implements Sync {
    private final ClusteredLock lock;
    private final ThreadLocal<ClusteredStore.SyncLockState> syncLockState;

    TcSync(ThreadLocal<ClusteredStore.SyncLockState> synclockstate, ClusteredLock lock) {
        this.syncLockState = synclockstate;
        this.lock = lock;
    }

    public void lock(LockType type) {
        switch (type) {
            case READ: {
                this.lock.lock(org.terracotta.locking.LockType.READ);
                break;
            }
            case WRITE: {
                this.lock.lock(org.terracotta.locking.LockType.WRITE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported LockType " + type.name());
            }
        }
        this.syncLockState.set(this.syncLockState.get().lockAcquired());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(LockType type, long timeout) throws InterruptedException {
        boolean lockAcquired = false;
        try {
            switch (type) {
                case READ: {
                    lockAcquired = this.lock.tryLock(org.terracotta.locking.LockType.READ, timeout, TimeUnit.MILLISECONDS);
                    break;
                }
                case WRITE: {
                    lockAcquired = this.lock.tryLock(org.terracotta.locking.LockType.WRITE, timeout, TimeUnit.MILLISECONDS);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported LockType " + type.name());
                }
            }
            boolean bl = lockAcquired;
            return bl;
        }
        finally {
            if (lockAcquired) {
                this.syncLockState.set(this.syncLockState.get().lockAcquired());
            }
        }
    }

    public void unlock(LockType type) {
        switch (type) {
            case READ: {
                this.lock.unlock(org.terracotta.locking.LockType.READ);
                break;
            }
            case WRITE: {
                this.lock.unlock(org.terracotta.locking.LockType.WRITE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported LockType " + type.name());
            }
        }
        if (this.isHeldByCurrentThread(LockType.READ) || this.isHeldByCurrentThread(LockType.WRITE)) {
            this.syncLockState.set(this.syncLockState.get().lockAcquired());
        } else {
            this.syncLockState.set(this.syncLockState.get().lockReleased());
        }
    }

    public boolean isHeldByCurrentThread(LockType type) {
        switch (type) {
            case READ: {
                return this.lock.isHeldByCurrentThread(org.terracotta.locking.LockType.READ);
            }
            case WRITE: {
                return this.lock.isHeldByCurrentThread(org.terracotta.locking.LockType.WRITE);
            }
        }
        throw new IllegalArgumentException("Unsupported LockType " + type.name());
    }

    public String toString() {
        return this.lock.toString();
    }
}

