/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.concurrency;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.Sync;
import org.terracotta.locking.ClusteredLock;
import org.terracotta.modules.ehcache.concurrency.TcSync;
import org.terracotta.modules.ehcache.store.ClusteredStore;
import org.terracotta.modules.ehcache.store.ClusteredStoreBackend;
import org.terracotta.modules.ehcache.store.ValueModeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcCacheLockProvider
implements CacheLockProvider {
    private final ClusteredStoreBackend backend;
    private final ValueModeHandler valueModeHandler;
    private final ThreadLocal<ClusteredStore.SyncLockState> synclockstate;

    public TcCacheLockProvider(ThreadLocal<ClusteredStore.SyncLockState> synclockstate, ClusteredStoreBackend backend, ValueModeHandler valueModeHandler) {
        this.synclockstate = synclockstate;
        this.backend = backend;
        this.valueModeHandler = valueModeHandler;
    }

    public Sync getSyncForKey(Object key) {
        return new TcSync(this.synclockstate, this.getFinegrainedLock(key));
    }

    private ClusteredLock getFinegrainedLock(Object key) {
        Object portableKey;
        try {
            portableKey = this.valueModeHandler.createPortableKey(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        return this.backend.createFinegrainedLock(portableKey);
    }
}

