/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.coherence;

import com.tc.object.bytecode.NotClearable;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.terracotta.cluster.ClusterEvent;
import org.terracotta.cluster.ClusterInfo;
import org.terracotta.cluster.ClusterListener;
import org.terracotta.cluster.ClusterLogger;
import org.terracotta.cluster.ClusterNode;
import org.terracotta.cluster.TerracottaClusterInfo;
import org.terracotta.cluster.TerracottaLogger;
import org.terracotta.cluster.TerracottaProperties;
import org.terracotta.collections.ConcurrentDistributedMap;
import org.terracotta.locking.LockStrategy;
import org.terracotta.locking.LockType;
import org.terracotta.locking.strategy.HashcodeLockStrategy;
import org.terracotta.modules.ehcache.coherence.CacheCoherence;
import org.terracotta.modules.ehcache.store.ClusteredStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncoherentNodesSet
implements CacheCoherence,
ClusterListener,
NotClearable {
    private static final ClusterLogger LOGGER = new TerracottaLogger(IncoherentNodesSet.class.getName());
    private static final boolean DEBUG = new TerracottaProperties().getBoolean("ehcache.incoherent.logging", Boolean.valueOf(false));
    private static final Object SENTINEL_VALUE = new Object();
    private final ConcurrentMap<String, Object> incoherentNodes;
    private final String cacheName;
    private volatile transient ClusterInfo clusterInfo;
    private volatile transient AtomicBoolean coherentLocally;
    private volatile transient ReentrantReadWriteLock readWriteLock;
    private transient Object nodeJoinedEventListenerSync;
    private final ClusteredStore clusteredStore;

    public IncoherentNodesSet(String name, ClusteredStore clusteredStore) {
        this.cacheName = name;
        this.clusteredStore = clusteredStore;
        this.incoherentNodes = new ConcurrentDistributedMap(LockType.WRITE, (LockStrategy)new HashcodeLockStrategy(), 1);
        this.init();
    }

    @Override
    public void loadReferences() {
        this.debug("loadReferences()");
        this.incoherentNodes.getClass();
    }

    public void init() {
        this.debug("init() start");
        this.clusterInfo = new TerracottaClusterInfo();
        if (this.clusterInfo == null) {
            throw new RuntimeException("TerracottaCluster is not injected.");
        }
        this.nodeJoinedEventListenerSync = new Object();
        this.readWriteLock = new ReentrantReadWriteLock();
        this.coherentLocally = new AtomicBoolean(this.queryIsNodeCoherent());
        this.clusterInfo.addClusterListener((ClusterListener)this);
        this.cleanIncoherentNodes(this.clusterInfo.getClusterTopology().getNodes());
        this.debug("init done()");
    }

    private synchronized void cleanIncoherentNodes(Collection<ClusterNode> nodes) {
        HashSet nodesToRemoveFromIncoherentNodes = new HashSet(this.incoherentNodes.keySet());
        for (ClusterNode node : nodes) {
            nodesToRemoveFromIncoherentNodes.remove(node.getId());
        }
        if (nodesToRemoveFromIncoherentNodes.size() > 0) {
            LOGGER.info((Object)("Sanitizing incoherent nodes set: need to remove defunct nodes: " + nodesToRemoveFromIncoherentNodes + ", incoherent nodes: " + this.incoherentNodes.keySet()));
            for (String nodeID : nodesToRemoveFromIncoherentNodes) {
                this.removeIncoherentNode(nodeID);
            }
        }
    }

    @Override
    public boolean isClusterOnline() {
        return this.clusterInfo.areOperationsEnabled();
    }

    @Override
    public void acquireReadLock() {
        this.readWriteLock.readLock().lock();
    }

    @Override
    public void acquireWriteLock() {
        this.readWriteLock.writeLock().lock();
    }

    @Override
    public void releaseReadLock() {
        this.readWriteLock.readLock().unlock();
    }

    @Override
    public void releaseWriteLock() {
        this.readWriteLock.writeLock().unlock();
    }

    private synchronized boolean queryIsNodeCoherent() {
        String currentNodeId = this.getCurrentNodeId();
        this.debug("queryIsNodeCoherent(): currentNode: " + currentNodeId);
        return !this.incoherentNodes.containsKey(currentNodeId);
    }

    private synchronized boolean gotoIncoherentMode() {
        String currentNodeId = this.getCurrentNodeId();
        this.debug("gotoIncoherentMode(): Going incoherent - currentNode: " + currentNodeId);
        if (this.incoherentNodes.putIfAbsent(currentNodeId, SENTINEL_VALUE) == null) {
            this.debug("gotoIncoherentMode(): Added currentNode '" + currentNodeId + "' to incoherent nodes set");
            return true;
        }
        this.debug("gotoIncoherentMode(): currentNode '" + currentNodeId + "' already present in incoherent nodes set");
        return false;
    }

    private void gotoCoherentMode() {
        String currentNodeId = this.getCurrentNodeId();
        this.debug("gotoCoherentMode(): Going to coherent mode: " + currentNodeId);
        this.removeIncoherentNode(currentNodeId);
        this.debug("gotoCoherentMode(): Going to coherent mode: " + currentNodeId + " done.");
    }

    private synchronized boolean removeIncoherentNode(String nodeID) {
        this.debug("removeIncoherentNode(): Going to remove nodeId from incoherent-nodes set: " + nodeID);
        if (this.incoherentNodes.remove(nodeID) != null) {
            this.notifyAll();
            return true;
        }
        this.debug("removeIncoherentNode(): Node id not present in incoherent nodes set: " + nodeID);
        this.debug("removeIncoherentNode() done");
        return false;
    }

    @Override
    public synchronized void waitUntilClusterCoherent() {
        while (this.incoherentNodes.size() > 0) {
            try {
                if (DEBUG) {
                    this.debug("waitUntilClusterCoherent(): Going to wait until coherent cluster-wide");
                }
                this.wait();
                if (!DEBUG) continue;
                this.debug("waitUntilClusterCoherent(): Got notified after removing incoherent node");
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.debug("waitUntilClusterCoherent() done");
    }

    @Override
    public synchronized boolean isClusterCoherent() {
        if (DEBUG) {
            this.debug("isClusterCoherent()");
        }
        return this.incoherentNodes.size() == 0;
    }

    public synchronized boolean isFirstIncoherent() {
        return this.incoherentNodes.size() == 1;
    }

    @Override
    public boolean isNodeCoherent() {
        return this.coherentLocally.get();
    }

    @Override
    public void setNodeCoherent(boolean coherent) {
        if (coherent) {
            if (this.coherentLocally.compareAndSet(false, true)) {
                this.gotoCoherentMode();
            }
        } else if (this.coherentLocally.compareAndSet(true, false)) {
            this.gotoIncoherentMode();
        }
    }

    private String getCurrentNodeId() {
        if (this.clusterInfo.isNodeJoined()) {
            return this.clusterInfo.getCurrentNode().getId();
        }
        this.waitUntilNodeJoinsCluster();
        return this.clusterInfo.getCurrentNode().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilNodeJoinsCluster() {
        Object object = this.nodeJoinedEventListenerSync;
        synchronized (object) {
            while (!this.clusterInfo.isNodeJoined()) {
                try {
                    this.nodeJoinedEventListenerSync.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void nodeLeft(ClusterEvent evt) {
        this.debug("Received node left event: " + evt.getNode().getId());
        String nodeID = evt.getNode().getId();
        if (nodeID.equals(this.clusterInfo.getCurrentNode().getId())) {
            if (DEBUG) {
                this.debug("Ignoring nodeLeft from current node " + nodeID);
            }
        } else if (this.removeIncoherentNode(nodeID) && this.isClusterCoherent()) {
            this.clusteredStore.fireClusterCoherent(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeJoined(ClusterEvent evt) {
        Object object = this.nodeJoinedEventListenerSync;
        synchronized (object) {
            this.nodeJoinedEventListenerSync.notifyAll();
        }
    }

    public void operationsDisabled(ClusterEvent evt) {
    }

    public void operationsEnabled(ClusterEvent evt) {
    }

    private void debug(String msg) {
        if (DEBUG) {
            LOGGER.info((Object)("[" + this.cacheName + "]: " + msg + " [ incoherentNodes.keySet(): " + this.incoherentNodes.keySet() + " ]"));
        }
    }
}

