/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.coherence;

import java.util.HashSet;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.nonstop.NonStopCacheException;
import org.terracotta.api.Terracotta;
import org.terracotta.cluster.ClusterLogger;
import org.terracotta.cluster.TerracottaClusterInfo;
import org.terracotta.cluster.TerracottaLogger;
import org.terracotta.cluster.TerracottaProperties;

public class CacheShutdownHook {
    private static final ClusterLogger LOGGER = new TerracottaLogger(CacheShutdownHook.class.getName());
    private static final boolean DEBUG = new TerracottaProperties().getBoolean("ehcache.incoherent.logging", Boolean.valueOf(false));
    public static final CacheShutdownHook INSTANCE = new CacheShutdownHook();
    private final Set<Ehcache> registeredCaches = new HashSet<Ehcache>();
    private TerracottaClusterInfo terracottaClusterInfo;

    private CacheShutdownHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Terracotta.registerBeforeShutdownHook((Runnable)new Runnable(){

            public void run() {
                CacheShutdownHook.this.shutdownRegisteredCaches();
            }
        });
        CacheShutdownHook cacheShutdownHook = this;
        synchronized (cacheShutdownHook) {
            if (this.terracottaClusterInfo == null) {
                this.terracottaClusterInfo = new TerracottaClusterInfo();
            }
        }
    }

    private synchronized void shutdownRegisteredCaches() {
        this.debug("Shutting down registered ehcaches...");
        if (this.terracottaClusterInfo.areOperationsEnabled()) {
            for (Ehcache cache : this.registeredCaches) {
                try {
                    if (cache.isNodeCoherent()) continue;
                    this.debug("Setting cache coherent: " + cache.getName());
                    cache.setNodeCoherent(true);
                }
                catch (NonStopCacheException e) {
                    this.debug("NonStopCacheException ignored, probably L2 is not reachable anymore - " + e.getMessage());
                }
            }
        }
        this.debug("Completed shutting down ehcaches.");
    }

    public synchronized void registerCache(Ehcache cache) {
        if (this.registeredCaches.add(cache)) {
            this.debug("Registered cache for shutdown hook: " + cache.getName());
        }
    }

    public synchronized void unregisterCache(Ehcache cache) {
        if (this.registeredCaches.remove(cache)) {
            this.debug("Unregistered cache from shutdown hook: " + cache.getName());
        }
    }

    private void debug(String msg) {
        if (DEBUG) {
            LOGGER.info((Object)msg);
        }
    }
}

