/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.terracotta.InternalEhcache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVMResources {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalVMResources.class);
    private final ConcurrentMap<String, Object> resources = new ConcurrentHashMap<String, Object>();

    public static LocalVMResources getInstance() {
        return LocalVMResourcesHolder.INSTANCE;
    }

    private LocalVMResources() {
    }

    public Object registerCacheManager(String uuid, CacheManager cacheManager) {
        LOGGER.debug("Registering CacheManager with uuid: " + uuid + ", cacheManager: " + cacheManager);
        CacheManagerDisposalListener cacheManagerEventListener = new CacheManagerDisposalListener(uuid);
        cacheManager.getCacheManagerEventListenerRegistry().registerListener((CacheManagerEventListener)cacheManagerEventListener);
        this.resources.put(CacheManagerDisposalListener.class.getName() + "_" + uuid, cacheManagerEventListener);
        return this.resources.put(uuid, cacheManager);
    }

    public CacheManager getRegisteredCacheManager(String cacheManagerClusterUUID) {
        Object object = this.resources.get(cacheManagerClusterUUID);
        if (object instanceof CacheManager) {
            return (CacheManager)object;
        }
        throw new CacheException("Expected a cacheManager to be registered with uuid: " + cacheManagerClusterUUID + ", but was mapped to (className: " + (object == null ? "null" : object.getClass().getName()) + "): " + object);
    }

    public Object registerCache(Ehcache cache) {
        LOGGER.debug("Registering Cache with name: " + cache.getName());
        return this.resources.put(this.getFQN(cache.getCacheManager(), cache.getName()), cache);
    }

    private String getFQN(CacheManager cacheManager, String cacheName) {
        String cmName = cacheManager.isNamed() ? cacheManager.getName() : "__DEFAULT_CM_PREFIX__";
        return cmName + "_" + cacheName;
    }

    public void unregisterCache(Ehcache cache) {
        LOGGER.debug("Unregistering Cache with name: " + cache.getName());
        if (this.getRegisteredCache(cache.getCacheManager(), cache.getName()) != null) {
            this.resources.remove(this.getFQN(cache.getCacheManager(), cache.getName()));
        }
    }

    public void unregisterCacheManager(String cacheManagerClusterUUID) {
        LOGGER.debug("Unregistering CacheManager with uuid: " + cacheManagerClusterUUID);
        CacheManager cacheManager = (CacheManager)this.resources.remove(cacheManagerClusterUUID);
        CacheManagerDisposalListener listener = (CacheManagerDisposalListener)this.resources.remove(CacheManagerDisposalListener.class.getName() + "_" + cacheManagerClusterUUID);
        if (cacheManager != null) {
            cacheManager.getCacheManagerEventListenerRegistry().unregisterListener((CacheManagerEventListener)listener);
        }
    }

    public InternalEhcache getRegisteredCache(CacheManager cacheManager, String cacheName) {
        String cacheFQN = this.getFQN(cacheManager, cacheName);
        Object object = this.resources.get(cacheFQN);
        if (object == null) {
            return null;
        }
        if (object instanceof InternalEhcache) {
            return (InternalEhcache)object;
        }
        throw new CacheException("Expected a cache to be registered with uuid: " + cacheFQN + ", but was mapped to (className: " + object.getClass().getName() + "): " + object);
    }

    ConcurrentMap<String, Object> getRegisteredResources() {
        return this.resources;
    }

    private class CacheManagerDisposalListener
    implements CacheManagerEventListener {
        private final String uuid;

        private CacheManagerDisposalListener(String uuid) {
            this.uuid = uuid;
        }

        public void init() throws CacheException {
        }

        public Status getStatus() {
            return null;
        }

        public void dispose() throws CacheException {
            LocalVMResources.this.unregisterCacheManager(this.uuid);
        }

        public void notifyCacheAdded(String cacheName) {
        }

        public void notifyCacheRemoved(String cacheName) {
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            return this.uuid.equals(((CacheManagerDisposalListener)o).uuid);
        }
    }

    private static final class LocalVMResourcesHolder {
        private static final LocalVMResources INSTANCE = new LocalVMResources();

        private LocalVMResourcesHolder() {
        }
    }
}

