/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.IOException;
import java.io.ObjectOutputStream;
import net.sf.ehcache.Element;
import net.sf.ehcache.util.TimeUtil;
import org.terracotta.cache.CacheConfig;
import org.terracotta.cache.ImmutableConfig;
import org.terracotta.cache.evictor.CapacityEvictionPolicyData;
import org.terracotta.cache.value.AbstractStatelessTimestampedValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementData
extends AbstractStatelessTimestampedValue<Object> {
    protected final Object value;
    protected final long version;
    protected final long creationTime;
    protected long lastAccessTime;
    protected final long hitCount;
    protected final boolean cacheDefaultLifespan;
    protected final int timeToLive;
    protected final int timeToIdle;
    protected final long lastUpdateTime;

    protected AbstractElementData(Object value, long version, long creationTime, long lastAccessTime, long hitCount, boolean cacheDefaultLifespan, int timeToLive, int timeToIdle, long lastUpdateTime) {
        this.value = value;
        this.version = version;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.hitCount = hitCount;
        this.cacheDefaultLifespan = cacheDefaultLifespan;
        this.timeToLive = timeToLive;
        this.timeToIdle = timeToIdle;
        this.lastUpdateTime = lastUpdateTime;
    }

    public abstract void setCapacityEvictionPolicyData(CapacityEvictionPolicyData var1);

    public abstract CapacityEvictionPolicyData getCapacityEvictionPolicyData();

    protected abstract CapacityEvictionPolicyData fastGetCapacityEvictionPolicyData();

    public Element createElement(Object key) {
        return new Element(key, this.value, this.version, this.creationTime, this.lastAccessTime, this.hitCount, this.cacheDefaultLifespan, this.timeToLive, this.timeToIdle, this.lastUpdateTime);
    }

    public void write(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.value);
        oos.writeLong(this.version);
        oos.writeLong(this.creationTime);
        oos.writeLong(this.lastAccessTime);
        oos.writeLong(this.hitCount);
        oos.writeBoolean(this.cacheDefaultLifespan);
        oos.writeInt(this.timeToLive);
        oos.writeInt(this.timeToIdle);
        oos.writeLong(this.lastUpdateTime);
    }

    public Object getValue() {
        return this.value;
    }

    public int getLastAccessedTime() {
        return TimeUtil.toSecs((long)this.lastAccessTime);
    }

    protected void setLastAccessedTimeInternal(int usedAtTime) {
        this.lastAccessTime = TimeUtil.toMillis((int)usedAtTime);
    }

    public int getCreateTime() {
        return TimeUtil.toSecs((long)this.creationTime);
    }

    public int expiresAt(CacheConfig config) {
        if (this.hasCustomLifespan()) {
            return this.customLifespanExpiresAt(config);
        }
        return super.expiresAt(config);
    }

    private boolean hasCustomLifespan() {
        return !this.cacheDefaultLifespan;
    }

    private int customLifespanExpiresAt(CacheConfig config) {
        ImmutableConfig customConfig = new ImmutableConfig("custom", false, this.timeToIdle, this.timeToLive, false, 0, 0, 0, null, config.isServerMap());
        return super.expiresAt((CacheConfig)customConfig);
    }
}

