/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.toolkit.collections.servermap;

import com.terracotta.toolkit.collections.servermap.api.ServerMapLocalStore;
import com.terracotta.toolkit.collections.servermap.api.ServerMapLocalStoreFactory;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheInitializationHelper;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.terracotta.InternalEhcache;
import org.terracotta.collections.servermap.ServerMapLocalStoreConfig;
import org.terracotta.modules.ehcache.store.servermap.EhcacheSMLocalStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServerMapLocalStoreFactory
implements ServerMapLocalStoreFactory {
    public <K, V> ServerMapLocalStore<K, V> getOrCreateServerMapLocalStore(ServerMapLocalStoreConfig config) {
        InternalEhcache localStoreCache = this.getOrCreateEhcacheLocalCache(config);
        return new EhcacheSMLocalStore(localStoreCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalEhcache getOrCreateEhcacheLocalCache(ServerMapLocalStoreConfig config) {
        InternalEhcache ehcache;
        CacheManager cacheManager;
        CacheManager cacheManager2 = cacheManager = this.getOrCreateCacheManager(config);
        synchronized (cacheManager2) {
            String localCacheName = "local-cache-for-" + config.getLocalStoreName();
            ehcache = (InternalEhcache)cacheManager.getEhcache(config.getLocalStoreName());
            if (ehcache == null) {
                ehcache = new Cache(new CacheConfiguration().name(localCacheName).maxEntriesLocalHeap(0));
                new CacheInitializationHelper(cacheManager).initializeEhcache((Ehcache)ehcache);
            }
        }
        return ehcache;
    }

    private CacheManager getOrCreateCacheManager(ServerMapLocalStoreConfig config) {
        CacheManager cacheManager = CacheManager.getCacheManager((String)config.getLocalStoreManagerName());
        if (cacheManager == null) {
            cacheManager = CacheManager.create((Configuration)new Configuration().name(config.getLocalStoreManagerName()));
        }
        return cacheManager;
    }
}

