/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.SettingsCacheModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneCacheModel
extends SettingsCacheModel {
    private final ObjectName beanName;
    private final CacheModelInstance cacheModelInstance;

    public StandaloneCacheModel(CacheManagerModel cacheManagerModel, CacheModelInstance cacheModelInstance) {
        super(cacheManagerModel, cacheModelInstance.getCacheName());
        this.cacheModelInstance = cacheModelInstance;
        this.beanName = cacheModelInstance.getBeanName();
        this.setAttributes(this.getAttributes(this.beanName, new HashSet<String>(Arrays.asList(MBEAN_ATTRS))));
        this.addNotificationListener(this.beanName, this);
    }

    @Override
    public ObjectName getRandomBean() {
        return this.beanName;
    }

    @Override
    public int beanCount() {
        return 1;
    }

    @Override
    public Set<CacheModelInstance> cacheModelInstances() {
        return Collections.singleton(this.cacheModelInstance);
    }

    public CacheModelInstance cacheModelInstance() {
        return this.cacheModelInstance;
    }

    @Override
    protected Set<ObjectName> getActiveCacheModelBeans() {
        return Collections.singleton(this.beanName);
    }

    @Override
    public int getStatisticsEnabledCount() {
        return this.cacheManagerModel.getStatisticsEnabledCount(this);
    }

    @Override
    public int getBulkLoadEnabledCount() {
        return this.cacheManagerModel.getBulkLoadEnabledCount(this);
    }

    @Override
    public int getEnabledCount() {
        return this.cacheManagerModel.getEnabledCount(this);
    }

    @Override
    public String generateActiveConfigDeclaration() {
        return this.cacheManagerModel.generateActiveConfigDeclaration(this.getCacheName());
    }

    @Override
    protected void cacheModelChanged() {
        super.cacheModelChanged();
        this.cacheManagerModel.fireStandaloneCacheModelChanged(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.beanName == null ? 0 : this.beanName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof StandaloneCacheModel)) {
            return false;
        }
        StandaloneCacheModel other = (StandaloneCacheModel)obj;
        return !(this.beanName == null ? other.beanName != null : !this.beanName.equals(other.beanName));
    }
}

