/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ICacheSettings;
import org.terracotta.modules.ehcache.presentation.model.IMutableCacheSettings;
import org.terracotta.modules.ehcache.presentation.model.MutableCacheSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsCacheModel
extends CacheModel
implements ICacheSettings {
    private static final String LOGGING_ENABLED_PROP = "LoggingEnabled";
    private static final String MAX_ENTRIES_LOCAL_HEAP_PROP = "MaxEntriesLocalHeap";
    private static final String MAX_ENTRIES_LOCAL_DISK_PROP = "MaxEntriesLocalDisk";
    private static final String MAX_BYTES_LOCAL_HEAP_PROP = "MaxBytesLocalHeap";
    private static final String MAX_BYTES_LOCAL_HEAP_AS_STRING_PROP = "MaxBytesLocalHeapAsString";
    private static final String MAX_BYTES_LOCAL_OFFHEAP_PROP = "MaxBytesLocalOffHeap";
    private static final String MAX_BYTES_LOCAL_OFFHEAP_AS_STRING_PROP = "MaxBytesLocalOffHeapAsString";
    private static final String MAX_BYTES_LOCAL_DISK_PROP = "MaxBytesLocalDisk";
    private static final String MAX_BYTES_LOCAL_DISK_AS_STRING_PROP = "MaxBytesLocalDiskAsString";
    private static final String TIME_TO_IDLE_SECONDS_PROP = "TimeToIdleSeconds";
    private static final String TIME_TO_LIVE_SECONDS_PROP = "TimeToLiveSeconds";
    private static final String MEMORY_STORE_EVICTION_POLICY_PROP = "MemoryStoreEvictionPolicy";
    private static final String DISK_PERSISTENT_PROP = "DiskPersistent";
    private static final String ETERNAL_PROP = "Eternal";
    private static final String OVERFLOW_TO_DISK_PROP = "OverflowToDisk";
    static final String[] MBEAN_ATTRS = new String[]{"CacheName", "MaxEntriesLocalHeap", "MaxEntriesLocalDisk", "MaxBytesLocalHeapAsString", "MaxBytesLocalHeap", "MaxBytesLocalOffHeapAsString", "MaxBytesLocalOffHeap", "MaxBytesLocalDiskAsString", "MaxBytesLocalDisk", "MemoryStoreEvictionPolicy", "TimeToIdleSeconds", "TimeToLiveSeconds", "DiskPersistent", "Eternal", "OverflowToDisk", "LoggingEnabled"};
    public static String[] ATTRS = new String[]{"ShortName", "MaxEntriesLocalHeap", "MaxEntriesLocalDisk", "MaxBytesLocalHeapAsString", "MaxBytesLocalHeap", "MaxBytesLocalOffHeapAsString", "MaxBytesLocalOffHeap", "MaxBytesLocalDiskAsString", "MaxBytesLocalDisk", "MemoryStoreEvictionPolicy", "TimeToIdleSeconds", "TimeToLiveSeconds"};
    public static String[] HEADERS = new String[]{"Name", "Max Local Heap Entries", "Max Local Disk Entries", "Max Local Heap Bytes", "Max Local Disk Bytes", "Max Local OffHeap Bytes", "Eviction Policy", "Time-To-Idle", "Time-To-Live"};
    private boolean loggingEnabled;
    private long maxEntriesLocalHeap;
    private long maxEntriesLocalDisk;
    private String maxBytesLocalHeapAsString;
    private String maxBytesLocalOffHeapAsString;
    private String maxBytesLocalDiskAsString;
    private long maxBytesLocalHeap;
    private long maxBytesLocalOffHeap;
    private long maxBytesLocalDisk;
    private long timeToIdleSeconds;
    private long timeToLiveSeconds;
    private String memoryStoreEvictionPolicy;
    private boolean diskPersistent;
    private boolean eternal;
    private boolean overflowToDisk;

    public SettingsCacheModel(CacheManagerModel cacheManagerModel, String cacheName) {
        super(cacheManagerModel, cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, Object> attrs) {
        SettingsCacheModel settingsCacheModel = this;
        synchronized (settingsCacheModel) {
            this.timeToLiveSeconds = SettingsCacheModel.longAttr(attrs, TIME_TO_LIVE_SECONDS_PROP);
            this.timeToIdleSeconds = SettingsCacheModel.longAttr(attrs, TIME_TO_IDLE_SECONDS_PROP);
            this.maxEntriesLocalHeap = SettingsCacheModel.longAttr(attrs, MAX_ENTRIES_LOCAL_HEAP_PROP);
            this.maxEntriesLocalDisk = SettingsCacheModel.longAttr(attrs, MAX_ENTRIES_LOCAL_DISK_PROP);
            this.maxBytesLocalHeapAsString = SettingsCacheModel.stringAttr(attrs, MAX_BYTES_LOCAL_HEAP_AS_STRING_PROP);
            this.maxBytesLocalOffHeapAsString = SettingsCacheModel.stringAttr(attrs, MAX_BYTES_LOCAL_OFFHEAP_AS_STRING_PROP);
            this.maxBytesLocalDiskAsString = SettingsCacheModel.stringAttr(attrs, MAX_BYTES_LOCAL_DISK_AS_STRING_PROP);
            this.maxBytesLocalHeap = SettingsCacheModel.longAttr(attrs, MAX_BYTES_LOCAL_HEAP_PROP);
            this.maxBytesLocalOffHeap = SettingsCacheModel.longAttr(attrs, MAX_BYTES_LOCAL_OFFHEAP_PROP);
            this.maxBytesLocalDisk = SettingsCacheModel.longAttr(attrs, MAX_BYTES_LOCAL_DISK_PROP);
            this.memoryStoreEvictionPolicy = SettingsCacheModel.stringAttr(attrs, MEMORY_STORE_EVICTION_POLICY_PROP);
            this.diskPersistent = SettingsCacheModel.booleanAttr(attrs, DISK_PERSISTENT_PROP);
            this.eternal = SettingsCacheModel.booleanAttr(attrs, ETERNAL_PROP);
            this.overflowToDisk = SettingsCacheModel.booleanAttr(attrs, OVERFLOW_TO_DISK_PROP);
            this.loggingEnabled = SettingsCacheModel.booleanAttr(attrs, LOGGING_ENABLED_PROP);
        }
        this.firePropertyChange(null, null, null);
    }

    @Override
    public Set<CacheModelInstance> cacheModelInstances() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoggingEnabled(boolean enabled) {
        boolean oldLoggingEnabled = this.isLoggingEnabled();
        if (oldLoggingEnabled != enabled) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.loggingEnabled = enabled;
            }
            this._setAttribute(LOGGING_ENABLED_PROP, enabled);
            this.firePropertyChange(LOGGING_ENABLED_PROP, oldLoggingEnabled, enabled);
        }
    }

    @Override
    public synchronized boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public synchronized long getMaxEntriesLocalHeap() {
        return this.maxEntriesLocalHeap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxEntriesLocalHeap(long maxEntries) {
        long oldMaxEntries = this.getMaxEntriesLocalHeap();
        if (oldMaxEntries != maxEntries) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.maxEntriesLocalHeap = maxEntries;
            }
            this._setAttribute(MAX_ENTRIES_LOCAL_HEAP_PROP, maxEntries);
            this.firePropertyChange(MAX_ENTRIES_LOCAL_HEAP_PROP, oldMaxEntries, maxEntries);
        }
    }

    @Override
    public synchronized long getMaxEntriesLocalDisk() {
        return this.maxEntriesLocalDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxEntriesLocalDisk(long maxEntries) {
        long oldMaxEntries = this.getMaxEntriesLocalDisk();
        if (oldMaxEntries != maxEntries) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.maxEntriesLocalDisk = maxEntries;
            }
            this._setAttribute(MAX_ENTRIES_LOCAL_DISK_PROP, maxEntries);
            this.firePropertyChange(MAX_ENTRIES_LOCAL_DISK_PROP, oldMaxEntries, maxEntries);
        }
    }

    @Override
    public synchronized String getMaxBytesLocalHeapAsString() {
        return this.maxBytesLocalHeapAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxBytesLocalHeapAsString(String maxBytes) {
        String oldMaxBytes = this.getMaxBytesLocalHeapAsString();
        if (!StringUtils.equals((String)oldMaxBytes, (String)maxBytes)) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.maxBytesLocalHeapAsString = maxBytes;
            }
            this._setAttribute(MAX_BYTES_LOCAL_HEAP_AS_STRING_PROP, maxBytes);
            this.firePropertyChange(MAX_BYTES_LOCAL_HEAP_AS_STRING_PROP, oldMaxBytes, maxBytes);
        }
    }

    @Override
    public synchronized String getMaxBytesLocalOffHeapAsString() {
        return this.maxBytesLocalOffHeapAsString;
    }

    @Override
    public synchronized long getMaxBytesLocalOffHeap() {
        return this.maxBytesLocalOffHeap;
    }

    @Override
    public synchronized long getMaxBytesLocalHeap() {
        return this.maxBytesLocalHeap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxBytesLocalHeap(long maxBytes) {
        long oldMaxBytes = this.getMaxBytesLocalHeap();
        if (oldMaxBytes != maxBytes) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.maxBytesLocalHeap = maxBytes;
            }
            this._setAttribute(MAX_BYTES_LOCAL_HEAP_PROP, maxBytes);
            this.firePropertyChange(MAX_BYTES_LOCAL_HEAP_PROP, oldMaxBytes, maxBytes);
        }
    }

    @Override
    public synchronized String getMaxBytesLocalDiskAsString() {
        return this.maxBytesLocalDiskAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxBytesLocalDiskAsString(String maxBytes) {
        String oldMaxBytes = this.getMaxBytesLocalDiskAsString();
        if (!StringUtils.equals((String)oldMaxBytes, (String)maxBytes)) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.maxBytesLocalDiskAsString = maxBytes;
            }
            this._setAttribute(MAX_BYTES_LOCAL_DISK_AS_STRING_PROP, maxBytes);
            this.firePropertyChange(MAX_BYTES_LOCAL_DISK_AS_STRING_PROP, oldMaxBytes, maxBytes);
        }
    }

    @Override
    public synchronized long getMaxBytesLocalDisk() {
        return this.maxBytesLocalDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxBytesLocalDisk(long maxBytes) {
        long oldMaxBytes = this.getMaxBytesLocalDisk();
        if (oldMaxBytes != maxBytes) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.maxBytesLocalDisk = maxBytes;
            }
            this._setAttribute(MAX_BYTES_LOCAL_DISK_PROP, maxBytes);
            this.firePropertyChange(MAX_BYTES_LOCAL_DISK_PROP, oldMaxBytes, maxBytes);
        }
    }

    @Override
    public synchronized long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeToIdleSeconds(long tti) {
        long oldTTI = this.getTimeToIdleSeconds();
        if (oldTTI != tti) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.timeToIdleSeconds = tti;
            }
            this._setAttribute(TIME_TO_IDLE_SECONDS_PROP, tti);
            this.firePropertyChange(TIME_TO_IDLE_SECONDS_PROP, oldTTI, tti);
        }
    }

    @Override
    public synchronized long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeToLiveSeconds(long ttl) {
        long oldTTL = this.getTimeToLiveSeconds();
        if (oldTTL != ttl) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.timeToLiveSeconds = ttl;
            }
            this._setAttribute(TIME_TO_LIVE_SECONDS_PROP, ttl);
            this.firePropertyChange(TIME_TO_LIVE_SECONDS_PROP, oldTTL, ttl);
        }
    }

    @Override
    public synchronized String getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemoryStoreEvictionPolicy(String evictionPolicy) {
        String oldEvictionPolicy = this.getMemoryStoreEvictionPolicy();
        if (!StringUtils.equals((String)oldEvictionPolicy, (String)evictionPolicy)) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.memoryStoreEvictionPolicy = evictionPolicy;
            }
            this._setAttribute(MEMORY_STORE_EVICTION_POLICY_PROP, evictionPolicy);
            this.firePropertyChange(MEMORY_STORE_EVICTION_POLICY_PROP, oldEvictionPolicy, evictionPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiskPersistent(boolean diskPersistent) {
        boolean oldDiskPersistent = this.isDiskPersistent();
        if (oldDiskPersistent != diskPersistent) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.diskPersistent = diskPersistent;
            }
            this._setAttribute(DISK_PERSISTENT_PROP, diskPersistent);
            this.firePropertyChange(DISK_PERSISTENT_PROP, oldDiskPersistent, diskPersistent);
        }
    }

    @Override
    public synchronized boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEternal(boolean eternal) {
        boolean oldEternal = this.isEternal();
        if (oldEternal != eternal) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.eternal = eternal;
            }
            this._setAttribute(ETERNAL_PROP, eternal);
            this.firePropertyChange(ETERNAL_PROP, oldEternal, eternal);
        }
    }

    @Override
    public synchronized boolean isEternal() {
        return this.eternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverflowToDisk(boolean overflowToDisk) {
        boolean oldOverflowToDisk = this.isOverflowToDisk();
        if (oldOverflowToDisk != overflowToDisk) {
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.overflowToDisk = overflowToDisk;
            }
            this._setAttribute(OVERFLOW_TO_DISK_PROP, overflowToDisk);
            this.firePropertyChange(OVERFLOW_TO_DISK_PROP, oldOverflowToDisk, overflowToDisk);
        }
    }

    @Override
    public synchronized boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public boolean hasSizeBasedLimits() {
        return this.getMaxBytesLocalHeap() + this.getMaxBytesLocalOffHeap() + this.getMaxBytesLocalDisk() > 0L;
    }

    @Override
    public void init() {
        this.addListeners();
        this.onSet.addAll(this.getActiveCacheModelBeans());
        ObjectName target = this.getRandomBean();
        if (target != null) {
            Map<String, Object> result = this.getAttributes(target, new HashSet<String>(Arrays.asList(MBEAN_ATTRS)));
            this.setAttributes(result);
            for (ObjectName objectName : this.onSet) {
                this.addNotificationListener(objectName, this);
            }
        }
    }

    @Override
    protected Set<ObjectName> getActiveCacheModelBeans() {
        return new HashSet<ObjectName>();
    }

    @Override
    public void suspend() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notif, Object data) {
        String type = notif.getType();
        if ("CacheChanged".equals(type) || "CacheEnabled".equals(type)) {
            Map attrs = (Map)notif.getUserData();
            SettingsCacheModel settingsCacheModel = this;
            synchronized (settingsCacheModel) {
                this.loggingEnabled = SettingsCacheModel.booleanAttr(attrs, LOGGING_ENABLED_PROP);
                this.timeToLiveSeconds = SettingsCacheModel.longAttr(attrs, TIME_TO_LIVE_SECONDS_PROP);
                this.timeToIdleSeconds = SettingsCacheModel.longAttr(attrs, TIME_TO_IDLE_SECONDS_PROP);
                this.maxEntriesLocalHeap = SettingsCacheModel.longAttr(attrs, MAX_ENTRIES_LOCAL_HEAP_PROP);
                this.maxEntriesLocalDisk = SettingsCacheModel.longAttr(attrs, MAX_ENTRIES_LOCAL_DISK_PROP);
                this.maxBytesLocalHeapAsString = SettingsCacheModel.stringAttr(attrs, MAX_BYTES_LOCAL_HEAP_AS_STRING_PROP);
                this.maxBytesLocalOffHeapAsString = SettingsCacheModel.stringAttr(attrs, MAX_BYTES_LOCAL_OFFHEAP_AS_STRING_PROP);
                this.maxBytesLocalDiskAsString = SettingsCacheModel.stringAttr(attrs, MAX_BYTES_LOCAL_DISK_AS_STRING_PROP);
                this.maxBytesLocalHeap = SettingsCacheModel.longAttr(attrs, MAX_BYTES_LOCAL_HEAP_PROP);
                this.maxBytesLocalOffHeap = SettingsCacheModel.longAttr(attrs, MAX_BYTES_LOCAL_OFFHEAP_PROP);
                this.maxBytesLocalDisk = SettingsCacheModel.longAttr(attrs, MAX_BYTES_LOCAL_DISK_PROP);
                this.memoryStoreEvictionPolicy = SettingsCacheModel.stringAttr(attrs, MEMORY_STORE_EVICTION_POLICY_PROP);
                this.diskPersistent = SettingsCacheModel.booleanAttr(attrs, DISK_PERSISTENT_PROP);
                this.eternal = SettingsCacheModel.booleanAttr(attrs, ETERNAL_PROP);
                this.overflowToDisk = SettingsCacheModel.booleanAttr(attrs, OVERFLOW_TO_DISK_PROP);
            }
            this.firePropertyChange(null, null, null);
            this.cacheModelChanged();
        }
    }

    protected void cacheModelChanged() {
        this.cacheManagerModel.cacheModelChanged(this);
    }

    @Override
    public int getStatisticsEnabledCount() {
        return this.cacheManagerModel.getStatisticsEnabledCount(this);
    }

    @Override
    public int getBulkLoadEnabledCount() {
        return this.cacheManagerModel.getBulkLoadEnabledCount(this);
    }

    @Override
    public int getEnabledCount() {
        return this.cacheManagerModel.getEnabledCount(this);
    }

    @Override
    public String generateActiveConfigDeclaration() {
        return this.cacheManagerModel.generateActiveConfigDeclaration(this.getCacheName());
    }

    @Override
    public int compareTo(Object o) {
        SettingsCacheModel other = (SettingsCacheModel)o;
        return this.getCacheName().compareTo(other.getCacheName());
    }

    public IMutableCacheSettings getCacheSettings() {
        return new MutableCacheSettings(this);
    }

    public void apply(IMutableCacheSettings settings) {
        this.setMaxEntriesLocalHeap(settings.getMaxEntriesLocalHeap());
        this.setMaxEntriesLocalDisk(settings.getMaxEntriesLocalDisk());
        this.setMaxBytesLocalHeapAsString(settings.getMaxBytesLocalHeapAsString());
        this.setMaxBytesLocalDiskAsString(settings.getMaxBytesLocalDiskAsString());
        this.setTimeToIdleSeconds(settings.getTimeToIdleSeconds());
        this.setTimeToLiveSeconds(settings.getTimeToLiveSeconds());
    }

    public TableModel executeQuery(String query) throws Exception {
        Object result = this.invokeOnce("executeQuery", new Object[]{query}, new String[]{"java.lang.String"});
        if (result instanceof Exception) {
            throw (Exception)result;
        }
        return (TableModel)result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isDiskPersistent() ? 1231 : 1237);
        result = 31 * result + (this.isEternal() ? 1231 : 1237);
        result = 31 * result + (this.isLoggingEnabled() ? 1231 : 1237);
        result = 31 * result + (int)this.getMaxEntriesLocalHeap();
        result = 31 * result + (int)this.getMaxEntriesLocalHeap();
        result = 31 * result + (int)this.getMaxEntriesLocalDisk();
        result = 31 * result + (this.getMemoryStoreEvictionPolicy() == null ? 0 : this.getMemoryStoreEvictionPolicy().hashCode());
        result = 31 * result + (this.isOverflowToDisk() ? 1231 : 1237);
        result = 31 * result + (int)(this.getTimeToIdleSeconds() ^ this.getTimeToIdleSeconds() >>> 32);
        result = 31 * result + (int)(this.getTimeToLiveSeconds() ^ this.getTimeToLiveSeconds() >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SettingsCacheModel)) {
            return false;
        }
        SettingsCacheModel other = (SettingsCacheModel)obj;
        if (this.isDiskPersistent() != other.isDiskPersistent()) {
            return false;
        }
        if (this.isEternal() != other.isEternal()) {
            return false;
        }
        if (this.isLoggingEnabled() != other.isLoggingEnabled()) {
            return false;
        }
        if (this.getMaxEntriesLocalHeap() != other.getMaxEntriesLocalHeap()) {
            return false;
        }
        if (this.getMaxEntriesLocalDisk() != other.getMaxEntriesLocalDisk()) {
            return false;
        }
        if (this.getMemoryStoreEvictionPolicy() == null ? other.getMemoryStoreEvictionPolicy() != null : !this.getMemoryStoreEvictionPolicy().equals(other.getMemoryStoreEvictionPolicy())) {
            return false;
        }
        if (this.isOverflowToDisk() != other.isOverflowToDisk()) {
            return false;
        }
        if (this.getTimeToIdleSeconds() != other.getTimeToIdleSeconds()) {
            return false;
        }
        return this.getTimeToLiveSeconds() == other.getTimeToLiveSeconds();
    }
}

