/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import com.tc.admin.model.IClusterModel;
import com.tc.admin.model.IServer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.ObjectName;
import org.terracotta.modules.ehcache.presentation.EhcacheStatsUtils;
import org.terracotta.modules.ehcache.presentation.model.BaseMBeanModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.EhcacheModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheModel
extends BaseMBeanModel
implements PropertyChangeListener {
    private final ConcurrentMap<String, CacheManagerModel> cacheManagerMap = new ConcurrentHashMap<String, CacheManagerModel>();
    public static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();

    public EhcacheModel(IClusterModel clusterModel) {
        super(clusterModel);
        clusterModel.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public CacheManagerModel getCacheManagerModel(String cacheManagerName) {
        return (CacheManagerModel)this.cacheManagerMap.get(cacheManagerName);
    }

    public int getCacheManagerCount() {
        return this.cacheManagerMap.size();
    }

    public Iterator<CacheManagerModel> cacheManagers() {
        return this.cacheManagerMap.values().iterator();
    }

    public String[] getCacheManagerNames() {
        Object[] result = this.cacheManagerMap.keySet().toArray(new String[this.cacheManagerMap.size()]);
        Arrays.sort(result);
        return result;
    }

    @Override
    public void init() {
        this.addListeners();
        this.onSet.addAll(this.getActiveCacheManagerBeans());
        for (ObjectName objectName : new HashSet(this.onSet)) {
            this.testAddCacheManagerModel(objectName);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IServer newActive;
        String prop = evt.getPropertyName();
        if ("activeCoordinator".equals(prop) && (newActive = (IServer)evt.getNewValue()) != null) {
            this.suspend();
            this.init();
        }
    }

    @Override
    public void suspend() {
        this.removeListeners();
        HashMap<String, CacheManagerModel> tmpMap = new HashMap<String, CacheManagerModel>(this.cacheManagerMap);
        this.cacheManagerMap.clear();
        for (CacheManagerModel cmm : tmpMap.values()) {
            if (cmm == null) continue;
            this.fireCacheManagerRemoved(cmm);
            cmm.tearDown();
        }
        tmpMap.clear();
    }

    @Override
    public void reset() {
    }

    private Set<ObjectName> getActiveCacheManagerBeans() {
        return this.getActiveCacheManagerBeans(null);
    }

    private Set<ObjectName> getActiveCacheManagerBeans(String name) {
        IServer activeCoord = this.getActiveCoordinator();
        if (activeCoord != null) {
            try {
                StringBuilder sb = new StringBuilder("net.sf.ehcache:type=SampledCacheManager");
                if (name != null) {
                    sb.append(",name=" + EhcacheStatsUtils.mbeanSafe(name));
                }
                sb.append(",*");
                return activeCoord.queryNames(new ObjectName(sb.toString()), null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }

    public CacheManagerModel removeCacheManagerModel(String cacheManagerName) {
        return (CacheManagerModel)this.cacheManagerMap.remove(cacheManagerName);
    }

    private boolean testAddCacheManagerModel(ObjectName on) {
        String name;
        this.onSet.add(on);
        if (this.cacheManagerMap != null && !this.cacheManagerMap.containsKey(name = on.getKeyProperty("name"))) {
            CacheManagerModel cacheManagerModel = new CacheManagerModel(this, name);
            cacheManagerModel.startup();
            if (this.cacheManagerMap.putIfAbsent(name, cacheManagerModel) == null) {
                this.fireCacheManagerAdded(cacheManagerModel);
                return true;
            }
        }
        return false;
    }

    private boolean testRemoveCacheManagerModel(ObjectName on) {
        String name;
        CacheManagerModel cacheManagerModel;
        this.onSet.remove(on);
        if (this.cacheManagerMap != null && (cacheManagerModel = this.getCacheManagerModel(name = on.getKeyProperty("name"))) != null && cacheManagerModel.isEmpty() && this.cacheManagerMap.remove(name, cacheManagerModel)) {
            this.fireCacheManagerRemoved(cacheManagerModel);
            cacheManagerModel.tearDown();
            return true;
        }
        return false;
    }

    private boolean isCacheManagerBean(ObjectName on) {
        if (on == null) {
            return false;
        }
        return on.getKeyProperty("type").equals("SampledCacheManager");
    }

    @Override
    public void handleNotification(Notification notif, Object data) {
        String type = notif.getType();
        if (notif instanceof MBeanServerNotification) {
            MBeanServerNotification mbsn = (MBeanServerNotification)notif;
            ObjectName on = mbsn.getMBeanName();
            if (type.equals("JMX.mbean.registered")) {
                if (this.isCacheManagerBean(on)) {
                    this.testAddCacheManagerModel(on);
                }
            } else if (type.equals("JMX.mbean.unregistered") && this.isCacheManagerBean(on)) {
                this.testRemoveCacheManagerModel(on);
            }
        }
    }

    public void addEhcacheModelListener(EhcacheModelListener listener) {
        this.listenerList.remove(EhcacheModelListener.class, listener);
        this.listenerList.add(EhcacheModelListener.class, listener);
    }

    public void removeEhcacheModelListener(EhcacheModelListener listener) {
        this.listenerList.remove(EhcacheModelListener.class, listener);
    }

    public void fireCacheManagerAdded(CacheManagerModel cacheManagerModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EhcacheModelListener.class) continue;
            ((EhcacheModelListener)listeners[i + 1]).cacheManagerModelAdded(cacheManagerModel);
        }
    }

    public void fireCacheManagerRemoved(CacheManagerModel cacheManagerModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EhcacheModelListener.class) continue;
            ((EhcacheModelListener)listeners[i + 1]).cacheManagerModelRemoved(cacheManagerModel);
        }
    }

    @Override
    public void tearDown() {
        this.clusterModel.removePropertyChangeListener((PropertyChangeListener)this);
        this.reset();
        super.tearDown();
    }
}

