/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.management.ObjectName;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.SettingsCacheModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredCacheModel
extends SettingsCacheModel {
    public ClusteredCacheModel(CacheManagerModel cacheManagerModel, String cacheName, ObjectName beanName) {
        super(cacheManagerModel, cacheName);
        this.addInstance(beanName);
    }

    @Override
    public Set<CacheModelInstance> cacheModelInstances() {
        return this.cacheManagerModel.clusteredCacheModelInstances(this);
    }

    public void addInstance(ObjectName on) {
        this.onSet.add(on);
        if (this.onSet.size() == 1) {
            this.setAttributes(this.getAttributes(on, new HashSet<String>(Arrays.asList(MBEAN_ATTRS))));
        }
        this.addNotificationListener(on, this);
    }

    public void removeInstance(ObjectName on) {
        this.onSet.remove(on);
    }

    public int instanceCount() {
        return this.beanCount();
    }

    @Override
    public int getStatisticsEnabledCount() {
        return this.cacheManagerModel.getStatisticsEnabledCount(this);
    }

    @Override
    public int getBulkLoadEnabledCount() {
        return this.cacheManagerModel.getBulkLoadEnabledCount(this);
    }

    @Override
    public int getEnabledCount() {
        return this.cacheManagerModel.getEnabledCount(this);
    }

    @Override
    public String generateActiveConfigDeclaration() {
        return this.cacheManagerModel.generateActiveConfigDeclaration(this.getCacheName());
    }

    @Override
    protected void cacheModelChanged() {
        super.cacheModelChanged();
        this.cacheManagerModel.fireClusteredCacheModelChanged(this);
    }
}

