/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

public class CacheTierSize {
    private final long maxEntriesLocalHeap;
    private final long localHeapSize;
    private final long localHeapMissRate;
    private final long maxEntriesLocalOffHeap;
    private final long localOffHeapSize;
    private final long localOffHeapMissRate;
    private final long maxEntriesLocalDisk;
    private final long localDiskSize;
    private final long localDiskMissRate;
    private final long maxBytesLocalHeap;
    private final long localHeapSizeInBytes;
    private final long maxBytesLocalOffHeap;
    private final long localOffHeapSizeInBytes;
    private final long maxBytesLocalDisk;
    private final long localDiskSizeInBytes;

    public CacheTierSize(long maxEntriesLocalHeap, long localHeapSize, long localOffHeapSize, long maxEntriesLocalDisk, long localDiskSize, long maxBytesLocalHeap, long localHeapSizeInBytes, long maxBytesLocalOffHeap, long localOffHeapSizeInBytes, long maxBytesLocalDisk, long localDiskSizeInBytes, long localHeapMissRate, long localOffHeapMissRate, long localDiskMissRate) {
        this.maxEntriesLocalHeap = maxEntriesLocalHeap;
        this.maxBytesLocalHeap = maxBytesLocalHeap;
        this.localHeapSize = localHeapSize;
        this.localHeapMissRate = localHeapMissRate;
        this.localHeapSizeInBytes = localHeapSizeInBytes;
        this.maxEntriesLocalOffHeap = 0L;
        this.maxBytesLocalOffHeap = maxBytesLocalOffHeap;
        this.localOffHeapSize = localOffHeapSize;
        this.localOffHeapMissRate = localOffHeapMissRate;
        this.localOffHeapSizeInBytes = localOffHeapSizeInBytes;
        this.maxEntriesLocalDisk = maxEntriesLocalDisk;
        this.maxBytesLocalDisk = maxBytesLocalDisk;
        this.localDiskSize = localDiskSize;
        this.localDiskMissRate = localDiskMissRate;
        this.localDiskSizeInBytes = localDiskSizeInBytes;
    }

    public long getMaxLocalHeapValue(boolean inBytes) {
        return inBytes ? this.getMaxBytesLocalHeap() : this.getMaxEntriesLocalHeap();
    }

    public long getMaxEntriesLocalHeap() {
        return this.maxEntriesLocalHeap;
    }

    public long getMaxBytesLocalHeap() {
        return this.maxBytesLocalHeap;
    }

    public long getLocalHeapValue(boolean inBytes) {
        return inBytes ? this.getLocalHeapSizeInBytes() : this.getLocalHeapSize();
    }

    public long getLocalHeapSize() {
        return this.localHeapSize;
    }

    public long getLocalHeapSizeInBytes() {
        return this.localHeapSizeInBytes;
    }

    public long getLocalHeapMissRate() {
        return this.localHeapMissRate;
    }

    public long getMaxLocalOffHeapValue(boolean inBytes) {
        return inBytes ? this.getMaxBytesLocalOffHeap() : this.getMaxEntriesLocalOffHeap();
    }

    public long getMaxEntriesLocalOffHeap() {
        return this.maxEntriesLocalOffHeap;
    }

    public long getMaxBytesLocalOffHeap() {
        return this.maxBytesLocalOffHeap;
    }

    public long getLocalOffHeapValue(boolean inBytes) {
        return inBytes ? this.getLocalOffHeapSizeInBytes() : this.getLocalOffHeapSize();
    }

    public long getLocalOffHeapSize() {
        return this.localOffHeapSize;
    }

    public long getLocalOffHeapSizeInBytes() {
        return this.localOffHeapSizeInBytes;
    }

    public long getLocalOffHeapMissRate() {
        return this.localOffHeapMissRate;
    }

    public long getMaxLocalDiskValue(boolean inBytes) {
        return inBytes ? this.getMaxBytesLocalDisk() : this.getMaxEntriesLocalDisk();
    }

    public long getMaxEntriesLocalDisk() {
        return this.maxEntriesLocalDisk;
    }

    public long getMaxBytesLocalDisk() {
        return this.maxBytesLocalDisk;
    }

    public long getLocalDiskValue(boolean inBytes) {
        return inBytes ? this.getLocalDiskSizeInBytes() : this.getLocalDiskSize();
    }

    public long getLocalDiskSize() {
        return this.localDiskSize;
    }

    public long getLocalDiskSizeInBytes() {
        return this.localDiskSizeInBytes;
    }

    public long getLocalDiskMissRate() {
        return this.localDiskMissRate;
    }

    public long entriesForTier(String tierName) {
        return this.valueForTier(false, tierName);
    }

    public long maxEntriesForTier(String tierName) {
        return this.maxForTier(false, tierName);
    }

    public long sizeInBytesForTier(String tierName) {
        return this.valueForTier(true, tierName);
    }

    public long valueForTier(boolean inBytes, String tierName) {
        if ("Local Heap".equals(tierName)) {
            return this.getLocalHeapValue(inBytes);
        }
        if ("Local OffHeap".equals(tierName)) {
            return this.getLocalOffHeapValue(inBytes);
        }
        if ("Local Disk".equals(tierName)) {
            return this.getLocalDiskValue(inBytes);
        }
        if ("Remote".equals(tierName)) {
            long entries = this.getLocalDiskSize();
            if (inBytes) {
                long size = this.getLocalOffHeapSize();
                if (size > 0L) {
                    return (long)((double)(entries * this.getLocalOffHeapSizeInBytes()) / (double)size);
                }
                size = this.getLocalHeapSize();
                if (size > 0L) {
                    return (long)((double)(entries * this.getLocalHeapSizeInBytes()) / (double)size);
                }
            } else {
                return entries;
            }
        }
        return 0L;
    }

    public long maxBytesForTier(String tierName) {
        return this.maxForTier(true, tierName);
    }

    public long maxForTier(boolean inBytes, String tierName) {
        if ("Local Heap".equals(tierName)) {
            return this.getMaxLocalHeapValue(inBytes);
        }
        if ("Local OffHeap".equals(tierName)) {
            return this.getMaxLocalOffHeapValue(inBytes);
        }
        if ("Local Disk".equals(tierName)) {
            return this.getMaxLocalDiskValue(inBytes);
        }
        if ("Remote".equals(tierName)) {
            long entries = this.getMaxEntriesLocalDisk();
            if (inBytes) {
                long size = this.getLocalOffHeapSize();
                if (size > 0L) {
                    return (long)((double)(entries * this.getLocalOffHeapSizeInBytes()) / (double)size);
                }
                size = this.getLocalHeapSize();
                if (size > 0L) {
                    return (long)((double)(entries * this.getLocalHeapSizeInBytes()) / (double)size);
                }
            } else {
                return entries;
            }
        }
        return 0L;
    }
}

