/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheStatisticsModel {
    private final Map<String, Object> attributes;
    private final String shortName;
    public static final String CACHE_NAME = "CacheName";
    public static final String CACHE_HIT_COUNT = "CacheHitCount";
    public static final String IN_MEMORY_HIT_COUNT = "InMemoryHitCount";
    public static final String OFF_HEAP_HIT_COUNT = "OffHeapHitCount";
    public static final String ON_DISK_HIT_COUNT = "OnDiskHitCount";
    public static final String CACHE_MISS_COUNT = "CacheMissCount";
    public static final String CACHE_MISS_COUNT_EXPIRED = "CacheMissCountExpired";
    public static final String IN_MEMORY_MISS_COUNT = "InMemoryMissCount";
    public static final String OFF_HEAP_MISS_COUNT = "OffHeapMissCount";
    public static final String ON_DISK_MISS_COUNT = "OnDiskMissCount";
    public static final String PUT_COUNT = "PutCount";
    public static final String UPDATE_COUNT = "UpdateCount";
    public static final String EVICTED_COUNT = "EvictedCount";
    public static final String EXPIRED_COUNT = "ExpiredCount";
    public static final String REMOVED_COUNT = "RemovedCount";
    public static final String AVERAGE_GET_TIME_MILLIS = "AverageGetTimeMillis";
    public static final String MIN_GET_TIME_MILLIS = "MinGetTimeMillis";
    public static final String MAX_GET_TIME_MILLIS = "MaxGetTimeMillis";
    public static final String LOCAL_HEAP_SIZE = "LocalHeapSize";
    public static final String LOCAL_HEAP_SIZE_IN_BYTES = "LocalHeapSizeInBytes";
    public static final String LOCAL_OFFHEAP_SIZE = "LocalOffHeapSize";
    public static final String LOCAL_OFFHEAP_SIZE_IN_BYTES = "LocalOffHeapSizeInBytes";
    public static final String LOCAL_DISK_SIZE = "LocalDiskSize";
    public static final String LOCAL_DISK_SIZE_IN_BYTES = "LocalDiskSizeInBytes";
    public static final String WRITER_QUEUE_LENGTH = "WriterQueueLength";
    public static final String XA_COMMIT_COUNT = "XaCommitCount";
    public static final String XA_ROLLBACK_COUNT = "XaRollbackCount";
    public static final String SHORT_NAME = "ShortName";
    public static final String CACHE_HIT_RATIO = "CacheHitRatio";
    public static final String[] MBEAN_ATTRS = new String[]{"CacheName", "CacheHitRatio", "CacheHitCount", "InMemoryHitCount", "OffHeapHitCount", "OnDiskHitCount", "CacheMissCount", "CacheMissCountExpired", "InMemoryMissCount", "OffHeapMissCount", "OnDiskMissCount", "PutCount", "UpdateCount", "EvictedCount", "ExpiredCount", "RemovedCount", "AverageGetTimeMillis", "MinGetTimeMillis", "MaxGetTimeMillis", "LocalHeapSize", "LocalHeapSizeInBytes", "LocalOffHeapSize", "LocalOffHeapSizeInBytes", "LocalDiskSize", "LocalDiskSizeInBytes", "WriterQueueLength", "XaCommitCount", "XaRollbackCount"};
    public static final String[] ATTRS = new String[]{"CacheName", "ShortName", "CacheHitRatio", "CacheHitCount", "InMemoryHitCount", "OffHeapHitCount", "OnDiskHitCount", "CacheMissCount", "CacheMissCountExpired", "InMemoryMissCount", "OffHeapMissCount", "OnDiskMissCount", "PutCount", "UpdateCount", "EvictedCount", "ExpiredCount", "RemovedCount", "AverageGetTimeMillis", "MinGetTimeMillis", "MaxGetTimeMillis", "LocalHeapSize", "LocalHeapSizeInBytes", "LocalOffHeapSize", "LocalOffHeapSizeInBytes", "LocalDiskSize", "LocalDiskSizeInBytes", "WriterQueueLength", "XaCommitCount", "XaRollbackCount"};
    public static final String[] HEADERS = new String[]{"Cache", "Name", "Hit Ratio", "Hits", "InMemory Hits", "OffHeap Hits", "OnDisk Hits", "Misses", "Misses, Expired", "InMemory Misses", "OffHeap Misses", "OnDisk Misses", "Puts", "Updates", "Evicted", "Expired", "Removed", "Avg. Get Time (ms.)", "Min Get Time (ms.)", "Max Get Time (ms.)", "Local Heap Size", "Local Heap Bytes", "Local OffHeap Size", "Local OffHeap Bytes", "Local Disk Size", "Local Disk Bytes", "Writer Q Length", "XA Commits", "XA Rollbacks"};

    public CacheStatisticsModel(String cacheName) {
        this.attributes = new HashMap<String, Object>();
        this.attributes.put(CACHE_NAME, cacheName);
        this.shortName = EhcachePresentationUtils.determineShortName(cacheName);
    }

    public CacheStatisticsModel(Map<String, Object> attributes) {
        this.attributes = attributes;
        this.shortName = EhcachePresentationUtils.determineShortName(this.getCacheName());
        this.updateCacheHitRatio();
    }

    public static String[] attributes(String[] headers) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> headerList = Arrays.asList(HEADERS);
        for (String header : headers) {
            int index = headerList.indexOf(header);
            if (index >= ATTRS.length) continue;
            list.add(ATTRS[index]);
        }
        return list.toArray(new String[0]);
    }

    public static String[] headersForAttributes(String[] attributes) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> attrList = Arrays.asList(ATTRS);
        for (String attr : attributes) {
            int index = attrList.indexOf(attr);
            if (index > -1 && index < HEADERS.length) {
                list.add(HEADERS[index]);
                continue;
            }
            list.add(attr);
        }
        return list.toArray(new String[0]);
    }

    public void add(CacheStatisticsModel cacheStats) {
        this.attributes.put(CACHE_HIT_COUNT, this.getCacheHitCount() + cacheStats.getCacheHitCount());
        this.attributes.put(IN_MEMORY_HIT_COUNT, this.getInMemoryHitCount() + cacheStats.getInMemoryHitCount());
        this.attributes.put(OFF_HEAP_HIT_COUNT, this.getOffHeapHitCount() + cacheStats.getOffHeapHitCount());
        this.attributes.put(ON_DISK_HIT_COUNT, this.getOnDiskHitCount() + cacheStats.getOnDiskHitCount());
        this.attributes.put(CACHE_MISS_COUNT, this.getCacheMissCount() + cacheStats.getCacheMissCount());
        this.attributes.put(CACHE_MISS_COUNT_EXPIRED, this.getCacheMissCountExpired() + cacheStats.getCacheMissCountExpired());
        this.attributes.put(IN_MEMORY_MISS_COUNT, this.getInMemoryMissCount() + cacheStats.getInMemoryMissCount());
        this.attributes.put(OFF_HEAP_MISS_COUNT, this.getOffHeapMissCount() + cacheStats.getOffHeapMissCount());
        this.attributes.put(ON_DISK_MISS_COUNT, this.getOnDiskMissCount() + cacheStats.getOnDiskMissCount());
        this.attributes.put(PUT_COUNT, this.getPutCount() + cacheStats.getPutCount());
        this.attributes.put(UPDATE_COUNT, this.getUpdateCount() + cacheStats.getUpdateCount());
        this.attributes.put(EVICTED_COUNT, this.getEvictedCount() + cacheStats.getEvictedCount());
        this.attributes.put(EXPIRED_COUNT, this.getExpiredCount() + cacheStats.getExpiredCount());
        this.attributes.put(REMOVED_COUNT, this.getRemovedCount() + cacheStats.getRemovedCount());
        this.attributes.put(LOCAL_HEAP_SIZE, this.getLocalHeapSize() + cacheStats.getLocalHeapSize());
        this.attributes.put(LOCAL_HEAP_SIZE_IN_BYTES, this.getLocalHeapSizeInBytes() + cacheStats.getLocalHeapSizeInBytes());
        this.attributes.put(LOCAL_OFFHEAP_SIZE, this.getLocalOffHeapSize() + cacheStats.getLocalOffHeapSize());
        this.attributes.put(LOCAL_OFFHEAP_SIZE_IN_BYTES, this.getLocalOffHeapSizeInBytes() + cacheStats.getLocalOffHeapSizeInBytes());
        this.attributes.put(LOCAL_DISK_SIZE, this.getLocalDiskSize() + cacheStats.getLocalDiskSize());
        this.attributes.put(LOCAL_DISK_SIZE_IN_BYTES, this.getLocalDiskSizeInBytes() + cacheStats.getLocalDiskSizeInBytes());
        this.attributes.put(WRITER_QUEUE_LENGTH, this.getWriterQueueLength() + cacheStats.getWriterQueueLength());
        this.attributes.put(XA_COMMIT_COUNT, this.getXaCommitCount() + cacheStats.getXaCommitCount());
        this.attributes.put(XA_ROLLBACK_COUNT, this.getXaRollbackCount() + cacheStats.getXaRollbackCount());
        this.updateCacheHitRatio();
    }

    private void updateCacheHitRatio() {
        long misses;
        long hits = this.getCacheHitCount();
        double tries = hits + (misses = this.getCacheMissCount());
        double cacheHitRatio = tries > 0.0 ? (double)hits / tries : 0.0;
        this.attributes.put(CACHE_HIT_RATIO, cacheHitRatio);
    }

    public String getCacheName() {
        return (String)this.attributes.get(CACHE_NAME);
    }

    public String getShortName() {
        return this.shortName != null ? this.shortName : this.getCacheName();
    }

    public double getCacheHitRatio() {
        Double result = (Double)this.attributes.get(CACHE_HIT_RATIO);
        return result == null ? 0.0 : result;
    }

    public long getCacheHitCount() {
        Long result = (Long)this.attributes.get(CACHE_HIT_COUNT);
        return result == null ? 0L : result;
    }

    public long getInMemoryHitCount() {
        Long result = (Long)this.attributes.get(IN_MEMORY_HIT_COUNT);
        return result == null ? 0L : result;
    }

    public long getOffHeapHitCount() {
        Long result = (Long)this.attributes.get(OFF_HEAP_HIT_COUNT);
        return result == null ? 0L : result;
    }

    public long getOnDiskHitCount() {
        Long result = (Long)this.attributes.get(ON_DISK_HIT_COUNT);
        return result == null ? 0L : result;
    }

    public long getCacheMissCount() {
        Long result = (Long)this.attributes.get(CACHE_MISS_COUNT);
        return result == null ? 0L : result;
    }

    public long getCacheMissCountExpired() {
        Long result = (Long)this.attributes.get(CACHE_MISS_COUNT_EXPIRED);
        return result == null ? 0L : result;
    }

    public long getInMemoryMissCount() {
        Long result = (Long)this.attributes.get(IN_MEMORY_MISS_COUNT);
        return result == null ? 0L : result;
    }

    public long getOffHeapMissCount() {
        Long result = (Long)this.attributes.get(OFF_HEAP_MISS_COUNT);
        return result == null ? 0L : result;
    }

    public long getOnDiskMissCount() {
        Long result = (Long)this.attributes.get(ON_DISK_MISS_COUNT);
        return result == null ? 0L : result;
    }

    public long getPutCount() {
        Long result = (Long)this.attributes.get(PUT_COUNT);
        return result == null ? 0L : result;
    }

    public long getUpdateCount() {
        Long result = (Long)this.attributes.get(UPDATE_COUNT);
        return result == null ? 0L : result;
    }

    public long getEvictedCount() {
        Long result = (Long)this.attributes.get(EVICTED_COUNT);
        return result == null ? 0L : result;
    }

    public long getExpiredCount() {
        Long result = (Long)this.attributes.get(EXPIRED_COUNT);
        return result == null ? 0L : result;
    }

    public long getRemovedCount() {
        Long result = (Long)this.attributes.get(REMOVED_COUNT);
        return result == null ? 0L : result;
    }

    public float getAverageGetTimeMillis() {
        Float result = (Float)this.attributes.get(AVERAGE_GET_TIME_MILLIS);
        return result == null ? 0.0f : result.floatValue();
    }

    public void setAverageGetTime(float averageGetTimeMillis) {
        this.attributes.put(AVERAGE_GET_TIME_MILLIS, Float.valueOf(averageGetTimeMillis));
    }

    public float getMinGetTimeMillis() {
        Number result = (Number)this.attributes.get(MIN_GET_TIME_MILLIS);
        return result == null ? 0.0f : result.floatValue();
    }

    public void setMinGetTime(float minGetTimeMillis) {
        this.attributes.put(MIN_GET_TIME_MILLIS, Float.valueOf(minGetTimeMillis));
    }

    public float getMaxGetTimeMillis() {
        Number result = (Number)this.attributes.get(MAX_GET_TIME_MILLIS);
        return result == null ? 0.0f : result.floatValue();
    }

    public void setMaxGetTime(float maxGetTimeMillis) {
        this.attributes.put(MAX_GET_TIME_MILLIS, Float.valueOf(maxGetTimeMillis));
    }

    public long getLocalHeapSize() {
        Long result = (Long)this.attributes.get(LOCAL_HEAP_SIZE);
        return result == null ? 0L : result;
    }

    public long getLocalHeapSizeInBytes() {
        Long result = (Long)this.attributes.get(LOCAL_HEAP_SIZE_IN_BYTES);
        return result == null ? 0L : result;
    }

    public long getLocalOffHeapSize() {
        Long result = (Long)this.attributes.get(LOCAL_OFFHEAP_SIZE);
        return result == null ? 0L : result;
    }

    public long getLocalOffHeapSizeInBytes() {
        Long result = (Long)this.attributes.get(LOCAL_OFFHEAP_SIZE_IN_BYTES);
        return result == null ? 0L : result;
    }

    public long getLocalDiskSize() {
        Long result = (Long)this.attributes.get(LOCAL_DISK_SIZE);
        return result == null ? 0L : result;
    }

    public long getLocalDiskSizeInBytes() {
        Long result = (Long)this.attributes.get(LOCAL_DISK_SIZE_IN_BYTES);
        return result == null ? 0L : result;
    }

    public long getWriterQueueLength() {
        Number result = (Number)this.attributes.get(WRITER_QUEUE_LENGTH);
        return result == null ? 0L : result.longValue();
    }

    public long getXaCommitCount() {
        Number result = (Number)this.attributes.get(XA_COMMIT_COUNT);
        return result == null ? 0L : result.longValue();
    }

    public long getXaRollbackCount() {
        Number result = (Number)this.attributes.get(XA_ROLLBACK_COUNT);
        return result == null ? 0L : result.longValue();
    }
}

