/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.ICacheSettings;
import org.terracotta.modules.ehcache.presentation.model.MutableCacheSettings;

public class CacheSettings
extends MutableCacheSettings
implements ICacheSettings {
    private final String memoryStoreEvictionPolicy;
    private final boolean diskPersistent;
    private final boolean eternal;
    private final boolean overflowToDisk;

    public CacheSettings(ClusteredCacheModel cacheModel) {
        super(cacheModel);
        this.memoryStoreEvictionPolicy = cacheModel.getMemoryStoreEvictionPolicy();
        this.diskPersistent = cacheModel.isDiskPersistent();
        this.eternal = cacheModel.isEternal();
        this.overflowToDisk = cacheModel.isOverflowToDisk();
    }

    public String getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.diskPersistent ? 1231 : 1237);
        result = 31 * result + (this.eternal ? 1231 : 1237);
        result = 31 * result + (this.memoryStoreEvictionPolicy == null ? 0 : this.memoryStoreEvictionPolicy.hashCode());
        result = 31 * result + (this.overflowToDisk ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CacheSettings)) {
            return false;
        }
        CacheSettings other = (CacheSettings)obj;
        if (this.diskPersistent != other.diskPersistent) {
            return false;
        }
        if (this.eternal != other.eternal) {
            return false;
        }
        if (this.memoryStoreEvictionPolicy == null ? other.memoryStoreEvictionPolicy != null : !this.memoryStoreEvictionPolicy.equals(other.memoryStoreEvictionPolicy)) {
            return false;
        }
        return this.overflowToDisk == other.overflowToDisk;
    }
}

