/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import com.tc.admin.model.IClient;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheStatisticsModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheModelInstance
implements NotificationListener,
Comparable {
    private final CacheManagerInstance cacheManagerInstance;
    private final String cacheName;
    private final String shortName;
    private final ObjectName beanName;
    private boolean enabled;
    private boolean bulkLoadEnabled;
    private boolean transactional;
    private String consistency;
    private boolean statisticsEnabled;
    private boolean terracottaClustered;
    private String pinnedToStore;
    private boolean loggingEnabled;
    private long maxEntriesLocalHeap;
    private long maxEntriesLocalDisk;
    private String maxBytesLocalHeapAsString;
    private String maxBytesLocalOffHeapAsString;
    private String maxBytesLocalDiskAsString;
    private long maxBytesLocalHeap;
    private long maxBytesLocalOffHeap;
    private long maxBytesLocalDisk;
    private long timeToIdleSeconds;
    private long timeToLiveSeconds;
    private String memoryStoreEvictionPolicy;
    private boolean diskPersistent;
    private boolean eternal;
    private boolean overflowToDisk;
    public static final String SHORT_NAME_PROP = "ShortName";
    public static final String CLIENT_NAME_PROP = "ClientName";
    public static final String ENABLED_PROP = "Enabled";
    public static final String BULK_LOAD_ENABLED_PROP = "NodeBulkLoadEnabled";
    public static final String BULK_LOAD_ENABLED_DESC_PROP = "BulkLoadEnabledDesc";
    public static final String TRANSACTIONAL_PROP = "Transactional";
    public static final String TERRACOTTA_CONSISTENCY_PROP = "TerracottaConsistency";
    public static final String TERRACOTTA_CLUSTERED_PROP = "TerracottaClustered";
    public static final String STATISTICS_ENABLED_PROP = "StatisticsEnabled";
    public static final String PINNED_TO_STORE_PROP = "PinnedToStore";
    public static final String CONSISTENCY_PROP = "Consistency";
    public static final String LOGGING_ENABLED_PROP = "LoggingEnabled";
    public static final String MAX_ENTRIES_LOCAL_HEAP_PROP = "MaxEntriesLocalHeap";
    public static final String MAX_ENTRIES_LOCAL_DISK_PROP = "MaxEntriesLocalDisk";
    public static final String MAX_BYTES_LOCAL_HEAP_PROP = "MaxBytesLocalHeap";
    public static final String MAX_BYTES_LOCAL_HEAP_AS_STRING_PROP = "MaxBytesLocalHeapAsString";
    public static final String MAX_BYTES_LOCAL_OFFHEAP_PROP = "MaxBytesLocalOffHeap";
    public static final String MAX_BYTES_LOCAL_OFFHEAP_AS_STRING_PROP = "MaxBytesLocalOffHeapAsString";
    public static final String MAX_BYTES_LOCAL_DISK_PROP = "MaxBytesLocalDisk";
    public static final String MAX_BYTES_LOCAL_DISK_AS_STRING_PROP = "MaxBytesLocalDiskAsString";
    public static final String TIME_TO_IDLE_SECONDS_PROP = "TimeToIdleSeconds";
    public static final String TIME_TO_LIVE_SECONDS_PROP = "TimeToLiveSeconds";
    public static final String MEMORY_STORE_EVICTION_POLICY_PROP = "MemoryStoreEvictionPolicy";
    public static final String DISK_PERSISTENT_PROP = "DiskPersistent";
    public static final String ETERNAL_PROP = "Eternal";
    public static final String OVERFLOW_TO_DISK_PROP = "OverflowToDisk";
    public static final String[] MBEAN_ATTRS = new String[]{"Enabled", "TerracottaClustered", "TerracottaConsistency", "NodeBulkLoadEnabled", "Transactional", "StatisticsEnabled", "PinnedToStore", "MaxEntriesLocalHeap", "MaxEntriesLocalDisk", "MaxBytesLocalHeapAsString", "MaxBytesLocalHeap", "MaxBytesLocalOffHeapAsString", "MaxBytesLocalOffHeap", "MaxBytesLocalDiskAsString", "MaxBytesLocalDisk", "MemoryStoreEvictionPolicy", "TimeToIdleSeconds", "TimeToLiveSeconds", "DiskPersistent", "Eternal", "OverflowToDisk", "LoggingEnabled"};
    public static final Set<String> MBEAN_ATTR_SET = new HashSet<String>(Arrays.asList(MBEAN_ATTRS));
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public CacheModelInstance(CacheManagerInstance cacheManagerInstance, String cacheName, ObjectName beanName) {
        Boolean bulkLoadEnabledPersistently;
        Boolean statsEnabledPersistently;
        this.cacheManagerInstance = cacheManagerInstance;
        this.cacheName = cacheName;
        this.beanName = beanName;
        this.shortName = EhcachePresentationUtils.determineShortName(cacheName);
        cacheManagerInstance.addNotificationListener(beanName, this);
        this.setAttributes(cacheManagerInstance.getAttributes(beanName, MBEAN_ATTR_SET));
        CacheManagerModel cacheManagerModel = cacheManagerInstance.getCacheManagerModel();
        Boolean enabledPersistently = cacheManagerModel.isCachesEnabledPersistently();
        if (enabledPersistently != null) {
            this.setEnabled(enabledPersistently);
        }
        if ((statsEnabledPersistently = cacheManagerModel.isStatisticsEnabledPersistently()) != null) {
            this.setStatisticsEnabled(statsEnabledPersistently);
        }
        if ((bulkLoadEnabledPersistently = cacheManagerModel.isBulkLoadEnabledPersistently()) != null) {
            this.setBulkLoadEnabled(bulkLoadEnabledPersistently);
        }
    }

    public ObjectName getBeanName() {
        return this.beanName;
    }

    public IClient getClient() {
        return this.cacheManagerInstance.getClient();
    }

    public String getClientName() {
        return this.cacheManagerInstance.getClientName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, Object> attrs) {
        CacheModelInstance cacheModelInstance = this;
        synchronized (cacheModelInstance) {
            this.enabled = CacheModelInstance.booleanAttr(attrs, ENABLED_PROP);
            this.transactional = CacheModelInstance.booleanAttr(attrs, TRANSACTIONAL_PROP);
            this.bulkLoadEnabled = CacheModelInstance.booleanAttr(attrs, BULK_LOAD_ENABLED_PROP);
            this.consistency = CacheModelInstance.stringAttr(attrs, TERRACOTTA_CONSISTENCY_PROP);
            this.terracottaClustered = CacheModelInstance.booleanAttr(attrs, TERRACOTTA_CLUSTERED_PROP);
            this.statisticsEnabled = CacheModelInstance.booleanAttr(attrs, STATISTICS_ENABLED_PROP);
            this.pinnedToStore = CacheModelInstance.stringAttr(attrs, PINNED_TO_STORE_PROP);
            this.timeToLiveSeconds = CacheModelInstance.longAttr(attrs, TIME_TO_LIVE_SECONDS_PROP);
            this.timeToIdleSeconds = CacheModelInstance.longAttr(attrs, TIME_TO_IDLE_SECONDS_PROP);
            this.maxEntriesLocalHeap = CacheModelInstance.longAttr(attrs, MAX_ENTRIES_LOCAL_HEAP_PROP);
            this.maxEntriesLocalDisk = CacheModelInstance.longAttr(attrs, MAX_ENTRIES_LOCAL_DISK_PROP);
            this.maxBytesLocalHeapAsString = CacheModelInstance.stringAttr(attrs, MAX_BYTES_LOCAL_HEAP_AS_STRING_PROP);
            this.maxBytesLocalOffHeapAsString = CacheModelInstance.stringAttr(attrs, MAX_BYTES_LOCAL_OFFHEAP_AS_STRING_PROP);
            this.maxBytesLocalDiskAsString = CacheModelInstance.stringAttr(attrs, MAX_BYTES_LOCAL_DISK_AS_STRING_PROP);
            this.maxBytesLocalHeap = CacheModelInstance.longAttr(attrs, MAX_BYTES_LOCAL_HEAP_PROP);
            this.maxBytesLocalOffHeap = CacheModelInstance.longAttr(attrs, MAX_BYTES_LOCAL_OFFHEAP_PROP);
            this.maxBytesLocalDisk = CacheModelInstance.longAttr(attrs, MAX_BYTES_LOCAL_DISK_PROP);
            this.memoryStoreEvictionPolicy = CacheModelInstance.stringAttr(attrs, MEMORY_STORE_EVICTION_POLICY_PROP);
            this.diskPersistent = CacheModelInstance.booleanAttr(attrs, DISK_PERSISTENT_PROP);
            this.eternal = CacheModelInstance.booleanAttr(attrs, ETERNAL_PROP);
            this.overflowToDisk = CacheModelInstance.booleanAttr(attrs, OVERFLOW_TO_DISK_PROP);
            this.loggingEnabled = CacheModelInstance.booleanAttr(attrs, LOGGING_ENABLED_PROP);
        }
        this.firePropertyChange(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Boolean booleanAttr(Map<String, Object> attrs, String name) {
        Boolean result = null;
        try {
            result = (Boolean)attrs.get(name);
        }
        catch (Exception exception) {
        }
        finally {
            if (result == null) {
                result = Boolean.FALSE;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String stringAttr(Map<String, Object> attrs, String name) {
        String result = null;
        try {
            Object val = attrs.get(name);
            if (val != null) {
                result = val.toString();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (result == null) {
                result = "";
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Long longAttr(Map<String, Object> attrs, String name) {
        Long result = null;
        try {
            result = (Long)attrs.get(name);
        }
        catch (Exception exception) {
        }
        finally {
            if (result == null) {
                result = 0L;
            }
        }
        return result;
    }

    public CacheManagerInstance getCacheManagerInstance() {
        return this.cacheManagerInstance;
    }

    public CacheModel getCacheModel() {
        return this.getCacheManagerInstance().getCacheManagerModel().getCacheModel(this.getCacheName());
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.isEnabled();
        CacheModelInstance cacheModelInstance = this;
        synchronized (cacheModelInstance) {
            this.enabled = enabled;
            if (oldEnabled != enabled) {
                this.cacheManagerInstance.safeSetAttribute(this.beanName, ENABLED_PROP, (Object)enabled);
            }
        }
        this.firePropertyChange(ENABLED_PROP, oldEnabled, enabled);
    }

    public synchronized boolean isTransactional() {
        return this.transactional;
    }

    public synchronized boolean isBulkLoadEnabled() {
        return this.bulkLoadEnabled;
    }

    public Boolean isBulkLoadEnabledDesc() {
        return this.isTerracottaClustered() ? Boolean.valueOf(this.bulkLoadEnabled) : null;
    }

    public boolean isBulkLoadDisabled() {
        return !this.isBulkLoadEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBulkLoadEnabled(boolean bulkLoadEnabled) {
        boolean oldIsBulkLoadEnabled = this.isBulkLoadEnabled();
        CacheModelInstance cacheModelInstance = this;
        synchronized (cacheModelInstance) {
            this.bulkLoadEnabled = bulkLoadEnabled;
            if (oldIsBulkLoadEnabled != bulkLoadEnabled) {
                this.setAttribute(BULK_LOAD_ENABLED_PROP, bulkLoadEnabled);
            }
        }
        this.firePropertyChange(BULK_LOAD_ENABLED_PROP, oldIsBulkLoadEnabled, bulkLoadEnabled);
    }

    public synchronized String getConsistency() {
        return this.isTerracottaClustered() ? this.consistency : "na";
    }

    public synchronized boolean isTerracottaClustered() {
        return this.terracottaClustered;
    }

    public synchronized boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatisticsEnabled(boolean enabled) {
        boolean oldEnabled = this.isStatisticsEnabled();
        CacheModelInstance cacheModelInstance = this;
        synchronized (cacheModelInstance) {
            this.statisticsEnabled = enabled;
            if (oldEnabled != enabled) {
                this.setAttribute(STATISTICS_ENABLED_PROP, enabled);
            }
        }
        this.firePropertyChange(STATISTICS_ENABLED_PROP, oldEnabled, enabled);
    }

    public boolean isPinned() {
        return !this.getPinnedToStore().equals("na");
    }

    public synchronized String getPinnedToStore() {
        return this.pinnedToStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggingEnabled(boolean enabled) {
        boolean oldLoggingEnabled = this.isLoggingEnabled();
        if (oldLoggingEnabled != enabled) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.loggingEnabled = enabled;
            }
            this.setAttribute(LOGGING_ENABLED_PROP, enabled);
            this.firePropertyChange(LOGGING_ENABLED_PROP, oldLoggingEnabled, enabled);
        }
    }

    public synchronized boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public synchronized long getMaxEntriesLocalHeap() {
        return this.maxEntriesLocalHeap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxEntriesLocalHeap(long maxEntries) {
        long oldMaxEntries = this.getMaxEntriesLocalHeap();
        if (oldMaxEntries != maxEntries) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.maxEntriesLocalHeap = maxEntries;
            }
            this.setAttribute(MAX_ENTRIES_LOCAL_HEAP_PROP, maxEntries);
            this.firePropertyChange(MAX_ENTRIES_LOCAL_HEAP_PROP, oldMaxEntries, maxEntries);
        }
    }

    public synchronized long getMaxEntriesLocalDisk() {
        return this.maxEntriesLocalDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxEntriesLocalDisk(long maxEntries) {
        long oldMaxEntries = this.getMaxEntriesLocalDisk();
        if (oldMaxEntries != maxEntries) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.maxEntriesLocalDisk = maxEntries;
            }
            this.setAttribute(MAX_ENTRIES_LOCAL_DISK_PROP, maxEntries);
            this.firePropertyChange(MAX_ENTRIES_LOCAL_DISK_PROP, oldMaxEntries, maxEntries);
        }
    }

    public synchronized String getMaxBytesLocalHeapAsString() {
        return this.maxBytesLocalHeapAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBytesLocalHeapAsString(String maxBytes) {
        String oldMaxBytes = this.getMaxBytesLocalHeapAsString();
        if (!oldMaxBytes.equals(maxBytes)) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.maxBytesLocalHeapAsString = maxBytes;
            }
            this.setAttribute(MAX_BYTES_LOCAL_HEAP_AS_STRING_PROP, maxBytes);
            this.firePropertyChange(MAX_BYTES_LOCAL_HEAP_AS_STRING_PROP, oldMaxBytes, maxBytes);
        }
    }

    public synchronized String getMaxBytesLocalOffHeapAsString() {
        return this.maxBytesLocalOffHeapAsString;
    }

    public synchronized long getMaxBytesLocalOffHeap() {
        return this.maxBytesLocalOffHeap;
    }

    public synchronized long getMaxBytesLocalHeap() {
        return this.maxBytesLocalHeap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBytesLocalHeap(long maxBytes) {
        long oldMaxBytes = this.getMaxBytesLocalHeap();
        if (oldMaxBytes != maxBytes) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.maxBytesLocalHeap = maxBytes;
            }
            this.setAttribute(MAX_BYTES_LOCAL_HEAP_PROP, maxBytes);
            this.firePropertyChange(MAX_BYTES_LOCAL_HEAP_PROP, oldMaxBytes, maxBytes);
        }
    }

    public synchronized String getMaxBytesLocalDiskAsString() {
        return this.maxBytesLocalDiskAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBytesLocalDiskAsString(String maxBytes) {
        String oldMaxBytes = this.getMaxBytesLocalDiskAsString();
        if (!oldMaxBytes.equals(maxBytes)) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.maxBytesLocalDiskAsString = maxBytes;
            }
            this.setAttribute(MAX_BYTES_LOCAL_DISK_AS_STRING_PROP, maxBytes);
            this.firePropertyChange(MAX_BYTES_LOCAL_DISK_AS_STRING_PROP, oldMaxBytes, maxBytes);
        }
    }

    public synchronized long getMaxBytesLocalDisk() {
        return this.maxBytesLocalDisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBytesLocalDisk(long maxBytes) {
        long oldMaxBytes = this.getMaxBytesLocalDisk();
        if (oldMaxBytes != maxBytes) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.maxBytesLocalDisk = maxBytes;
            }
            this.setAttribute(MAX_BYTES_LOCAL_DISK_PROP, maxBytes);
            this.firePropertyChange(MAX_BYTES_LOCAL_DISK_PROP, oldMaxBytes, maxBytes);
        }
    }

    public synchronized long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeToIdleSeconds(long tti) {
        long oldTTI = this.getTimeToIdleSeconds();
        if (oldTTI != tti) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.timeToIdleSeconds = tti;
            }
            this.setAttribute(TIME_TO_IDLE_SECONDS_PROP, tti);
            this.firePropertyChange(TIME_TO_IDLE_SECONDS_PROP, oldTTI, tti);
        }
    }

    public synchronized long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeToLiveSeconds(long ttl) {
        long oldTTL = this.getTimeToLiveSeconds();
        if (oldTTL != ttl) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.timeToLiveSeconds = ttl;
            }
            this.setAttribute(TIME_TO_LIVE_SECONDS_PROP, ttl);
            this.firePropertyChange(TIME_TO_LIVE_SECONDS_PROP, oldTTL, ttl);
        }
    }

    public synchronized String getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemoryStoreEvictionPolicy(String evictionPolicy) {
        String oldEvictionPolicy = this.getMemoryStoreEvictionPolicy();
        if (!oldEvictionPolicy.equals(evictionPolicy)) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.memoryStoreEvictionPolicy = evictionPolicy;
            }
            this.setAttribute(MEMORY_STORE_EVICTION_POLICY_PROP, evictionPolicy);
            this.firePropertyChange(MEMORY_STORE_EVICTION_POLICY_PROP, oldEvictionPolicy, evictionPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiskPersistent(boolean diskPersistent) {
        boolean oldDiskPersistent = this.isDiskPersistent();
        if (oldDiskPersistent != diskPersistent) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.diskPersistent = diskPersistent;
            }
            this.setAttribute(DISK_PERSISTENT_PROP, diskPersistent);
            this.firePropertyChange(DISK_PERSISTENT_PROP, oldDiskPersistent, diskPersistent);
        }
    }

    public synchronized boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEternal(boolean eternal) {
        boolean oldEternal = this.isEternal();
        if (oldEternal != eternal) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.eternal = eternal;
            }
            this.setAttribute(ETERNAL_PROP, eternal);
            this.firePropertyChange(ETERNAL_PROP, oldEternal, eternal);
        }
    }

    public synchronized boolean isEternal() {
        return this.eternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverflowToDisk(boolean overflowToDisk) {
        boolean oldOverflowToDisk = this.isOverflowToDisk();
        if (oldOverflowToDisk != overflowToDisk) {
            CacheModelInstance cacheModelInstance = this;
            synchronized (cacheModelInstance) {
                this.overflowToDisk = overflowToDisk;
            }
            this.setAttribute(OVERFLOW_TO_DISK_PROP, overflowToDisk);
            this.firePropertyChange(OVERFLOW_TO_DISK_PROP, oldOverflowToDisk, overflowToDisk);
        }
    }

    public synchronized boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public boolean hasSizeBasedLimits() {
        return this.getMaxBytesLocalHeap() + this.getMaxBytesLocalOffHeap() + this.getMaxBytesLocalDisk() > 0L;
    }

    private void setAttribute(String attribute, Object value) {
        this.cacheManagerInstance.safeSetAttribute(this.beanName, attribute, value);
    }

    public CacheStatisticsModel getCacheStatistics() {
        return this.getCacheStatistics(CacheStatisticsModel.MBEAN_ATTRS);
    }

    public CacheStatisticsModel getCacheStatistics(String[] attributes) {
        CacheStatisticsModel result = null;
        Map<String, Object> attrMap = this.cacheManagerInstance.getAttributes(this.beanName, new HashSet<String>(Arrays.asList(attributes)));
        if (attrMap != null && !attrMap.isEmpty()) {
            result = new CacheStatisticsModel(attrMap);
        }
        return result;
    }

    public void removeAll() {
        this.cacheManagerInstance.invokeOnce(this.beanName, "removeAll");
    }

    public String generateActiveConfigDeclaration() {
        String result = this.cacheManagerInstance.generateActiveConfigDeclaration(this.getCacheName());
        return result != null ? result.toString() : "";
    }

    public int getSize() {
        Object o = this.cacheManagerInstance.getAttribute(this.getBeanName(), "Size");
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return 0;
    }

    @Override
    public void handleNotification(Notification notif, Object data) {
        if ("CacheChanged".equals(notif.getType())) {
            this.setAttributes((Map)notif.getUserData());
            this.cacheManagerInstance.cacheInstanceChanged(this);
        }
    }

    public String toString() {
        return this.getCacheName() + " on node " + this.cacheManagerInstance.getClientName();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null && this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null && this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport pcs;
        CacheModelInstance cacheModelInstance = this;
        synchronized (cacheModelInstance) {
            pcs = this.propertyChangeSupport;
        }
        if (pcs != null) {
            pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public int compareTo(Object o) {
        CacheModelInstance other = (CacheModelInstance)o;
        return this.cacheName.compareTo(other.getCacheName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beanName == null ? 0 : this.beanName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheModelInstance other = (CacheModelInstance)obj;
        return !(this.beanName == null ? other.beanName != null : !this.beanName.equals(other.beanName));
    }

    public void tearDown() {
        this.cacheManagerInstance.removeNotificationListener(this.beanName, this);
    }
}

