/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import com.tc.admin.model.IClient;
import com.tc.admin.model.IServer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.ObjectName;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.EhcacheStatsUtils;
import org.terracotta.modules.ehcache.presentation.model.BaseMBeanModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheStatisticsModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheModel
extends BaseMBeanModel
implements Comparable {
    protected final CacheManagerModel cacheManagerModel;
    protected final String cacheName;
    protected final String shortName;
    protected final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public CacheModel(CacheManagerModel cacheManagerModel, String cacheName) {
        super(cacheManagerModel.getClusterModel());
        this.cacheManagerModel = cacheManagerModel;
        this.cacheName = cacheName;
        this.shortName = EhcachePresentationUtils.determineShortName(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Boolean booleanAttr(Map<String, Object> attrs, String name) {
        Boolean result = null;
        try {
            result = (Boolean)attrs.get(name);
        }
        catch (Exception exception) {
        }
        finally {
            if (result == null) {
                result = Boolean.FALSE;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Integer integerAttr(Map<String, Object> attrs, String name) {
        Integer result = null;
        try {
            result = (Integer)attrs.get(name);
        }
        catch (Exception exception) {
        }
        finally {
            if (result == null) {
                result = 0;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Long longAttr(Map<String, Object> attrs, String name) {
        Long result = null;
        try {
            result = (Long)attrs.get(name);
        }
        catch (Exception exception) {
        }
        finally {
            if (result == null) {
                result = 0L;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String stringAttr(Map<String, Object> attrs, String name) {
        String result = null;
        try {
            result = (String)attrs.get(name);
        }
        catch (Exception exception) {
        }
        finally {
            if (result == null) {
                result = "";
            }
        }
        return result;
    }

    public synchronized CacheManagerModel getCacheManagerModel() {
        return this.cacheManagerModel;
    }

    public Set<CacheModelInstance> cacheModelInstances() {
        return this.cacheManagerModel.cacheModelInstances(this);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getInstanceCount() {
        return this.onSet != null ? this.onSet.size() : 0;
    }

    protected void _setAttribute(String attribute, Object value) {
        ObjectName target = this.getRandomBean();
        if (target != null) {
            this.safeSetAttribute(target, attribute, value);
            return;
        }
    }

    public CacheStatisticsModel getCacheStatistics(IClient client) {
        IServer activeCoord = this.getActiveCoordinator();
        if (activeCoord == null) {
            return null;
        }
        CacheStatisticsModel result = null;
        try {
            HashMap<ObjectName, HashSet<String>> request = new HashMap<ObjectName, HashSet<String>>();
            ObjectName templateName = EhcacheStatsUtils.getSampledCacheBeanName(this.cacheManagerModel.getName(), this.cacheName);
            templateName = client.getTunneledBeanName(templateName);
            request.put(templateName, new HashSet<String>(Arrays.asList(CacheStatisticsModel.MBEAN_ATTRS)));
            Map resp = activeCoord.getAttributeMap(request, Long.MAX_VALUE, TimeUnit.SECONDS);
            Map attrMap = (Map)resp.get(templateName);
            if (attrMap != null && !attrMap.isEmpty()) {
                result = new CacheStatisticsModel(attrMap);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public CacheStatisticsModel getAggregateCacheStatistics() {
        CacheStatisticsModel result = new CacheStatisticsModel(this.cacheName);
        HashSet<String> attrSet = new HashSet<String>(Arrays.asList(CacheStatisticsModel.MBEAN_ATTRS));
        float avgGetTimeMillis = 0.0f;
        float minGetTimeMillis = 0.0f;
        float maxGetTimeMillis = 0.0f;
        int instances = 0;
        Map<ObjectName, Map<String, Object>> resp = this.getAttributes(attrSet);
        for (Map.Entry<ObjectName, Map<String, Object>> entry : resp.entrySet()) {
            Map<String, Object> attrMap = entry.getValue();
            if (attrMap == null) continue;
            CacheStatisticsModel csm = new CacheStatisticsModel(attrMap);
            result.add(csm);
            avgGetTimeMillis += csm.getAverageGetTimeMillis();
            minGetTimeMillis += csm.getMinGetTimeMillis();
            maxGetTimeMillis += csm.getMaxGetTimeMillis();
            ++instances;
        }
        if (instances > 0) {
            result.setAverageGetTime(avgGetTimeMillis / (float)instances);
            result.setMinGetTime(minGetTimeMillis / (float)instances);
            result.setMaxGetTime(maxGetTimeMillis / (float)instances);
        }
        return result;
    }

    public void removeAll() {
        this.invokeAll("removeAll");
    }

    public void setEnabled(boolean enabled) {
        this.safeSetAttribute("Enabled", enabled);
    }

    public void setBulkLoadEnabled(boolean bulkLoadEnabled) {
        this.safeSetAttribute("NodeBulkLoadEnabled", bulkLoadEnabled);
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.safeSetAttribute("StatisticsEnabled", enabled);
    }

    @Override
    public void init() {
        this.addListeners();
        this.onSet.addAll(this.getActiveCacheModelBeans());
    }

    protected Set<ObjectName> getActiveCacheModelBeans() {
        IServer activeCoord = this.getActiveCoordinator();
        if (activeCoord != null) {
            try {
                StringBuilder sb = new StringBuilder("net.sf.ehcache:type=SampledCache").append(",SampledCacheManager=").append(EhcacheStatsUtils.mbeanSafe(this.cacheManagerModel.getName())).append(",name=").append(this.cacheName).append(",*");
                return activeCoord.queryNames(new ObjectName(sb.toString()), null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public void suspend() {
    }

    @Override
    public void handleNotification(Notification notif, Object data) {
        String type = notif.getType();
        if (notif instanceof MBeanServerNotification) {
            MBeanServerNotification mbsn = (MBeanServerNotification)notif;
            ObjectName on = mbsn.getMBeanName();
            if (type.equals("JMX.mbean.unregistered")) {
                if (this.cacheManagerModel.isCacheInstance(on) && on.getKeyProperty("name").equals(this.cacheName)) {
                    CacheModel cacheModel;
                    this.onSet.remove(on);
                    if (this.onSet.isEmpty() && (cacheModel = this.cacheManagerModel.removeCacheModel(this.cacheName)) != null) {
                        cacheModel.tearDown();
                    }
                }
            } else if (type.equals("JMX.mbean.registered") && this.cacheManagerModel.isCacheInstance(on) && on.getKeyProperty("name").equals(this.cacheName)) {
                this.onSet.add(on);
            }
        }
    }

    public int getStatisticsEnabledCount() {
        return this.cacheManagerModel.getStatisticsEnabledCount(this);
    }

    public int getBulkLoadEnabledCount() {
        return this.cacheManagerModel.getBulkLoadEnabledCount(this);
    }

    public int getBulkLoadDisabledCount() {
        return this.cacheManagerModel.getBulkLoadDisabledCount(this);
    }

    public int getEnabledCount() {
        return this.cacheManagerModel.getEnabledCount(this);
    }

    public int getTransactionalCount() {
        return this.cacheManagerModel.getTransactionalCount(this);
    }

    public int getTerracottaClusteredInstanceCount() {
        return this.cacheManagerModel.getTerracottaClusteredInstanceCount(this);
    }

    public String generateActiveConfigDeclaration() {
        return this.cacheManagerModel.generateActiveConfigDeclaration(this.getCacheName());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public int compareTo(Object o) {
        CacheModel other = (CacheModel)o;
        return this.getCacheName().compareTo(other.getCacheName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cacheName == null ? 0 : this.cacheName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheModel other = (CacheModel)obj;
        return !(this.cacheName == null ? other.cacheName != null : !this.cacheName.equals(other.cacheName));
    }

    public int getSize() {
        Iterator<CacheModelInstance> i$ = this.cacheModelInstances().iterator();
        if (i$.hasNext()) {
            CacheModelInstance cmi = i$.next();
            return cmi.getSize();
        }
        return 0;
    }

    public String toString() {
        return this.cacheName;
    }

    @Override
    public void tearDown() {
        this.removeListeners();
        super.tearDown();
    }
}

