/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import com.tc.admin.model.IClient;
import com.tc.admin.model.IServer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.terracotta.modules.ehcache.presentation.EhcacheStatsUtils;
import org.terracotta.modules.ehcache.presentation.model.BaseMBeanModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.EhcacheModel;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManagerModel
extends BaseMBeanModel
implements PropertyChangeListener {
    private final EhcacheModel ehcacheModel;
    private final String name;
    private final Set<ObjectName> pendingClients;
    private final ConcurrentMap<ObjectName, CacheManagerInstance> cacheManagerInstanceMap;
    private final ConcurrentMap<String, CacheModel> cacheModelMap;
    private final ConcurrentMap<String, ClusteredCacheModel> clusteredCacheModelMap;
    private final ConcurrentMap<CacheModelInstance, StandaloneCacheModel> standaloneCacheModelMap;
    private Boolean cachesEnabledPersistently;
    private Boolean cachesBulkLoadEnabledPersistently;
    private Boolean statisticsEnabledPersistently;

    public CacheManagerModel(EhcacheModel ehCacheModel, String name) {
        super(ehCacheModel.getClusterModel());
        this.ehcacheModel = ehCacheModel;
        this.name = name;
        this.pendingClients = new HashSet<ObjectName>();
        this.cacheManagerInstanceMap = new ConcurrentHashMap<ObjectName, CacheManagerInstance>();
        this.cacheModelMap = new ConcurrentHashMap<String, CacheModel>();
        this.clusteredCacheModelMap = new ConcurrentHashMap<String, ClusteredCacheModel>();
        this.standaloneCacheModelMap = new ConcurrentHashMap<CacheModelInstance, StandaloneCacheModel>();
    }

    public boolean isEmpty() {
        return this.cacheManagerInstanceMap != null && this.cacheManagerInstanceMap.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public EhcacheModel getEhcacheModel() {
        return this.ehcacheModel;
    }

    public int getInstanceCount() {
        return this.cacheManagerInstanceMap != null ? this.cacheManagerInstanceMap.size() : 0;
    }

    public int getCacheModelCount() {
        return this.cacheModelMap != null ? this.cacheModelMap.size() : 0;
    }

    public Set<CacheModelInstance> allCacheModelInstances() {
        LinkedHashSet<CacheModelInstance> list = new LinkedHashSet<CacheModelInstance>();
        for (CacheModel cacheModel : this.cacheModels()) {
            list.addAll(cacheModel.cacheModelInstances());
        }
        return Collections.unmodifiableSet(list);
    }

    public Set<CacheModelInstance> cacheModelInstances(CacheModel cacheModel) {
        LinkedHashSet<CacheModelInstance> list = new LinkedHashSet<CacheModelInstance>();
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            CacheManagerInstance cmi = iter.next();
            CacheModelInstance cacheModelInstance = cmi.getCacheModelInstance(cacheModel.getCacheName());
            if (cacheModelInstance == null) continue;
            list.add(cacheModelInstance);
        }
        return Collections.unmodifiableSet(list);
    }

    public Set<CacheModelInstance> clusteredCacheModelInstances(CacheModel cacheModel) {
        LinkedHashSet<CacheModelInstance> list = new LinkedHashSet<CacheModelInstance>();
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            CacheManagerInstance cmi = iter.next();
            CacheModelInstance cacheModelInstance = cmi.getCacheModelInstance(cacheModel.getCacheName());
            if (cacheModelInstance == null || !cacheModelInstance.isTerracottaClustered()) continue;
            list.add(cacheModelInstance);
        }
        return Collections.unmodifiableSet(list);
    }

    public CacheManagerInstance getInstance(IClient client) {
        if (client == null || this.cacheManagerInstanceMap == null) {
            return null;
        }
        String remoteAddress = client.getRemoteAddress().replace(':', '/');
        for (ObjectName on : this.cacheManagerInstanceMap.keySet()) {
            String node = on.getKeyProperty("node");
            if (!remoteAddress.equals(node)) continue;
            return (CacheManagerInstance)this.cacheManagerInstanceMap.get(on);
        }
        return null;
    }

    public CacheModelInstance getCacheModelInstance(IClient client, String cacheName) {
        CacheManagerInstance cacheManagerInstance = this.getInstance(client);
        return cacheManagerInstance != null ? cacheManagerInstance.getCacheModelInstance(cacheName) : null;
    }

    public IClient getClient(ObjectName on) {
        if (on == null || this.clusterModel == null) {
            return null;
        }
        String node = on.getKeyProperty("node").replace('/', ':');
        IClient result = null;
        for (IClient client : this.clusterModel.getClients()) {
            if (!client.getRemoteAddress().equals(node)) continue;
            result = client;
            break;
        }
        return result;
    }

    @Override
    public void clientConnected(IClient client) {
        for (ObjectName on : this.pendingClients.toArray(new ObjectName[0])) {
            IClient theClient = this.getClient(on);
            if (theClient == null) continue;
            this.bindClientToCacheManagerInstance(theClient, on);
        }
    }

    @Override
    public void clientDisconnected(IClient client) {
    }

    private void addPendingClient(ObjectName on) {
        this.pendingClients.add(on);
    }

    private void bindClientToCacheManagerInstance(IClient client, ObjectName on) {
        CacheManagerInstance instance = new CacheManagerInstance(this, client, on);
        if (this.cacheManagerInstanceMap.putIfAbsent(on, instance) == null) {
            this.onSet.add(on);
            instance.startup();
            this.addNotificationListener(on, this);
            this.fireInstanceAdded(instance);
        } else {
            instance.tearDown();
        }
    }

    @Override
    public void init() {
        this.addListeners();
        this.onSet.addAll(this.getActiveCacheManagerBeans());
        for (ObjectName on : this.onSet.toArray(new ObjectName[0])) {
            IClient client = this.getClient(on);
            if (client != null) {
                this.bindClientToCacheManagerInstance(client, on);
                continue;
            }
            this.addPendingClient(on);
        }
        this.initCacheModelMap();
        if (this.getStatisticsEnabledCount() == this.getCacheModelInstanceCount()) {
            this.statisticsEnabledPersistently = Boolean.TRUE;
        }
    }

    @Override
    public void suspend() {
        for (ObjectName on : this.onSet.toArray(new ObjectName[0])) {
            CacheManagerInstance instance = (CacheManagerInstance)this.cacheManagerInstanceMap.remove(on);
            if (instance == null) continue;
            this.fireInstanceRemoved(instance);
            instance.tearDown();
        }
        for (CacheModel cacheModel : this.cacheModels()) {
            this.removeCacheModel(cacheModel.getCacheName());
        }
        this.onSet.clear();
    }

    private boolean testAddCacheModel(ObjectName on) {
        String cacheName = on.getKeyProperty("name");
        if (cacheName != null && !cacheName.endsWith("org.hibernate.cache.UpdateTimestampsCache") && !this.hasCacheModel(cacheName)) {
            CacheModel cacheModel = new CacheModel(this, cacheName);
            CacheModel prev = this.addCacheModel(cacheModel);
            if (prev == null) {
                cacheModel.startup();
            }
            return prev == null;
        }
        return false;
    }

    private void initCacheModelMap() {
        for (ObjectName objectName : this.getActiveCacheModelBeans()) {
            this.testAddCacheModel(objectName);
        }
    }

    public Set<ObjectName> allCacheManagerBeans() {
        if (this.onSet != null) {
            return new HashSet<ObjectName>(this.onSet);
        }
        return Collections.emptySet();
    }

    private Set<ObjectName> getActiveCacheManagerBeans() {
        IServer activeCoord = this.getActiveCoordinator();
        if (activeCoord != null) {
            try {
                StringBuilder sb = new StringBuilder("net.sf.ehcache:type=SampledCacheManager").append(",name=").append(EhcacheStatsUtils.mbeanSafe(this.name)).append(",*");
                return activeCoord.queryNames(new ObjectName(sb.toString()), null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }

    private Set<ObjectName> getActiveCacheModelBeans() {
        IServer activeCoord = this.getActiveCoordinator();
        if (activeCoord != null) {
            try {
                StringBuilder sb = new StringBuilder("net.sf.ehcache:type=SampledCache").append(",SampledCacheManager=").append(EhcacheStatsUtils.mbeanSafe(this.name)).append(",*");
                return activeCoord.queryNames(new ObjectName(sb.toString()), null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }

    public Set<CacheModel> cacheModels() {
        return Collections.unmodifiableSet(new HashSet(this.cacheModelMap.values()));
    }

    public Iterator<CacheModel> cacheModelIterator() {
        return new TreeMap<String, CacheModel>(this.cacheModelMap).values().iterator();
    }

    public Set<CacheManagerInstance> cacheManagerInstances() {
        return Collections.unmodifiableSet(new HashSet(this.cacheManagerInstanceMap.values()));
    }

    public Iterator<CacheManagerInstance> cacheManagerInstanceIterator() {
        ArrayList l = new ArrayList(this.cacheManagerInstanceMap.values());
        Collections.sort(l);
        return l.iterator();
    }

    public CacheModel getCacheModel(String cacheName) {
        return (CacheModel)this.cacheModelMap.get(cacheName);
    }

    public boolean hasCacheModel(String cacheName) {
        return this.getCacheModel(cacheName) != null;
    }

    public CacheModel removeCacheModel(String cacheName) {
        CacheModel prev = (CacheModel)this.cacheModelMap.remove(cacheName);
        if (prev != null) {
            this.fireCacheModelRemoved(prev);
            prev.removePropertyChangeListener(this);
        }
        return prev;
    }

    public CacheModel addCacheModel(CacheModel cacheModel) {
        CacheModel prev = this.cacheModelMap.putIfAbsent(cacheModel.getCacheName(), cacheModel);
        if (prev == null) {
            cacheModel.addPropertyChangeListener(this);
            this.fireCacheModelAdded(cacheModel);
        }
        return prev;
    }

    public void cacheModelChanged(CacheModel cacheModel) {
        this.fireCacheModelChanged(cacheModel);
    }

    public void registerCacheModelInstance(CacheModelInstance cacheModelInstance) {
        if (cacheModelInstance != null) {
            String cacheName = cacheModelInstance.getCacheName();
            ObjectName beanName = cacheModelInstance.getBeanName();
            if (cacheModelInstance.isTerracottaClustered()) {
                ClusteredCacheModel cacheModel = this.getClusteredCacheModel(cacheName);
                if (cacheModel == null) {
                    cacheModel = new ClusteredCacheModel(this, cacheName, beanName);
                    this.addClusteredCacheModel(cacheModel);
                } else {
                    cacheModel.addInstance(beanName);
                }
            } else {
                this.addStandaloneCacheModel(cacheModelInstance, new StandaloneCacheModel(this, cacheModelInstance));
            }
        }
    }

    public void deregisterCacheModelInstance(CacheModelInstance cacheModelInstance) {
        if (cacheModelInstance != null) {
            String cacheName = cacheModelInstance.getCacheName();
            if (cacheModelInstance.isTerracottaClustered()) {
                ClusteredCacheModel cacheModel = this.getClusteredCacheModel(cacheName);
                if (cacheModel != null) {
                    cacheModel.removeInstance(cacheModelInstance.getBeanName());
                    if (cacheModel.instanceCount() == 0) {
                        this.removeClusteredCacheModel(cacheName);
                    }
                }
            } else {
                this.removeStandaloneCacheModel(cacheModelInstance);
            }
        }
    }

    public StandaloneCacheModel removeStandaloneCacheModel(CacheModelInstance cacheModelInstance) {
        StandaloneCacheModel cacheModel = (StandaloneCacheModel)this.standaloneCacheModelMap.remove(cacheModelInstance);
        if (cacheModel != null) {
            cacheModel.removePropertyChangeListener(this);
            this.fireStandaloneCacheModelRemoved(cacheModel);
        }
        return cacheModel;
    }

    public StandaloneCacheModel addStandaloneCacheModel(CacheModelInstance cacheModelInstance, StandaloneCacheModel cacheModel) {
        StandaloneCacheModel prev = this.standaloneCacheModelMap.putIfAbsent(cacheModelInstance, cacheModel);
        if (prev == null) {
            cacheModel.addPropertyChangeListener(this);
            this.fireStandaloneCacheModelAdded(cacheModel);
        }
        return prev;
    }

    public Map<CacheModelInstance, StandaloneCacheModel> standaloneCacheModels() {
        return new HashMap<CacheModelInstance, StandaloneCacheModel>(this.standaloneCacheModelMap);
    }

    public CacheModelInstance cacheModelInstance(StandaloneCacheModel cacheModel) {
        for (Map.Entry entry : this.standaloneCacheModelMap.entrySet()) {
            if (!((StandaloneCacheModel)entry.getValue()).equals(cacheModel)) continue;
            return (CacheModelInstance)entry.getKey();
        }
        return null;
    }

    public StandaloneCacheModel standaloneCacheModel(CacheModelInstance cacheModelInstance) {
        return (StandaloneCacheModel)this.standaloneCacheModelMap.get(cacheModelInstance);
    }

    public ClusteredCacheModel addClusteredCacheModel(ClusteredCacheModel cacheModel) {
        ClusteredCacheModel prev = this.clusteredCacheModelMap.putIfAbsent(cacheModel.getCacheName(), cacheModel);
        if (prev == null) {
            cacheModel.addPropertyChangeListener(this);
            this.fireClusteredCacheModelAdded(cacheModel);
        }
        return prev;
    }

    public ClusteredCacheModel removeClusteredCacheModel(String cacheName) {
        ClusteredCacheModel cacheModel = (ClusteredCacheModel)this.clusteredCacheModelMap.remove(cacheName);
        if (cacheModel != null) {
            cacheModel.removePropertyChangeListener(this);
            this.fireClusteredCacheModelRemoved(cacheModel);
        }
        return cacheModel;
    }

    public StandaloneCacheModel getStandaloneCacheModel(CacheModelInstance cacheModelInstance) {
        return (StandaloneCacheModel)this.standaloneCacheModelMap.get(cacheModelInstance);
    }

    public ClusteredCacheModel getClusteredCacheModel(String cacheName) {
        return (ClusteredCacheModel)this.clusteredCacheModelMap.get(cacheName);
    }

    public boolean hasClusteredCacheModel(String cacheName) {
        return this.getClusteredCacheModel(cacheName) != null;
    }

    public Set<ClusteredCacheModel> clusteredCacheModels() {
        return new HashSet<ClusteredCacheModel>(this.clusteredCacheModelMap.values());
    }

    public Iterator<ClusteredCacheModel> clusteredCacheModelIterator() {
        return new TreeMap<String, ClusteredCacheModel>(this.clusteredCacheModelMap).values().iterator();
    }

    public Map<CacheModelInstance, Object> invokeCacheModelInstances(Set<CacheModelInstance> targets, String operation) {
        IServer activeCoord = this.getActiveCoordinator();
        if (activeCoord != null) {
            HashMap<ObjectName, CacheModelInstance> on2cmi = new HashMap<ObjectName, CacheModelInstance>();
            for (CacheModelInstance cmi : targets) {
                on2cmi.put(cmi.getBeanName(), cmi);
            }
            Map<ObjectName, Object> response = this.invokeAll(on2cmi.keySet(), operation);
            HashMap<CacheModelInstance, Object> result = new HashMap<CacheModelInstance, Object>();
            for (Map.Entry<ObjectName, Object> entry : response.entrySet()) {
                result.put((CacheModelInstance)on2cmi.get(entry.getKey()), entry.getValue());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public Map<CacheModelInstance, Exception> setCacheModelInstanceAttribute(String attr, Map<CacheModelInstance, Object> attrMap) throws Exception {
        IServer activeCoord = this.getActiveCoordinator();
        if (activeCoord != null) {
            HashMap<ObjectName, CacheModelInstance> on2cmi = new HashMap<ObjectName, CacheModelInstance>();
            HashMap<ObjectName, Object> on2val = new HashMap<ObjectName, Object>();
            for (Map.Entry<CacheModelInstance, Object> entry : attrMap.entrySet()) {
                CacheModelInstance cmi = entry.getKey();
                ObjectName on = cmi.getBeanName();
                on2cmi.put(on, cmi);
                on2val.put(on, entry.getValue());
            }
            Map response = activeCoord.setAttribute(attr, on2val);
            HashMap<CacheModelInstance, Exception> result = new HashMap<CacheModelInstance, Exception>();
            for (Map.Entry entry : response.entrySet()) {
                result.put((CacheModelInstance)on2cmi.get(entry.getKey()), (Exception)entry.getValue());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public void clearStatistics() {
        this.invokeAll("clearStatistics");
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.setStatisticsEnabled(enabled, false);
    }

    public void setStatisticsEnabled(boolean enabled, boolean persistent) {
        this.setStatisticsEnabledPersistently(enabled, persistent);
        this.safeSetAttribute("StatisticsEnabled", enabled);
    }

    public void setStatisticsEnabledPersistently(boolean enabled, boolean persistent) {
        this.statisticsEnabledPersistently = persistent ? Boolean.valueOf(enabled) : null;
    }

    public void setStatisticsEnabled(CacheModel cacheModel, boolean enabled) {
        this.safeSetAttribute(this.allCacheModelInstanceBeans(cacheModel), "StatisticsEnabled", (Object)enabled);
    }

    public Boolean isStatisticsEnabledPersistently() {
        return this.statisticsEnabledPersistently;
    }

    public void clearAllCaches() {
        this.invokeAll("clearAll");
    }

    public Set<ObjectName> allCacheModelInstanceBeans() {
        LinkedHashSet<ObjectName> result = new LinkedHashSet<ObjectName>();
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            result.addAll(iter.next().cacheModelInstanceBeans());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<ObjectName> allCacheModelInstanceBeans(CacheModel cacheModel) {
        LinkedHashSet<ObjectName> result = new LinkedHashSet<ObjectName>();
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            CacheManagerInstance cmi = iter.next();
            CacheModelInstance cacheModelInstance = cmi.getCacheModelInstance(cacheModel.getCacheName());
            if (cacheModelInstance == null) continue;
            result.add(cacheModelInstance.getBeanName());
        }
        return Collections.unmodifiableSet(result);
    }

    public void setBulkLoadEnabled(boolean bulkLoadEnabled) {
        this.setBulkLoadEnabled(bulkLoadEnabled, false);
    }

    public void setBulkLoadEnabled(boolean bulkLoadEnabled, boolean persistent) {
        this.setCachesBulkLoadEnabledPersistently(bulkLoadEnabled, persistent);
        this.safeSetAttribute(this.allCacheModelInstanceBeans(), "NodeBulkLoadEnabled", (Object)bulkLoadEnabled);
    }

    public void setCachesBulkLoadEnabledPersistently(boolean bulkLoadEnabled, boolean persistent) {
        this.cachesBulkLoadEnabledPersistently = persistent ? Boolean.valueOf(bulkLoadEnabled) : null;
    }

    public void setBulkLoadEnabled(CacheModel cacheModel, boolean bulkLoadEnabled) {
        this.safeSetAttribute(this.allCacheModelInstanceBeans(cacheModel), "NodeBulkLoadEnabled", (Object)bulkLoadEnabled);
    }

    public Boolean isBulkLoadEnabledPersistently() {
        return this.cachesBulkLoadEnabledPersistently;
    }

    public void setCachesEnabled(boolean enabled) {
        this.setCachesEnabled(enabled, false);
    }

    public void setCachesEnabled(boolean enabled, boolean persistent) {
        this.setCachesEnabledPersistently(enabled, persistent);
        this.safeSetAttribute("Enabled", enabled);
    }

    public void setCachesEnabledPersistently(boolean enabled, boolean persistent) {
        this.cachesEnabledPersistently = persistent ? Boolean.valueOf(enabled) : null;
    }

    public Boolean isCachesEnabledPersistently() {
        return this.cachesEnabledPersistently;
    }

    public void setCachesEnabled(CacheModel cacheModel, boolean enabled) {
        this.safeSetAttribute(this.allCacheModelInstanceBeans(cacheModel), "Enabled", (Object)enabled);
    }

    public int getCacheModelInstanceCount() {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            result += iter.next().getInstanceCount();
        }
        return result;
    }

    public int getCacheModelInstanceCount(CacheModel cacheModel) {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            if (iter.next().getCacheModelInstance(cacheModel.getCacheName()) == null) continue;
            ++result;
        }
        return result;
    }

    public int getEnabledCount() {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            result += iter.next().getEnabledCount();
        }
        return result;
    }

    public int getEnabledCount(CacheModel cacheModel) {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            CacheModelInstance cacheModelInstance = iter.next().getCacheModelInstance(cacheModel.getCacheName());
            if (cacheModelInstance == null || !cacheModelInstance.isEnabled()) continue;
            ++result;
        }
        return result;
    }

    public int getTerracottaClusteredInstanceCount(CacheModel cacheModel) {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            CacheModelInstance cacheModelInstance = iter.next().getCacheModelInstance(cacheModel.getCacheName());
            if (cacheModelInstance == null || !cacheModelInstance.isTerracottaClustered()) continue;
            ++result;
        }
        return result;
    }

    public int getTransactionalCount() {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            result += iter.next().getTransactionalCount();
        }
        return result;
    }

    public int getTransactionalCount(CacheModel cacheModel) {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            CacheModelInstance cacheModelInstance = iter.next().getCacheModelInstance(cacheModel.getCacheName());
            if (cacheModelInstance == null || !cacheModelInstance.isTransactional()) continue;
            ++result;
        }
        return result;
    }

    public int getBulkLoadEnabledCount() {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            result += iter.next().getBulkLoadEnabledCount();
        }
        return result;
    }

    public int getBulkLoadDisabledCount() {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            result += iter.next().getBulkLoadDisabledCount();
        }
        return result;
    }

    public int getBulkLoadEnabledCount(CacheModel cacheModel) {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            CacheModelInstance cacheModelInstance = iter.next().getCacheModelInstance(cacheModel.getCacheName());
            if (cacheModelInstance == null || !cacheModelInstance.isBulkLoadEnabled()) continue;
            ++result;
        }
        return result;
    }

    public int getBulkLoadDisabledCount(CacheModel cacheModel) {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            CacheModelInstance cacheModelInstance = iter.next().getCacheModelInstance(cacheModel.getCacheName());
            if (cacheModelInstance == null || cacheModelInstance.isBulkLoadEnabled()) continue;
            ++result;
        }
        return result;
    }

    public int getStatisticsEnabledCount() {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            result += iter.next().getStatisticsEnabledCount();
        }
        return result;
    }

    public int getStatisticsEnabledCount(CacheModel cacheModel) {
        int result = 0;
        Iterator<CacheManagerInstance> iter = this.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            CacheModelInstance cacheModelInstance = iter.next().getCacheModelInstance(cacheModel.getCacheName());
            if (cacheModelInstance == null || !cacheModelInstance.isStatisticsEnabled()) continue;
            ++result;
        }
        return result;
    }

    public boolean isCacheManagerInstance(ObjectName on) {
        if (on == null) {
            return false;
        }
        return on.getKeyProperty("type").equals("SampledCacheManager") && on.getKeyProperty("name").equals(this.name);
    }

    public static boolean isCacheManagerInstance(ObjectName on, String name) {
        if (on == null || name == null) {
            return false;
        }
        return on.getKeyProperty("type").equals("SampledCacheManager") && on.getKeyProperty("name").equals(name);
    }

    public boolean isCacheInstance(ObjectName on) {
        if (on == null) {
            return false;
        }
        return on.getKeyProperty("type").equals("SampledCache") && on.getKeyProperty("SampledCacheManager").equals(this.name);
    }

    @Override
    public void handleNotification(Notification notif, Object data) {
        String type = notif.getType();
        if (notif instanceof MBeanServerNotification) {
            MBeanServerNotification mbsn = (MBeanServerNotification)notif;
            ObjectName on = mbsn.getMBeanName();
            if (type.equals("JMX.mbean.unregistered")) {
                if (this.isCacheManagerInstance(on)) {
                    CacheManagerModel cacheManagerModel;
                    this.onSet.remove(on);
                    CacheManagerInstance instance = (CacheManagerInstance)this.cacheManagerInstanceMap.remove(on);
                    if (instance != null) {
                        this.fireInstanceRemoved(instance);
                        instance.tearDown();
                    }
                    if (this.cacheManagerInstanceMap.size() == 0 && (cacheManagerModel = this.ehcacheModel.removeCacheManagerModel(this.name)) != null) {
                        this.ehcacheModel.fireCacheManagerRemoved(cacheManagerModel);
                        cacheManagerModel.tearDown();
                    }
                }
            } else if (type.equals("JMX.mbean.registered")) {
                if (this.isCacheManagerInstance(on)) {
                    IClient client = this.getClient(on);
                    if (client != null) {
                        this.bindClientToCacheManagerInstance(client, on);
                    } else {
                        this.addPendingClient(on);
                    }
                } else if (this.isCacheInstance(on)) {
                    this.testAddCacheModel(on);
                }
            }
        }
    }

    public void addCacheManagerModelListener(CacheManagerModelListener listener) {
        this.listenerList.remove(CacheManagerModelListener.class, listener);
        this.listenerList.add(CacheManagerModelListener.class, listener);
    }

    public void removeCacheManagerModelListener(CacheManagerModelListener listener) {
        this.listenerList.remove(CacheManagerModelListener.class, listener);
    }

    protected void fireInstanceAdded(CacheManagerInstance instance) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).instanceAdded(instance);
        }
    }

    protected void fireInstanceRemoved(CacheManagerInstance instance) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).instanceRemoved(instance);
        }
    }

    protected void fireCacheModelAdded(CacheModel cacheModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).cacheModelAdded(cacheModel);
        }
    }

    protected void fireCacheModelRemoved(CacheModel cacheModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).cacheModelRemoved(cacheModel);
        }
    }

    protected void fireCacheModelChanged(CacheModel cacheModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).cacheModelChanged(cacheModel);
        }
    }

    protected void fireClusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).clusteredCacheModelAdded(cacheModel);
        }
    }

    protected void fireClusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).clusteredCacheModelRemoved(cacheModel);
        }
    }

    protected void fireClusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).clusteredCacheModelChanged(cacheModel);
        }
    }

    protected void fireStandaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).standaloneCacheModelAdded(cacheModel);
        }
    }

    protected void fireStandaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).standaloneCacheModelRemoved(cacheModel);
        }
    }

    protected void fireStandaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerModelListener.class) continue;
            ((CacheManagerModelListener)listeners[i + 1]).standaloneCacheModelChanged(cacheModel);
        }
    }

    public String generateActiveConfigDeclaration() {
        Object result = this.invokeOnce("generateActiveConfigDeclaration");
        return result != null ? result.toString() : "";
    }

    public String generateActiveConfigDeclaration(String cacheName) {
        Object result = this.invokeOnce("generateActiveConfigDeclaration", new Object[]{cacheName}, new String[]{"java.lang.String"});
        return result != null ? result.toString() : "";
    }

    public TableModel executeQuery(String cacheName, String query) throws Exception {
        ClusteredCacheModel cacheModel = this.getClusteredCacheModel(cacheName);
        if (cacheModel != null) {
            return cacheModel.executeQuery(query);
        }
        return new DefaultTableModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("Enabled".equals(prop)) {
            // empty if block
        }
    }

    @Override
    public void tearDown() {
        this.removeListeners();
        for (CacheManagerInstance cacheManagerInstance : this.cacheManagerInstanceMap.values()) {
            cacheManagerInstance.tearDown();
        }
        super.tearDown();
    }
}

