/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import com.tc.admin.model.IClient;
import com.tc.admin.model.IServer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.terracotta.modules.ehcache.presentation.EhcacheStatsUtils;
import org.terracotta.modules.ehcache.presentation.model.BaseMBeanModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceListener;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheTierSize;
import org.terracotta.modules.ehcache.presentation.model.SettingsCacheModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManagerInstance
extends BaseMBeanModel
implements PropertyChangeListener,
Comparable {
    private final CacheManagerModel cacheManagerModel;
    private final IClient client;
    private final ObjectName beanName;
    private String[] cacheNames;
    private final ConcurrentMap<ObjectName, CacheModelInstance> cacheModelInstanceMap;
    private Long maxBytesLocalHeap;
    private String maxBytesLocalHeapAsString;
    private Long maxBytesLocalOffHeap;
    private String maxBytesLocalOffHeapAsString;
    private Long maxBytesLocalDisk;
    private String maxBytesLocalDiskAsString;
    public static final String CACHE_NAMES_ATTR = "CacheNames";
    public static final String MAX_BYTES_LOCAL_HEAP_ATTR = "MaxBytesLocalHeap";
    public static final String MAX_BYTES_LOCAL_HEAP_AS_STRING_ATTR = "MaxBytesLocalHeapAsString";
    public static final String MAX_BYTES_LOCAL_OFFHEAP_ATTR = "MaxBytesLocalOffHeap";
    public static final String MAX_BYTES_LOCAL_OFFHEAP_AS_STRING_ATTR = "MaxBytesLocalOffHeapAsString";
    public static final String MAX_BYTES_LOCAL_DISK_ATTR = "MaxBytesLocalDisk";
    public static final String MAX_BYTES_LOCAL_DISK_AS_STRING_ATTR = "MaxBytesLocalDiskAsString";
    public static final String[] ATTRIBUTE_ARRAY = new String[]{"CacheNames", "MaxBytesLocalHeap", "MaxBytesLocalHeapAsString", "MaxBytesLocalOffHeap", "MaxBytesLocalOffHeapAsString", "MaxBytesLocalDisk", "MaxBytesLocalDiskAsString"};
    public static final Set<String> ATTRIBUTE_SET = new HashSet<String>(Arrays.asList(ATTRIBUTE_ARRAY));

    public CacheManagerInstance(CacheManagerModel cacheManagerModel, IClient client, ObjectName beanName) {
        super(cacheManagerModel.getClusterModel());
        this.cacheManagerModel = cacheManagerModel;
        this.client = client;
        this.beanName = beanName;
        this.cacheModelInstanceMap = new ConcurrentHashMap<ObjectName, CacheModelInstance>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(Map<String, Object> attrs) {
        CacheManagerInstance cacheManagerInstance = this;
        synchronized (cacheManagerInstance) {
            this.cacheNames = (String[])attrs.get(CACHE_NAMES_ATTR);
            this.maxBytesLocalHeap = (Long)attrs.get(MAX_BYTES_LOCAL_HEAP_ATTR);
            this.maxBytesLocalHeapAsString = (String)attrs.get(MAX_BYTES_LOCAL_HEAP_AS_STRING_ATTR);
            this.maxBytesLocalOffHeap = (Long)attrs.get(MAX_BYTES_LOCAL_OFFHEAP_ATTR);
            this.maxBytesLocalOffHeapAsString = (String)attrs.get(MAX_BYTES_LOCAL_OFFHEAP_AS_STRING_ATTR);
            this.maxBytesLocalDisk = (Long)attrs.get(MAX_BYTES_LOCAL_DISK_ATTR);
            this.maxBytesLocalDiskAsString = (String)attrs.get(MAX_BYTES_LOCAL_DISK_AS_STRING_ATTR);
        }
    }

    public CacheManagerModel getCacheManagerModel() {
        return this.cacheManagerModel;
    }

    public ObjectName getBeanName() {
        return this.beanName;
    }

    public String getCacheManagerName() {
        return this.getCacheManagerModel().getName();
    }

    public String[] getCacheNames() {
        return this.cacheNames;
    }

    public Long getMaxLocalHeapValue(boolean inBytes) {
        return inBytes ? this.getMaxBytesLocalHeap().longValue() : this.getMaxEntriesLocalHeap();
    }

    public Long getMaxBytesLocalHeap() {
        return this.maxBytesLocalHeap != null ? this.maxBytesLocalHeap : Long.valueOf(0L);
    }

    public String getMaxBytesLocalHeapAsString() {
        return this.maxBytesLocalHeapAsString;
    }

    public long getMaxEntriesLocalHeap() {
        long result = 0L;
        for (CacheModelInstance cacheModelInstance : this.cacheModelInstances()) {
            SettingsCacheModel scm = this.getSettingsCacheModel(cacheModelInstance);
            result += scm.getMaxEntriesLocalHeap();
        }
        return result;
    }

    public Long getMaxLocalOffHeapValue(boolean inBytes) {
        return inBytes ? this.getMaxBytesLocalOffHeap().longValue() : this.getMaxEntriesLocalOffHeap();
    }

    public Long getMaxBytesLocalOffHeap() {
        return this.maxBytesLocalOffHeap != null ? this.maxBytesLocalOffHeap : Long.valueOf(0L);
    }

    public String getMaxBytesLocalOffHeapAsString() {
        return this.maxBytesLocalOffHeapAsString;
    }

    public long getMaxEntriesLocalOffHeap() {
        return 0L;
    }

    public Long getMaxLocalDiskValue(boolean inBytes) {
        return inBytes ? this.getMaxBytesLocalDisk() : this.getMaxEntriesLocalDisk();
    }

    public Long getMaxBytesLocalDisk() {
        return this.maxBytesLocalDisk != null ? this.maxBytesLocalDisk : Long.valueOf(0L);
    }

    public String getMaxBytesLocalDiskAsString() {
        return this.maxBytesLocalDiskAsString;
    }

    public Long getMaxEntriesLocalDisk() {
        long result = 0L;
        for (CacheModelInstance cacheModelInstance : this.cacheModelInstances()) {
            if (cacheModelInstance.isTerracottaClustered()) continue;
            SettingsCacheModel scm = this.getSettingsCacheModel(cacheModelInstance);
            result += scm.getMaxEntriesLocalDisk();
        }
        return result;
    }

    public Long getMaxRemoteValue(boolean inBytes) {
        return inBytes ? this.getMaxBytesRemote() : this.getMaxEntriesRemote();
    }

    public Long getMaxBytesRemote() {
        long result = 0L;
        for (CacheModelInstance cacheModelInstance : this.cacheModelInstances()) {
            if (!cacheModelInstance.isTerracottaClustered()) continue;
            SettingsCacheModel scm = this.getSettingsCacheModel(cacheModelInstance);
            result += scm.getMaxBytesLocalDisk();
        }
        return result;
    }

    public Long getMaxEntriesRemote() {
        long result = 0L;
        for (CacheModelInstance cacheModelInstance : this.cacheModelInstances()) {
            if (!cacheModelInstance.isTerracottaClustered()) continue;
            SettingsCacheModel scm = this.getSettingsCacheModel(cacheModelInstance);
            result += scm.getMaxEntriesLocalDisk();
        }
        return result;
    }

    public boolean hasSizeBasedPooling() {
        return this.getMaxBytesLocalHeap() + this.getMaxBytesLocalOffHeap() + this.getMaxBytesLocalDisk() > 0L;
    }

    public boolean hasSizeBasedCache() {
        for (CacheModelInstance cmi : this.cacheModelInstances()) {
            if (!this.getSettingsCacheModel(cmi).hasSizeBasedLimits()) continue;
            return true;
        }
        return false;
    }

    public IClient getClient() {
        return this.client;
    }

    public String getClientName() {
        return this.client != null ? this.client.toString() : "";
    }

    public synchronized Set<ObjectName> cacheModelInstanceBeans() {
        return Collections.unmodifiableSet(this.cacheModelInstanceMap.keySet());
    }

    public synchronized Iterator<CacheModelInstance> cacheModelInstanceIter() {
        ArrayList l = new ArrayList(this.cacheModelInstanceMap.values());
        Collections.sort(l);
        return Collections.unmodifiableList(l).iterator();
    }

    public synchronized Set<CacheModelInstance> cacheModelInstances() {
        return new HashSet<CacheModelInstance>(this.cacheModelInstanceMap.values());
    }

    public synchronized CacheModelInstance getCacheModelInstance(String cacheName) {
        Iterator<CacheModelInstance> iter = this.cacheModelInstanceIter();
        while (iter.hasNext()) {
            CacheModelInstance instance = iter.next();
            if (!instance.getCacheName().equals(cacheName)) continue;
            return instance;
        }
        return null;
    }

    public boolean hasCacheModelInstance(String cacheName) {
        return this.getCacheModelInstance(cacheName) != null;
    }

    private synchronized CacheModelInstance removeCacheModelInstance(ObjectName on) {
        CacheModelInstance prev = (CacheModelInstance)this.cacheModelInstanceMap.remove(on);
        if (prev != null) {
            this.onSet.remove(on);
            this.cacheManagerModel.deregisterCacheModelInstance(prev);
            this.fireCacheInstanceRemoved(prev);
            prev.removePropertyChangeListener(this);
            this.removeNotificationListener(on, this);
        }
        return prev;
    }

    private CacheModelInstance addCacheModelInstance(ObjectName on, CacheModelInstance cacheModelInstance) {
        CacheModelInstance prev = this.cacheModelInstanceMap.putIfAbsent(on, cacheModelInstance);
        if (prev == null) {
            this.onSet.add(on);
            this.cacheManagerModel.registerCacheModelInstance(cacheModelInstance);
            this.fireCacheInstanceAdded(cacheModelInstance);
            cacheModelInstance.addPropertyChangeListener(this);
            this.addNotificationListener(on, this);
        }
        return prev;
    }

    public void cacheInstanceChanged(CacheModelInstance cacheModelInstance) {
        this.fireCacheInstanceChanged(cacheModelInstance);
    }

    private boolean isCacheModelInstance(ObjectName on) {
        if (on == null) {
            return false;
        }
        return on.getKeyProperty("type").equals("SampledCache") && on.getKeyProperty("SampledCacheManager").equals(this.cacheManagerModel.getName()) && on.getKeyProperty("node").equals(this.client.getRemoteAddress().replace(':', '/')) && !on.getKeyProperty("name").endsWith("org.hibernate.cache.UpdateTimestampsCache");
    }

    @Override
    public void handleNotification(Notification notif, Object data) {
        String type = notif.getType();
        if (notif instanceof MBeanServerNotification) {
            CacheModelInstance instance;
            String cacheName;
            MBeanServerNotification mbsn = (MBeanServerNotification)notif;
            ObjectName on = mbsn.getMBeanName();
            if (type.equals("JMX.mbean.unregistered")) {
                CacheModelInstance cacheModelInstance;
                if (this.isCacheModelInstance(on) && (cacheModelInstance = this.removeCacheModelInstance(on)) != null) {
                    cacheModelInstance.tearDown();
                }
            } else if (type.equals("JMX.mbean.registered") && this.isCacheModelInstance(on) && !this.hasCacheModelInstance(cacheName = on.getKeyProperty("name")) && this.addCacheModelInstance(on, instance = new CacheModelInstance(this, cacheName, on)) != null) {
                instance.tearDown();
            }
        } else if ("CacheManagerChanged".equals(notif.getType())) {
            this.setAttributes((Map)notif.getUserData());
            this.fireCacheManagerInstanceChanged();
        }
    }

    private Set<ObjectName> getActiveCacheModelBeans() {
        IServer activeCoord = this.getActiveCoordinator();
        if (activeCoord != null) {
            try {
                StringBuilder sb = new StringBuilder("net.sf.ehcache:type=SampledCache").append(",SampledCacheManager=").append(EhcacheStatsUtils.mbeanSafe(this.cacheManagerModel.getName())).append(",node=").append(this.client.getRemoteAddress().replace(':', '/')).append(",*");
                return activeCoord.queryNames(new ObjectName(sb.toString()), null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public void init() {
        this.addListeners();
        this.setAttributes(this.getAttributes(this.beanName, ATTRIBUTE_SET));
        this.addNotificationListener(this.beanName, this);
        this.onSet.addAll(this.getActiveCacheModelBeans());
        for (ObjectName on : this.onSet.toArray(new ObjectName[0])) {
            String cacheName = on.getKeyProperty("name");
            if (cacheName.endsWith("org.hibernate.cache.UpdateTimestampsCache") || this.hasCacheModelInstance(cacheName)) continue;
            this.addCacheModelInstance(on, new CacheModelInstance(this, cacheName, on));
        }
    }

    public void addCacheManagerInstanceListener(CacheManagerInstanceListener listener) {
        this.listenerList.add(CacheManagerInstanceListener.class, listener);
    }

    public void removeCacheManagerInstanceListener(CacheManagerInstanceListener listener) {
        this.listenerList.remove(CacheManagerInstanceListener.class, listener);
    }

    protected void fireCacheManagerInstanceChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerInstanceListener.class) continue;
            ((CacheManagerInstanceListener)listeners[i + 1]).cacheManagerInstanceChanged(this);
        }
    }

    protected void fireCacheInstanceAdded(CacheModelInstance instance) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerInstanceListener.class) continue;
            ((CacheManagerInstanceListener)listeners[i + 1]).cacheModelInstanceAdded(instance);
        }
    }

    protected void fireCacheInstanceRemoved(CacheModelInstance instance) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerInstanceListener.class) continue;
            ((CacheManagerInstanceListener)listeners[i + 1]).cacheModelInstanceRemoved(instance);
        }
    }

    protected void fireCacheInstanceChanged(CacheModelInstance instance) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CacheManagerInstanceListener.class) continue;
            ((CacheManagerInstanceListener)listeners[i + 1]).cacheModelInstanceChanged(instance);
        }
    }

    @Override
    public void suspend() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("Enabled".equals(prop)) {
            // empty if block
        }
    }

    public int getInstanceCount() {
        return this.cacheModelInstanceMap.size();
    }

    public int getEnabledCount() {
        int result = 0;
        for (CacheModelInstance info : this.cacheModelInstanceMap.values()) {
            if (!info.isEnabled()) continue;
            ++result;
        }
        return result;
    }

    public int getBulkLoadEnabledCount() {
        int result = 0;
        for (CacheModelInstance info : this.cacheModelInstanceMap.values()) {
            if (!info.isBulkLoadEnabled()) continue;
            ++result;
        }
        return result;
    }

    public int getBulkLoadDisabledCount() {
        int result = 0;
        for (CacheModelInstance info : this.cacheModelInstanceMap.values()) {
            if (info.isBulkLoadEnabled()) continue;
            ++result;
        }
        return result;
    }

    public int getTransactionalCount() {
        int result = 0;
        for (CacheModelInstance info : this.cacheModelInstanceMap.values()) {
            if (!info.isTransactional()) continue;
            ++result;
        }
        return result;
    }

    public int getStatisticsEnabledCount() {
        int result = 0;
        for (CacheModelInstance info : this.cacheModelInstanceMap.values()) {
            if (!info.isStatisticsEnabled()) continue;
            ++result;
        }
        return result;
    }

    public int getTerracottaClusteredInstanceCount() {
        int result = 0;
        for (CacheModelInstance info : this.cacheModelInstanceMap.values()) {
            if (!info.isTerracottaClustered()) continue;
            ++result;
        }
        return result;
    }

    public void setCachesEnabled(boolean enabled) {
        this.safeSetAttribute(this.cacheModelInstanceBeans(), "Enabled", (Object)enabled);
    }

    public void setCachesBulkLoadEnabled(boolean bulkLoadEnabled) {
        this.safeSetAttribute(this.cacheModelInstanceBeans(), "NodeBulkLoadEnabled", (Object)bulkLoadEnabled);
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.safeSetAttribute(this.cacheModelInstanceBeans(), "StatisticsEnabled", (Object)enabled);
    }

    public void clearAll() {
        this.invokeAll("clearAll");
    }

    public boolean isCacheTerracottaClustered(String cacheName) {
        CacheModelInstance cacheModelInstance = this.getCacheModelInstance(cacheName);
        if (cacheModelInstance != null) {
            return cacheModelInstance.isTerracottaClustered();
        }
        return false;
    }

    public String generateActiveConfigDeclaration() {
        Object result = this.invokeOnce(this.beanName, "generateActiveConfigDeclaration");
        return result != null ? result.toString() : "";
    }

    public String generateActiveConfigDeclaration(String cacheName) {
        Object result = this.invokeOnce(this.beanName, "generateActiveConfigDeclaration", new Object[]{cacheName}, new String[]{"java.lang.String"});
        return result != null ? result.toString() : "";
    }

    public Map<CacheModelInstance, CacheTierSize> getSizes() {
        TreeMap<CacheModelInstance, CacheTierSize> result = new TreeMap<CacheModelInstance, CacheTierSize>();
        Map<ObjectName, Map<String, Object>> attrs = this.getAttributes(new HashSet<String>(Arrays.asList("LocalHeapSize", "LocalHeapSizeInBytes", "LocalOffHeapSize", "LocalOffHeapSizeInBytes", "LocalDiskSize", "LocalDiskSizeInBytes", "InMemoryMissCount", "OffHeapMissCount", "OnDiskMissCount", "CacheInMemoryMissRate", "CacheOffHeapMissRate", "CacheOnDiskMissRate")));
        for (Map.Entry<ObjectName, Map<String, Object>> entry : attrs.entrySet()) {
            Map<String, Object> value = entry.getValue();
            CacheModelInstance cmi = (CacheModelInstance)this.cacheModelInstanceMap.get(entry.getKey());
            if (cmi == null) continue;
            result.put(cmi, this.getTierSize(cmi, this.getSettingsCacheModel(cmi), value));
        }
        return result;
    }

    public CacheTierSize getTierSize(CacheModelInstance cmi, SettingsCacheModel scm, Map<String, Object> sizes) {
        return new CacheTierSize(this.getMaxEntriesLocalHeap(), CacheManagerInstance.getLong(sizes, "LocalHeapSize"), CacheManagerInstance.getLong(sizes, "LocalOffHeapSize"), scm.getMaxEntriesLocalDisk(), CacheManagerInstance.getLong(sizes, "LocalDiskSize"), cmi.getMaxBytesLocalHeap(), CacheManagerInstance.getLong(sizes, "LocalHeapSizeInBytes"), cmi.getMaxBytesLocalOffHeap(), CacheManagerInstance.getLong(sizes, "LocalOffHeapSizeInBytes"), scm.getMaxBytesLocalDisk(), CacheManagerInstance.getLong(sizes, "LocalDiskSizeInBytes"), CacheManagerInstance.getLong(sizes, "CacheInMemoryMissRate"), CacheManagerInstance.getLong(sizes, "CacheOffHeapMissRate"), CacheManagerInstance.getLong(sizes, "CacheOnDiskMissRate"));
    }

    private static long getLong(Map<String, Object> sizes, String attr) {
        Long result = (Long)sizes.get(attr);
        return result != null ? result : 0L;
    }

    public SettingsCacheModel getSettingsCacheModel(String cacheName) throws MalformedObjectNameException, NullPointerException {
        return this.getSettingsCacheModel((CacheModelInstance)this.cacheModelInstanceMap.get(new ObjectName(cacheName)));
    }

    public SettingsCacheModel getSettingsCacheModel(CacheModelInstance cmi) {
        if (cmi != null) {
            if (cmi.isTerracottaClustered()) {
                return this.getCacheManagerModel().getClusteredCacheModel(cmi.getCacheName());
            }
            return this.getCacheManagerModel().getStandaloneCacheModel(cmi);
        }
        return null;
    }

    public int compareTo(Object o) {
        CacheManagerInstance other = (CacheManagerInstance)o;
        return this.getCacheManagerName().compareTo(other.getCacheManagerName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beanName == null ? 0 : this.beanName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheManagerInstance other = (CacheManagerInstance)obj;
        return !(this.beanName == null ? other.beanName != null : !this.beanName.equals(other.beanName));
    }

    public String toString() {
        return this.getCacheManagerName() + " on node " + this.getClientName();
    }

    @Override
    public void tearDown() {
        this.removeListeners();
        for (CacheModelInstance cacheModelInstance : this.cacheModelInstanceMap.values()) {
            cacheModelInstance.tearDown();
        }
        this.cacheModelInstanceMap.clear();
        super.tearDown();
    }
}

