/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation.model;

import com.tc.admin.AbstractClusterListener;
import com.tc.admin.model.ClientConnectionListener;
import com.tc.admin.model.IClient;
import com.tc.admin.model.IClusterModel;
import com.tc.admin.model.IServer;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMBeanModel
implements NotificationListener,
ClientConnectionListener {
    protected final IClusterModel clusterModel;
    protected final ClusterListener clusterListener;
    protected final EventListenerList listenerList;
    protected final Set<ObjectName> onSet;
    private static final Random RANDOM = new Random();
    private static final Object[] NULL_PARAMS = new Object[0];
    private static final String[] NULL_SIGS = new String[0];
    private static final ObjectName MBEAN_SERVER_DELEGATE;

    protected BaseMBeanModel(IClusterModel clusterModel) {
        this.clusterModel = clusterModel;
        this.clusterListener = new ClusterListener(clusterModel);
        this.listenerList = new EventListenerList();
        this.onSet = new HashSet<ObjectName>();
    }

    public void startup() {
        this.clusterModel.addPropertyChangeListener((PropertyChangeListener)((Object)this.clusterListener));
        if (this.clusterModel.isReady()) {
            this.init();
        } else {
            this.suspend();
        }
    }

    public void clientConnected(IClient client) {
    }

    public void clientDisconnected(IClient client) {
    }

    @Override
    public abstract void handleNotification(Notification var1, Object var2);

    public abstract void init();

    public abstract void suspend();

    public void reset() {
    }

    public IClusterModel getClusterModel() {
        return this.clusterModel;
    }

    public IServer getActiveCoordinator() {
        return this.clusterModel.getActiveCoordinator();
    }

    protected void addListeners() {
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            try {
                activeCoord.addNotificationListener(MBEAN_SERVER_DELEGATE, (NotificationListener)this);
                activeCoord.addClientConnectionListener((ClientConnectionListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void removeListeners() {
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            try {
                activeCoord.removeNotificationListener(MBEAN_SERVER_DELEGATE, (NotificationListener)this);
                activeCoord.removeClientConnectionListener((ClientConnectionListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ObjectName getRandomBean() {
        return this.getRandomBean(this.onSet);
    }

    public int beanCount() {
        return this.onSet.size();
    }

    private Set<ObjectName> newSet(Collection<ObjectName> collection) {
        return new HashSet<ObjectName>(collection);
    }

    public ObjectName getRandomBean(Set<ObjectName> targets) {
        ObjectName[] beanArray;
        if (targets != null && (beanArray = targets.toArray(new ObjectName[0])).length > 0) {
            return beanArray[RANDOM.nextInt(beanArray.length)];
        }
        return null;
    }

    public Object invokeOnce(String operation) {
        return this.invokeOnce(operation, NULL_PARAMS, NULL_SIGS);
    }

    public Object invokeOnce(ObjectName target, String operation) {
        return this.invokeOnce(target, operation, NULL_PARAMS, NULL_SIGS);
    }

    public Object invokeOnce(String operation, Object[] params, String[] sigs) {
        return this.invokeOnce(this.getRandomBean(), operation, params, sigs);
    }

    public Object invokeOnce(ObjectName target, String operation, Object[] params, String[] sigs) {
        Map response;
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null && target != null && (response = activeCoord.invoke(Collections.singleton(target), operation, Integer.MAX_VALUE, TimeUnit.SECONDS, params, sigs)) != null) {
            return response.get(target);
        }
        return null;
    }

    public Map<ObjectName, Object> invokeAll(String operation) {
        return this.invokeAll(this.onSet, operation);
    }

    public Map<ObjectName, Object> invokeAll(Set<ObjectName> targets, String operation) {
        return this.invokeAll(targets, operation, NULL_PARAMS, NULL_SIGS);
    }

    public Map<ObjectName, Object> invokeAll(String operation, Object[] params, String[] sigs) {
        return this.invokeAll(this.onSet, operation, params, sigs);
    }

    public Map<ObjectName, Object> invokeAll(Set<ObjectName> targets, String operation, Object[] params, String[] sigs) {
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            Map result = activeCoord.invoke(this.newSet(targets), operation, params, sigs);
            return result;
        }
        return null;
    }

    public Map<ObjectName, Map<String, Object>> getAttributes(Set<String> attrSet) {
        return this.getAttributes(this.onSet, attrSet);
    }

    public Map<String, Object> getAttributes(ObjectName target, Set<String> attrSet) {
        Map<ObjectName, Map<String, Object>> mapping = this.getAttributes(Collections.singleton(target), attrSet);
        return mapping != null ? mapping.get(target) : null;
    }

    public Map<ObjectName, Map<String, Object>> getAttributes(Set<ObjectName> targets, Set<String> attrSet) {
        Map<ObjectName, Map<String, Object>> result = new HashMap<ObjectName, Map<String, Object>>();
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            HashMap<ObjectName, Set<String>> request = new HashMap<ObjectName, Set<String>>();
            for (ObjectName objectName : targets) {
                request.put(objectName, attrSet);
            }
            result = activeCoord.getAttributeMap(request);
        }
        return result;
    }

    public Map<ObjectName, Object> getAttribute(String attr) {
        return this.getAttribute(this.onSet, attr);
    }

    public Object getAttribute(ObjectName target, String attr) {
        Map<ObjectName, Object> mapping = this.getAttribute(Collections.singleton(target), attr);
        return mapping != null ? mapping.get(target) : null;
    }

    public Map<ObjectName, Object> getAttribute(Set<ObjectName> targets, String attr) {
        HashMap<ObjectName, Object> result = new HashMap<ObjectName, Object>();
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            HashMap<ObjectName, Set<String>> request = new HashMap<ObjectName, Set<String>>();
            for (ObjectName objectName : targets) {
                request.put(objectName, Collections.singleton(attr));
            }
            Map response = activeCoord.getAttributeMap(request);
            if (response != null) {
                for (Map.Entry entry : response.entrySet()) {
                    Map mapping = (Map)entry.getValue();
                    if (mapping == null) continue;
                    result.put((ObjectName)entry.getKey(), mapping.get(attr));
                }
            }
        }
        return result;
    }

    public void setAttribute(String attr, Object value) throws Exception {
        this.setAttribute(this.onSet, attr, value);
    }

    public void safeSetAttribute(String attr, Object value) {
        this.safeSetAttribute(this.onSet, attr, value);
    }

    public void safeSetAttribute(Set<ObjectName> targets, String attr, Object value) {
        try {
            this.setAttribute(targets, attr, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAttribute(ObjectName on, String attr, Object value) throws Exception {
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            activeCoord.setAttribute(on, attr, value);
        }
    }

    public void setAttribute(Set<ObjectName> targets, String attr, Object value) throws Exception {
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            activeCoord.setAttribute(this.newSet(targets), attr, value);
        }
    }

    public void safeSetAttribute(ObjectName on, String attr, Object value) {
        try {
            this.setAttribute(on, attr, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean addNotificationListener(ObjectName on, NotificationListener listener) {
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            try {
                activeCoord.addNotificationListener(on, listener);
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean removeNotificationListener(ObjectName on, NotificationListener listener) {
        IServer activeCoord = this.clusterModel.getActiveCoordinator();
        if (activeCoord != null) {
            try {
                activeCoord.removeNotificationListener(on, listener);
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    public void tearDown() {
        this.clusterModel.removePropertyChangeListener((PropertyChangeListener)((Object)this.clusterListener));
        this.clusterListener.tearDown();
        this.onSet.clear();
    }

    static {
        try {
            MBEAN_SERVER_DELEGATE = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class ClusterListener
    extends AbstractClusterListener {
        private ClusterListener(IClusterModel clusterModel) {
            super(clusterModel, false);
        }

        protected void handleReady() {
            if (this.clusterModel.isReady()) {
                BaseMBeanModel.this.init();
            } else {
                BaseMBeanModel.this.suspend();
            }
        }

        protected void handleActiveCoordinator(IServer oldActive, IServer newActive) {
            if (newActive != null) {
                BaseMBeanModel.this.reset();
            }
        }
    }
}

