/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.ButtonSet;
import com.tc.admin.common.WindowHelper;
import com.tc.admin.common.XAbstractAction;
import com.tc.admin.common.XCheckBox;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XScrollPane;
import com.tc.admin.common.XTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.terracotta.modules.ehcache.presentation.BaseClusterModelPanel;
import org.terracotta.modules.ehcache.presentation.CacheManagerTopologyPanel;
import org.terracotta.modules.ehcache.presentation.CacheTopologyPanel;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.TopologyPanelPage;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyPanel
extends BaseClusterModelPanel {
    private final CacheManagerModel cacheManagerModel;
    private Mode mode;
    private TopologyPanelPage currentPage;
    private ButtonSet pageSelector;
    private XContainer pageHolder;
    EnableCachesAction disableCachesAction;
    EnableCachesAction enableCachesAction;
    StatisticsControlAction enableStatisticsAction;
    StatisticsControlAction disableStatisticsAction;
    ClearCachesAction clearCachesAction;
    BulkLoadingControlAction enableBulkLoadingAction;
    BulkLoadingControlAction disableBulkLoadingAction;
    ShowConfigAction showConfigAction;

    public TopologyPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        super(appContext, cacheManagerModel.getClusterModel());
        this.cacheManagerModel = cacheManagerModel;
        this.enableCachesAction = new EnableCachesAction(true);
        this.disableCachesAction = new EnableCachesAction(false);
        this.enableStatisticsAction = new StatisticsControlAction(true);
        this.disableStatisticsAction = new StatisticsControlAction(false);
        this.enableBulkLoadingAction = new BulkLoadingControlAction(true);
        this.disableBulkLoadingAction = new BulkLoadingControlAction(false);
        this.clearCachesAction = new ClearCachesAction();
        this.showConfigAction = new ShowConfigAction();
    }

    public CacheManagerModel getCacheManagerModel() {
        return this.cacheManagerModel;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    protected void init() {
    }

    @Override
    protected XContainer createMainPanel() {
        XContainer topPanel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(1, 5, 1, 0);
        topPanel.add((Component)new XLabel("View by: "), (Object)gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(1, 0, 1, 0);
        this.pageSelector = new ButtonSet((LayoutManager)new FlowLayout(1, 0, 0));
        topPanel.add((Component)this.pageSelector, (Object)gbc);
        JRadioButton rb = new JRadioButton("CacheManager Instances");
        this.pageSelector.add((Component)rb);
        rb.setName(Mode.CACHE_MANAGER.toString());
        rb = new JRadioButton("Caches");
        this.pageSelector.add((Component)rb);
        rb.setName(Mode.CACHE.toString());
        this.pageSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = ((ButtonSet)e.getSource()).getSelected();
                if (!name.equals(TopologyPanel.this.currentPage.getName())) {
                    TopologyPanelPage oldPage = TopologyPanel.this.currentPage;
                    if (Mode.CACHE.toString().equals(name)) {
                        CacheManagerTopologyPanel cmtp = (CacheManagerTopologyPanel)TopologyPanel.this.currentPage;
                        TopologyPanel.this.currentPage = TopologyPanel.this.createCacheView(cmtp.getSelectedCacheModels());
                    } else {
                        CacheTopologyPanel ctp = (CacheTopologyPanel)TopologyPanel.this.currentPage;
                        TopologyPanel.this.currentPage = TopologyPanel.this.createCacheManagerView(ctp.getSelectedCacheManagerInstances());
                    }
                    TopologyPanel.this.pageHolder.removeAll();
                    oldPage.tearDown();
                    TopologyPanel.this.currentPage.setup();
                    TopologyPanel.this.pageHolder.add((Component)((Object)TopologyPanel.this.currentPage));
                    TopologyPanel.this.pageHolder.revalidate();
                    TopologyPanel.this.pageHolder.repaint();
                }
            }
        });
        this.pageSelector.setSelectedIndex(0);
        this.pageHolder = new XContainer((LayoutManager)new BorderLayout());
        this.currentPage = this.createCacheManagerView();
        this.pageHolder.add((Component)((Object)this.currentPage));
        this.currentPage.setup();
        XContainer result = new XContainer((LayoutManager)new BorderLayout());
        result.add((Component)topPanel, (Object)"North");
        result.add((Component)this.pageHolder, (Object)"Center");
        return result;
    }

    private CacheManagerTopologyPanel createCacheManagerView() {
        this.setMode(Mode.CACHE_MANAGER);
        CacheManagerTopologyPanel result = new CacheManagerTopologyPanel(this);
        return result;
    }

    private CacheManagerTopologyPanel createCacheManagerView(Set<CacheManagerInstance> selectedCacheManagerInstances) {
        this.setMode(Mode.CACHE_MANAGER);
        CacheManagerTopologyPanel result = new CacheManagerTopologyPanel(this, selectedCacheManagerInstances);
        return result;
    }

    private CacheTopologyPanel createCacheView(Set<CacheModel> selectedCacheModels) {
        this.setMode(Mode.CACHE);
        CacheTopologyPanel result = new CacheTopologyPanel(this, selectedCacheModels);
        return result;
    }

    JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu();
        popup.add((Action)((Object)this.enableCachesAction));
        popup.add((Action)((Object)this.disableCachesAction));
        popup.addSeparator();
        popup.add((Action)((Object)this.enableBulkLoadingAction));
        popup.add((Action)((Object)this.disableBulkLoadingAction));
        popup.addSeparator();
        popup.add(this.enableStatisticsAction);
        popup.add(this.disableStatisticsAction);
        popup.addSeparator();
        popup.add((Action)((Object)this.clearCachesAction));
        popup.addSeparator();
        popup.add((Action)((Object)this.showConfigAction));
        return popup;
    }

    private void queryClearSelectedCaches(JPopupMenu popupMenu) {
        XLabel msg = new XLabel(bundle.getString("clear.selected.caches.confirm"));
        msg.setFont((Font)bundle.getObject("message.label.font"));
        msg.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        int answer = JOptionPane.showConfirmDialog((Component)((Object)this), msg, frame.getTitle(), 2);
        if (answer == 0) {
            this.appContext.submit(this.currentPage.createClearCachesWorker(popupMenu));
        }
    }

    private void queryEnableSelectedCaches(JPopupMenu popupMenu) {
        XLabel msg = new XLabel(bundle.getString("enable.selected.caches.confirm"));
        msg.setFont((Font)bundle.getObject("message.label.font"));
        msg.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        int answer = JOptionPane.showConfirmDialog((Component)((Object)this), msg, frame.getTitle(), 2);
        if (answer == 0) {
            this.appContext.submit(this.currentPage.createEnableCachesWorker(popupMenu, true, false));
        }
    }

    private void queryDisableSelectedCaches(JPopupMenu popupMenu) {
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        XLabel label = new XLabel(bundle.getString("disable.selected.caches.confirm"));
        label.setFont((Font)bundle.getObject("message.label.font"));
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        XCheckBox cb = new XCheckBox("Clear Contents");
        cb.setSelected(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 17;
        panel.add((Component)label, (Object)gbc);
        ++gbc.gridy;
        panel.add((Component)cb, (Object)gbc);
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        int answer = JOptionPane.showConfirmDialog((Component)((Object)this), panel, frame.getTitle(), 2);
        if (answer == 0) {
            this.appContext.submit(this.currentPage.createEnableCachesWorker(popupMenu, false, cb.isSelected()));
        }
    }

    private void queryEnableSelectedStats(JPopupMenu popupMenu) {
        XLabel msg = new XLabel(MessageFormat.format(bundle.getString("enable.selected.statistics.confirm"), this.cacheManagerModel.getName()));
        msg.setFont((Font)bundle.getObject("message.label.font"));
        msg.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        int answer = JOptionPane.showConfirmDialog((Component)((Object)this), msg, frame.getTitle(), 2);
        if (answer == 0) {
            this.appContext.submit(this.currentPage.createStatisticsControlWorker(popupMenu, true));
        }
    }

    private void queryDisableSelectedStats(JPopupMenu popupMenu) {
        XLabel msg = new XLabel(MessageFormat.format(bundle.getString("disable.selected.statistics.confirm"), this.cacheManagerModel.getName()));
        msg.setFont((Font)bundle.getObject("message.label.font"));
        msg.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        int answer = JOptionPane.showConfirmDialog((Component)((Object)this), msg, frame.getTitle(), 2);
        if (answer == 0) {
            this.appContext.submit(this.currentPage.createStatisticsControlWorker(popupMenu, false));
        }
    }

    private void queryEnableBulkLoad(final JPopupMenu popup) {
        XLabel msg = new XLabel(MessageFormat.format(bundle.getString("enable.bulkload.confirm"), this.cacheManagerModel.getName()));
        msg.setFont((Font)bundle.getObject("message.label.font"));
        msg.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        int answer = JOptionPane.showConfirmDialog((Component)((Object)this), msg, frame.getTitle(), 2);
        if (answer == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TopologyPanel.this.appContext.submit(TopologyPanel.this.currentPage.createBulkLoadControlWorker(popup, true));
                }
            });
        }
    }

    private void queryDisableBulkLoad(final JPopupMenu popup) {
        XLabel msg = new XLabel(MessageFormat.format(bundle.getString("disable.bulkload.confirm"), this.cacheManagerModel.getName()));
        msg.setFont((Font)bundle.getObject("message.label.font"));
        msg.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
        int answer = JOptionPane.showConfirmDialog((Component)((Object)this), msg, frame.getTitle(), 2);
        if (answer == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TopologyPanel.this.appContext.submit(TopologyPanel.this.currentPage.createBulkLoadControlWorker(popup, false));
                }
            });
        }
    }

    class ShowConfigAction
    extends XAbstractAction {
        private ShowConfigAction() {
            super("Show Configuration");
        }

        public void actionPerformed(ActionEvent ae) {
            String text;
            JMenuItem mitem = (JMenuItem)ae.getSource();
            JPopupMenu popup = (JPopupMenu)mitem.getParent();
            Callable<String> configGenerator = TopologyPanel.this.currentPage.createConfigurationGenerator(popup);
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)TopologyPanel.this));
            JDialog dialog = new JDialog(frame, frame.getTitle(), true);
            XTextArea textArea = new XTextArea();
            textArea.setEditable(false);
            try {
                text = configGenerator.call();
            }
            catch (Exception e) {
                text = e.toString();
            }
            textArea.setText(text);
            dialog.getContentPane().add((Component)new XScrollPane((Component)textArea));
            dialog.setSize(500, 600);
            WindowHelper.center((Window)dialog);
            dialog.setVisible(true);
        }
    }

    class BulkLoadingControlAction
    extends XAbstractAction {
        private final boolean enable;

        private BulkLoadingControlAction(boolean enable) {
            this.enable = enable;
            this.setName(BaseClusterModelPanel.bundle.getString(enable ? "enable.bulkload" : "disable.bulkload"));
            this.setSmallIcon(enable ? EhcachePresentationUtils.BULK_LOAD_DISABLED_ICON : EhcachePresentationUtils.BULK_LOAD_ENABLED_ICON);
            this.putValue("ShortDescription", BaseClusterModelPanel.bundle.getString(enable ? "enable.bulkload.tip" : "disable.bulkload.tip"));
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mitem = (JMenuItem)e.getSource();
            JPopupMenu popup = (JPopupMenu)mitem.getParent();
            if (this.enable) {
                TopologyPanel.this.queryEnableBulkLoad(popup);
            } else {
                TopologyPanel.this.queryDisableBulkLoad(popup);
            }
        }
    }

    class StatisticsControlAction
    extends AbstractAction {
        private final boolean enable;

        StatisticsControlAction(boolean enable) {
            this.enable = enable;
            this.putValue("Name", BaseClusterModelPanel.bundle.getString(enable ? "enable.statistics" : "disable.statistics"));
            this.putValue("ShortDescription", BaseClusterModelPanel.bundle.getString(enable ? "enable.statistics.tip" : "disable.statistics.tip"));
            this.putValue("SmallIcon", enable ? EhcachePresentationUtils.ENABLE_STATS_ICON : EhcachePresentationUtils.DISABLE_STATS_ICON);
        }

        public void actionPerformed(ActionEvent ae) {
            JMenuItem mitem = (JMenuItem)ae.getSource();
            JPopupMenu popup = (JPopupMenu)mitem.getParent();
            if (this.enable) {
                TopologyPanel.this.queryEnableSelectedStats(popup);
            } else {
                TopologyPanel.this.queryDisableSelectedStats(popup);
            }
        }
    }

    class EnableCachesAction
    extends XAbstractAction {
        private final boolean enable;

        private EnableCachesAction(boolean enable) {
            this.enable = enable;
            this.putValue("Name", BaseClusterModelPanel.bundle.getString(enable ? "enable.caches" : "disable.caches"));
            this.putValue("SmallIcon", enable ? EhcachePresentationUtils.ENABLE_CACHE_ICON : EhcachePresentationUtils.DISABLE_CACHE_ICON);
            this.putValue("ShortDescription", BaseClusterModelPanel.bundle.getString(enable ? "enable.caches.tip" : "disable.caches.tip"));
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mitem = (JMenuItem)e.getSource();
            JPopupMenu popup = (JPopupMenu)mitem.getParent();
            if (this.enable) {
                TopologyPanel.this.queryEnableSelectedCaches(popup);
            } else {
                TopologyPanel.this.queryDisableSelectedCaches(popup);
            }
        }
    }

    class ClearCachesAction
    extends XAbstractAction {
        private ClearCachesAction() {
            super(BaseClusterModelPanel.bundle.getString("clear.caches"), EhcachePresentationUtils.CLEAR_CACHE_ICON);
            this.putValue("ShortDescription", BaseClusterModelPanel.bundle.getString("clear.caches.tip"));
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mitem = (JMenuItem)e.getSource();
            JPopupMenu popup = (JPopupMenu)mitem.getParent();
            TopologyPanel.this.queryClearSelectedCaches(popup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        CACHE_MANAGER,
        CACHE;

    }
}

