/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.StatusView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TierChooserRenderer
extends StatusView
implements ListCellRenderer,
Serializable {
    private final Map<String, Color> indicatorMap;
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);

    public TierChooserRenderer(Map<String, Color> indicatorMap) {
        this.indicatorMap = indicatorMap;
        this.setOpaque(true);
        this.setBorder(TierChooserRenderer.getNoFocusBorder());
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    public Dimension getPreferredSize() {
        Dimension size;
        if (this.getLabel().getText() == null || this.getLabel().getText().equals("")) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setText(value == null ? "" : value.toString());
        if (value != null) {
            this.setIndicator(this.indicatorMap.get(value.toString()));
        }
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = TierChooserRenderer.getNoFocusBorder();
        }
        this.setBorder(border);
        return this;
    }

    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UIResource
    extends TierChooserRenderer
    implements javax.swing.plaf.UIResource {
        public UIResource(Map<String, Color> indicatorMap) {
            super(indicatorMap);
        }
    }
}

