/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.XRootNode;
import com.tc.admin.common.XTreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.terracotta.modules.ehcache.presentation.AbstractViewPage;
import org.terracotta.modules.ehcache.presentation.ManageChannel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeViewPage
extends AbstractViewPage {
    private final Map<CacheManagerInstance, AbstractViewPage.CacheManagerInstanceControl> cacheManagerInstanceMap = new HashMap<CacheManagerInstance, AbstractViewPage.CacheManagerInstanceControl>();
    private final Map<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> cacheModelInstanceMap = new HashMap<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl>();
    private final CacheManagerInstanceControlListener cacheManagerInstanceControlListener = new CacheManagerInstanceControlListener();
    private final CacheModelInstanceControlListener cacheModelInstanceControlListener = new CacheModelInstanceControlListener();

    public NodeViewPage(ManageChannel channel, CacheManagerModel cacheManagerModel) {
        super(channel, cacheManagerModel);
        this.initialize();
        cacheManagerModel.addCacheManagerModelListener(this);
        cacheManagerModel.getEhcacheModel().addEhcacheModelListener(this);
    }

    @Override
    public Map<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> getSelection() {
        return new HashMap<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl>(this.cacheModelInstanceMap);
    }

    @Override
    public void setSelection(Map<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> selection) {
        if (selection != null) {
            for (Map.Entry<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> entry : selection.entrySet()) {
                AbstractViewPage.CacheModelInstanceControl cmic = this.cacheModelInstanceMap.get(entry.getKey());
                if (cmic == null) continue;
                cmic.setSelected(entry.getValue().isSelected());
            }
        }
    }

    @Override
    public void initialize() {
        XRootNode rootNode = (XRootNode)this.treeModel.getRoot();
        rootNode.tearDownChildren();
        this.treeModel.nodeStructureChanged((TreeNode)rootNode);
        this.cacheManagerInstanceMap.clear();
        this.cacheModelInstanceMap.clear();
        int x = 0;
        Iterator<CacheManagerInstance> cacheManagerInstanceIter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (cacheManagerInstanceIter.hasNext()) {
            CacheManagerInstance cacheManagerInstance = cacheManagerInstanceIter.next();
            AbstractViewPage.CacheManagerInstanceControl cmic = new AbstractViewPage.CacheManagerInstanceControl(cacheManagerInstance){

                public void setSelectedAndChildren(boolean selected) {
                    this.setSelected(selected);
                    Iterator<CacheModelInstance> iter = this.cacheManagerInstance.cacheModelInstanceIter();
                    while (iter.hasNext()) {
                        ((AbstractViewPage.CacheModelInstanceControl)NodeViewPage.this.cacheModelInstanceMap.get(iter.next())).setSelected(selected);
                    }
                }
            };
            XTreeNode parentNode = new XTreeNode((Object)cmic);
            this.treeModel.insertNodeInto((MutableTreeNode)parentNode, (MutableTreeNode)rootNode, x++);
            cmic.addActionListener(this.cacheManagerInstanceControlListener);
            this.cacheManagerInstanceMap.put(cacheManagerInstance, cmic);
            cacheManagerInstance.addCacheManagerInstanceListener(this);
            int y = 0;
            Iterator<CacheModelInstance> cacheModelInstanceIter = cacheManagerInstance.cacheModelInstanceIter();
            while (cacheModelInstanceIter.hasNext()) {
                CacheModelInstance cacheModelInstance = cacheModelInstanceIter.next();
                AbstractViewPage.CacheModelInstanceControl cacheModelInstanceControl = new AbstractViewPage.CacheModelInstanceControl(this, cacheModelInstance);
                XTreeNode xtn = new XTreeNode((Object)cacheModelInstanceControl);
                xtn.setIcon(cacheModelInstanceControl.getIcon());
                this.treeModel.insertNodeInto((MutableTreeNode)xtn, (MutableTreeNode)parentNode, y++);
                cacheModelInstanceControl.addActionListener(this.cacheModelInstanceControlListener);
                this.cacheModelInstanceMap.put(cacheModelInstance, cacheModelInstanceControl);
            }
        }
        this.tree.expandAll();
        this.handleAllSelector();
    }

    @Override
    public void selectAll(boolean select) {
        for (AbstractViewPage.CacheManagerInstanceControl cacheManagerInstanceControl : this.cacheManagerInstanceMap.values()) {
            cacheManagerInstanceControl.setSelectedAndChildren(select);
        }
        this.updateAllNodes();
        this.handleAllSelector();
    }

    @Override
    public void apply(Boolean applyToNewcomers) {
        boolean cmValue = this.channel.getValue(this.cacheManagerModel);
        if (this.isAllSelected() && !cmValue || this.isAllDeselected() && cmValue) {
            this.channel.setValue(this.cacheManagerModel, !cmValue, applyToNewcomers != null ? applyToNewcomers : false);
        } else {
            HashMap<CacheManagerInstance, Boolean> cacheManagerInstances = new HashMap<CacheManagerInstance, Boolean>();
            HashMap<CacheModelInstance, Boolean> cacheModelInstances = new HashMap<CacheModelInstance, Boolean>();
            for (CacheManagerInstance cacheManagerInstance : this.cacheManagerInstanceMap.keySet()) {
                AbstractViewPage.CacheManagerInstanceControl cacheManagerInstanceControl = this.cacheManagerInstanceMap.get(cacheManagerInstance);
                if (cacheManagerInstanceControl.isSelected() && !this.channel.getValue(cacheManagerInstance)) {
                    cacheManagerInstances.put(cacheManagerInstance, Boolean.TRUE);
                } else {
                    for (CacheModelInstance cacheModelInstance : this.cacheModelInstanceMap.keySet()) {
                        AbstractViewPage.CacheModelInstanceControl cacheModelInstanceControl = this.cacheModelInstanceMap.get(cacheModelInstance);
                        if (cacheModelInstanceControl.isSelected() == this.channel.getValue(cacheModelInstance)) continue;
                        cacheModelInstances.put(cacheModelInstance, cacheModelInstanceControl.isSelected());
                    }
                }
                this.channel.setNodeViewValues(cacheManagerInstances, cacheModelInstances);
            }
        }
    }

    @Override
    public void handleAllSelector() {
        boolean allSelected = true;
        for (CacheManagerInstance cacheManagerInstance : this.cacheManagerInstanceMap.keySet()) {
            AbstractViewPage.CacheManagerInstanceControl cacheManagerInstanceControl = this.cacheManagerInstanceMap.get(cacheManagerInstance);
            if (cacheManagerInstanceControl.isSelected()) continue;
            allSelected = false;
            break;
        }
        if (this.isAllSelected = allSelected) {
            this.isAllDeselected = false;
            this.isSomeSelected = true;
            this.firePropertyChange("ALL_SELECTED", allSelected, !allSelected);
        } else {
            boolean allDeselected = true;
            for (AbstractViewPage.CacheModelInstanceControl cacheModelInstanceControl : this.cacheModelInstanceMap.values()) {
                if (!cacheModelInstanceControl.isSelected()) continue;
                allDeselected = false;
                break;
            }
            if (this.isAllDeselected = allDeselected) {
                this.isAllSelected = false;
                this.isSomeSelected = false;
                this.firePropertyChange("ALL_DESELECTED", allDeselected, !allDeselected);
            } else {
                this.isSomeSelected = true;
                this.isAllDeselected = false;
                this.isAllSelected = false;
                this.firePropertyChange("SOME_SELECTED", true, false);
            }
        }
    }

    @Override
    public void tearDown() {
        this.cacheManagerInstanceMap.clear();
        this.cacheModelInstanceMap.clear();
        super.tearDown();
    }

    private class CacheModelInstanceControlListener
    implements ActionListener {
        private CacheModelInstanceControlListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractViewPage.CacheModelInstanceControl cacheModelInstanceControl = (AbstractViewPage.CacheModelInstanceControl)e.getSource();
            boolean selected = cacheModelInstanceControl.isSelected();
            CacheModelInstance cacheModelInstance = cacheModelInstanceControl.getCacheModelInstance();
            CacheManagerInstance cacheManagerInstance = cacheModelInstance.getCacheManagerInstance();
            AbstractViewPage.CacheManagerInstanceControl parentControl = (AbstractViewPage.CacheManagerInstanceControl)NodeViewPage.this.cacheManagerInstanceMap.get(cacheManagerInstance);
            if (!selected && parentControl.isSelected()) {
                parentControl.setSelectedQuietly(false);
            } else if (selected && !parentControl.isSelected()) {
                boolean allEnabled = true;
                Iterator<CacheModelInstance> iter = cacheManagerInstance.cacheModelInstanceIter();
                while (iter.hasNext()) {
                    if (((AbstractViewPage.CacheModelInstanceControl)NodeViewPage.this.cacheModelInstanceMap.get(iter.next())).isSelected()) continue;
                    allEnabled = false;
                    break;
                }
                parentControl.setSelectedQuietly(allEnabled);
            }
            NodeViewPage.this.updateAllNodes();
            NodeViewPage.this.handleAllSelector();
        }
    }

    private class CacheManagerInstanceControlListener
    implements ActionListener {
        private CacheManagerInstanceControlListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractViewPage.CacheManagerInstanceControl cmic = (AbstractViewPage.CacheManagerInstanceControl)e.getSource();
            CacheManagerInstance cacheManagerInstance = cmic.getCacheManagerInstance();
            boolean selected = cmic.isSelected();
            Iterator<CacheModelInstance> iter = cacheManagerInstance.cacheModelInstanceIter();
            while (iter.hasNext()) {
                AbstractViewPage.CacheModelInstanceControl cacheModelInstanceControl = (AbstractViewPage.CacheModelInstanceControl)NodeViewPage.this.cacheModelInstanceMap.get(iter.next());
                if (cacheModelInstanceControl == null || selected == cacheModelInstanceControl.isSelected()) continue;
                cacheModelInstanceControl.setSelectedQuietly(selected);
            }
            NodeViewPage.this.updateAllNodes();
            NodeViewPage.this.handleAllSelector();
        }
    }
}

