/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import java.awt.Frame;
import java.util.Map;
import org.terracotta.modules.ehcache.presentation.ManageMessage;
import org.terracotta.modules.ehcache.presentation.TopologyPanel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageStatisticsMessage
extends ManageMessage {
    public ManageStatisticsMessage(Frame frame, ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        this(frame, appContext, cacheManagerModel, TopologyPanel.Mode.CACHE_MANAGER);
    }

    public ManageStatisticsMessage(Frame frame, ApplicationContext appContext, CacheManagerModel cacheManagerModel, TopologyPanel.Mode mode) {
        super(frame, appContext, cacheManagerModel, "Manage Cache Statistics", "The selected caches will begin gathering statistics.", mode);
    }

    @Override
    public boolean getValue(CacheModelInstance cacheModelInstance) {
        return cacheModelInstance.isStatisticsEnabled();
    }

    @Override
    public boolean getValue(CacheManagerInstance cacheManagerInstance) {
        int instanceCount = cacheManagerInstance.getInstanceCount();
        return instanceCount > 0 && cacheManagerInstance.getStatisticsEnabledCount() == instanceCount;
    }

    @Override
    public boolean getValue(CacheManagerModel theCacheManagerModel) {
        return theCacheManagerModel.getStatisticsEnabledCount() == theCacheManagerModel.getCacheModelCount();
    }

    @Override
    public void setValue(CacheManagerModel cacheManagerModel, boolean value, boolean applyToNewcomers) {
        String prefix = value ? "Enabling" : "Disabling";
        String msg = prefix + " all cache statistics for '" + cacheManagerModel.getName() + "'...";
        cacheManagerModel.setStatisticsEnabledPersistently(value, applyToNewcomers);
        this.setValueImpl(cacheManagerModel, "StatisticsEnabled", value, msg);
    }

    @Override
    public boolean getValue(CacheModel cacheModel) {
        CacheManagerModel cacheManagerModel = cacheModel.getCacheManagerModel();
        return cacheManagerModel.getStatisticsEnabledCount(cacheModel) == cacheManagerModel.getCacheModelInstanceCount(cacheModel);
    }

    @Override
    public void setNodeViewValues(Map<CacheManagerInstance, Boolean> cacheManagerInstances, Map<CacheModelInstance, Boolean> cacheModelInstances) {
        String msg = "Setting cache statistics...";
        this.setNodeViewValuesImpl(cacheManagerInstances, cacheModelInstances, "StatisticsEnabled", "Setting cache statistics...");
    }

    @Override
    public void setCacheViewValues(Map<CacheModel, Boolean> cacheModels, Map<CacheModelInstance, Boolean> cacheModelInstances) {
        String msg = "Setting cache statistics...";
        this.setCacheViewValuesImpl(cacheModels, cacheModelInstances, "StatisticsEnabled", "Setting cache statistics...");
    }
}

