/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.ButtonSet;
import com.tc.admin.common.ExceptionHelper;
import com.tc.admin.common.WindowHelper;
import com.tc.admin.common.XCheckBox;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.util.concurrent.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ObjectName;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.terracotta.modules.ehcache.presentation.AbstractViewPage;
import org.terracotta.modules.ehcache.presentation.CacheViewPage;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.EhcacheResourceBundle;
import org.terracotta.modules.ehcache.presentation.ManageChannel;
import org.terracotta.modules.ehcache.presentation.NodeViewPage;
import org.terracotta.modules.ehcache.presentation.TopologyPanel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManageMessage
extends XContainer
implements ManageChannel,
PropertyChangeListener {
    private final CacheManagerModel cacheManagerModel;
    private final Frame frame;
    private final ApplicationContext appContext;
    private final String title;
    private AbstractViewPage currentPage;
    private ButtonSet pageSelector;
    private final XContainer pageHolder;
    protected XCheckBox selectAllToggle;
    private XCheckBox applyToNewcomersToggle;
    private XLabel overviewLabel;
    private final String overviewMsg;
    private JDialog waitDialog;
    private XLabel waitMsgLabel;
    private final AtomicBoolean hideWaitDialog = new AtomicBoolean(false);
    private WaitDialogListener waitDialogListener;
    protected static final ResourceBundle bundle = ResourceBundle.getBundle(EhcacheResourceBundle.class.getName());
    protected static final long MIN_WAIT_DIALOG_TIME = 1500L;

    public ManageMessage(Frame frame, ApplicationContext appContext, CacheManagerModel cacheManagerModel, String phrase, String overviewMsg, TopologyPanel.Mode mode) {
        super((LayoutManager)new BorderLayout());
        this.frame = frame;
        this.appContext = appContext;
        this.cacheManagerModel = cacheManagerModel;
        this.overviewMsg = overviewMsg;
        this.title = phrase + " on " + cacheManagerModel.getName();
        XContainer topPanel = new XContainer((LayoutManager)new BorderLayout());
        topPanel.add((Component)this.createOverviewPanel(), (Object)"North");
        topPanel.add((Component)this.createViewByPanel(), (Object)"Center");
        this.pageHolder = new XContainer((LayoutManager)new BorderLayout());
        this.currentPage = mode == TopologyPanel.Mode.CACHE_MANAGER ? this.createNodeView() : this.createCacheView();
        this.pageSelector.setSelected(mode.toString());
        this.pageHolder.add((Component)((Object)this.currentPage));
        XContainer bottomPanel = new XContainer((LayoutManager)new BorderLayout());
        this.createApplyToNewcomersToggle(bottomPanel);
        this.selectAllToggle = new XCheckBox("Select/De-select All");
        bottomPanel.add((Component)this.selectAllToggle, (Object)"East");
        this.selectAllToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManageMessage.this.currentPage.selectAll(ManageMessage.this.selectAllToggle.isSelected());
                if (ManageMessage.this.selectAllToggle.isSelected()) {
                    ManageMessage.this.setApplyToNewcomersToggleVisible(true);
                }
            }
        });
        this.selectAllToggle.setSelected(this.isAllSelected());
        bottomPanel.add((Component)new XLabel("Terracotta-clustered", EhcachePresentationUtils.CLUSTERED_ICON), (Object)"West");
        this.add((Component)topPanel, "North");
        this.add((Component)this.pageHolder, "Center");
        this.add((Component)bottomPanel, "South");
    }

    public ManageMessage(Frame frame, ApplicationContext appContext, CacheManagerModel cacheManagerModel, String phrase, String overviewMsg) {
        this(frame, appContext, cacheManagerModel, phrase, overviewMsg, TopologyPanel.Mode.CACHE_MANAGER);
    }

    private XContainer createOverviewPanel() {
        XContainer result = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 5, 1, 0);
        this.overviewLabel = new XLabel(this.overviewMsg);
        result.add((Component)this.overviewLabel, (Object)gbc);
        this.overviewLabel.setIcon(EhcachePresentationUtils.ALERT_ICON);
        result.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        return result;
    }

    private XContainer createViewByPanel() {
        XContainer result = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(1, 5, 1, 0);
        result.add((Component)new XLabel("View by: "), (Object)gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(1, 0, 1, 0);
        this.pageSelector = new ButtonSet((LayoutManager)new FlowLayout(1, 0, 0));
        result.add((Component)this.pageSelector, (Object)gbc);
        JRadioButton rb = new JRadioButton("CacheManager Instances");
        rb.setName(TopologyPanel.Mode.CACHE_MANAGER.toString());
        this.pageSelector.add((Component)rb);
        rb = new JRadioButton("Caches");
        this.pageSelector.add((Component)rb);
        rb.setName(TopologyPanel.Mode.CACHE.toString());
        this.pageSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = ((ButtonSet)e.getSource()).getSelected();
                if (!name.equals(ManageMessage.this.currentPage.getName())) {
                    Map<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> selection = ManageMessage.this.currentPage.getSelection();
                    ManageMessage.this.currentPage.removePropertyChangeListener(ManageMessage.this);
                    ManageMessage.this.pageHolder.removeAll();
                    if (TopologyPanel.Mode.CACHE.toString().equals(name)) {
                        ManageMessage.this.currentPage = ManageMessage.this.createCacheView(selection);
                    } else {
                        ManageMessage.this.currentPage = ManageMessage.this.createNodeView(selection);
                    }
                    ManageMessage.this.pageHolder.add((Component)((Object)ManageMessage.this.currentPage));
                    ManageMessage.this.pageHolder.revalidate();
                    ManageMessage.this.pageHolder.repaint();
                }
            }
        });
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public XLabel getOverviewLabel() {
        return this.overviewLabel;
    }

    public void resetOverviewLabel() {
        this.overviewLabel.setText(this.overviewMsg);
    }

    protected void createApplyToNewcomersToggle(XContainer panel) {
        this.applyToNewcomersToggle = new XCheckBox("Apply to newcomers");
        panel.add((Component)this.applyToNewcomersToggle, (Object)"West");
        this.applyToNewcomersToggle.setSelected(true);
        this.applyToNewcomersToggle.setVisible(false);
    }

    private NodeViewPage createNodeView() {
        return this.createNodeView(null);
    }

    private NodeViewPage createNodeView(Map<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> selection) {
        NodeViewPage result = new NodeViewPage(this, this.cacheManagerModel);
        result.addPropertyChangeListener(this);
        if (selection != null) {
            result.setSelection(selection);
        }
        return result;
    }

    private CacheViewPage createCacheView() {
        return this.createCacheView(null);
    }

    private CacheViewPage createCacheView(Map<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> selection) {
        CacheViewPage result = new CacheViewPage(this, this.cacheManagerModel);
        result.addPropertyChangeListener(this);
        if (selection != null) {
            result.setSelection(selection);
        }
        return result;
    }

    protected void setApplyToNewcomersToggleVisible(boolean visible) {
        if (this.applyToNewcomersToggle != null) {
            this.applyToNewcomersToggle.setVisible(visible);
        }
    }

    public boolean hasApplyToNewcomersToggle() {
        return this.applyToNewcomersToggle != null;
    }

    public boolean shouldApplyToNewcomers() {
        return this.applyToNewcomersToggle != null && this.applyToNewcomersToggle.isSelected();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("ALL_SELECTED".equals(prop) || "ALL_DESELECTED".equals(prop)) {
            this.setApplyToNewcomersToggleVisible(true);
            this.selectAllToggle.setSelected("ALL_SELECTED".equals(prop));
        } else if ("SOME_SELECTED".equals(prop)) {
            this.setApplyToNewcomersToggleVisible(false);
        }
    }

    public boolean isAllSelected() {
        return this.currentPage.isAllSelected();
    }

    public boolean isAllDeselected() {
        return this.currentPage.isAllDeselected();
    }

    public boolean isSomeSelected() {
        return this.currentPage.isSomeSelected();
    }

    protected String createApplyLabel() {
        return "OK";
    }

    @Override
    public boolean isEnabled(CacheModelInstance cacheModel) {
        return true;
    }

    @Override
    public boolean isEnabled(CacheModel cacheModel) {
        return true;
    }

    @Override
    public boolean isEnabled(CacheManagerInstance cacheModel) {
        return true;
    }

    @Override
    public abstract boolean getValue(CacheModelInstance var1);

    @Override
    public abstract boolean getValue(CacheManagerInstance var1);

    @Override
    public abstract boolean getValue(CacheManagerModel var1);

    @Override
    public abstract boolean getValue(CacheModel var1);

    @Override
    public abstract void setValue(CacheManagerModel var1, boolean var2, boolean var3);

    @Override
    public abstract void setNodeViewValues(Map<CacheManagerInstance, Boolean> var1, Map<CacheModelInstance, Boolean> var2);

    @Override
    public abstract void setCacheViewValues(Map<CacheModel, Boolean> var1, Map<CacheModelInstance, Boolean> var2);

    public CacheManagerModel getCacheManagerModel() {
        return this.cacheManagerModel;
    }

    public void apply(Boolean toNewcomers) {
        if (this.currentPage != null) {
            this.currentPage.apply(toNewcomers);
        }
    }

    protected void setValueImpl(final CacheManagerModel cacheManagerModel, final String prop, final boolean value, final String msg) {
        this.showWaitDialog(msg, new Runnable(){

            public void run() {
                long startTime = System.currentTimeMillis();
                HashMap<CacheModelInstance, Object> attrMap = new HashMap<CacheModelInstance, Object>();
                for (CacheModelInstance cacheModelInstance : cacheManagerModel.allCacheModelInstances()) {
                    attrMap.put(cacheModelInstance, value);
                }
                try {
                    Map<CacheModelInstance, Exception> result = cacheManagerModel.setCacheModelInstanceAttribute(prop, attrMap);
                    if (result != null && result.size() > 0) {
                        ManageMessage.this.reportCacheModelInstanceErrors(result);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                long timeTaken = System.currentTimeMillis() - startTime;
                if (timeTaken < 1500L) {
                    ThreadUtil.reallySleep((long)(1500L - timeTaken));
                }
                ManageMessage.this.hideWaitDialog(msg);
            }
        });
    }

    protected void setNodeViewValuesImpl(final Map<CacheManagerInstance, Boolean> cacheManagerInstances, final Map<CacheModelInstance, Boolean> cacheModelInstances, final String prop, final String msg) {
        this.showWaitDialog(msg, new Runnable(){

            public void run() {
                long startTime = System.currentTimeMillis();
                HashMap<CacheModelInstance, Object> attrMap = new HashMap<CacheModelInstance, Object>();
                for (CacheManagerInstance cacheManagerInstance : cacheManagerInstances.keySet()) {
                    Object val = cacheManagerInstances.get(cacheManagerInstance);
                    for (CacheModelInstance cmi : cacheManagerInstance.cacheModelInstances()) {
                        attrMap.put(cmi, val);
                    }
                }
                for (CacheModelInstance cacheModelInstance : cacheModelInstances.keySet()) {
                    attrMap.put(cacheModelInstance, cacheModelInstances.get(cacheModelInstance));
                }
                try {
                    Map<CacheModelInstance, Exception> result = ManageMessage.this.cacheManagerModel.setCacheModelInstanceAttribute(prop, attrMap);
                    if (result != null && result.size() > 0) {
                        ManageMessage.this.reportCacheModelInstanceErrors(result);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                long timeTaken = System.currentTimeMillis() - startTime;
                if (timeTaken < 1500L) {
                    ThreadUtil.reallySleep((long)(1500L - timeTaken));
                }
                ManageMessage.this.hideWaitDialog(msg);
            }
        });
    }

    protected void setCacheViewValuesImpl(final Map<CacheModel, Boolean> cacheModels, final Map<CacheModelInstance, Boolean> cacheModelInstances, final String prop, final String msg) {
        this.showWaitDialog(msg, new Runnable(){

            public void run() {
                long startTime = System.currentTimeMillis();
                HashMap<CacheModelInstance, Object> attrMap = new HashMap<CacheModelInstance, Object>();
                for (CacheModel cacheModel : cacheModels.keySet()) {
                    Object val = cacheModels.get(cacheModel);
                    for (CacheModelInstance cmi : cacheModel.cacheModelInstances()) {
                        attrMap.put(cmi, val);
                    }
                }
                for (CacheModelInstance cacheModelInstance : cacheModelInstances.keySet()) {
                    attrMap.put(cacheModelInstance, cacheModelInstances.get(cacheModelInstance));
                }
                try {
                    Map<CacheModelInstance, Exception> result = ManageMessage.this.cacheManagerModel.setCacheModelInstanceAttribute(prop, attrMap);
                    if (result != null && result.size() > 0) {
                        ManageMessage.this.reportCacheModelInstanceErrors(result);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                long timeTaken = System.currentTimeMillis() - startTime;
                if (timeTaken < 1500L) {
                    ThreadUtil.reallySleep((long)(1500L - timeTaken));
                }
                ManageMessage.this.hideWaitDialog(msg);
            }
        });
    }

    private void createWaitDialog(String msg) {
        this.waitDialog = new JDialog(this.frame, this.frame.getTitle(), true);
        this.waitDialog.getRootPane().setWindowDecorationStyle(3);
        this.waitDialog.setDefaultCloseOperation(0);
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 11;
        this.waitMsgLabel = new XLabel("<html>" + msg + "</html>");
        panel.add((Component)this.waitMsgLabel, (Object)gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        panel.add((Component)new XLabel(), (Object)gbc);
        this.waitDialog.getContentPane().add(new JScrollPane((Component)panel));
        this.waitDialog.pack();
        this.waitDialog.setSize(450, 150);
        WindowHelper.center((Window)this.waitDialog, (Window)this.frame);
        this.waitDialogListener = new WaitDialogListener();
        this.waitDialog.addHierarchyListener(this.waitDialogListener);
    }

    private void setMsgText(String msg) {
        this.waitMsgLabel.setText("<html>" + msg + "</html>");
        this.waitMsgLabel.paintImmediately(0, 0, this.waitMsgLabel.getWidth(), this.waitMsgLabel.getHeight());
    }

    protected void reportErrors(final Map<ObjectName, Exception> result) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringBuilder sb = new StringBuilder("<p>There were errors:</p><table border=1 cellspacing=1 cellpadding=1>");
                for (ObjectName on : result.keySet()) {
                    Throwable t = ExceptionHelper.getRootCause((Throwable)((Throwable)result.get(on)));
                    ManageMessage.this.appContext.log(t);
                    sb.append("<tr><td>");
                    sb.append(on.getKeyProperty("name"));
                    sb.append(":");
                    sb.append("</td><td>");
                    sb.append(t.getLocalizedMessage());
                    sb.append("</td></tr>");
                }
                sb.append("</table>");
                ManageMessage.this.setMsgText(sb.toString());
                JButton btn = new JButton("Close");
                btn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        ManageMessage.this.waitDialog.setVisible(false);
                    }
                });
                JPanel btnPanel = new JPanel(new FlowLayout());
                btnPanel.add(btn);
                ManageMessage.this.waitDialog.getContentPane().add((Component)btnPanel, "South");
                ManageMessage.this.waitDialog.getRootPane().setWindowDecorationStyle(4);
                ManageMessage.this.waitDialog.setDefaultCloseOperation(2);
                Dimension size = ManageMessage.this.waitDialog.getSize();
                ManageMessage.this.waitDialog.pack();
                ManageMessage.this.waitDialog.setSize(size);
            }
        });
    }

    protected void reportCacheModelInstanceErrors(final Map<CacheModelInstance, Exception> result) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringBuilder sb = new StringBuilder("<p>There were errors:</p><table border=1 cellspacing=1 cellpadding=1>");
                for (CacheModelInstance cmi : result.keySet()) {
                    Throwable t = ExceptionHelper.getRootCause((Throwable)((Throwable)result.get(cmi)));
                    ManageMessage.this.appContext.log(t);
                    sb.append("<tr><td>");
                    sb.append(cmi);
                    sb.append(":");
                    sb.append("</td><td width='300'><p>");
                    String msg = t.getLocalizedMessage();
                    if (msg == null) {
                        msg = t.getClass().getSimpleName();
                    }
                    sb.append(msg);
                    sb.append("</p></td></tr>");
                }
                sb.append("</table>");
                ManageMessage.this.setMsgText(sb.toString());
                JButton btn = new JButton("Close");
                btn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        ManageMessage.this.waitDialog.setVisible(false);
                    }
                });
                JPanel btnPanel = new JPanel(new FlowLayout());
                btnPanel.add(btn);
                ManageMessage.this.waitDialog.getContentPane().add((Component)btnPanel, "South");
                ManageMessage.this.waitDialog.getRootPane().setWindowDecorationStyle(4);
                ManageMessage.this.waitDialog.setDefaultCloseOperation(2);
                Dimension size = ManageMessage.this.waitDialog.getSize();
                ManageMessage.this.waitDialog.pack();
                ManageMessage.this.waitDialog.setSize(size);
            }
        });
    }

    protected void showWaitDialog(String msg, Runnable runner) {
        this.hideWaitDialog.set(false);
        if (this.waitDialog == null) {
            this.createWaitDialog(msg);
        } else {
            this.setMsgText(msg);
        }
        this.appContext.setStatus(msg);
        this.waitDialogListener.runner = runner;
        this.waitDialog.setVisible(true);
    }

    protected void hideWaitDialog(String msg) {
        this.hideWaitDialog.set(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ManageMessage.this.appContext.setStatus("");
                if (ManageMessage.this.hideWaitDialog.getAndSet(false)) {
                    ManageMessage.this.waitDialog.setVisible(false);
                }
            }
        });
    }

    public void tearDown() {
        if (this.currentPage != null) {
            this.currentPage.removePropertyChangeListener(this);
        }
        if (this.waitDialog != null) {
            this.waitDialog.setVisible(false);
        }
        super.tearDown();
    }

    private class WaitDialogListener
    implements HierarchyListener {
        Runnable runner;

        private WaitDialogListener() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) != 0L && ManageMessage.this.waitDialog.isShowing() && this.runner != null) {
                ManageMessage.this.appContext.submit(this.runner);
            }
        }
    }
}

