/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import java.awt.Frame;
import java.util.Map;
import org.terracotta.modules.ehcache.presentation.ManageMessage;
import org.terracotta.modules.ehcache.presentation.TopologyPanel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageEnablementMessage
extends ManageMessage {
    public ManageEnablementMessage(Frame frame, ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        this(frame, appContext, cacheManagerModel, TopologyPanel.Mode.CACHE_MANAGER);
    }

    public ManageEnablementMessage(Frame frame, ApplicationContext appContext, CacheManagerModel cacheManagerModel, TopologyPanel.Mode mode) {
        super(frame, appContext, cacheManagerModel, "Manage Active Caches", "The selected caches will enabled.", mode);
    }

    @Override
    public boolean getValue(CacheModelInstance cacheModelInstance) {
        return cacheModelInstance.isEnabled();
    }

    @Override
    public boolean getValue(CacheManagerInstance cacheManagerInstance) {
        return cacheManagerInstance.getEnabledCount() == cacheManagerInstance.getInstanceCount();
    }

    @Override
    public boolean getValue(CacheManagerModel theCacheManagerModel) {
        return theCacheManagerModel.getEnabledCount() == theCacheManagerModel.getCacheModelCount();
    }

    @Override
    public void setValue(CacheManagerModel cacheManagerModel, boolean value, boolean applyToNewcomers) {
        String prefix = value ? "Enabling" : "Disabling";
        String msg = prefix + " all caches contained by '" + cacheManagerModel.getName() + "'...";
        cacheManagerModel.setCachesBulkLoadEnabledPersistently(value, applyToNewcomers);
        this.setValueImpl(cacheManagerModel, "Enabled", value, msg);
    }

    @Override
    public boolean getValue(CacheModel cacheModel) {
        CacheManagerModel cacheManagerModel = cacheModel.getCacheManagerModel();
        return cacheManagerModel.getEnabledCount(cacheModel) == cacheManagerModel.getCacheModelInstanceCount(cacheModel);
    }

    @Override
    public void setNodeViewValues(Map<CacheManagerInstance, Boolean> cacheManagerInstances, Map<CacheModelInstance, Boolean> cacheModelInstances) {
        String msg = "Changing cache enablement...";
        this.setNodeViewValuesImpl(cacheManagerInstances, cacheModelInstances, "Enabled", "Changing cache enablement...");
    }

    @Override
    public void setCacheViewValues(Map<CacheModel, Boolean> cacheModels, Map<CacheModelInstance, Boolean> cacheModelInstances) {
        String msg = "Changing cache enablement...";
        this.setCacheViewValuesImpl(cacheModels, cacheModelInstances, "Enabled", "Changing cache enablement...");
    }
}

