/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.XContainer;
import com.tc.util.concurrent.ThreadUtil;
import java.awt.Frame;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.terracotta.modules.ehcache.presentation.ManageMessage;
import org.terracotta.modules.ehcache.presentation.TopologyPanel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageContentsMessage
extends ManageMessage {
    private static final String OVERVIEW_MSG = "<html>The selected caches will have their contents cleared.<br> Note: transactional caches cannot be cleared over JMX.</html>";

    public ManageContentsMessage(Frame frame, ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        this(frame, appContext, cacheManagerModel, TopologyPanel.Mode.CACHE_MANAGER);
    }

    public ManageContentsMessage(Frame frame, ApplicationContext appContext, CacheManagerModel cacheManagerModel, TopologyPanel.Mode mode) {
        super(frame, appContext, cacheManagerModel, "Clear Cache Contents", OVERVIEW_MSG, mode);
    }

    @Override
    protected void createApplyToNewcomersToggle(XContainer panel) {
    }

    @Override
    protected void setApplyToNewcomersToggleVisible(boolean visible) {
    }

    @Override
    public boolean getValue(CacheModelInstance cacheModelInstance) {
        return false;
    }

    @Override
    public boolean getValue(CacheManagerInstance cacheManagerInstance) {
        return false;
    }

    @Override
    public boolean getValue(CacheManagerModel theCacheManagerModel) {
        return false;
    }

    @Override
    public void setValue(final CacheManagerModel cacheManagerModel, boolean value, boolean applyToNewcomers) {
        if (value) {
            final String msg = "Clearing all cache contents for '" + cacheManagerModel.getName() + "'...";
            this.showWaitDialog(msg, new Runnable(){

                public void run() {
                    long timeTaken;
                    long startTime = System.currentTimeMillis();
                    Set<CacheModelInstance> cmiSet = cacheManagerModel.allCacheModelInstances();
                    if (cmiSet.size() > 0) {
                        try {
                            Map<CacheModelInstance, Object> result = cacheManagerModel.invokeCacheModelInstances(cmiSet, "removeAll");
                            if (result != null && result.size() > 0) {
                                HashMap<CacheModelInstance, Exception> errors = new HashMap<CacheModelInstance, Exception>();
                                for (Map.Entry<CacheModelInstance, Object> entry : result.entrySet()) {
                                    Object val = entry.getValue();
                                    if (!(val instanceof Exception)) continue;
                                    errors.put(entry.getKey(), (Exception)val);
                                }
                                if (errors.size() > 0) {
                                    ManageContentsMessage.this.reportCacheModelInstanceErrors(errors);
                                    return;
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if ((timeTaken = System.currentTimeMillis() - startTime) < 1500L) {
                        ThreadUtil.reallySleep((long)(1500L - timeTaken));
                    }
                    ManageContentsMessage.this.hideWaitDialog(msg);
                }
            });
        }
    }

    @Override
    public boolean getValue(CacheModel cacheModel) {
        return false;
    }

    @Override
    public void setNodeViewValues(final Map<CacheManagerInstance, Boolean> cacheManagerInstances, final Map<CacheModelInstance, Boolean> cacheModelInstances) {
        String msg = "Clearing cache contents...";
        this.showWaitDialog("Clearing cache contents...", new Runnable(){

            public void run() {
                long timeTaken;
                Object val;
                long startTime = System.currentTimeMillis();
                HashSet<CacheModelInstance> cmiSet = new HashSet<CacheModelInstance>();
                for (CacheManagerInstance cacheManagerInstance : cacheManagerInstances.keySet()) {
                    val = cacheManagerInstances.get(cacheManagerInstance);
                    if (!val.equals(Boolean.TRUE)) continue;
                    cmiSet.addAll(cacheManagerInstance.cacheModelInstances());
                }
                for (CacheModelInstance cacheModelInstance : cacheModelInstances.keySet()) {
                    val = cacheModelInstances.get(cacheModelInstance);
                    if (!val.equals(Boolean.TRUE)) continue;
                    cmiSet.add(cacheModelInstance);
                }
                if (cmiSet.size() > 0) {
                    try {
                        Map<CacheModelInstance, Object> result = ManageContentsMessage.this.getCacheManagerModel().invokeCacheModelInstances(cmiSet, "removeAll");
                        if (result != null && result.size() > 0) {
                            HashMap<CacheModelInstance, Exception> errors = new HashMap<CacheModelInstance, Exception>();
                            for (Map.Entry<CacheModelInstance, Object> entry : result.entrySet()) {
                                Object val2 = entry.getValue();
                                if (!(val2 instanceof Exception)) continue;
                                errors.put(entry.getKey(), (Exception)val2);
                            }
                            if (errors.size() > 0) {
                                ManageContentsMessage.this.reportCacheModelInstanceErrors(errors);
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((timeTaken = System.currentTimeMillis() - startTime) < 1500L) {
                    ThreadUtil.reallySleep((long)(1500L - timeTaken));
                }
                ManageContentsMessage.this.hideWaitDialog("Clearing cache contents...");
            }
        });
    }

    @Override
    public void setCacheViewValues(final Map<CacheModel, Boolean> cacheModels, final Map<CacheModelInstance, Boolean> cacheModelInstances) {
        String msg = "Clearing cache contents...";
        this.showWaitDialog("Clearing cache contents...", new Runnable(){

            public void run() {
                long timeTaken;
                Object val;
                long startTime = System.currentTimeMillis();
                CacheManagerModel cacheManagerModel = ManageContentsMessage.this.getCacheManagerModel();
                HashSet<CacheModelInstance> cmiSet = new HashSet<CacheModelInstance>();
                for (CacheModel cacheModel : cacheModels.keySet()) {
                    val = cacheModels.get(cacheModel);
                    if (!val.equals(Boolean.TRUE)) continue;
                    cmiSet.addAll(cacheModel.cacheModelInstances());
                }
                for (CacheModelInstance cacheModelInstance : cacheModelInstances.keySet()) {
                    val = cacheModelInstances.get(cacheModelInstance);
                    if (!val.equals(Boolean.TRUE)) continue;
                    cmiSet.add(cacheModelInstance);
                }
                if (cmiSet.size() > 0) {
                    try {
                        Map<CacheModelInstance, Object> result = cacheManagerModel.invokeCacheModelInstances(cmiSet, "removeAll");
                        if (result != null && result.size() > 0) {
                            HashMap<CacheModelInstance, Exception> errors = new HashMap<CacheModelInstance, Exception>();
                            for (Map.Entry<CacheModelInstance, Object> entry : result.entrySet()) {
                                Object val2 = entry.getValue();
                                if (!(val2 instanceof Exception)) continue;
                                errors.put(entry.getKey(), (Exception)val2);
                            }
                            if (errors.size() > 0) {
                                ManageContentsMessage.this.reportCacheModelInstanceErrors(errors);
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if ((timeTaken = System.currentTimeMillis() - startTime) < 1500L) {
                    ThreadUtil.reallySleep((long)(1500L - timeTaken));
                }
                ManageContentsMessage.this.hideWaitDialog("Clearing cache contents...");
            }
        });
    }
}

