/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import java.awt.Frame;
import java.util.Map;
import org.terracotta.modules.ehcache.presentation.ManageMessage;
import org.terracotta.modules.ehcache.presentation.TopologyPanel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageBulkLoadingMessage
extends ManageMessage {
    private static final String OVERVIEW_MSG = "<html>The selected caches will be put into bulk-load mode.<br> Note: transactional caches cannot be put into bulk-load mode.</html>";

    public ManageBulkLoadingMessage(Frame frame, ApplicationContext appContext, CacheManagerModel cacheManagerModel, TopologyPanel.Mode mode) {
        super(frame, appContext, cacheManagerModel, "Manage BulkLoad Mode", OVERVIEW_MSG, mode);
        boolean haveTransactionalCaches = cacheManagerModel.getTransactionalCount() > 0;
        this.selectAllToggle.setEnabled(!haveTransactionalCaches);
    }

    @Override
    public boolean getValue(CacheModelInstance cacheModelInstance) {
        return cacheModelInstance.isBulkLoadEnabled();
    }

    @Override
    public boolean getValue(CacheManagerInstance cacheManagerInstance) {
        return cacheManagerInstance.getBulkLoadEnabledCount() == cacheManagerInstance.getInstanceCount();
    }

    @Override
    public boolean getValue(CacheManagerModel theCacheManagerModel) {
        return theCacheManagerModel.getBulkLoadEnabledCount() == theCacheManagerModel.getCacheModelCount();
    }

    @Override
    public void setValue(CacheManagerModel cacheManagerModel, boolean value, boolean applyToNewcomers) {
        String enablingMsg = "Putting CacheManager '" + cacheManagerModel.getName() + "' into bulk-load mode...";
        String disablingMsg = "Removing CacheManager '" + cacheManagerModel.getName() + "' from bulk-load mode...";
        String msg = value ? enablingMsg : disablingMsg;
        cacheManagerModel.setCachesBulkLoadEnabledPersistently(value, applyToNewcomers);
        this.setValueImpl(cacheManagerModel, "NodeBulkLoadEnabled", value, msg);
    }

    @Override
    public boolean getValue(CacheModel cacheModel) {
        CacheManagerModel cacheManagerModel = cacheModel.getCacheManagerModel();
        return cacheManagerModel.getBulkLoadEnabledCount(cacheModel) == cacheManagerModel.getCacheModelInstanceCount(cacheModel);
    }

    @Override
    public boolean isEnabled(CacheModelInstance cacheModelInstance) {
        return !cacheModelInstance.isTransactional();
    }

    @Override
    public boolean isEnabled(CacheModel cacheModel) {
        return cacheModel.getTransactionalCount() == 0;
    }

    @Override
    public boolean isEnabled(CacheManagerInstance cacheManageInstance) {
        return cacheManageInstance.getTransactionalCount() == 0;
    }

    @Override
    public void setNodeViewValues(Map<CacheManagerInstance, Boolean> cacheManagerInstances, Map<CacheModelInstance, Boolean> cacheModelInstances) {
        String msg = "Updating bulk-load modes...";
        this.setNodeViewValuesImpl(cacheManagerInstances, cacheModelInstances, "NodeBulkLoadEnabled", "Updating bulk-load modes...");
    }

    @Override
    public void setCacheViewValues(Map<CacheModel, Boolean> cacheModels, Map<CacheModelInstance, Boolean> cacheModelInstances) {
        String msg = "Updating bulk-load modes...";
        this.setCacheViewValuesImpl(cacheModels, cacheModelInstances, "NodeBulkLoadEnabled", "Updating bulk-load modes...");
    }
}

