/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class EhcacheStatsUtils {
    public static final String EHCACHE_DOMAIN = "net.sf.ehcache";
    public static final String SAMPLED_CACHE_MANAGER_BEAN_NAME_PREFIX = "net.sf.ehcache:type=SampledCacheManager";
    public static final String SAMPLED_CACHE_BEAN_NAME_PREFIX = "net.sf.ehcache:type=SampledCache";

    public static String mbeanSafe(String s) {
        return s == null ? "" : s.replaceAll(":|=|\n", ".");
    }

    public static ObjectName getSampledCacheManagerBeanName(String name) throws MalformedObjectNameException {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        return new ObjectName("net.sf.ehcache:type=SampledCacheManager,name=" + EhcacheStatsUtils.mbeanSafe(name));
    }

    public static ObjectName getSampledCacheBeanName(String cacheManagerName, String cacheName) throws MalformedObjectNameException {
        if (cacheManagerName == null) {
            throw new IllegalArgumentException("cacheManagerName");
        }
        if (cacheName == null) {
            throw new IllegalArgumentException("cacheName");
        }
        return new ObjectName("net.sf.ehcache:type=SampledCache,SampledCacheManager=" + EhcacheStatsUtils.mbeanSafe(cacheManagerName) + ",name=" + EhcacheStatsUtils.mbeanSafe(cacheName));
    }

    public static ObjectName replaceKey(ObjectName beanName, String key, String value) {
        Hashtable<String, String> keyPropertyList = beanName.getKeyPropertyList();
        Hashtable<String, String> propertyList = new Hashtable<String, String>(keyPropertyList);
        propertyList.put(key, value);
        try {
            return new ObjectName(beanName.getDomain(), propertyList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectName renameKey(ObjectName beanName, String oldKey, String newKey) {
        Hashtable<String, String> keyPropertyList = beanName.getKeyPropertyList();
        Hashtable<String, String> propertyList = new Hashtable<String, String>(keyPropertyList);
        String value = propertyList.remove(oldKey);
        if (value != null) {
            propertyList.put(newKey, value);
        }
        try {
            return new ObjectName(beanName.getDomain(), propertyList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

