/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.ClusterElementChooser;
import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.PagedView;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XSplitPane;
import com.tc.admin.common.XTabbedPane;
import com.tc.admin.common.XTreeNode;
import com.tc.admin.dso.ClientNode;
import com.tc.admin.dso.ClientsNode;
import com.tc.admin.model.IClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.terracotta.modules.ehcache.presentation.AggregateEhcacheRuntimeStatsPanel;
import org.terracotta.modules.ehcache.presentation.AggregateEhcacheStatsChartPanel;
import org.terracotta.modules.ehcache.presentation.BaseClusterModelPanel;
import org.terracotta.modules.ehcache.presentation.BaseEhcacheRuntimeStatsPanel;
import org.terracotta.modules.ehcache.presentation.CacheModelInstanceRuntimeStatsPanel;
import org.terracotta.modules.ehcache.presentation.CacheModelInstanceStatsChartPanel;
import org.terracotta.modules.ehcache.presentation.CacheModelRuntimeStatsPanel;
import org.terracotta.modules.ehcache.presentation.CacheModelStatsChartPanel;
import org.terracotta.modules.ehcache.presentation.ClientEhCacheRuntimeStatsPanel;
import org.terracotta.modules.ehcache.presentation.ClientEhcacheStatsChartPanel;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.ManageStatisticsMessage;
import org.terracotta.modules.ehcache.presentation.QueryForStatsMessage;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceAdapter;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelAdapter;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;

public class EhcacheRuntimeStatsPanel
extends BaseClusterModelPanel
implements ActionListener,
PropertyChangeListener,
HierarchyListener,
TreeModelListener {
    private final CacheManagerModel cacheManagerModel;
    private final CacheModelListener cacheModelListener;
    private final CacheModelInstanceListener cacheModelInstanceListener;
    private XLabel currentViewLabel;
    private ElementChooser elementChooser;
    private XTreeNode aggregateViewsNode;
    private XTreeNode aggregateViewNode;
    private ClientsNode clientsNode;
    private XSplitPane splitter;
    private PagedView chartPagedView;
    private PagedView tablePagedView;
    private final ManageStatisticsAction manageStatsAction;
    private final QueryForStatsMessage queryForStatsMessage;
    private static final String AGGREGATE_NODE_NAME = "AggregateNode";
    private static final String CACHE_MODEL_NAME_PREFIX = "Aggregate ";
    private static final String CACHE_MODEL_INSTANCE_NAME_PREFIX = "Instance of ";

    public EhcacheRuntimeStatsPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        super(appContext, cacheManagerModel.getClusterModel());
        this.cacheManagerModel = cacheManagerModel;
        this.cacheModelListener = new CacheModelListener();
        this.cacheModelInstanceListener = new CacheModelInstanceListener();
        this.manageStatsAction = new ManageStatisticsAction();
        this.addHierarchyListener(this);
        this.queryForStatsMessage = new QueryForStatsMessage(this.manageStatsAction);
    }

    public void setup() {
        super.setup();
        this.cacheManagerModel.addCacheManagerModelListener(this.cacheModelListener);
        for (CacheManagerInstance cmi : this.cacheManagerModel.cacheManagerInstances()) {
            cmi.addCacheManagerInstanceListener(this.cacheModelInstanceListener);
        }
    }

    private String cacheModelInstanceName(CacheModelInstance cacheModelInstance) {
        return CACHE_MODEL_INSTANCE_NAME_PREFIX + cacheModelInstance.getCacheName() + " on " + cacheModelInstance.getClientName();
    }

    private ClientNode clientNode(CacheManagerInstance cmi) {
        IClient client = cmi.getClient();
        for (int i = 0; i < this.clientsNode.getChildCount(); ++i) {
            ClientNode clientNode = (ClientNode)this.clientsNode.getChildAt(i);
            if (client != clientNode.getClient()) continue;
            return clientNode;
        }
        return null;
    }

    private void addToAggregate(CacheModel cacheModel) {
        CacheModelNode node = new CacheModelNode(cacheModel);
        node.setName(CACHE_MODEL_NAME_PREFIX + cacheModel.getCacheName());
        this.aggregateViewNode.addChild((XTreeNode)node);
    }

    private void removeFromAggregate(CacheModel cacheModel) {
        for (int i = 0; i < this.aggregateViewNode.getChildCount(); ++i) {
            CacheModelNode node = (CacheModelNode)((Object)this.aggregateViewNode.getChildAt(i));
            if (node.getCacheModel() != cacheModel) continue;
            this.aggregateViewNode.removeChild((XTreeNode)node);
            node.tearDown();
            break;
        }
    }

    private void removePagesForNode(XTreeNode node) {
        this.chartPagedView.removePage(node.getName());
        this.tablePagedView.removePage(node.getName());
    }

    protected XContainer createMainPanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        XContainer topPanel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 13;
        Font headerFont = (Font)this.appContext.getObject("header.label.font");
        XLabel headerLabel = new XLabel(this.appContext.getString("current.view.type"));
        topPanel.add((Component)headerLabel, (Object)gbc);
        headerLabel.setFont(headerFont);
        ++gbc.gridx;
        this.currentViewLabel = new XLabel();
        topPanel.add((Component)this.currentViewLabel, (Object)gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        topPanel.add((Component)new XLabel(), (Object)gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        headerLabel = new XLabel(this.appContext.getString("select.view"));
        topPanel.add((Component)headerLabel, (Object)gbc);
        headerLabel.setFont(headerFont);
        ++gbc.gridx;
        this.elementChooser = new ElementChooser();
        topPanel.add((Component)((Object)this.elementChooser), (Object)gbc);
        topPanel.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        panel.add((Component)topPanel, (Object)"North");
        this.chartPagedView = new PagedView();
        this.tablePagedView = new PagedView();
        this.splitter = new XSplitPane(0, (Component)this.chartPagedView, (Component)this.tablePagedView);
        this.splitter.setPreferences(this.appContext.getPrefs().node(this.getClass().getName() + "/split"));
        this.splitter.setResizeWeight(1.0);
        this.splitter.setDefaultDividerLocation(0.5);
        panel.add((Component)this.splitter, (Object)"Center");
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        ElementChooser chsr = (ElementChooser)((Object)e.getSource());
        XTreeNode node = (XTreeNode)chsr.getSelectedObject();
        String name = node.getName();
        if (!this.chartPagedView.hasPage(name)) {
            if (node instanceof ClientNode) {
                IClient client = ((ClientNode)node).getClient();
                this.chartPagedView.addPage((Component)((Object)this.createClientEhcacheStatsChartPanel(client)));
                this.tablePagedView.addPage((Component)((Object)this.createClientRuntimeStatsPanel(client)));
            } else if (node instanceof CacheModelNode) {
                CacheModel cacheModel = ((CacheModelNode)node).getCacheModel();
                this.chartPagedView.addPage((Component)((Object)this.createCacheModelStatsChartPanel(cacheModel)));
                this.tablePagedView.addPage((Component)((Object)this.createCacheModelRuntimeStatsPanel(cacheModel)));
            } else if (node instanceof CacheModelInstanceNode) {
                CacheModelInstance cacheModelInstance = ((CacheModelInstanceNode)node).getCacheModelInstance();
                this.chartPagedView.addPage((Component)((Object)this.createCacheModelInstanceStatsChartPanel(cacheModelInstance)));
                this.tablePagedView.addPage((Component)((Object)this.createCacheModelInstanceRuntimeStatsPanel(cacheModelInstance)));
            }
        }
        this.chartPagedView.setPage(name);
        this.tablePagedView.setPage(name);
        TreePath path = this.elementChooser.getSelectedPath();
        Object type = path.getPathComponent(1);
        String currentView = type.toString();
        if (node instanceof CacheModelInstanceNode) {
            currentView = currentView + "> " + path.getPathComponent(2);
        }
        this.currentViewLabel.setText(currentView);
    }

    public void clientConnected(IClient client) {
    }

    public void clientDisconnected(IClient client) {
        SwingUtilities.invokeLater(new ClientDisconnectHandler(client));
    }

    private void removePage(PagedView pagedView, String pageName) {
        Component page = pagedView.getPage(pageName);
        if (page != null) {
            pagedView.removePage(pageName);
            if (page instanceof XContainer) {
                ((XContainer)page).tearDown();
            } else if (page instanceof XTabbedPane) {
                ((XTabbedPane)page).tearDown();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("CurrentPage".equals(prop)) {
            String newPage = (String)evt.getNewValue();
            this.elementChooser.setSelectedPath(newPage);
        } else if ("SelectedCacheModel".equals(prop)) {
            this.firePropertyChange("SelectedCacheModel", evt.getOldValue(), evt.getNewValue());
        }
    }

    public void setSelectedCacheModel(CacheModel cacheModel) {
        if (this.tablePagedView != null) {
            for (Component page : this.tablePagedView.getComponents()) {
                if (!(page instanceof BaseEhcacheRuntimeStatsPanel)) continue;
                ((BaseEhcacheRuntimeStatsPanel)((Object)page)).setSelectedCacheModel(cacheModel);
            }
        }
    }

    protected void init() {
        this.elementChooser.setupTreeModel();
        this.chartPagedView.removeAll();
        this.tablePagedView.removeAll();
        this.chartPagedView.addPage((Component)((Object)this.createAggregateEhcacheStatsChartPanel()));
        this.tablePagedView.addPage((Component)((Object)this.createAggregateRuntimeStatsPanel()));
        this.elementChooser.setSelectedPath(AGGREGATE_NODE_NAME);
        this.chartPagedView.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private AggregateEhcacheRuntimeStatsPanel createAggregateRuntimeStatsPanel() {
        AggregateEhcacheRuntimeStatsPanel panel = new AggregateEhcacheRuntimeStatsPanel(this.appContext, this.cacheManagerModel);
        panel.setName(AGGREGATE_NODE_NAME);
        panel.setup();
        panel.addPropertyChangeListener(this);
        return panel;
    }

    private ClientEhCacheRuntimeStatsPanel createClientRuntimeStatsPanel(IClient client) {
        ClientEhCacheRuntimeStatsPanel panel = new ClientEhCacheRuntimeStatsPanel(this.appContext, this.cacheManagerModel, client);
        panel.setName(client.toString());
        panel.setup();
        panel.addPropertyChangeListener(this);
        return panel;
    }

    private AggregateEhcacheStatsChartPanel createAggregateEhcacheStatsChartPanel() {
        AggregateEhcacheStatsChartPanel panel = new AggregateEhcacheStatsChartPanel(this.appContext, this.cacheManagerModel);
        panel.setName(AGGREGATE_NODE_NAME);
        panel.setup();
        return panel;
    }

    private ClientEhcacheStatsChartPanel createClientEhcacheStatsChartPanel(IClient client) {
        ClientEhcacheStatsChartPanel panel = new ClientEhcacheStatsChartPanel(this.appContext, this.cacheManagerModel, client);
        panel.setName(client.toString());
        panel.setup();
        return panel;
    }

    private CacheModelStatsChartPanel createCacheModelStatsChartPanel(CacheModel cacheModel) {
        CacheModelStatsChartPanel panel = new CacheModelStatsChartPanel(this.appContext, cacheModel);
        panel.setName(CACHE_MODEL_NAME_PREFIX + cacheModel.getCacheName());
        panel.setup();
        return panel;
    }

    private CacheModelRuntimeStatsPanel createCacheModelRuntimeStatsPanel(CacheModel cacheModel) {
        CacheModelRuntimeStatsPanel panel = new CacheModelRuntimeStatsPanel(this.appContext, cacheModel);
        panel.setName(CACHE_MODEL_NAME_PREFIX + cacheModel.getCacheName());
        panel.setup();
        panel.addPropertyChangeListener(this);
        return panel;
    }

    private CacheModelInstanceStatsChartPanel createCacheModelInstanceStatsChartPanel(CacheModelInstance cacheModelInstance) {
        CacheModelInstanceStatsChartPanel panel = new CacheModelInstanceStatsChartPanel(this.appContext, cacheModelInstance);
        panel.setName(this.cacheModelInstanceName(cacheModelInstance));
        panel.setup();
        return panel;
    }

    private CacheModelInstanceRuntimeStatsPanel createCacheModelInstanceRuntimeStatsPanel(CacheModelInstance cacheModelInstance) {
        CacheModelInstanceRuntimeStatsPanel panel = new CacheModelInstanceRuntimeStatsPanel(this.appContext, cacheModelInstance);
        panel.setName(this.cacheModelInstanceName(cacheModelInstance));
        panel.setup();
        panel.addPropertyChangeListener(this);
        return panel;
    }

    protected CacheManagerModel getCacheManagerModel() {
        return this.cacheManagerModel;
    }

    private void testDismissQueryForStatsMessage() {
        JDialog queryForStatsDialog;
        if (this.queryForStatsMessage.isShowing() && (queryForStatsDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, (Component)((Object)this.queryForStatsMessage))) != null) {
            queryForStatsDialog.setVisible(false);
        }
    }

    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing() && this.cacheManagerModel.getStatisticsEnabledCount() < this.cacheManagerModel.getCacheModelInstanceCount() && this.queryForStatsMessage.shouldShowAgain()) {
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
            int answer = JOptionPane.showConfirmDialog((Component)((Object)this), this.queryForStatsMessage, frame.getTitle(), 0);
            if (answer == 0) {
                this.appContext.submit(new Runnable(){

                    public void run() {
                        EhcacheRuntimeStatsPanel.this.cacheManagerModel.setStatisticsEnabled(true, true);
                    }
                });
            }
            if (!this.queryForStatsMessage.shouldShowAgain()) {
                this.removeHierarchyListener(this);
            }
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
    }

    public void treeNodesInserted(TreeModelEvent e) {
        Object parent = e.getTreePath().getLastPathComponent();
        if (parent instanceof ClientsNode) {
            for (Object child : e.getChildren()) {
                ClientNode clientNode = (ClientNode)child;
                IClient client = clientNode.getClient();
                CacheManagerInstance cmi = this.cacheManagerModel.getInstance(client);
                if (cmi == null) continue;
                for (CacheModelInstance cacheModelInstance : cmi.cacheModelInstances()) {
                    CacheModelInstanceNode node = new CacheModelInstanceNode(cacheModelInstance);
                    node.setName(this.cacheModelInstanceName(cacheModelInstance));
                    clientNode.addChild((XTreeNode)node);
                }
            }
            this.elementChooser.expandPath(new TreePath(this.clientsNode.getPath()));
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        for (Object child : e.getChildren()) {
            this.removePagesForNode((XTreeNode)child);
        }
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }

    public void tearDown() {
        this.cacheManagerModel.removeCacheManagerModelListener(this.cacheModelListener);
        for (CacheManagerInstance cmi : this.cacheManagerModel.cacheManagerInstances()) {
            cmi.removeCacheManagerInstanceListener(this.cacheModelInstanceListener);
        }
        this.chartPagedView.removePropertyChangeListener((PropertyChangeListener)this);
        this.elementChooser.removeActionListener(this);
        super.tearDown();
    }

    private class ManageStatisticsAction
    extends AbstractAction {
        private ManageStatisticsAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            EhcacheRuntimeStatsPanel c = EhcacheRuntimeStatsPanel.this;
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)c));
            ManageStatisticsMessage msg = new ManageStatisticsMessage(frame, EhcacheRuntimeStatsPanel.this.appContext, EhcacheRuntimeStatsPanel.this.cacheManagerModel);
            int result = JOptionPane.showConfirmDialog((Component)((Object)c), msg, msg.getTitle(), 2);
            if (result == 0) {
                Boolean toNewcomers = null;
                if (msg.hasApplyToNewcomersToggle()) {
                    toNewcomers = msg.shouldApplyToNewcomers();
                }
                msg.apply(toNewcomers);
                EhcacheRuntimeStatsPanel.this.testDismissQueryForStatsMessage();
            }
            msg.tearDown();
        }
    }

    private class ClientDisconnectHandler
    implements Runnable {
        private final IClient client;

        ClientDisconnectHandler(IClient client) {
            this.client = client;
        }

        public void run() {
            String pageName = this.client.toString();
            if (pageName != null) {
                EhcacheRuntimeStatsPanel.this.removePage(EhcacheRuntimeStatsPanel.this.chartPagedView, pageName);
                EhcacheRuntimeStatsPanel.this.removePage(EhcacheRuntimeStatsPanel.this.tablePagedView, pageName);
            }
        }
    }

    private class ElementChooser
    extends ClusterElementChooser {
        ElementChooser() {
            super(EhcacheRuntimeStatsPanel.this.cacheManagerModel.getClusterModel(), (ActionListener)EhcacheRuntimeStatsPanel.this);
        }

        protected XTreeNode[] createTopLevelNodes() {
            EhcacheRuntimeStatsPanel.this.aggregateViewsNode = new XTreeNode((Object)EhcacheRuntimeStatsPanel.this.appContext.getString("aggregate.view"));
            EhcacheRuntimeStatsPanel.this.aggregateViewNode = new XTreeNode((Object)BaseClusterModelPanel.bundle.getString("cluster.stats"));
            EhcacheRuntimeStatsPanel.this.aggregateViewNode.setName(EhcacheRuntimeStatsPanel.AGGREGATE_NODE_NAME);
            EhcacheRuntimeStatsPanel.this.aggregateViewsNode.addChild(EhcacheRuntimeStatsPanel.this.aggregateViewNode);
            for (CacheModel cacheModel : EhcacheRuntimeStatsPanel.this.cacheManagerModel.cacheModels()) {
                EhcacheRuntimeStatsPanel.this.addToAggregate(cacheModel);
            }
            EhcacheRuntimeStatsPanel.this.clientsNode = new ClientsNode(EhcacheRuntimeStatsPanel.this.appContext, EhcacheRuntimeStatsPanel.this.cacheManagerModel.getClusterModel()){

                protected void updateLabel() {
                }
            };
            for (int i = 0; i < EhcacheRuntimeStatsPanel.this.clientsNode.getChildCount(); ++i) {
                ClientNode clientNode = (ClientNode)EhcacheRuntimeStatsPanel.this.clientsNode.getChildAt(i);
                IClient client = clientNode.getClient();
                CacheManagerInstance cmi = EhcacheRuntimeStatsPanel.this.cacheManagerModel.getInstance(client);
                if (cmi == null) continue;
                for (CacheModelInstance cacheModelInstance : cmi.cacheModelInstances()) {
                    CacheModelInstanceNode node = new CacheModelInstanceNode(cacheModelInstance);
                    node.setName(EhcacheRuntimeStatsPanel.this.cacheModelInstanceName(cacheModelInstance));
                    clientNode.addChild((XTreeNode)node);
                }
            }
            EhcacheRuntimeStatsPanel.this.clientsNode.setLabel(EhcacheRuntimeStatsPanel.this.appContext.getString("runtime.stats.per.client.view"));
            this.treeModel.addTreeModelListener(EhcacheRuntimeStatsPanel.this);
            return new XTreeNode[]{EhcacheRuntimeStatsPanel.this.aggregateViewsNode, EhcacheRuntimeStatsPanel.this.clientsNode};
        }

        protected boolean acceptPath(TreePath path) {
            Object o = path.getLastPathComponent();
            if (o instanceof XTreeNode) {
                XTreeNode node = (XTreeNode)o;
                return EhcacheRuntimeStatsPanel.AGGREGATE_NODE_NAME.equals(node.getName()) || node instanceof ClientNode || node instanceof CacheModelNode || node instanceof CacheModelInstanceNode;
            }
            return false;
        }

        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            XTreeNode node = (XTreeNode)event.getPath().getLastPathComponent();
            if (node == EhcacheRuntimeStatsPanel.this.aggregateViewsNode || node == EhcacheRuntimeStatsPanel.this.clientsNode) {
                throw new ExpandVetoException(event);
            }
            if (node == EhcacheRuntimeStatsPanel.this.aggregateViewNode || node instanceof ClientNode) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    XTreeNode child = (XTreeNode)node.getChildAt(i);
                    if (!EhcacheRuntimeStatsPanel.this.chartPagedView.hasPage(child.getName())) continue;
                    throw new ExpandVetoException(event);
                }
            }
        }

        public void expandPath(TreePath treePath) {
            this.tree.expandPath(treePath);
            this.treeModelChanged();
        }
    }

    private class CacheModelInstanceNode
    extends XTreeNode {
        private final CacheModelInstance cacheModelInstance;

        private CacheModelInstanceNode(CacheModelInstance cacheModelInstance) {
            super((Object)cacheModelInstance);
            this.cacheModelInstance = cacheModelInstance;
            this.setIcon(cacheModelInstance.isTerracottaClustered() ? EhcachePresentationUtils.CLUSTERED_ICON : EhcachePresentationUtils.NON_CLUSTERED_ICON);
        }

        public CacheModelInstance getCacheModelInstance() {
            return this.cacheModelInstance;
        }

        public String toString() {
            return this.cacheModelInstance.getCacheName();
        }
    }

    private class CacheModelNode
    extends XTreeNode {
        private final CacheModel cacheModel;

        private CacheModelNode(CacheModel cacheModel) {
            super((Object)cacheModel);
            this.cacheModel = cacheModel;
        }

        public CacheModel getCacheModel() {
            return this.cacheModel;
        }
    }

    private class CacheModelInstanceListener
    extends CacheManagerInstanceAdapter {
        private CacheModelInstanceListener() {
        }

        public void cacheModelInstanceAdded(final CacheModelInstance cacheModelInstance) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClientNode clientNode = EhcacheRuntimeStatsPanel.this.clientNode(cacheModelInstance.getCacheManagerInstance());
                    if (clientNode != null) {
                        CacheModelInstanceNode node = new CacheModelInstanceNode(cacheModelInstance);
                        node.setName(EhcacheRuntimeStatsPanel.this.cacheModelInstanceName(cacheModelInstance));
                        clientNode.addChild((XTreeNode)node);
                    }
                }
            });
        }

        public void cacheModelInstanceRemoved(final CacheModelInstance cacheModelInstance) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClientNode clientNode = EhcacheRuntimeStatsPanel.this.clientNode(cacheModelInstance.getCacheManagerInstance());
                    if (clientNode != null) {
                        for (int i = 0; i < clientNode.getChildCount(); ++i) {
                            CacheModelInstanceNode node = (CacheModelInstanceNode)((Object)clientNode.getChildAt(i));
                            if (node.getCacheModelInstance() != cacheModelInstance) continue;
                            clientNode.removeChild((XTreeNode)node);
                            node.tearDown();
                            break;
                        }
                    }
                }
            });
        }
    }

    private class CacheModelListener
    extends CacheManagerModelAdapter {
        private CacheModelListener() {
        }

        public void cacheModelAdded(final CacheModel cacheModel) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EhcacheRuntimeStatsPanel.this.addToAggregate(cacheModel);
                }
            });
        }

        public void cacheModelRemoved(final CacheModel cacheModel) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EhcacheRuntimeStatsPanel.this.removeFromAggregate(cacheModel);
                }
            });
        }

        public void instanceAdded(final CacheManagerInstance cmi) {
            cmi.addCacheManagerInstanceListener(EhcacheRuntimeStatsPanel.this.cacheModelInstanceListener);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClientNode clientNode = EhcacheRuntimeStatsPanel.this.clientNode(cmi);
                    if (clientNode != null) {
                        for (CacheModelInstance cacheModelInstance : cmi.cacheModelInstances()) {
                            CacheModelInstanceNode node = new CacheModelInstanceNode(cacheModelInstance);
                            node.setName(EhcacheRuntimeStatsPanel.this.cacheModelInstanceName(cacheModelInstance));
                            clientNode.addChild((XTreeNode)node);
                        }
                    }
                }
            });
        }

        public void instanceRemoved(final CacheManagerInstance cmi) {
            cmi.removeCacheManagerInstanceListener(EhcacheRuntimeStatsPanel.this.cacheModelInstanceListener);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClientNode clientNode = EhcacheRuntimeStatsPanel.this.clientNode(cmi);
                    if (clientNode != null) {
                        clientNode.tearDownChildren();
                    }
                }
            });
        }
    }
}

