/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.AbstractClusterListener;
import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.BasicWorker;
import com.tc.admin.common.PagedView;
import com.tc.admin.common.XComboBox;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.model.IClusterModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.terracotta.modules.configuration.Presentation;
import org.terracotta.modules.ehcache.presentation.CacheManagerPanel;
import org.terracotta.modules.ehcache.presentation.EhcacheResourceBundle;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceListener;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.EhcacheModel;
import org.terracotta.modules.ehcache.presentation.model.EhcacheModelListener;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

public class EhcachePresentationPanel
extends Presentation
implements EhcacheModelListener {
    private ApplicationContext appContext;
    private IClusterModel clusterModel;
    private ClusterListener clusterListener;
    private EhcacheModel ehcacheModel;
    private XContainer mainPanel;
    private XComboBox cacheManagerSelector;
    private XLabel summaryLabel;
    private XContainer messagePanel;
    private XLabel messageLabel;
    private PagedView pagedView;
    private MyListener myListener;
    private static final ResourceBundle bundle = ResourceBundle.getBundle(EhcacheResourceBundle.class.getName());
    private static final Icon icon;
    private final AtomicBoolean tornDown = new AtomicBoolean(false);

    private synchronized IClusterModel getClusterModel() {
        return this.clusterModel;
    }

    public void setup(ApplicationContext appContext, IClusterModel clusterModel) {
        this.appContext = appContext;
        this.clusterModel = clusterModel;
        this.ehcacheModel = new EhcacheModel(clusterModel);
        this.ehcacheModel.addEhcacheModelListener(this);
        this.myListener = new MyListener();
        this.setup();
    }

    public void startup() {
        this.appContext.submit((Runnable)((Object)new StartupWorker()));
    }

    public Icon getIcon() {
        return icon;
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new XContainer((LayoutManager)new BorderLayout());
        XContainer topPanel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        XLabel headerLabel = new XLabel(bundle.getString("cache.manager"));
        topPanel.add((Component)headerLabel, (Object)gbc);
        headerLabel.setFont((Font)this.appContext.getObject("header.label.font"));
        ++gbc.gridx;
        gbc.ipadx = 10;
        this.cacheManagerSelector = new XComboBox();
        topPanel.add((Component)this.cacheManagerSelector, (Object)gbc);
        this.cacheManagerSelector.addItemListener((ItemListener)new CacheManagerSelectionListener());
        ++gbc.gridx;
        this.summaryLabel = new XLabel();
        topPanel.add((Component)this.summaryLabel, (Object)gbc);
        ++gbc.gridx;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        topPanel.add((Component)new XLabel(), (Object)gbc);
        ++gbc.gridx;
        this.mainPanel.add((Component)topPanel, (Object)"North");
        this.pagedView = new PagedView();
        this.mainPanel.add((Component)this.pagedView, (Object)"Center");
        this.messagePanel = new XContainer((LayoutManager)new BorderLayout());
        this.messageLabel = new XLabel();
        this.messagePanel.add((Component)this.messageLabel);
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setFont((Font)this.appContext.getObject("message.label.font"));
        this.messageLabel.setText(this.appContext.getString("cluster.not.ready.msg"));
    }

    private void init() {
        this.removeAll();
        this.cacheManagerSelector.removeAllItems();
        String[] cacheManagerNames = this.ehcacheModel.getCacheManagerNames();
        if (cacheManagerNames != null && cacheManagerNames.length > 0) {
            this.add((Component)this.mainPanel, "Center");
            for (String cacheManagerName : cacheManagerNames) {
                this.cacheManagerSelector.addItem((Object)cacheManagerName);
            }
            this.addModelListeners(this.ehcacheModel.getCacheManagerModel(cacheManagerNames[0]));
            this.handleSummaryText();
            this.firePropertyChange("presentationReady", false, true);
        } else {
            this.messageLabel.setText(bundle.getString("no.cache-managers.msg"));
            this.add((Component)this.messagePanel);
        }
        this.revalidate();
        this.repaint();
    }

    private void suspend() {
        this.removeAll();
        this.cacheManagerSelector.removeAllItems();
        this.messageLabel.setText(this.appContext.getString("cluster.not.ready.msg"));
        this.add((Component)this.messagePanel);
        this.revalidate();
        this.repaint();
    }

    private void addModelListeners(CacheManagerModel cacheManagerModel) {
        if (cacheManagerModel != null) {
            cacheManagerModel.addCacheManagerModelListener(this.myListener);
            Iterator<CacheManagerInstance> iter = cacheManagerModel.cacheManagerInstanceIterator();
            while (iter.hasNext()) {
                iter.next().addCacheManagerInstanceListener(this.myListener);
            }
        }
    }

    private void removeModelListeners(CacheManagerModel cacheManagerModel) {
        if (cacheManagerModel != null) {
            cacheManagerModel.removeCacheManagerModelListener(this.myListener);
            Iterator<CacheManagerInstance> iter = cacheManagerModel.cacheManagerInstanceIterator();
            while (iter.hasNext()) {
                iter.next().removeCacheManagerInstanceListener(this.myListener);
            }
        }
    }

    private CacheManagerModel getSelection() {
        String cacheManagerName = (String)this.cacheManagerSelector.getSelectedItem();
        return cacheManagerName != null ? this.ehcacheModel.getCacheManagerModel(cacheManagerName) : null;
    }

    private void handleSummaryText() {
        CacheManagerModel cacheManagerModel = this.getSelection();
        if (cacheManagerModel != null) {
            int cacheModelInstanceCount = cacheManagerModel.getCacheModelInstanceCount();
            String summary = MessageFormat.format(bundle.getString("cache-manager.residence.summary"), cacheManagerModel.getInstanceCount(), cacheModelInstanceCount);
            this.summaryLabel.setText(summary);
        }
    }

    private void testAnyCacheManagers() {
        boolean changedHierarchy = false;
        DefaultComboBoxModel puModel = (DefaultComboBoxModel)this.cacheManagerSelector.getModel();
        if (puModel.getSize() == 0) {
            if (this.mainPanel.getParent() != null) {
                this.removeAll();
            }
            this.messageLabel.setText(bundle.getString("no.cache-managers.msg"));
            if (this.messagePanel.getParent() == null) {
                this.add((Component)this.messagePanel);
                changedHierarchy = true;
            }
        } else {
            if (this.messagePanel.getParent() != null) {
                this.removeAll();
            }
            if (this.mainPanel.getParent() == null) {
                this.add((Component)this.mainPanel);
                changedHierarchy = true;
            }
        }
        if (changedHierarchy) {
            this.revalidate();
            this.repaint();
        }
    }

    public void cacheManagerModelAdded(final CacheManagerModel cacheManagerModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (EhcachePresentationPanel.this.tornDown.get()) {
                    return;
                }
                String cacheManagerName = cacheManagerModel.getName();
                DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)EhcachePresentationPanel.this.cacheManagerSelector.getModel();
                if (comboBoxModel.getIndexOf(cacheManagerName) == -1) {
                    comboBoxModel.addElement(cacheManagerName);
                    EhcachePresentationPanel.this.appContext.setStatus("Added Ehcache CacheManager '" + cacheManagerName + "'");
                    EhcachePresentationPanel.this.testAnyCacheManagers();
                    if (EhcachePresentationPanel.this.cacheManagerSelector.getItemCount() == 1) {
                        EhcachePresentationPanel.this.firePropertyChange("presentationReady", false, true);
                    }
                    EhcachePresentationPanel.this.addModelListeners(cacheManagerModel);
                }
            }
        });
    }

    public void cacheManagerModelRemoved(final CacheManagerModel cacheManagerModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (EhcachePresentationPanel.this.tornDown.get()) {
                    return;
                }
                String cacheManagerName = cacheManagerModel.getName();
                DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)EhcachePresentationPanel.this.cacheManagerSelector.getModel();
                int index = comboBoxModel.getIndexOf(cacheManagerName);
                if (index != -1) {
                    CacheManagerPanel page = (CacheManagerPanel)((Object)EhcachePresentationPanel.this.pagedView.getPage(cacheManagerName));
                    if (page != null) {
                        EhcachePresentationPanel.this.pagedView.removePage(cacheManagerName);
                        page.tearDown();
                    }
                    comboBoxModel.removeElementAt(index);
                    EhcachePresentationPanel.this.appContext.setStatus("Removed Ehcache CacheManager '" + cacheManagerName + "'");
                    EhcachePresentationPanel.this.testAnyCacheManagers();
                    if (EhcachePresentationPanel.this.cacheManagerSelector.getItemCount() == 0) {
                        EhcachePresentationPanel.this.firePropertyChange("presentationReady", true, false);
                    }
                    EhcachePresentationPanel.this.removeModelListeners(cacheManagerModel);
                }
            }
        });
    }

    public boolean isReady() {
        return this.cacheManagerSelector != null && this.cacheManagerSelector.getItemCount() > 0;
    }

    public void tearDown() {
        if (!this.tornDown.compareAndSet(false, true)) {
            return;
        }
        if (this.pagedView != null) {
            String currentPage = this.pagedView.getPage();
            if (currentPage != null && this.ehcacheModel != null) {
                this.removeModelListeners(this.ehcacheModel.getCacheManagerModel(currentPage));
            }
            if (this.mainPanel != null) {
                this.mainPanel.tearDown();
            }
        }
        if (this.ehcacheModel != null) {
            this.ehcacheModel.removeEhcacheModelListener(this);
            if (this.clusterListener != null) {
                if (this.clusterModel != null) {
                    this.clusterModel.removePropertyChangeListener((PropertyChangeListener)((Object)this.clusterListener));
                }
                this.clusterListener.tearDown();
            }
            this.ehcacheModel.tearDown();
        }
        this.removeAll();
    }

    static {
        try {
            icon = new ImageIcon(EhcachePresentationPanel.class.getResource("ehcache.png"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class MyListener
    implements CacheManagerModelListener,
    CacheManagerInstanceListener,
    Runnable {
        private MyListener() {
        }

        public void cacheModelAdded(CacheModel cacheModel) {
        }

        public void cacheModelChanged(CacheModel cacheModel) {
        }

        public void cacheModelRemoved(CacheModel cacheModel) {
        }

        public void clusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
        }

        public void clusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
        }

        public void clusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
        }

        public void standaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
        }

        public void standaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
        }

        public void standaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
        }

        public void instanceAdded(CacheManagerInstance instance) {
            SwingUtilities.invokeLater(this);
        }

        public void instanceRemoved(CacheManagerInstance instance) {
            SwingUtilities.invokeLater(this);
        }

        public void cacheManagerInstanceChanged(CacheManagerInstance cacheManagerInstance) {
        }

        public void cacheModelInstanceAdded(CacheModelInstance cacheModelInstance) {
            SwingUtilities.invokeLater(this);
        }

        public void cacheModelInstanceChanged(CacheModelInstance cacheModelInstance) {
        }

        public void cacheModelInstanceRemoved(CacheModelInstance cacheModelInstance) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (!EhcachePresentationPanel.this.tornDown.get()) {
                EhcachePresentationPanel.this.handleSummaryText();
            }
        }
    }

    private class CacheManagerSelectionListener
    implements ItemListener {
        private CacheManagerSelectionListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            String cacheManagerName;
            IClusterModel theClusterModel = EhcachePresentationPanel.this.getClusterModel();
            if (theClusterModel == null) {
                return;
            }
            String currentPage = EhcachePresentationPanel.this.pagedView.getPage();
            if (currentPage != null) {
                EhcachePresentationPanel.this.removeModelListeners(EhcachePresentationPanel.this.ehcacheModel.getCacheManagerModel(currentPage));
            }
            if ((cacheManagerName = (String)EhcachePresentationPanel.this.cacheManagerSelector.getSelectedItem()) != null) {
                CacheManagerPanel cacheManagerPage;
                if (!EhcachePresentationPanel.this.pagedView.hasPage(cacheManagerName)) {
                    cacheManagerPage = new CacheManagerPanel(EhcachePresentationPanel.this.appContext, EhcachePresentationPanel.this.ehcacheModel.getCacheManagerModel(cacheManagerName));
                    cacheManagerPage.setName(cacheManagerName);
                    EhcachePresentationPanel.this.pagedView.addPage((Component)((Object)cacheManagerPage));
                    cacheManagerPage.setup();
                } else {
                    cacheManagerPage = (CacheManagerPanel)((Object)EhcachePresentationPanel.this.pagedView.getPage(cacheManagerName));
                }
                EhcachePresentationPanel.this.pagedView.setPage(cacheManagerName);
                if (cacheManagerPage != null) {
                    EhcachePresentationPanel.this.addModelListeners(cacheManagerPage.getCacheManagerModel());
                }
                EhcachePresentationPanel.this.handleSummaryText();
            }
        }
    }

    private class ClusterListener
    extends AbstractClusterListener {
        private ClusterListener(IClusterModel clusterModel) {
            super(clusterModel);
        }

        protected void handleReady() {
            if (EhcachePresentationPanel.this.tornDown.get()) {
                return;
            }
            if (this.clusterModel.isReady()) {
                EhcachePresentationPanel.this.init();
            } else {
                EhcachePresentationPanel.this.suspend();
            }
        }

        protected void handleUncaughtError(Exception e) {
            if (EhcachePresentationPanel.this.appContext != null) {
                EhcachePresentationPanel.this.appContext.log((Throwable)e);
            } else {
                super.handleUncaughtError(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartupWorker
    extends BasicWorker<Void> {
        private StartupWorker() {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    EhcachePresentationPanel.this.ehcacheModel.startup();
                    return null;
                }
            });
        }

        protected void finished() {
            Exception e = this.getException();
            if (e != null) {
                EhcachePresentationPanel.this.appContext.log((Throwable)e);
            }
            EhcachePresentationPanel.this.clusterModel.addPropertyChangeListener((PropertyChangeListener)((Object)(EhcachePresentationPanel.this.clusterListener = new ClusterListener(EhcachePresentationPanel.this.clusterModel))));
            if (EhcachePresentationPanel.this.clusterModel.isReady()) {
                EhcachePresentationPanel.this.init();
            }
        }
    }
}

