/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.StatusView;
import com.tc.admin.common.XButton;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.terracotta.modules.ehcache.presentation.AggregateVuMeterPanel;
import org.terracotta.modules.ehcache.presentation.BaseClusterModelPanel;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.ManageStatisticsMessage;
import org.terracotta.modules.ehcache.presentation.QueryForStatsMessage;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceListener;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

public class EhcachePerformancePanel
extends BaseClusterModelPanel
implements CacheManagerModelListener,
CacheManagerInstanceListener,
HierarchyListener {
    private final CacheManagerModel cacheManagerModel;
    private XLabel summaryLabel;
    private final ManageStatisticsAction manageStatsAction;
    private XButton manageStatsButton;
    private final QueryForStatsMessage queryForStatsMessage;
    private final AggregateVuMeterPanel vuMeterGlobalPanel;
    private final AggregateVuMeterPanel vuMeterPerCachePanel;

    public EhcachePerformancePanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        super(appContext, cacheManagerModel.getClusterModel());
        this.cacheManagerModel = cacheManagerModel;
        this.vuMeterGlobalPanel = new AggregateVuMeterPanel(appContext, cacheManagerModel, true);
        this.vuMeterGlobalPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("global.cache.performance")));
        this.vuMeterPerCachePanel = new AggregateVuMeterPanel(appContext, cacheManagerModel, false);
        this.vuMeterPerCachePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("per-cache.performance")));
        this.manageStatsAction = new ManageStatisticsAction();
        this.addHierarchyListener(this);
        this.queryForStatsMessage = new QueryForStatsMessage(this.manageStatsAction);
    }

    public void setup() {
        this.cacheManagerModel.addCacheManagerModelListener(this);
        super.setup();
        this.revalidate();
        this.repaint();
    }

    protected void init() {
        this.vuMeterGlobalPanel.setup();
        this.vuMeterPerCachePanel.setup();
        Iterator<CacheManagerInstance> iter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            iter.next().addCacheManagerInstanceListener(this);
        }
        this.handleSummaryText();
    }

    protected XContainer createMainPanel() {
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)this.createSummaryPanel(), (Object)gbc);
        ++gbc.gridy;
        panel.add((Component)this.createLegend(), (Object)gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(1, 1, 1, 1);
        panel.add((Component)((Object)this.vuMeterGlobalPanel), (Object)gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)((Object)this.vuMeterPerCachePanel), (Object)gbc);
        return panel;
    }

    private XContainer createSummaryPanel() {
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.summaryLabel = new XLabel();
        panel.add((Component)this.summaryLabel, (Object)gbc);
        this.summaryLabel.setIcon(EhcachePresentationUtils.ALERT_ICON);
        ++gbc.gridx;
        this.manageStatsButton = new XButton("Manage Statistics...");
        panel.add((Component)this.manageStatsButton, (Object)gbc);
        this.manageStatsButton.addActionListener((ActionListener)this.manageStatsAction);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)new XLabel(), (Object)gbc);
        return panel;
    }

    private XContainer createLegend() {
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 1, 0, 1);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        XLabel label = new XLabel(bundle.getString("current.value"));
        panel.add((Component)label, (Object)gbc);
        label.setHorizontalAlignment(2);
        ++gbc.gridx;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        StatusView sv = new StatusView();
        panel.add((Component)sv, (Object)gbc);
        sv.setIndicator(EhcachePresentationUtils.HIT_FILL_COLOR);
        sv.setText(bundle.getString("hits"));
        ++gbc.gridx;
        sv = new StatusView();
        panel.add((Component)sv, (Object)gbc);
        sv.setIndicator(EhcachePresentationUtils.MISS_FILL_COLOR);
        sv.setText(bundle.getString("misses"));
        ++gbc.gridx;
        sv = new StatusView();
        panel.add((Component)sv, (Object)gbc);
        sv.setIndicator(EhcachePresentationUtils.PUT_FILL_COLOR);
        sv.setText(bundle.getString("puts"));
        ++gbc.gridx;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        label = new XLabel(bundle.getString("local.maximum.value"));
        panel.add((Component)label, (Object)gbc);
        label.setHorizontalAlignment(4);
        return panel;
    }

    private void handleSummaryText() {
        String text = null;
        Icon icon = null;
        int statsEnabledCount = this.cacheManagerModel.getStatisticsEnabledCount();
        int instanceCount = this.cacheManagerModel.getInstanceCount();
        if (instanceCount > 0 && statsEnabledCount == 0) {
            text = "No cache instances have statistics enabled.";
            icon = EhcachePresentationUtils.ALERT_ICON;
        } else if (statsEnabledCount < instanceCount) {
            text = MessageFormat.format("Statistics enabled on {0} of {1} cache instances.", statsEnabledCount, instanceCount);
            icon = EhcachePresentationUtils.WARN_ICON;
        }
        this.summaryLabel.setText(text);
        this.summaryLabel.setIcon(icon);
        this.summaryLabel.setVisible(text != null);
        this.manageStatsButton.setVisible(text != null);
    }

    private void handleSummaryTextLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EhcachePerformancePanel.this.handleSummaryText();
            }
        });
    }

    public void instanceAdded(CacheManagerInstance instance) {
        instance.addCacheManagerInstanceListener(this);
        this.handleSummaryTextLater();
    }

    public void instanceRemoved(CacheManagerInstance instance) {
        instance.removeCacheManagerInstanceListener(this);
        this.handleSummaryTextLater();
    }

    public void cacheModelAdded(CacheModel cacheModel) {
    }

    public void cacheModelRemoved(CacheModel cacheModel) {
    }

    public void cacheModelChanged(CacheModel cacheModel) {
    }

    public void clusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
    }

    public void clusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
    }

    public void clusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
    }

    public void standaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
    }

    public void standaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
    }

    public void standaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
    }

    public void cacheManagerInstanceChanged(CacheManagerInstance cacheManagerInstance) {
    }

    public void cacheModelInstanceAdded(CacheModelInstance cacheModelInstance) {
        this.handleSummaryTextLater();
    }

    public void cacheModelInstanceChanged(CacheModelInstance cacheModelInstance) {
        this.handleSummaryTextLater();
    }

    public void cacheModelInstanceRemoved(CacheModelInstance cacheModelInstance) {
        this.handleSummaryTextLater();
    }

    private void testDismissQueryForStatsMessage() {
        JDialog queryForStatsDialog;
        if (this.queryForStatsMessage.isShowing() && (queryForStatsDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, (Component)((Object)this.queryForStatsMessage))) != null) {
            queryForStatsDialog.setVisible(false);
        }
    }

    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing() && this.cacheManagerModel.getStatisticsEnabledCount() < this.cacheManagerModel.getCacheModelInstanceCount() && this.queryForStatsMessage.shouldShowAgain()) {
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)this));
            int answer = JOptionPane.showConfirmDialog((Component)((Object)this), this.queryForStatsMessage, frame.getTitle(), 0);
            if (answer == 0) {
                this.cacheManagerModel.setStatisticsEnabled(true, true);
            }
            if (!this.queryForStatsMessage.shouldShowAgain()) {
                this.removeHierarchyListener(this);
            }
        }
    }

    public void tearDown() {
        this.cacheManagerModel.removeCacheManagerModelListener(this);
        Iterator<CacheManagerInstance> iter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            iter.next().removeCacheManagerInstanceListener(this);
        }
        super.tearDown();
    }

    private class ManageStatisticsAction
    extends AbstractAction {
        private ManageStatisticsAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            EhcachePerformancePanel c = EhcachePerformancePanel.this;
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)c));
            ManageStatisticsMessage msg = new ManageStatisticsMessage(frame, EhcachePerformancePanel.this.appContext, EhcachePerformancePanel.this.cacheManagerModel);
            int result = JOptionPane.showConfirmDialog((Component)((Object)c), msg, msg.getTitle(), 2);
            if (result == 0) {
                Boolean toNewcomers = null;
                if (msg.hasApplyToNewcomersToggle()) {
                    toNewcomers = msg.shouldApplyToNewcomers();
                }
                msg.apply(toNewcomers);
                EhcachePerformancePanel.this.testDismissQueryForStatsMessage();
            }
            msg.tearDown();
        }
    }
}

