/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.WindowHelper;
import com.tc.admin.common.XButton;
import com.tc.admin.common.XContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.terracotta.modules.ehcache.presentation.BaseClusterModelPanel;
import org.terracotta.modules.ehcache.presentation.CacheModelMessage;
import org.terracotta.modules.ehcache.presentation.ManageBulkLoadingMessage;
import org.terracotta.modules.ehcache.presentation.ManageContentsMessage;
import org.terracotta.modules.ehcache.presentation.ManageEnablementMessage;
import org.terracotta.modules.ehcache.presentation.ManageMessage;
import org.terracotta.modules.ehcache.presentation.ManageStatisticsMessage;
import org.terracotta.modules.ehcache.presentation.TopologyPanel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceListener;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

public class EhcacheOverviewPanel
extends BaseClusterModelPanel
implements CacheManagerModelListener,
CacheManagerInstanceListener {
    private final CacheManagerModel cacheManagerModel;
    private TopologyPanel topologyPanel;
    private ManageMessage currentManageMessage;

    public EhcacheOverviewPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        super(appContext, cacheManagerModel.getClusterModel());
        this.cacheManagerModel = cacheManagerModel;
    }

    public void setup() {
        this.cacheManagerModel.addCacheManagerModelListener(this);
        super.setup();
        this.revalidate();
        this.repaint();
    }

    protected void init() {
        this.topologyPanel.setup();
        Iterator<CacheManagerInstance> iter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            iter.next().addCacheManagerInstanceListener(this);
        }
    }

    protected XContainer createMainPanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        panel.add((Component)this.createAltToolBar(), (Object)"North");
        panel.add((Component)this.createTopologyPanel(), (Object)"Center");
        return panel;
    }

    public JComponent createAltToolBar() {
        XContainer panel = new XContainer((LayoutManager)new FlowLayout(1, 1, 3));
        panel.add((Component)new XButton((Action)new ManageEnablementAction()));
        panel.add((Component)new XButton((Action)new ManageBulkLoadAction()));
        panel.add((Component)new XButton((Action)new ManageStatisticsAction()));
        panel.add((Component)new XButton((Action)new ManageContentsAction()));
        panel.add((Component)new XButton((Action)new ManageSettingsAction2()));
        return panel;
    }

    private XContainer createTopologyPanel() {
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.topologyPanel = new TopologyPanel(this.appContext, this.cacheManagerModel);
        panel.add((Component)((Object)this.topologyPanel), (Object)gbc);
        return panel;
    }

    protected CacheManagerModel getCacheManagerModel() {
        return this.cacheManagerModel;
    }

    public void instanceAdded(CacheManagerInstance instance) {
        instance.addCacheManagerInstanceListener(this);
    }

    public void instanceRemoved(CacheManagerInstance instance) {
        instance.removeCacheManagerInstanceListener(this);
    }

    public void cacheModelAdded(final CacheModel cacheModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EhcacheOverviewPanel.this.setStatus(MessageFormat.format(BaseClusterModelPanel.bundle.getString("overview.cacheModelAdded"), cacheModel.getCacheName(), EhcacheOverviewPanel.this.cacheManagerModel.getName()));
            }
        });
    }

    public void cacheModelRemoved(final CacheModel cacheModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EhcacheOverviewPanel.this.setStatus(MessageFormat.format(BaseClusterModelPanel.bundle.getString("overview.cacheModelRemoved"), cacheModel.getCacheName(), EhcacheOverviewPanel.this.cacheManagerModel.getName()));
            }
        });
    }

    public void cacheModelChanged(final CacheModel cacheModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EhcacheOverviewPanel.this.setStatus(MessageFormat.format(BaseClusterModelPanel.bundle.getString("overview.cacheModelChanged"), cacheModel.getCacheName(), EhcacheOverviewPanel.this.cacheManagerModel.getName()));
            }
        });
    }

    public void clusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
    }

    public void clusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
    }

    public void clusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
    }

    public void standaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
    }

    public void standaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
    }

    public void standaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
    }

    public void cacheManagerInstanceChanged(CacheManagerInstance cacheManagerInstance) {
    }

    public void cacheModelInstanceAdded(CacheModelInstance cacheModelInstance) {
    }

    public void cacheModelInstanceChanged(CacheModelInstance cacheModelInstance) {
    }

    public void cacheModelInstanceRemoved(CacheModelInstance cacheModelInstance) {
    }

    public void tearDown() {
        JDialog dialog;
        if (this.currentManageMessage != null && (dialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, (Component)((Object)this.currentManageMessage))) != null) {
            dialog.setVisible(false);
        }
        this.cacheManagerModel.removeCacheManagerModelListener(this);
        Iterator<CacheManagerInstance> iter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            iter.next().removeCacheManagerInstanceListener(this);
        }
        super.tearDown();
    }

    private class ManageSettingsAction2
    extends AbstractAction {
        private ManageSettingsAction2() {
            super(BaseClusterModelPanel.bundle.getString("Cache Configuration..."));
        }

        private CacheModelMessage createMessage() {
            return new CacheModelMessage(EhcacheOverviewPanel.this.getCacheManagerModel());
        }

        public void actionPerformed(ActionEvent ae) {
            EhcacheOverviewPanel c = EhcacheOverviewPanel.this;
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)c));
            final CacheModelMessage msg = this.createMessage();
            String applyLabel = "Apply";
            String closeLabel = "Close";
            final JOptionPane optionPane = new JOptionPane(msg, -1, -1, null, new String[]{"Apply", "Close"}, "Apply");
            final JDialog dialog = new JDialog(frame, BaseClusterModelPanel.bundle.getString("Manage Cache Configuration"), true);
            dialog.setContentPane(optionPane);
            dialog.setDefaultCloseOperation(0);
            dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent we) {
                    if (msg.canClose()) {
                        dialog.setVisible(false);
                    }
                }
            });
            optionPane.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    String newValue = e.getNewValue().toString();
                    if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                        if ("Close".equals(newValue) && msg.canClose()) {
                            dialog.setVisible(false);
                        } else if ("Apply".equals(newValue)) {
                            msg.apply();
                        }
                    }
                    if (dialog.isVisible()) {
                        optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    }
                }
            });
            dialog.pack();
            WindowHelper.center((Window)dialog, (Component)((Object)c));
            dialog.setVisible(true);
            msg.tearDown();
        }
    }

    private class ManageContentsAction
    extends AbstractManageAction {
        private ManageContentsAction() {
            super(BaseClusterModelPanel.bundle.getString("Clear Cache Contents..."));
        }

        protected ManageMessage createMessage() {
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)EhcacheOverviewPanel.this));
            return new ManageContentsMessage(frame, EhcacheOverviewPanel.this.appContext, EhcacheOverviewPanel.this.cacheManagerModel, EhcacheOverviewPanel.this.topologyPanel.getMode());
        }
    }

    private class ManageBulkLoadAction
    extends AbstractManageAction {
        private ManageBulkLoadAction() {
            super(BaseClusterModelPanel.bundle.getString("Cache BulkLoading..."));
        }

        protected ManageMessage createMessage() {
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)EhcacheOverviewPanel.this));
            return new ManageBulkLoadingMessage(frame, EhcacheOverviewPanel.this.appContext, EhcacheOverviewPanel.this.cacheManagerModel, EhcacheOverviewPanel.this.topologyPanel.getMode());
        }
    }

    private class ManageStatisticsAction
    extends AbstractManageAction {
        private ManageStatisticsAction() {
            super(BaseClusterModelPanel.bundle.getString("Cache Statistics..."));
        }

        protected ManageMessage createMessage() {
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)EhcacheOverviewPanel.this));
            return new ManageStatisticsMessage(frame, EhcacheOverviewPanel.this.appContext, EhcacheOverviewPanel.this.cacheManagerModel, EhcacheOverviewPanel.this.topologyPanel.getMode());
        }
    }

    private class ManageEnablementAction
    extends AbstractManageAction {
        private ManageEnablementAction() {
            super(BaseClusterModelPanel.bundle.getString("Manage Active Caches..."));
        }

        protected ManageMessage createMessage() {
            Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)EhcacheOverviewPanel.this));
            return new ManageEnablementMessage(frame, EhcacheOverviewPanel.this.appContext, EhcacheOverviewPanel.this.cacheManagerModel, EhcacheOverviewPanel.this.topologyPanel.getMode());
        }
    }

    private abstract class AbstractManageAction
    extends AbstractAction {
        protected AbstractManageAction(String name) {
            super(name);
        }

        protected abstract ManageMessage createMessage();

        public void actionPerformed(ActionEvent ae) {
            EhcacheOverviewPanel c = EhcacheOverviewPanel.this;
            EhcacheOverviewPanel.this.currentManageMessage = this.createMessage();
            boolean yesLast = UIManager.getBoolean("OptionPane.isYesLast");
            final String applyLabel = EhcacheOverviewPanel.this.currentManageMessage.createApplyLabel();
            String cancelLabel = UIManager.getString((Object)"OptionPane.cancelButtonText", ((Component)((Object)c)).getLocale());
            String defaultOption = applyLabel;
            Object[] options = yesLast ? new String[]{cancelLabel, applyLabel} : new String[]{applyLabel, cancelLabel};
            final Object[] theOptions = options;
            final int result = JOptionPane.showOptionDialog((Component)((Object)c), EhcacheOverviewPanel.this.currentManageMessage, EhcacheOverviewPanel.this.currentManageMessage.getTitle(), -1, -1, null, options, defaultOption);
            if (EhcacheOverviewPanel.this.currentManageMessage != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (result != -1 && theOptions[result].equals(applyLabel)) {
                            Boolean toNewcomers = null;
                            if (EhcacheOverviewPanel.this.currentManageMessage.hasApplyToNewcomersToggle()) {
                                toNewcomers = EhcacheOverviewPanel.this.currentManageMessage.shouldApplyToNewcomers();
                            }
                            EhcacheOverviewPanel.this.currentManageMessage.apply(toNewcomers);
                        }
                        EhcacheOverviewPanel.this.currentManageMessage.tearDown();
                        EhcacheOverviewPanel.this.currentManageMessage = null;
                    }
                });
            }
        }
    }
}

