/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.BasicWorker;
import com.tc.admin.common.ExceptionHelper;
import com.tc.admin.common.XButton;
import com.tc.admin.common.XCheckBox;
import com.tc.admin.common.XComboBox;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XScrollPane;
import com.tc.admin.common.XTable;
import com.tc.admin.common.XTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.terracotta.modules.ehcache.presentation.BaseClusterModelPanel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

public class EhcacheContentsPanel
extends BaseClusterModelPanel
implements CacheManagerModelListener,
ClipboardOwner {
    private final CacheManagerModel cacheManagerModel;
    private XComboBox clusteredCacheSelector;
    private XButton searchButton;
    private XTextField searchField;
    private XLabel contentsHeader;
    private XContainer resultsPanel;
    private XTable resultsTable;
    private XContainer topPanel;
    private XContainer clusteredPanel;
    private XContainer standalonePanel;
    private XComboBox cacheManagerInstanceSelector;
    private XComboBox standaloneCacheSelector;
    private XCheckBox clusteredCacheToggle;
    private XCheckBox standaloneCacheToggle;
    private Object clusteredConstraint;
    private Object standaloneConstraint;
    private static final TableModel EMPTY_TABLE_MODEL = new DefaultTableModel();
    private static final Icon WAIT_ICON = new ImageIcon(EhcacheContentsPanel.class.getResource("/com/tc/admin/icons/wait.gif"));
    private static final Icon EMPTY_WAIT_ICON = new ImageIcon(EhcacheContentsPanel.class.getResource("/com/tc/admin/icons/transparent16x16.png"));

    public EhcacheContentsPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel) {
        super(appContext, cacheManagerModel.getClusterModel());
        this.cacheManagerModel = cacheManagerModel;
    }

    protected void init() {
        DefaultComboBoxModel<ClusteredCacheModel> comboModel = new DefaultComboBoxModel<ClusteredCacheModel>();
        for (ClusteredCacheModel cacheModel : this.cacheManagerModel.clusteredCacheModels()) {
            comboModel.addElement(cacheModel);
        }
        this.clusteredCacheSelector.setModel(comboModel);
        this.updateCacheManagerSelector();
        this.evaluateVisibility();
        this.cacheManagerModel.addCacheManagerModelListener(this);
    }

    private void updateCacheManagerSelector() {
        int selIndex = this.cacheManagerInstanceSelector.getSelectedIndex();
        Map<CacheModelInstance, StandaloneCacheModel> standaloneCacheModels = this.cacheManagerModel.standaloneCacheModels();
        HashSet<CacheManagerInstance> cmis = new HashSet<CacheManagerInstance>();
        for (CacheModelInstance cacheModelInstance : standaloneCacheModels.keySet()) {
            cmis.add(cacheModelInstance.getCacheManagerInstance());
        }
        this.cacheManagerInstanceSelector.setModel(new DefaultComboBoxModel<CacheManagerInstance>(cmis.toArray(new CacheManagerInstance[0])));
        if (selIndex != -1 && selIndex < this.cacheManagerInstanceSelector.getItemCount()) {
            this.cacheManagerInstanceSelector.setSelectedIndex(selIndex);
        }
    }

    private void evaluateVisibility() {
        boolean haveStandalone;
        boolean haveClustered;
        Set<ClusteredCacheModel> clusteredCacheModels = this.cacheManagerModel.clusteredCacheModels();
        boolean bl = haveClustered = clusteredCacheModels.size() > 0;
        if (haveClustered && this.clusteredPanel.getParent() == null) {
            this.topPanel.add((Component)this.clusteredPanel, this.clusteredConstraint);
        } else if (!haveClustered && this.clusteredPanel.getParent() != null) {
            this.topPanel.remove((Component)this.clusteredPanel);
        }
        Map<CacheModelInstance, StandaloneCacheModel> standaloneCacheModels = this.cacheManagerModel.standaloneCacheModels();
        boolean bl2 = haveStandalone = standaloneCacheModels.size() > 0;
        if (haveStandalone && this.standalonePanel.getParent() == null) {
            this.topPanel.add((Component)this.standalonePanel, this.standaloneConstraint);
            this.cacheManagerInstanceSelector.setSelectedIndex(0);
        } else if (!haveStandalone && this.standalonePanel.getParent() != null) {
            this.topPanel.remove((Component)this.standalonePanel);
        }
        if (haveClustered) {
            this.setClusteredCachesEnabled(true);
        } else if (haveStandalone) {
            this.setStandaloneCachesEnabled(true);
        }
        this.topPanel.revalidate();
        this.topPanel.repaint();
    }

    private void setClusteredCachesEnabled(boolean enabled) {
        this.clusteredCacheToggle.setSelected(enabled);
        this.clusteredCacheSelector.setEnabled(enabled);
        this.standaloneCacheToggle.setSelected(!enabled);
        this.cacheManagerInstanceSelector.setEnabled(!enabled);
        this.standaloneCacheSelector.setEnabled(!enabled);
    }

    private void setStandaloneCachesEnabled(boolean enabled) {
        this.standaloneCacheToggle.setSelected(enabled);
        this.cacheManagerInstanceSelector.setEnabled(enabled);
        this.standaloneCacheSelector.setEnabled(enabled);
        this.clusteredCacheToggle.setSelected(!enabled);
        this.clusteredCacheSelector.setEnabled(!enabled);
    }

    public XContainer createMainPanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        this.topPanel = this.createTopPanel();
        panel.add((Component)this.topPanel, (Object)"North");
        panel.add((Component)this.createCenterPanel());
        return panel;
    }

    protected XContainer createClusteredPanel() {
        XContainer result = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.clusteredCacheToggle = new XCheckBox("Clustered Caches:");
        result.add((Component)this.clusteredCacheToggle, (Object)gbc);
        this.clusteredCacheToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean selected = EhcacheContentsPanel.this.clusteredCacheToggle.isSelected();
                EhcacheContentsPanel.this.clusteredCacheSelector.setEnabled(selected);
                EhcacheContentsPanel.this.standaloneCacheToggle.setSelected(!selected);
                EhcacheContentsPanel.this.cacheManagerInstanceSelector.setEnabled(!selected);
                EhcacheContentsPanel.this.standaloneCacheSelector.setEnabled(!selected);
            }
        });
        ++gbc.gridx;
        this.clusteredCacheSelector = new XComboBox();
        result.add((Component)this.clusteredCacheSelector, (Object)gbc);
        return result;
    }

    protected XContainer createStandalonePanel() {
        XContainer result = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.standaloneCacheToggle = new XCheckBox("Standalone Caches:");
        result.add((Component)this.standaloneCacheToggle, (Object)gbc);
        this.standaloneCacheToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean selected = EhcacheContentsPanel.this.standaloneCacheToggle.isSelected();
                EhcacheContentsPanel.this.cacheManagerInstanceSelector.setEnabled(selected);
                EhcacheContentsPanel.this.standaloneCacheSelector.setEnabled(selected);
                EhcacheContentsPanel.this.clusteredCacheToggle.setSelected(!selected);
                EhcacheContentsPanel.this.clusteredCacheSelector.setEnabled(!selected);
            }
        });
        ++gbc.gridx;
        this.cacheManagerInstanceSelector = new XComboBox();
        result.add((Component)this.cacheManagerInstanceSelector, (Object)gbc);
        this.cacheManagerInstanceSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashSet<StandaloneCacheModel> set = new HashSet<StandaloneCacheModel>();
                CacheManagerInstance cacheManagerInstance = (CacheManagerInstance)EhcacheContentsPanel.this.cacheManagerInstanceSelector.getSelectedItem();
                for (CacheModelInstance cacheModelInstance : cacheManagerInstance.cacheModelInstances()) {
                    StandaloneCacheModel cacheModel = EhcacheContentsPanel.this.cacheManagerModel.standaloneCacheModel(cacheModelInstance);
                    if (cacheModel == null) continue;
                    set.add(cacheModel);
                }
                DefaultComboBoxModel<StandaloneCacheModel> comboModel = new DefaultComboBoxModel<StandaloneCacheModel>(set.toArray(new StandaloneCacheModel[0]));
                EhcacheContentsPanel.this.standaloneCacheSelector.setModel(comboModel);
            }
        });
        ++gbc.gridx;
        this.standaloneCacheSelector = new XComboBox();
        result.add((Component)this.standaloneCacheSelector, (Object)gbc);
        this.standaloneCacheSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        result.add((Component)new XLabel(), (Object)gbc);
        return result;
    }

    protected XContainer createTopPanel() {
        XContainer result = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.clusteredConstraint = gbc.clone();
        ++gbc.gridx;
        this.standaloneConstraint = gbc.clone();
        this.clusteredPanel = this.createClusteredPanel();
        this.standalonePanel = this.createStandalonePanel();
        return result;
    }

    protected XContainer createCenterPanel() {
        XContainer top = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.searchButton = new XButton(bundle.getString("search"));
        top.add((Component)this.searchButton, (Object)gbc);
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EhcacheContentsPanel.this.findElements();
            }
        });
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.searchField = new XTextField();
        top.add((Component)this.searchField, (Object)gbc);
        this.searchField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EhcacheContentsPanel.this.findElements();
            }
        });
        this.resultsPanel = new XContainer((LayoutManager)new BorderLayout());
        this.resultsTable = new XTable();
        this.resultsPanel.add((Component)new XScrollPane((Component)this.resultsTable));
        EhcacheContentsPanel.trySetAutoCreateRowSorter((JTable)this.resultsTable);
        XContainer contentsPanel = new XContainer((LayoutManager)new BorderLayout());
        XContainer headerPanel = new XContainer((LayoutManager)new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.contentsHeader = new XLabel(bundle.getString("no.elements"), EMPTY_WAIT_ICON);
        headerPanel.add((Component)this.contentsHeader, (Object)gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        headerPanel.add((Component)new XLabel(), (Object)gbc);
        contentsPanel.add((Component)headerPanel, (Object)"North");
        contentsPanel.add((Component)new XScrollPane((Component)this.resultsPanel));
        XContainer result = new XContainer((LayoutManager)new BorderLayout());
        result.add((Component)top, (Object)"North");
        result.add((Component)contentsPanel, (Object)"Center");
        return result;
    }

    private static void trySetAutoCreateRowSorter(JTable table) {
        try {
            Method m = table.getClass().getMethod("setAutoCreateRowSorter", Boolean.TYPE);
            m.invoke((Object)table, Boolean.TRUE);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void findElements() {
        String query = this.searchField.getText().trim();
        if (query.length() > 0) {
            this.appContext.submit((Runnable)((Object)new ContentsRetrievalWorker(query)));
        }
    }

    private static TableModel convertTableModel(TableModel tableModel) {
        if (tableModel.getRowCount() > 0) {
            Class[] columnTypes = new Class[tableModel.getColumnCount()];
            for (int i = 0; i < columnTypes.length; ++i) {
                Object value = tableModel.getValueAt(0, i);
                columnTypes[i] = value.getClass();
            }
            return new WrappingTableModel(tableModel, columnTypes);
        }
        return tableModel;
    }

    private void updateHeader(ContentsRetrievalResult result) {
        String text;
        int returnedRows = result.data.getRowCount();
        if (returnedRows <= 0) {
            text = bundle.getString("no.elements");
        } else if ((long)returnedRows == result.totalElements) {
            text = MessageFormat.format(bundle.getString("retrieved.all.elements"), result.totalElements, result.elapsedMillis);
        } else {
            String elements = bundle.getString(returnedRows == 1 ? "element" : "elements");
            text = MessageFormat.format(bundle.getString("retrieved.some.elements"), returnedRows, elements, result.totalElements, result.elapsedMillis);
        }
        this.contentsHeader.setText(text);
        this.contentsHeader.setIcon(EMPTY_WAIT_ICON);
    }

    private void clearResults() {
        this.resultsPanel.setBorder(null);
        this.resultsTable.setModel(EMPTY_TABLE_MODEL);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void cacheModelAdded(CacheModel cacheModel) {
    }

    public void cacheModelRemoved(CacheModel cacheModel) {
    }

    public void cacheModelChanged(CacheModel cacheModel) {
    }

    private void updateClusteredCacheSelector() {
        int index = this.clusteredCacheSelector.getSelectedIndex();
        ArrayList<ClusteredCacheModel> list = new ArrayList<ClusteredCacheModel>(this.cacheManagerModel.clusteredCacheModels());
        Object[] a = list.toArray(new ClusteredCacheModel[0]);
        Arrays.sort(a);
        this.clusteredCacheSelector.setModel(new DefaultComboBoxModel<Object>(a));
        if (index != -1 && index < this.clusteredCacheSelector.getItemCount()) {
            this.clusteredCacheSelector.setSelectedIndex(index);
        }
    }

    public void clusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
        this.updateClusteredCacheSelector();
        this.evaluateVisibility();
    }

    public void clusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
        this.updateClusteredCacheSelector();
        this.evaluateVisibility();
    }

    public void clusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
    }

    public void standaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
        this.updateCacheManagerSelector();
        this.evaluateVisibility();
    }

    public void standaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
        this.updateCacheManagerSelector();
        this.evaluateVisibility();
    }

    public void standaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
    }

    public void instanceAdded(CacheManagerInstance instance) {
    }

    public void instanceRemoved(CacheManagerInstance instance) {
    }

    public void tearDown() {
        this.cacheManagerModel.removeCacheManagerModelListener(this);
        super.tearDown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrappingTableModel
    extends DefaultTableModel {
        private final Class[] columnClasses;

        WrappingTableModel(TableModel tableModel, Class[] columnClasses) {
            this.columnClasses = columnClasses;
            DefaultTableModel dtm = (DefaultTableModel)tableModel;
            Vector<String> columnIds = new Vector<String>();
            for (int i = 0; i < columnClasses.length; ++i) {
                columnIds.add(tableModel.getColumnName(i));
            }
            this.setDataVector((Vector)dtm.getDataVector().clone(), columnIds);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columnClasses[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContentsRetrievalWorker
    extends BasicWorker<ContentsRetrievalResult> {
        private ContentsRetrievalWorker(final String query) {
            super((Callable)new Callable<ContentsRetrievalResult>(){

                @Override
                public ContentsRetrievalResult call() throws Exception {
                    ContentsRetrievalResult result = null;
                    long startTime = System.currentTimeMillis();
                    if (EhcacheContentsPanel.this.clusteredCacheToggle.isSelected()) {
                        CacheModel selectedCacheModel = (CacheModel)EhcacheContentsPanel.this.clusteredCacheSelector.getSelectedItem();
                        String cacheName = selectedCacheModel.getCacheName();
                        result = new ContentsRetrievalResult();
                        result.data = EhcacheContentsPanel.this.cacheManagerModel.executeQuery(cacheName, query);
                        result.totalElements = selectedCacheModel.getSize();
                    } else {
                        StandaloneCacheModel cacheModel = (StandaloneCacheModel)EhcacheContentsPanel.this.standaloneCacheSelector.getSelectedItem();
                        result = new ContentsRetrievalResult();
                        result.data = cacheModel.executeQuery(query);
                        result.totalElements = cacheModel.getSize();
                    }
                    result.elapsedMillis = System.currentTimeMillis() - startTime;
                    return result;
                }
            });
            EhcacheContentsPanel.this.clearResults();
            EhcacheContentsPanel.this.searchButton.setEnabled(false);
            EhcacheContentsPanel.this.searchField.setEnabled(false);
            EhcacheContentsPanel.this.contentsHeader.setText("Retrieving...");
            EhcacheContentsPanel.this.contentsHeader.setIcon(WAIT_ICON);
        }

        protected void finished() {
            Exception e = this.getException();
            if (e != null) {
                Throwable cause = ExceptionHelper.getRootCause((Throwable)e);
                EhcacheContentsPanel.this.contentsHeader.setText(cause.toString());
                EhcacheContentsPanel.this.contentsHeader.setIcon(EMPTY_WAIT_ICON);
                EhcacheContentsPanel.this.showError("Retrieving search results", cause);
                EhcacheContentsPanel.this.appContext.log(cause);
            } else {
                ContentsRetrievalResult result = (ContentsRetrievalResult)this.getResult();
                EhcacheContentsPanel.this.resultsTable.setModel(EhcacheContentsPanel.convertTableModel(result.data));
                EhcacheContentsPanel.this.updateHeader(result);
            }
            EhcacheContentsPanel.this.searchButton.setEnabled(true);
            EhcacheContentsPanel.this.searchField.setEnabled(true);
        }
    }

    private static class ContentsRetrievalResult {
        TableModel data;
        long totalElements;
        long elapsedMillis;

        private ContentsRetrievalResult() {
        }
    }
}

