/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.XButton;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.model.IClient;
import com.tc.admin.model.IClusterNode;
import com.tc.admin.model.PolledAttributeListener;
import com.tc.admin.model.PolledAttributesResult;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.management.ObjectName;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.terracotta.modules.ehcache.presentation.BaseEhcacheStatsChartPanel;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.ManageStatisticsMessage;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceListener;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

public class ClientEhcacheStatsChartPanel
extends BaseEhcacheStatsChartPanel
implements CacheManagerInstanceListener,
CacheManagerModelListener {
    protected final IClient client;
    protected CacheManagerInstance cacheManagerInstance;
    protected XLabel summaryLabel;
    protected XButton manageStatsButton;

    public ClientEhcacheStatsChartPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel, IClient client) {
        super(appContext, cacheManagerModel);
        this.client = client;
        this.setInstance(cacheManagerModel.getInstance(client));
        this.setupSummaryPanel();
    }

    private synchronized CacheManagerInstance getInstance() {
        return this.cacheManagerInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstance(CacheManagerInstance cmi) {
        CacheManagerInstance oldInstance = null;
        ClientEhcacheStatsChartPanel clientEhcacheStatsChartPanel = this;
        synchronized (clientEhcacheStatsChartPanel) {
            oldInstance = this.cacheManagerInstance;
            this.cacheManagerInstance = cmi;
        }
        if (oldInstance != null) {
            oldInstance.removeCacheManagerInstanceListener(this);
        }
        if (cmi != null) {
            cmi.addCacheManagerInstanceListener(this);
        }
    }

    public void setup() {
        super.setup();
        this.cacheManagerModel.addCacheManagerModelListener(this);
    }

    private void setupSummaryPanel() {
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 17;
        this.summaryLabel = new XLabel();
        panel.add((Component)this.summaryLabel, (Object)gbc);
        this.summaryLabel.setIcon(EhcachePresentationUtils.ALERT_ICON);
        ++gbc.gridx;
        this.manageStatsButton = new XButton("Manage Statistics...");
        panel.add((Component)this.manageStatsButton, (Object)gbc);
        this.manageStatsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ClientEhcacheStatsChartPanel c = ClientEhcacheStatsChartPanel.this;
                Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)c));
                ManageStatisticsMessage msg = new ManageStatisticsMessage(frame, ClientEhcacheStatsChartPanel.this.appContext, ClientEhcacheStatsChartPanel.this.cacheManagerModel);
                int result = JOptionPane.showConfirmDialog((Component)((Object)c), msg, msg.getTitle(), 2);
                if (result == 0) {
                    Boolean toNewcomers = null;
                    if (msg.hasApplyToNewcomersToggle()) {
                        toNewcomers = msg.shouldApplyToNewcomers();
                    }
                    msg.apply(toNewcomers);
                }
                msg.tearDown();
            }
        });
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)new XLabel(), (Object)gbc);
        this.add((Component)panel, "North");
    }

    protected void init() {
        super.init();
        this.updateSummary();
    }

    protected void updateSummary() {
        CacheManagerInstance cmi = this.getInstance();
        if (cmi != null) {
            String text = null;
            Icon icon = null;
            int statsEnabledCount = cmi.getStatisticsEnabledCount();
            int instanceCount = cmi.getInstanceCount();
            if (instanceCount > 0 && statsEnabledCount == 0) {
                text = "No cache instances on this node have statistics enabled.";
                icon = EhcachePresentationUtils.ALERT_ICON;
            } else if (statsEnabledCount < instanceCount) {
                text = MessageFormat.format("Statistics enabled on {0} of {1} cache instances.", statsEnabledCount, instanceCount);
                icon = EhcachePresentationUtils.WARN_ICON;
            }
            this.summaryLabel.setText(text);
            this.summaryLabel.setIcon(icon);
            this.summaryLabel.setVisible(text != null);
            this.manageStatsButton.setVisible(text != null);
        } else {
            this.summaryLabel.setText(bundle.getString("cache-manager.not.resident.on.client"));
            this.summaryLabel.setIcon(EhcachePresentationUtils.ALERT_ICON);
        }
    }

    private void updateSummaryLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClientEhcacheStatsChartPanel.this.updateSummary();
            }
        });
    }

    public void attributesPolled(PolledAttributesResult result) {
        Boolean b;
        long searchCount = 0L;
        long averageSearchTime = 0L;
        long txCommitCount = 0L;
        long txRollbackCount = 0L;
        long writerQueueLength = 0L;
        int writerMaxQueueSize = 0;
        boolean hasAnyWriters = false;
        boolean transactional = false;
        boolean searchable = false;
        ObjectName on = this.client.getTunneledBeanName(this.statsBeanObjectName);
        for (BaseEhcacheStatsChartPanel.ChartContentProvider chartProvider : this.chartProviders) {
            chartProvider.acceptPolledAttributeResult(result, this.client, on);
        }
        Number n = (Number)result.getPolledAttribute((IClusterNode)this.client, on, "CacheSearchRate");
        if (n != null) {
            searchCount += n.longValue();
        }
        if ((n = (Number)result.getPolledAttribute((IClusterNode)this.client, on, "CacheAverageSearchTime")) != null) {
            averageSearchTime += n.longValue();
        }
        if ((n = (Number)result.getPolledAttribute((IClusterNode)this.client, on, "TransactionCommitRate")) != null) {
            txCommitCount += n.longValue();
        }
        if ((n = (Number)result.getPolledAttribute((IClusterNode)this.client, on, "TransactionRollbackRate")) != null) {
            txRollbackCount += n.longValue();
        }
        if ((n = (Number)result.getPolledAttribute((IClusterNode)this.client, on, "WriterQueueLength")) != null) {
            writerQueueLength += n.longValue();
        }
        if ((n = (Number)result.getPolledAttribute((IClusterNode)this.client, on, "WriterMaxQueueSize")) != null) {
            writerMaxQueueSize += n.intValue();
        }
        if ((b = (Boolean)result.getPolledAttribute((IClusterNode)this.client, on, "HasWriteBehindWriter")) != null) {
            hasAnyWriters = b;
        }
        if ((b = (Boolean)result.getPolledAttribute((IClusterNode)this.client, on, "Transactional")) != null) {
            transactional = b;
        }
        if ((b = (Boolean)result.getPolledAttribute((IClusterNode)this.client, on, "Searchable")) != null) {
            searchable = b;
        }
        final long theSearchCount = searchCount;
        final long theAverageSearchTime = averageSearchTime;
        final long theTxCommitCount = txCommitCount;
        final long theTxRollbackCount = txRollbackCount;
        final long theWriterQueueLength = writerQueueLength;
        final int theWriterMaxQueueSize = writerMaxQueueSize;
        final boolean theHasAnyWriters = hasAnyWriters;
        final boolean theTransactional = transactional;
        final boolean theSearchable = searchable;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClientEhcacheStatsChartPanel.this.updateAllSeries(theSearchCount, theAverageSearchTime, theTxCommitCount, theTxRollbackCount, theWriterQueueLength, theWriterMaxQueueSize, theHasAnyWriters, theTransactional, theSearchable);
            }
        });
    }

    protected void addPolledAttributeListener() {
        ObjectName on = this.client.getTunneledBeanName(this.statsBeanObjectName);
        this.client.addPolledAttributeListener(on, POLLED_ATTRS_SET, (PolledAttributeListener)this);
    }

    protected void removePolledAttributeListener() {
        ObjectName on = this.client.getTunneledBeanName(this.statsBeanObjectName);
        this.client.removePolledAttributeListener(on, POLLED_ATTRS_SET, (PolledAttributeListener)this);
    }

    public void cacheModelAdded(CacheModel cacheModel) {
    }

    public void cacheModelChanged(CacheModel cacheModel) {
    }

    public void cacheModelRemoved(CacheModel cacheModel) {
    }

    public void clusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
    }

    public void clusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
    }

    public void clusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
    }

    public void standaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
    }

    public void standaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
    }

    public void standaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
    }

    public void instanceAdded(CacheManagerInstance instance) {
        CacheManagerInstance cmi = this.getInstance();
        if (cmi == null) {
            this.setInstance(this.cacheManagerModel.getInstance(this.client));
            this.updateSummaryLater();
        }
    }

    public void instanceRemoved(CacheManagerInstance instance) {
        CacheManagerInstance cmi = this.getInstance();
        if (cmi == instance) {
            this.setInstance(null);
        }
        this.updateSummaryLater();
    }

    public void cacheManagerInstanceChanged(CacheManagerInstance theCacheManagerInstance) {
    }

    public void cacheModelInstanceAdded(CacheModelInstance cacheModelInstance) {
        this.updateSummaryLater();
    }

    public void cacheModelInstanceChanged(CacheModelInstance cacheModelInstance) {
        this.updateSummaryLater();
    }

    public void cacheModelInstanceRemoved(CacheModelInstance cacheModelInstance) {
        this.updateSummaryLater();
    }

    public void tearDown() {
        this.cacheManagerModel.removeCacheManagerModelListener(this);
        this.setInstance(null);
        super.tearDown();
    }
}

