/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XTable;
import com.tc.admin.model.IClient;
import java.awt.Component;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.swing.table.TableCellRenderer;
import org.terracotta.modules.ehcache.presentation.BaseEhcacheRuntimeStatsPanel;
import org.terracotta.modules.ehcache.presentation.CacheStatisticsTableModel;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheStatisticsModel;

public class ClientEhCacheRuntimeStatsPanel
extends BaseEhcacheRuntimeStatsPanel {
    protected IClient client;

    public ClientEhCacheRuntimeStatsPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel, IClient client) {
        super(appContext, cacheManagerModel);
        this.client = client;
    }

    protected XContainer createTopPanel() {
        XContainer panel = super.createTopPanel();
        XLabel label = new XLabel("Terracotta-clustered", EhcachePresentationUtils.CLUSTERED_ICON);
        panel.add((Component)label, (Object)"West");
        return panel;
    }

    protected BaseEhcacheRuntimeStatsPanel.TableModelWorker createTableModelWorker() {
        return new ClientTableModelWorker();
    }

    protected void setCacheStatisticsTableModel(CacheStatisticsTableModel tableModel) {
        super.setCacheStatisticsTableModel(tableModel);
        this.cacheTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new CacheNameRenderer()));
    }

    protected boolean isCacheTerracottaClustered(String cacheName) {
        CacheManagerInstance cacheManagerInstance = this.cacheManagerModel.getInstance(this.client);
        if (cacheManagerInstance != null) {
            return cacheManagerInstance.isCacheTerracottaClustered(cacheName);
        }
        return false;
    }

    private class CacheNameRenderer
    extends XTable.BaseRenderer {
        private CacheNameRenderer() {
        }

        public void setValue(Object value) {
            super.setValue(value);
            String cacheName = value.toString();
            this.label.setIcon(ClientEhCacheRuntimeStatsPanel.this.isCacheTerracottaClustered(cacheName) ? EhcachePresentationUtils.CLUSTERED_ICON : EhcachePresentationUtils.NON_CLUSTERED_ICON);
        }
    }

    private class ClientTableModelWorker
    extends BaseEhcacheRuntimeStatsPanel.TableModelWorker {
        private ClientTableModelWorker() {
            super(ClientEhCacheRuntimeStatsPanel.this, new Callable<CacheStatisticsTableModel>(){

                @Override
                public CacheStatisticsTableModel call() throws Exception {
                    CacheStatisticsTableModel result = new CacheStatisticsTableModel(ClientEhCacheRuntimeStatsPanel.this.getEffectiveTableColumns());
                    Iterator<CacheModel> iter = ClientEhCacheRuntimeStatsPanel.this.cacheManagerModel.cacheModelIterator();
                    while (iter.hasNext()) {
                        CacheStatisticsModel csm = iter.next().getCacheStatistics(ClientEhCacheRuntimeStatsPanel.this.client);
                        if (csm == null) continue;
                        result.add(csm);
                    }
                    return result;
                }
            });
        }
    }
}

