/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.BasicWorker;
import com.tc.admin.common.ExceptionHelper;
import com.tc.admin.common.PagedView;
import com.tc.admin.common.StatusView;
import com.tc.admin.common.ThinDecimalFormat;
import com.tc.admin.common.ThinMemoryFormat;
import com.tc.admin.common.XAbstractAction;
import com.tc.admin.common.XComboBox;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XScrollPane;
import com.tc.admin.common.XSplitPane;
import com.tc.admin.common.XTable;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.RangeType;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.terracotta.modules.ehcache.presentation.BaseClusterModelPanel;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.EhcacheToolBar;
import org.terracotta.modules.ehcache.presentation.TierChooserRenderer;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceListener;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheTierSize;
import org.terracotta.modules.ehcache.presentation.model.SettingsCacheModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCacheManagerSizingPanel
extends BaseClusterModelPanel
implements HierarchyListener,
CacheManagerInstanceListener {
    private final CacheManagerInstance cacheManagerInstance;
    private Map<CacheModelInstance, CacheTierSize> cacheSizes;
    private PagedView pagedView;
    private XLabel cacheSummaryLabel;
    private XContainer selectedCachePanel;
    private XComboBox tierChooser;
    private ActionListener tierChooserListener;
    private XComboBox selectedCacheChooser;
    private SelectedCacheListener selectedCacheListener;
    private XContainer cacheManagerCapacityPanel;
    private PiePlot tierUsageByCachePlot;
    private RectangleInsets tierUsageByCachePlotInsets;
    private ChartPanel tierUsageByCachePanel;
    private DefaultTableModel tierUsageByCacheTableModel;
    private XTable tierUsageByCacheTable;
    private ListSelectionListener tierUsageByCacheTableSelectionListener;
    private XLabel tierUsageByCacheLabel;
    private DefaultPieDataset tierUsageByCacheDataset;
    private StatusView tierUsageByCacheStatusView;
    private DefaultCategoryDataset localHeapCapacityDataset;
    private DefaultCategoryDataset localOffHeapCapacityDataset;
    private DefaultCategoryDataset localDiskCapacityDataset;
    private DefaultCategoryDataset remoteCapacityDataset;
    private ChartPanel localHeapCapacityPanel;
    private ChartPanel localOffHeapCapacityPanel;
    private ChartPanel localDiskCapacityPanel;
    private ChartPanel remoteCapacityPanel;
    private CategoryPlot localHeapCapacityPlot;
    private CategoryPlot localOffHeapCapacityPlot;
    private CategoryPlot localDiskCapacityPlot;
    private CategoryPlot remoteCapacityPlot;
    private CategoryItemRenderer localHeapCapacityPlotRenderer;
    private CategoryItemRenderer localOffHeapCapacityPlotRenderer;
    private CategoryItemRenderer localDiskCapacityPlotRenderer;
    private CategoryItemRenderer remoteCapacityPlotRenderer;
    private XLabel localHeapCapacityLabel;
    private XLabel localOffHeapCapacityLabel;
    private XLabel localDiskCapacityLabel;
    private XLabel remoteCapacityLabel;
    private UtilizationToolTipGenerator localHeapCapacityTipGenerator;
    private UtilizationToolTipGenerator localOffHeapCapacityTipGenerator;
    private UtilizationToolTipGenerator localDiskCapacityTipGenerator;
    private RemoteUtilizationToolTipGenerator remoteCapacityTipGenerator;
    private ChartPanel cacheLocalHeapCapacityPanel;
    private ChartPanel cacheLocalOffHeapCapacityPanel;
    private ChartPanel cacheLocalDiskCapacityPanel;
    private CategoryPlot cacheLocalHeapCapacityPlot;
    private DefaultCategoryDataset cacheLocalHeapCapacityDataset;
    private CategoryItemRenderer cacheLocalHeapCapacityPlotRenderer;
    private CategoryPlot cacheLocalOffHeapCapacityPlot;
    private DefaultCategoryDataset cacheLocalOffHeapCapacityDataset;
    private CategoryItemRenderer cacheLocalOffHeapCapacityPlotRenderer;
    private CategoryPlot cacheLocalDiskCapacityPlot;
    private DefaultCategoryDataset cacheLocalDiskCapacityDataset;
    private CategoryItemRenderer cacheLocalDiskCapacityPlotRenderer;
    private StatusView cacheLocalDiskCapacityStatusView;
    private XLabel cacheLocalHeapCapacityLabel;
    private XLabel cacheLocalOffHeapCapacityLabel;
    private XLabel cacheLocalDiskCapacityLabel;
    private UtilizationToolTipGenerator cacheLocalHeapCapacityTipGenerator;
    private UtilizationToolTipGenerator cacheLocalOffHeapCapacityTipGenerator;
    private UtilizationToolTipGenerator cacheLocalDiskCapacityTipGenerator;
    private TierChartListener cacheLocalDiskCapacityChartListener;
    private RemoteUtilizationToolTipGenerator cacheRemoteCapacityTipGenerator;
    private DefaultCategoryDataset localHeapMissesDataset;
    private DefaultCategoryDataset localOffHeapMissesDataset;
    private DefaultCategoryDataset localDiskMissesDataset;
    private CategoryPlot localHeapMissesPlot;
    private CategoryPlot localOffHeapMissesPlot;
    private CategoryPlot localDiskMissesPlot;
    private StatusView localDiskMissesStatusView;
    private XLabel localHeapMissesLabel;
    private XLabel localOffHeapMissesLabel;
    private XLabel localDiskMissesLabel;
    private RefreshAction refreshAction;
    private static final String SIZES_PAGED_VIEW = "SizesView";
    private static final String COUNTS_PAGED_VIEW = "CountsView";
    private static final ThinDecimalFormat THIN_DECIMAL_FORMAT = ThinDecimalFormat.INSTANCE;
    private static final ThinMemoryFormat THIN_MEMORY_FORMAT = ThinMemoryFormat.INSTANCE;
    private static final String USED = "Used";
    private static final String MISS_RATE = "Miss Rate";
    private static final String LOCAL_HEAP = "Local Heap";
    private static final String LOCAL_OFFHEAP = "Local OffHeap";
    private static final String LOCAL_DISK = "Local Disk";
    private static final String REMOTE = "Remote";
    private static final String AVAILABLE = "Available";
    private static final Dimension CHART_MIN_SIZE = new Dimension(200, 40);
    private static final Font LABEL_FONT = new Font("Dialog", 1, 12);
    private static final Font CHART_LABEL_FONT = new Font("Dialog", 0, 10);
    private static final Color CHART_LABEL_FG = Color.gray;
    private static String[] L1_TIERS = new String[]{"Local Heap", "Local OffHeap", "Local Disk", "Remote"};
    private static final double PIE_SLICE_EXPLODE_PERCENT = 0.1;
    private static final TickUnitSource MEMORY_TICK_UNITS = ClientCacheManagerSizingPanel.createMemoryIntegerTickUnits();
    protected static final String SIZE_IN_BYTES = "Size in Bytes";
    protected static final String SIZE_IN_BYTES_REMOTE = "Size in Bytes (est.)";
    private static final String[] CACHE_SIZES_TABLE_COLUMNS = new String[]{"Cache", "Size in Bytes", "% of Used", "Entries", "Mean Entry Size"};
    private final MemorySizeTableRenderer MEMORY_SIZE_TABLE_RENDERER = new MemorySizeTableRenderer();
    private final PercentMemoryUsedRenderer PERCENT_MEMORY_USED_TABLE_RENDERER = new PercentMemoryUsedRenderer();
    private final EntryCountTableRenderer ENTRY_COUNT_TABLE_RENDERER = new EntryCountTableRenderer();
    private static final Color MAX_COLOR = Color.red;
    private static final Color RESERVED_COLOR = new Color(255, 201, 14);
    private static final Color[] SCHEME_1 = new Color[]{new Color(234, 211, 153), new Color(153, 217, 234), new Color(234, 171, 153)};
    private static final Color[] SCHEME_2 = new Color[]{new Color(228, 214, 196), new Color(154, 177, 208), new Color(145, 189, 112)};
    private static final Color[] SCHEME_3 = new Color[]{new Color(196, 210, 228), new Color(208, 185, 154), new Color(224, 225, 193)};
    private static final Color[][] ALL_SCHEMES = new Color[][]{SCHEME_1, SCHEME_2, SCHEME_3};
    private static final String LOCAL_DISK_WITH_CLUSTERED_TIP = "Local Disk not available with Terracotta-clustered caches";
    private static final String REMOTE_WITH_NON_CLUSTERED_TIP = "Remote tier not available for non-Terracotta clustered caches";
    private static final Color[] CURRENT_SCHEME = ALL_SCHEMES[1];
    private static final Color LOCAL_HEAP_COLOR = CURRENT_SCHEME[0];
    private static final Color LOCAL_OFFHEAP_COLOR = CURRENT_SCHEME[1];
    private static final Color LOCAL_DISK_COLOR = CURRENT_SCHEME[2];
    private static final Color REMOTE_COLOR = new Color(234, 171, 153);
    private static final double MAXIMUM_BAR_WIDTH = 0.25;
    private static final float FOREGROUND_ALPHA = 1.0f;
    private static final Color SELECTED_TIER_PLOT_BG = Color.white;
    private static final Color UNSELECTED_TIER_PLOT_BG = null;
    private static final float SELECTED_TIER_PLOT_ALPHA = 1.0f;
    private static final float UNSELECTED_TIER_PLOT_ALPHA = 0.5f;
    private static final int DEFAULT_REFRESH_TIMER_SECONDS = 30;
    private static final int REFRESH_TIMER_SECONDS = Integer.getInteger("ClientCacheManagerSizingPanel.refreshTimerSeconds", 30);
    private final Timer refreshTimer = this.createRefreshTimer();
    private static final int MAX_LABEL_OFFSET = 1;
    private static final int RESERVED_LABEL_OFFSET = CHART_LABEL_FONT.getSize() + 2;
    private final CachePieValuesGenerator CACHE_PIE_VALUES_GENERATOR = new CachePieValuesGenerator();

    public ClientCacheManagerSizingPanel(ApplicationContext appContext, CacheManagerModel cacheManagerModel, CacheManagerInstance cacheManagerInstance) {
        super(appContext, cacheManagerModel.getClusterModel());
        this.cacheManagerInstance = cacheManagerInstance;
        this.addHierarchyListener(this);
    }

    @Override
    protected void init() {
        if (this.cacheManagerInstance != null) {
            this.cacheManagerInstance.addCacheManagerInstanceListener(this);
        }
    }

    public CacheManagerInstance getCacheManagerInstance() {
        return this.cacheManagerInstance;
    }

    private Timer createRefreshTimer() {
        Timer result = new Timer(REFRESH_TIMER_SECONDS * 1000, new RefreshTimerAction());
        result.setRepeats(false);
        return result;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L) {
            if (this.isShowing()) {
                this.refresh();
            } else {
                this.refreshTimer.stop();
            }
        }
    }

    void refresh() {
        if (this.cacheManagerInstance != null) {
            if (this.cacheManagerInstance.hasSizeBasedPooling() || this.cacheManagerInstance.hasSizeBasedCache()) {
                this.pagedView.setPage(SIZES_PAGED_VIEW);
                this.refreshTimer.stop();
                this.appContext.submit((Runnable)((Object)new GetSizesWorker()));
            } else {
                this.pagedView.setPage(COUNTS_PAGED_VIEW);
            }
        }
    }

    private void update(Map<CacheModelInstance, CacheTierSize> theCacheSizes) {
        this.cacheSizes = theCacheSizes;
        if (theCacheSizes != null && !theCacheSizes.isEmpty()) {
            Color tierColor;
            long used;
            long max;
            long reservedLocalHeapBytes = 0L;
            long usedLocalHeapBytes = 0L;
            long usedLocalHeapEntries = 0L;
            long reservedLocalOffHeapBytes = 0L;
            long usedLocalOffHeapBytes = 0L;
            long usedLocalOffHeapEntries = 0L;
            long reservedLocalDiskBytes = 0L;
            long usedLocalDiskBytes = 0L;
            long usedLocalDiskEntries = 0L;
            long reservedRemoteBytes = 0L;
            long usedRemoteBytes = 0L;
            long usedRemoteEntries = 0L;
            long maxRemoteEntries = 0L;
            String selectedCacheName = (String)this.selectedCacheChooser.getSelectedItem();
            this.selectedCacheChooser.removeActionListener((ActionListener)this.selectedCacheListener);
            this.selectedCacheChooser.removeAllItems();
            TreeSet<Comparable> keys = new TreeSet<Comparable>();
            String selectedTier = this.selectedTier();
            int tcClusteredCount = this.cacheManagerInstance.getTerracottaClusteredInstanceCount();
            boolean isPooledCacheManager = this.cacheManagerInstance.hasSizeBasedPooling();
            this.tierUsageByCacheDataset.clear();
            for (Map.Entry<CacheModelInstance, CacheTierSize> entry : theCacheSizes.entrySet()) {
                CacheModelInstance cmi = entry.getKey();
                SettingsCacheModel scm = this.cacheManagerInstance.getSettingsCacheModel(cmi);
                if (!isPooledCacheManager && !scm.hasSizeBasedLimits()) continue;
                boolean tcClustered = cmi.isTerracottaClustered();
                CacheTierSize tierSize = entry.getValue();
                String cacheName = cmi.getCacheName();
                Long cacheTierSize = 0L;
                if (selectedTier.equals(LOCAL_HEAP)) {
                    cacheTierSize = tierSize.getLocalHeapSizeInBytes();
                } else if (selectedTier.equals(LOCAL_OFFHEAP)) {
                    cacheTierSize = tierSize.getLocalOffHeapSizeInBytes();
                } else if (selectedTier.equals(LOCAL_DISK)) {
                    if (!tcClustered) {
                        cacheTierSize = tierSize.getLocalDiskSizeInBytes();
                    }
                } else if (tcClustered) {
                    cacheTierSize = tierSize.sizeInBytesForTier(REMOTE);
                }
                this.tierUsageByCacheDataset.setValue((Comparable)((Object)cacheName), (Number)cacheTierSize);
                reservedLocalHeapBytes += tierSize.getMaxBytesLocalHeap();
                usedLocalHeapBytes += tierSize.getLocalHeapSizeInBytes();
                usedLocalHeapEntries += tierSize.getLocalHeapSize();
                reservedLocalOffHeapBytes += tierSize.getMaxBytesLocalOffHeap();
                usedLocalOffHeapBytes += tierSize.getLocalOffHeapSizeInBytes();
                usedLocalOffHeapEntries += tierSize.getLocalOffHeapSize();
                if (tcClustered) {
                    reservedRemoteBytes += tierSize.maxBytesForTier(REMOTE);
                    usedRemoteBytes += tierSize.sizeInBytesForTier(REMOTE);
                    usedRemoteEntries += tierSize.getLocalDiskSize();
                    maxRemoteEntries += tierSize.maxEntriesForTier(REMOTE);
                } else {
                    reservedLocalDiskBytes += tierSize.getMaxBytesLocalDisk();
                    usedLocalDiskBytes += tierSize.getLocalDiskSizeInBytes();
                    usedLocalDiskEntries += tierSize.getLocalDiskSize();
                }
                this.selectedCacheChooser.addItem((Object)cacheName);
                keys.add((Comparable)((Object)cacheName));
            }
            this.renderPieChartDetails(keys, this.tierUsageByCachePanel);
            long maxLocalHeapBytes = this.cacheManagerInstance.getMaxBytesLocalHeap();
            long maxLocalOffHeapBytes = this.cacheManagerInstance.getMaxBytesLocalOffHeap();
            long maxLocalDiskBytes = this.cacheManagerInstance.getMaxBytesLocalDisk();
            long maxRemoteBytes = reservedRemoteBytes;
            reservedRemoteBytes = 0L;
            if (selectedTier.equals(LOCAL_HEAP)) {
                max = maxLocalHeapBytes;
                used = usedLocalHeapBytes;
                this.updateUnusedLabel(maxLocalHeapBytes, reservedLocalHeapBytes, usedLocalHeapBytes, usedLocalHeapEntries);
                tierColor = LOCAL_HEAP_COLOR;
            } else if (selectedTier.equals(LOCAL_OFFHEAP)) {
                max = maxLocalOffHeapBytes;
                used = usedLocalOffHeapBytes;
                this.updateUnusedLabel(maxLocalOffHeapBytes, reservedLocalOffHeapBytes, usedLocalOffHeapBytes, usedLocalOffHeapEntries);
                tierColor = LOCAL_OFFHEAP_COLOR;
            } else if (selectedTier.equals(LOCAL_DISK)) {
                max = maxLocalDiskBytes;
                used = usedLocalDiskBytes;
                this.updateUnusedLabel(maxLocalDiskBytes, reservedLocalDiskBytes, usedLocalDiskBytes, usedLocalDiskEntries);
                tierColor = LOCAL_DISK_COLOR;
            } else {
                max = maxRemoteBytes;
                used = usedRemoteBytes;
                this.updateUnusedLabel(maxRemoteBytes, reservedRemoteBytes, usedRemoteBytes, usedRemoteEntries);
                tierColor = REMOTE_COLOR;
            }
            if (max > 0L && max - used > 0L) {
                this.tierUsageByCacheDataset.setValue((Comparable)((Object)AVAILABLE), (double)(max - used));
            }
            this.tierUsageByCacheStatusView.setText(selectedTier);
            this.tierUsageByCacheStatusView.setIndicator(tierColor);
            this.cacheManagerCapacityPanel.removeAll();
            this.cacheManagerCapacityPanel.setLayout((LayoutManager)new GridLayout(0, 1));
            this.localHeapCapacityDataset.clear();
            this.localHeapCapacityPlot.clearRangeMarkers();
            if (reservedLocalHeapBytes > 0L) {
                this.addReservedRangeValueMarker(this.localHeapCapacityPlot, reservedLocalHeapBytes);
            }
            this.localHeapCapacityDataset.setValue((double)usedLocalHeapBytes, (Comparable)((Object)USED), (Comparable)((Object)LOCAL_HEAP));
            if (maxLocalHeapBytes > 0L) {
                this.addMaximumRangeValueMarker(this.localHeapCapacityPlot, maxLocalHeapBytes);
            }
            this.localHeapCapacityLabel.setText(this.handleReserved(reservedLocalHeapBytes, (DecimalFormat)THIN_MEMORY_FORMAT) + " Used: " + THIN_MEMORY_FORMAT.format(usedLocalHeapBytes) + this.handleAvailable(maxLocalHeapBytes, usedLocalHeapBytes, (DecimalFormat)THIN_MEMORY_FORMAT));
            this.cacheManagerCapacityPanel.add((Component)this.localHeapCapacityPanel);
            ClientCacheManagerSizingPanel.updatePlotRangeAxis(this.localHeapCapacityPlot);
            this.updateTierPlotSelectionGraphics((Plot)this.localHeapCapacityPlot, selectedTier, LOCAL_HEAP);
            this.localHeapCapacityTipGenerator.setup(LOCAL_HEAP, usedLocalHeapBytes, reservedLocalHeapBytes, maxLocalHeapBytes, usedLocalHeapEntries);
            this.localOffHeapCapacityDataset.clear();
            this.localOffHeapCapacityPlot.clearRangeMarkers();
            if (reservedLocalOffHeapBytes > 0L) {
                this.addReservedRangeValueMarker(this.localOffHeapCapacityPlot, reservedLocalOffHeapBytes);
            }
            this.localOffHeapCapacityDataset.setValue((double)usedLocalOffHeapBytes, (Comparable)((Object)USED), (Comparable)((Object)LOCAL_OFFHEAP));
            if (maxLocalOffHeapBytes > 0L) {
                this.addMaximumRangeValueMarker(this.localOffHeapCapacityPlot, maxLocalOffHeapBytes);
            }
            this.localOffHeapCapacityLabel.setText(this.handleReserved(reservedLocalOffHeapBytes, (DecimalFormat)THIN_MEMORY_FORMAT) + " Used: " + THIN_MEMORY_FORMAT.format(usedLocalOffHeapBytes) + this.handleAvailable(maxLocalOffHeapBytes, usedLocalOffHeapBytes, (DecimalFormat)THIN_MEMORY_FORMAT));
            this.cacheManagerCapacityPanel.add((Component)this.localOffHeapCapacityPanel);
            ClientCacheManagerSizingPanel.updatePlotRangeAxis(this.localOffHeapCapacityPlot);
            this.updateTierPlotSelectionGraphics((Plot)this.localOffHeapCapacityPlot, selectedTier, LOCAL_OFFHEAP);
            this.localOffHeapCapacityTipGenerator.setup(LOCAL_OFFHEAP, usedLocalOffHeapBytes, reservedLocalOffHeapBytes, maxLocalOffHeapBytes, usedLocalOffHeapEntries);
            this.localDiskCapacityDataset.clear();
            this.localDiskCapacityPlot.clearRangeMarkers();
            if (tcClusteredCount != this.cacheManagerInstance.getInstanceCount()) {
                if (reservedLocalDiskBytes > 0L) {
                    this.addReservedRangeValueMarker(this.localDiskCapacityPlot, reservedLocalDiskBytes);
                }
                this.localDiskCapacityDataset.setValue((double)usedLocalDiskBytes, (Comparable)((Object)USED), (Comparable)((Object)LOCAL_DISK));
                if (maxLocalDiskBytes > 0L) {
                    this.addMaximumRangeValueMarker(this.localDiskCapacityPlot, maxLocalDiskBytes);
                }
                this.localDiskCapacityLabel.setText(this.handleReserved(reservedLocalDiskBytes, (DecimalFormat)THIN_MEMORY_FORMAT) + " Used: " + THIN_MEMORY_FORMAT.format(usedLocalDiskBytes) + this.handleAvailable(maxLocalDiskBytes, usedLocalDiskBytes, (DecimalFormat)THIN_MEMORY_FORMAT));
                this.cacheManagerCapacityPanel.add((Component)this.localDiskCapacityPanel);
                ClientCacheManagerSizingPanel.updatePlotRangeAxis(this.localDiskCapacityPlot);
                this.updateTierPlotSelectionGraphics((Plot)this.localDiskCapacityPlot, selectedTier, LOCAL_DISK);
                this.localDiskCapacityTipGenerator.setup(LOCAL_DISK, usedLocalDiskBytes, reservedLocalDiskBytes, maxLocalDiskBytes, usedLocalDiskEntries);
            }
            this.remoteCapacityDataset.clear();
            this.remoteCapacityPlot.clearRangeMarkers();
            if (tcClusteredCount > 0) {
                if (reservedRemoteBytes > 0L) {
                    this.addReservedRangeValueMarker(this.remoteCapacityPlot, reservedRemoteBytes);
                }
                this.remoteCapacityDataset.setValue((double)usedRemoteBytes, (Comparable)((Object)USED), (Comparable)((Object)REMOTE));
                if (maxRemoteBytes > 0L) {
                    this.addMaximumRangeValueMarker(this.remoteCapacityPlot, maxRemoteBytes);
                }
                this.remoteCapacityLabel.setText("Used: " + THIN_MEMORY_FORMAT.format(usedRemoteBytes) + this.handleAvailable(maxRemoteBytes, usedRemoteBytes, (DecimalFormat)THIN_MEMORY_FORMAT));
                this.cacheManagerCapacityPanel.add((Component)this.remoteCapacityPanel);
                ClientCacheManagerSizingPanel.updatePlotRangeAxis(this.remoteCapacityPlot);
                this.updateTierPlotSelectionGraphics((Plot)this.remoteCapacityPlot, selectedTier, REMOTE);
                this.remoteCapacityTipGenerator.setup(REMOTE, maxRemoteEntries, maxRemoteBytes, usedRemoteEntries, usedRemoteBytes);
            }
            long upperBound = this.determineMax(maxLocalHeapBytes, reservedLocalHeapBytes, usedLocalHeapBytes, maxLocalOffHeapBytes, reservedLocalOffHeapBytes, usedLocalOffHeapBytes, maxLocalDiskBytes, reservedLocalDiskBytes, usedLocalDiskBytes, maxRemoteBytes, reservedRemoteBytes, usedRemoteBytes);
            this.setRangeAxisPlusExtra(upperBound, this.localHeapCapacityPlot, this.localOffHeapCapacityPlot, this.localDiskCapacityPlot, this.remoteCapacityPlot);
            if (selectedCacheName == null) {
                selectedCacheName = (String)this.tierUsageByCachePlot.getDataset().getKeys().get(0);
            }
            this.selectedCacheChooser.setSelectedItem((Object)selectedCacheName);
            this.selectCacheSlice((Comparable)((Object)selectedCacheName));
            this.updateTierUsageByCacheTable(selectedCacheName);
            this.selectedCacheChooser.addActionListener((ActionListener)this.selectedCacheListener);
            this.tierChooser.setModel(new DefaultComboBoxModel<String>(L1_TIERS));
            if (tcClusteredCount == 0) {
                this.tierChooser.removeItem((Object)REMOTE);
            }
            if (tcClusteredCount == this.cacheManagerInstance.getInstanceCount()) {
                this.tierChooser.removeItem((Object)LOCAL_DISK);
            }
            this.setSelectedTier(selectedTier);
            this.refreshTimer.start();
        }
    }

    private void updateTierPlotSelectionGraphics(Plot plot, String selectedTier, String tierName) {
        plot.setBackgroundAlpha(selectedTier.equals(tierName) ? 1.0f : 0.5f);
        plot.setBackgroundPaint((Paint)(selectedTier.equals(tierName) ? SELECTED_TIER_PLOT_BG : UNSELECTED_TIER_PLOT_BG));
    }

    private void setSelectedTier(String tierName) {
        this.tierChooser.removeActionListener(this.tierChooserListener);
        this.tierChooser.setSelectedItem((Object)tierName);
        this.tierChooser.addActionListener(this.tierChooserListener);
    }

    private long determineMax(long ... values) {
        long result = 0L;
        for (long value : values) {
            result = Math.max(result, value);
        }
        return result;
    }

    private void setRangeAxisPlusExtra(long value, CategoryPlot ... plots) {
        value = value > 10L ? (value += value / 10L) : ++value;
        for (CategoryPlot plot : plots) {
            plot.getRangeAxis().setRange(0.0, (double)value);
        }
    }

    private void addMaximumRangeValueMarker(CategoryPlot plot, long value) {
        this.addRangeValueMarker(plot, value, "Max", MAX_COLOR, 1);
    }

    private void addReservedRangeValueMarker(CategoryPlot plot, long value) {
        this.addRangeValueMarker(plot, value, "Reserved", RESERVED_COLOR, RESERVED_LABEL_OFFSET);
    }

    private void addRangeValueMarker(CategoryPlot plot, long value, String label, Color color, int labelOffset) {
        float[] dash = new float[]{2.0f};
        BasicStroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        ValueMarker marker = new ValueMarker((double)value, (Paint)color, (Stroke)new BasicStroke(1.0f), (Paint)color, (Stroke)stroke, 1.0f);
        plot.addRangeMarker((Marker)marker, Layer.BACKGROUND);
        marker.setLabel(label);
        marker.setLabelOffset(new RectangleInsets((double)labelOffset, 5.0, 0.0, 0.0));
        marker.setLabelFont(CHART_LABEL_FONT);
        marker.setLabelPaint((Paint)CHART_LABEL_FG);
        marker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
        marker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
        marker = new ValueMarker((double)value, (Paint)color, (Stroke)new BasicStroke(1.0f), (Paint)color, (Stroke)stroke, 1.0f);
        plot.addRangeMarker((Marker)marker, Layer.BACKGROUND);
        marker.setLabel(THIN_MEMORY_FORMAT.format(value));
        marker.setLabelOffset(new RectangleInsets((double)labelOffset, 0.0, 0.0, 5.0));
        marker.setLabelFont(CHART_LABEL_FONT);
        marker.setLabelPaint((Paint)CHART_LABEL_FG);
        marker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        marker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
    }

    private void updateUnusedLabel(long maxBytes, long reservedBytes, long usedBytes, long usedEntries) {
        StringBuilder sb = new StringBuilder();
        if (maxBytes - usedBytes > 0L) {
            sb.append("Available Space: ");
            long availableBytes = maxBytes - usedBytes;
            sb.append(THIN_MEMORY_FORMAT.format(availableBytes));
            sb.append(" (");
            sb.append(NumberFormat.getPercentInstance().format((double)availableBytes / (double)maxBytes));
            sb.append(")");
            sb.append(", Entries: ");
            sb.append(THIN_DECIMAL_FORMAT.format(usedEntries));
        } else if (reservedBytes - usedBytes > 0L) {
            long availableBytes = reservedBytes - usedBytes;
            sb.append("Available Space: ");
            sb.append(THIN_MEMORY_FORMAT.format(availableBytes));
            sb.append(" (");
            sb.append(NumberFormat.getPercentInstance().format((double)availableBytes / (double)reservedBytes));
            sb.append(")");
            sb.append(", Entries: ");
            sb.append(THIN_DECIMAL_FORMAT.format(usedEntries));
        } else {
            sb.append("Entries: ");
            sb.append(THIN_DECIMAL_FORMAT.format(usedEntries));
        }
        this.tierUsageByCacheLabel.setText(sb.toString());
    }

    private static void updatePlotRangeAxis(CategoryPlot categoryPlot) {
        NumberAxis rangeAxis = (NumberAxis)categoryPlot.getRangeAxis();
        rangeAxis.setNumberFormatOverride((NumberFormat)THIN_MEMORY_FORMAT);
        rangeAxis.setStandardTickUnits(MEMORY_TICK_UNITS);
    }

    private void renderPieChartDetails(Set<Comparable> keys, ChartPanel chartPanel) {
        PieDataset pieDataset = ((PiePlot)chartPanel.getChart().getPlot()).getDataset();
        this.tierUsageByCacheTableModel.setRowCount(0);
        for (Comparable key : keys) {
            this.tierUsageByCacheTableModel.addRow(this.CACHE_PIE_VALUES_GENERATOR.getTableItemArray(pieDataset, key));
        }
    }

    private XContainer createSizesView() {
        XContainer result = new XContainer((LayoutManager)new BorderLayout());
        XSplitPane splitter = new XSplitPane(0, (Component)this.createCacheManagerPanel(), (Component)this.createCachePanel());
        splitter.setDefaultDividerLocation(0.5);
        splitter.setBorder(null);
        result.add((Component)splitter, (Object)"Center");
        result.add((Component)this.createBottomPanel(), (Object)"South");
        result.setName(SIZES_PAGED_VIEW);
        return result;
    }

    private XContainer createCountsView() {
        XContainer result = new XContainer((LayoutManager)new BorderLayout());
        XLabel label = new XLabel("Not available unless the CacheManager is using size-based pooling or contains some size-based caches.");
        label.setHorizontalAlignment(0);
        result.add((Component)label);
        result.setName(COUNTS_PAGED_VIEW);
        return result;
    }

    @Override
    protected XContainer createMainPanel() {
        this.pagedView = new PagedView();
        this.pagedView.add((Component)this.createSizesView());
        this.pagedView.add((Component)this.createCountsView());
        return this.pagedView;
    }

    protected JComponent createBottomPanel() {
        EhcacheToolBar bottomPanel = new EhcacheToolBar();
        this.refreshAction = new RefreshAction();
        bottomPanel.add((Action)((Object)this.refreshAction));
        return bottomPanel;
    }

    private XContainer createCacheManagerPanel() {
        XContainer result = new XContainer((LayoutManager)new BorderLayout());
        this.cacheManagerCapacityPanel = this.createCacheManagerCapacityPanel();
        XSplitPane splitter = new XSplitPane(1, (Component)this.cacheManagerCapacityPanel, (Component)this.createCacheManagerUsageByCachePanel());
        result.add((Component)splitter);
        splitter.setDefaultDividerLocation(0.5);
        splitter.setBorder(null);
        return result;
    }

    private XContainer createCacheManagerUsageByCachePanel() {
        XContainer topPanel = new XContainer((LayoutManager)new BorderLayout());
        XContainer tierChooserPanel = new XContainer((LayoutManager)new FlowLayout());
        XLabel label = new XLabel("Tier:");
        tierChooserPanel.add((Component)label);
        label.setFont(LABEL_FONT);
        this.tierChooser = new XComboBox(new DefaultComboBoxModel<String>(L1_TIERS));
        HashMap<String, Color> indicatorMap = new HashMap<String, Color>();
        indicatorMap.put(LOCAL_HEAP, LOCAL_HEAP_COLOR);
        indicatorMap.put(LOCAL_OFFHEAP, LOCAL_OFFHEAP_COLOR);
        indicatorMap.put(LOCAL_DISK, LOCAL_DISK_COLOR);
        indicatorMap.put(REMOTE, REMOTE_COLOR);
        this.tierChooser.setRenderer((ListCellRenderer)new TierChooserRenderer(indicatorMap));
        this.tierChooserListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientCacheManagerSizingPanel.this.tierUsageByCacheTable.getColumnModel().getColumn(1).setHeaderValue(ClientCacheManagerSizingPanel.this.selectedTier().equals(ClientCacheManagerSizingPanel.REMOTE) ? ClientCacheManagerSizingPanel.SIZE_IN_BYTES_REMOTE : ClientCacheManagerSizingPanel.SIZE_IN_BYTES);
                ClientCacheManagerSizingPanel.this.refresh();
            }
        };
        this.tierChooser.addActionListener(this.tierChooserListener);
        tierChooserPanel.add((Component)this.tierChooser);
        topPanel.add((Component)tierChooserPanel, (Object)"West");
        topPanel.add((Component)new XLabel("Terracotta-clustered", EhcachePresentationUtils.CLUSTERED_ICON), (Object)"East");
        XScrollPane scrollPane = new XScrollPane((Component)this.createTierUsageByCacheTable());
        scrollPane.setPreferredSize(new Dimension(280, 200));
        XSplitPane splitter = new XSplitPane(0, (Component)scrollPane, (Component)this.createTierUsageByCacheChartPanel());
        splitter.setDefaultDividerLocation(0.4);
        splitter.setBorder(null);
        XContainer result = new XContainer((LayoutManager)new BorderLayout());
        result.add((Component)topPanel, (Object)"North");
        result.add((Component)splitter, (Object)"Center");
        result.setBorder((Border)BorderFactory.createTitledBorder("CacheManager Relative Cache Sizes"));
        return result;
    }

    private ChartPanel createTierUsageByCacheChartPanel() {
        this.tierUsageByCacheDataset = new DefaultPieDataset();
        this.tierUsageByCachePanel = this.createPieChart((PieDataset)this.tierUsageByCacheDataset, false);
        this.tierUsageByCachePanel.addChartMouseListener((ChartMouseListener)new TierUsageByCacheChartListener());
        this.tierUsageByCachePlot = (PiePlot)this.tierUsageByCachePanel.getChart().getPlot();
        this.tierUsageByCachePlot.setOutlineVisible(false);
        this.tierUsageByCachePlotInsets = new RectangleInsets(0.0, 0.0, (double)CHART_LABEL_FONT.getSize2D(), 0.0);
        this.tierUsageByCachePlot.setInsets(this.tierUsageByCachePlotInsets);
        this.tierUsageByCachePlot.setForegroundAlpha(0.6f);
        this.tierUsageByCachePlot.setSectionPaint((Comparable)((Object)AVAILABLE), (Paint)Color.white);
        this.tierUsageByCacheStatusView = ClientCacheManagerSizingPanel.createOverlayLabel(LOCAL_HEAP, LOCAL_HEAP_COLOR);
        this.tierUsageByCacheLabel = this.addOverlayLabel(this.tierUsageByCachePanel, (JComponent)this.tierUsageByCacheStatusView);
        this.tierUsageByCachePanel.setBackground((Color)this.tierUsageByCachePlot.getBackgroundPaint());
        return this.tierUsageByCachePanel;
    }

    private XTable createTierUsageByCacheTable() {
        this.tierUsageByCacheTableModel = new DefaultTableModel(CACHE_SIZES_TABLE_COLUMNS, 0){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return Long.class;
                    }
                    case 2: {
                        return Double.class;
                    }
                    case 3: {
                        return Double.class;
                    }
                    case 4: {
                        return Long.class;
                    }
                    case 5: {
                        return Double.class;
                    }
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tierUsageByCacheTable = new XTable(this.tierUsageByCacheTableModel){

            public String getToolTipText(MouseEvent me) {
                int hitRowIndex = this.rowAtPoint(me.getPoint());
                if (hitRowIndex != -1) {
                    int hitColIndex = this.columnAtPoint(me.getPoint());
                    String cacheName = (String)ClientCacheManagerSizingPanel.this.tierUsageByCacheTable.getValueAt(hitRowIndex, 0);
                    CacheModelInstance cmi = ClientCacheManagerSizingPanel.this.cacheManagerInstance.getCacheModelInstance(cacheName);
                    boolean tcClustered = cmi.isTerracottaClustered();
                    String selectedTier = ClientCacheManagerSizingPanel.this.selectedTier();
                    switch (hitColIndex) {
                        case 0: {
                            return (String)ClientCacheManagerSizingPanel.this.tierUsageByCacheTable.getValueAt(hitRowIndex, 0);
                        }
                        case 1: {
                            if (tcClustered && selectedTier.equals(ClientCacheManagerSizingPanel.LOCAL_DISK)) {
                                return ClientCacheManagerSizingPanel.LOCAL_DISK_WITH_CLUSTERED_TIP;
                            }
                            if (!tcClustered && selectedTier.equals(ClientCacheManagerSizingPanel.REMOTE)) {
                                return ClientCacheManagerSizingPanel.REMOTE_WITH_NON_CLUSTERED_TIP;
                            }
                            Long value = (Long)ClientCacheManagerSizingPanel.this.tierUsageByCacheTable.getValueAt(hitRowIndex, 1);
                            return NumberFormat.getNumberInstance().format(value) + " Bytes";
                        }
                        case 2: {
                            if (tcClustered && selectedTier.equals(ClientCacheManagerSizingPanel.LOCAL_DISK)) {
                                return ClientCacheManagerSizingPanel.LOCAL_DISK_WITH_CLUSTERED_TIP;
                            }
                            if (!tcClustered && selectedTier.equals(ClientCacheManagerSizingPanel.REMOTE)) {
                                return ClientCacheManagerSizingPanel.REMOTE_WITH_NON_CLUSTERED_TIP;
                            }
                            return super.getToolTipText(me);
                        }
                        case 3: {
                            if (tcClustered && selectedTier.equals(ClientCacheManagerSizingPanel.LOCAL_DISK)) {
                                return ClientCacheManagerSizingPanel.LOCAL_DISK_WITH_CLUSTERED_TIP;
                            }
                            if (!tcClustered && selectedTier.equals(ClientCacheManagerSizingPanel.REMOTE)) {
                                return ClientCacheManagerSizingPanel.REMOTE_WITH_NON_CLUSTERED_TIP;
                            }
                            Long value = (Long)ClientCacheManagerSizingPanel.this.tierUsageByCacheTable.getValueAt(hitRowIndex, 3);
                            return NumberFormat.getNumberInstance().format(value) + " Entries";
                        }
                        case 4: {
                            if (tcClustered && selectedTier.equals(ClientCacheManagerSizingPanel.LOCAL_DISK)) {
                                return ClientCacheManagerSizingPanel.LOCAL_DISK_WITH_CLUSTERED_TIP;
                            }
                            if (!tcClustered && selectedTier.equals(ClientCacheManagerSizingPanel.REMOTE)) {
                                return ClientCacheManagerSizingPanel.REMOTE_WITH_NON_CLUSTERED_TIP;
                            }
                            Double value = (Double)ClientCacheManagerSizingPanel.this.tierUsageByCacheTable.getValueAt(hitRowIndex, 4);
                            return NumberFormat.getNumberInstance().format(value) + " Bytes";
                        }
                    }
                }
                return super.getToolTipText(me);
            }

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent me) {
                        int column = this.columnAtPoint(me.getPoint());
                        if (column != -1) {
                            String selectedTier = ClientCacheManagerSizingPanel.this.selectedTier().toLowerCase();
                            switch (column) {
                                case 0: {
                                    return "The cache name";
                                }
                                case 1: {
                                    return "Size of the cache on " + selectedTier;
                                }
                                case 2: {
                                    return "Portion of " + selectedTier + " usage taken by the cache";
                                }
                                case 3: {
                                    return "Number of the cache entries on the " + selectedTier;
                                }
                                case 4: {
                                    return "Mean size of an entry on " + selectedTier;
                                }
                            }
                        }
                        return null;
                    }
                };
            }
        };
        ClientCacheManagerSizingPanel.trySetAutoCreateRowSorter((JTable)this.tierUsageByCacheTable);
        this.tierUsageByCacheTable.setSelectionMode(0);
        this.tierUsageByCacheTableSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int row;
                if (!e.getValueIsAdjusting() && (row = ClientCacheManagerSizingPanel.this.tierUsageByCacheTable.getSelectedRow()) != -1) {
                    String cacheName = (String)ClientCacheManagerSizingPanel.this.tierUsageByCacheTable.getValueAt(row, 0);
                    ClientCacheManagerSizingPanel.this.selectedCacheChooser.setSelectedItem((Object)cacheName);
                }
            }
        };
        this.tierUsageByCacheTable.getSelectionModel().addListSelectionListener(this.tierUsageByCacheTableSelectionListener);
        this.tierUsageByCacheTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new CacheNameRenderer()));
        this.tierUsageByCacheTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)this.MEMORY_SIZE_TABLE_RENDERER));
        this.tierUsageByCacheTable.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)((Object)this.PERCENT_MEMORY_USED_TABLE_RENDERER));
        this.tierUsageByCacheTable.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)((Object)this.ENTRY_COUNT_TABLE_RENDERER));
        this.tierUsageByCacheTable.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)((Object)this.MEMORY_SIZE_TABLE_RENDERER));
        return this.tierUsageByCacheTable;
    }

    protected static StatusView createOverlayLabel(String text, Color fg, Color indicator) {
        StatusView result = new StatusView();
        result.setText(text);
        result.setIndicator(indicator);
        result.setFont(CHART_LABEL_FONT);
        result.getLabel().setHorizontalAlignment(0);
        result.setForeground(fg);
        return result;
    }

    protected static StatusView createOverlayLabel(String text, Color indicator) {
        return ClientCacheManagerSizingPanel.createOverlayLabel(text, CHART_LABEL_FG, indicator);
    }

    private XLabel addOverlayLabel(ChartPanel chartPanel, JComponent label) {
        Plot plot = chartPanel.getChart().getPlot();
        int bottomInset = plot.getInsets().equals((Object)this.tierUsageByCachePlotInsets) ? 1 : 4;
        chartPanel.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 10, bottomInset, 1);
        gbc.fill = 1;
        gbc.anchor = 17;
        chartPanel.add((Component)new XLabel(), (Object)gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        chartPanel.add((Component)label, (Object)gbc);
        ++gbc.gridx;
        gbc.insets = new Insets(0, 0, 0, 0);
        chartPanel.add((Component)new XLabel(), (Object)gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 1, bottomInset, 10);
        XLabel result = new XLabel();
        chartPanel.add((Component)result, (Object)gbc);
        label.setOpaque(false);
        result.setForeground(label.getForeground());
        return result;
    }

    private XContainer createCacheManagerCapacityPanel() {
        XContainer result = new XContainer((LayoutManager)new GridLayout(3, 1));
        this.localHeapCapacityDataset = new DefaultCategoryDataset();
        this.localHeapCapacityPanel = ClientCacheManagerSizingPanel.createCapacityBarChart(this.localHeapCapacityDataset, false);
        this.localHeapCapacityLabel = this.addOverlayLabel(this.localHeapCapacityPanel, (JComponent)ClientCacheManagerSizingPanel.createOverlayLabel(LOCAL_HEAP, LOCAL_HEAP_COLOR));
        this.localHeapCapacityPanel.setBorder(null);
        this.localHeapCapacityPanel.addChartMouseListener((ChartMouseListener)new TierChartListener(LOCAL_HEAP));
        this.localHeapCapacityPlot = (CategoryPlot)this.localHeapCapacityPanel.getChart().getPlot();
        this.localHeapCapacityPlot.getDomainAxis().setVisible(false);
        this.localHeapCapacityPlotRenderer = this.localHeapCapacityPlot.getRenderer();
        this.localHeapCapacityTipGenerator = (UtilizationToolTipGenerator)this.localHeapCapacityPlotRenderer.getBaseToolTipGenerator();
        this.localHeapCapacityPlotRenderer.setSeriesPaint(0, (Paint)LOCAL_HEAP_COLOR);
        result.add((Component)this.localHeapCapacityPanel);
        this.localOffHeapCapacityDataset = new DefaultCategoryDataset();
        this.localOffHeapCapacityPanel = ClientCacheManagerSizingPanel.createCapacityBarChart(this.localOffHeapCapacityDataset, false);
        this.localOffHeapCapacityLabel = this.addOverlayLabel(this.localOffHeapCapacityPanel, (JComponent)ClientCacheManagerSizingPanel.createOverlayLabel(LOCAL_OFFHEAP, LOCAL_OFFHEAP_COLOR));
        this.localOffHeapCapacityPanel.setBorder(null);
        this.localOffHeapCapacityPanel.addChartMouseListener((ChartMouseListener)new TierChartListener(LOCAL_OFFHEAP));
        this.localOffHeapCapacityPlot = (CategoryPlot)this.localOffHeapCapacityPanel.getChart().getPlot();
        this.localOffHeapCapacityPlot.getDomainAxis().setVisible(false);
        this.localOffHeapCapacityPlotRenderer = this.localOffHeapCapacityPlot.getRenderer();
        this.localOffHeapCapacityTipGenerator = (UtilizationToolTipGenerator)this.localOffHeapCapacityPlotRenderer.getBaseToolTipGenerator();
        this.localOffHeapCapacityPlotRenderer.setSeriesPaint(0, (Paint)LOCAL_OFFHEAP_COLOR);
        result.add((Component)this.localOffHeapCapacityPanel);
        this.localDiskCapacityDataset = new DefaultCategoryDataset();
        this.localDiskCapacityPanel = ClientCacheManagerSizingPanel.createCapacityBarChart(this.localDiskCapacityDataset, false);
        this.localDiskCapacityLabel = this.addOverlayLabel(this.localDiskCapacityPanel, (JComponent)ClientCacheManagerSizingPanel.createOverlayLabel(LOCAL_DISK, LOCAL_DISK_COLOR));
        this.localDiskCapacityPanel.setBorder(null);
        this.localDiskCapacityPanel.addChartMouseListener((ChartMouseListener)new TierChartListener(LOCAL_DISK));
        this.localDiskCapacityPlot = (CategoryPlot)this.localDiskCapacityPanel.getChart().getPlot();
        this.localDiskCapacityPlot.getDomainAxis().setVisible(false);
        this.localDiskCapacityPlotRenderer = this.localDiskCapacityPlot.getRenderer();
        this.localDiskCapacityTipGenerator = (UtilizationToolTipGenerator)this.localDiskCapacityPlotRenderer.getBaseToolTipGenerator();
        this.localDiskCapacityPlotRenderer.setSeriesPaint(0, (Paint)LOCAL_DISK_COLOR);
        result.add((Component)this.localDiskCapacityPanel);
        this.remoteCapacityDataset = new DefaultCategoryDataset();
        this.remoteCapacityPanel = ClientCacheManagerSizingPanel.createCapacityBarChart(this.remoteCapacityDataset, false);
        this.remoteCapacityLabel = this.addOverlayLabel(this.remoteCapacityPanel, (JComponent)ClientCacheManagerSizingPanel.createOverlayLabel("Remote (estimate)", REMOTE_COLOR));
        this.remoteCapacityPanel.setBorder(null);
        this.remoteCapacityPanel.addChartMouseListener((ChartMouseListener)new TierChartListener(REMOTE));
        this.remoteCapacityPlot = (CategoryPlot)this.remoteCapacityPanel.getChart().getPlot();
        this.remoteCapacityPlot.getDomainAxis().setVisible(false);
        this.remoteCapacityPlotRenderer = this.remoteCapacityPlot.getRenderer();
        this.remoteCapacityTipGenerator = new RemoteUtilizationToolTipGenerator();
        this.remoteCapacityPlotRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)this.remoteCapacityTipGenerator);
        this.remoteCapacityPlotRenderer.setSeriesPaint(0, (Paint)REMOTE_COLOR);
        result.add((Component)this.remoteCapacityPanel);
        result.setBorder((Border)BorderFactory.createTitledBorder("CacheManager Utilization by Tier"));
        return result;
    }

    static IntervalMarker createReservedMarker(long value) {
        Color c = new Color(255, 230, 138);
        return new IntervalMarker(0.0, (double)value, (Paint)c, (Stroke)new BasicStroke(0.5f), (Paint)c, (Stroke)new BasicStroke(0.5f), 0.3f);
    }

    private static void trySetAutoCreateRowSorter(JTable table) {
        try {
            Method m = table.getClass().getMethod("setAutoCreateRowSorter", Boolean.TYPE);
            m.invoke((Object)table, Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private XContainer createCachePanel() {
        this.selectedCachePanel = new XContainer((LayoutManager)new BorderLayout());
        XSplitPane splitter = new XSplitPane(1, (Component)this.createCacheCapacityPanel(), (Component)this.createMissesByTierChart());
        splitter.setDefaultDividerLocation(0.5);
        this.selectedCachePanel.add((Component)splitter, (Object)"Center");
        XContainer topPanel = new XContainer((LayoutManager)new BorderLayout());
        XContainer topContent = new XContainer((LayoutManager)new FlowLayout());
        XLabel label = new XLabel("Selected Cache:");
        topContent.add((Component)label);
        label.setFont(LABEL_FONT);
        this.selectedCacheChooser = new XComboBox(new DefaultComboBoxModel());
        topContent.add((Component)this.selectedCacheChooser);
        this.selectedCacheChooser.setRenderer((ListCellRenderer)new CacheComboRenderer());
        this.selectedCacheListener = new SelectedCacheListener();
        this.cacheSummaryLabel = new XLabel();
        topContent.add((Component)this.cacheSummaryLabel);
        topPanel.add((Component)topContent, (Object)"West");
        this.selectedCachePanel.add((Component)topPanel, (Object)"North");
        return this.selectedCachePanel;
    }

    private XContainer createCacheCapacityPanel() {
        XContainer result = new XContainer((LayoutManager)new GridLayout(3, 1));
        this.cacheLocalHeapCapacityDataset = new DefaultCategoryDataset();
        this.cacheLocalHeapCapacityPanel = ClientCacheManagerSizingPanel.createCapacityBarChart(this.cacheLocalHeapCapacityDataset, false);
        this.cacheLocalHeapCapacityLabel = this.addOverlayLabel(this.cacheLocalHeapCapacityPanel, (JComponent)ClientCacheManagerSizingPanel.createOverlayLabel(LOCAL_HEAP, LOCAL_HEAP_COLOR));
        this.cacheLocalHeapCapacityPanel.setBorder(null);
        this.cacheLocalHeapCapacityPanel.addChartMouseListener((ChartMouseListener)new TierChartListener(LOCAL_HEAP));
        this.cacheLocalHeapCapacityPlot = (CategoryPlot)this.cacheLocalHeapCapacityPanel.getChart().getPlot();
        this.cacheLocalHeapCapacityPlot.getDomainAxis().setVisible(false);
        this.cacheLocalHeapCapacityPlotRenderer = this.cacheLocalHeapCapacityPlot.getRenderer();
        this.cacheLocalHeapCapacityTipGenerator = (UtilizationToolTipGenerator)this.cacheLocalHeapCapacityPlotRenderer.getBaseToolTipGenerator();
        this.cacheLocalHeapCapacityPlotRenderer.setSeriesPaint(0, (Paint)LOCAL_HEAP_COLOR);
        result.add((Component)this.cacheLocalHeapCapacityPanel);
        this.cacheLocalOffHeapCapacityDataset = new DefaultCategoryDataset();
        this.cacheLocalOffHeapCapacityPanel = ClientCacheManagerSizingPanel.createCapacityBarChart(this.cacheLocalOffHeapCapacityDataset, false);
        this.cacheLocalOffHeapCapacityLabel = this.addOverlayLabel(this.cacheLocalOffHeapCapacityPanel, (JComponent)ClientCacheManagerSizingPanel.createOverlayLabel(LOCAL_OFFHEAP, LOCAL_OFFHEAP_COLOR));
        this.cacheLocalOffHeapCapacityPanel.setBorder(null);
        this.cacheLocalOffHeapCapacityPanel.addChartMouseListener((ChartMouseListener)new TierChartListener(LOCAL_OFFHEAP));
        this.cacheLocalOffHeapCapacityPlot = (CategoryPlot)this.cacheLocalOffHeapCapacityPanel.getChart().getPlot();
        this.cacheLocalOffHeapCapacityPlot.getDomainAxis().setVisible(false);
        this.cacheLocalOffHeapCapacityPlotRenderer = this.cacheLocalOffHeapCapacityPlot.getRenderer();
        this.cacheLocalOffHeapCapacityTipGenerator = (UtilizationToolTipGenerator)this.cacheLocalOffHeapCapacityPlotRenderer.getBaseToolTipGenerator();
        this.cacheLocalOffHeapCapacityPlotRenderer.setSeriesPaint(0, (Paint)LOCAL_OFFHEAP_COLOR);
        result.add((Component)this.cacheLocalOffHeapCapacityPanel);
        this.cacheLocalDiskCapacityDataset = new DefaultCategoryDataset();
        this.cacheLocalDiskCapacityPanel = ClientCacheManagerSizingPanel.createCapacityBarChart(this.cacheLocalDiskCapacityDataset, false);
        this.cacheLocalDiskCapacityStatusView = ClientCacheManagerSizingPanel.createOverlayLabel(LOCAL_DISK, LOCAL_DISK_COLOR);
        this.cacheLocalDiskCapacityLabel = this.addOverlayLabel(this.cacheLocalDiskCapacityPanel, (JComponent)this.cacheLocalDiskCapacityStatusView);
        this.cacheLocalDiskCapacityPanel.setBorder(null);
        this.cacheLocalDiskCapacityChartListener = new TierChartListener(LOCAL_DISK);
        this.cacheLocalDiskCapacityPanel.addChartMouseListener((ChartMouseListener)this.cacheLocalDiskCapacityChartListener);
        this.cacheLocalDiskCapacityPlot = (CategoryPlot)this.cacheLocalDiskCapacityPanel.getChart().getPlot();
        this.cacheLocalDiskCapacityPlot.getDomainAxis().setVisible(false);
        this.cacheLocalDiskCapacityPlotRenderer = this.cacheLocalDiskCapacityPlot.getRenderer();
        this.cacheLocalDiskCapacityTipGenerator = (UtilizationToolTipGenerator)this.cacheLocalDiskCapacityPlotRenderer.getBaseToolTipGenerator();
        this.cacheRemoteCapacityTipGenerator = new RemoteUtilizationToolTipGenerator();
        this.cacheLocalDiskCapacityPlotRenderer.setSeriesPaint(0, (Paint)LOCAL_DISK_COLOR);
        result.add((Component)this.cacheLocalDiskCapacityPanel);
        result.setBorder((Border)BorderFactory.createTitledBorder("Cache Utilization by Tier"));
        return result;
    }

    private ChartPanel createPieChart(PieDataset dataset, boolean showLegend) {
        return this.createPieChart(dataset, showLegend, null, 0.0);
    }

    private ChartPanel createPieChart(PieDataset dataset, boolean showLegend, String explodeSlice, double explodePercent) {
        JFreeChart chart = ChartFactory.createPieChart((String)"", (PieDataset)dataset, (boolean)showLegend, (boolean)true, (boolean)false);
        chart.setAntiAlias(true);
        chart.setBackgroundPaint(null);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setToolTipGenerator((PieToolTipGenerator)new CachePieToolTipGenerator());
        if (explodeSlice != null) {
            plot.setExplodePercent((Comparable)((Object)explodeSlice), explodePercent);
        }
        plot.setIgnoreZeroValues(true);
        plot.setMaximumLabelWidth(0.2);
        plot.setSimpleLabels(false);
        plot.setSectionOutlinesVisible(true);
        plot.setNoDataMessage("No data available");
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPopupMenu(null);
        chartPanel.setMouseZoomable(false);
        chartPanel.setMouseWheelEnabled(false);
        chartPanel.setPreferredSize(CHART_MIN_SIZE);
        return chartPanel;
    }

    private XContainer createMissesByTierChart() {
        XContainer result = new XContainer((LayoutManager)new GridLayout(3, 1));
        this.localHeapMissesDataset = new DefaultCategoryDataset();
        ChartPanel missesPanel = this.createBarChart((CategoryDataset)this.localHeapMissesDataset, false);
        this.localHeapMissesLabel = this.addOverlayLabel(missesPanel, (JComponent)ClientCacheManagerSizingPanel.createOverlayLabel(LOCAL_HEAP, LOCAL_HEAP_COLOR));
        missesPanel.setBorder(null);
        missesPanel.addChartMouseListener((ChartMouseListener)new TierChartListener(LOCAL_HEAP));
        this.localHeapMissesPlot = (CategoryPlot)missesPanel.getChart().getPlot();
        this.localHeapMissesPlot.getDomainAxis().setVisible(false);
        this.localHeapMissesPlot.getRenderer().setSeriesPaint(0, (Paint)LOCAL_HEAP_COLOR);
        result.add((Component)missesPanel);
        this.localOffHeapMissesDataset = new DefaultCategoryDataset();
        missesPanel = this.createBarChart((CategoryDataset)this.localOffHeapMissesDataset, false);
        this.localOffHeapMissesLabel = this.addOverlayLabel(missesPanel, (JComponent)ClientCacheManagerSizingPanel.createOverlayLabel(LOCAL_OFFHEAP, LOCAL_OFFHEAP_COLOR));
        missesPanel.setBorder(null);
        missesPanel.addChartMouseListener((ChartMouseListener)new TierChartListener(LOCAL_OFFHEAP));
        this.localOffHeapMissesPlot = (CategoryPlot)missesPanel.getChart().getPlot();
        this.localOffHeapMissesPlot.getDomainAxis().setVisible(false);
        this.localOffHeapMissesPlot.getRenderer().setSeriesPaint(0, (Paint)LOCAL_OFFHEAP_COLOR);
        result.add((Component)missesPanel);
        this.localDiskMissesDataset = new DefaultCategoryDataset();
        missesPanel = this.createBarChart((CategoryDataset)this.localDiskMissesDataset, false);
        this.localDiskMissesStatusView = ClientCacheManagerSizingPanel.createOverlayLabel(LOCAL_DISK, LOCAL_DISK_COLOR);
        this.localDiskMissesLabel = this.addOverlayLabel(missesPanel, (JComponent)this.localDiskMissesStatusView);
        missesPanel.setBorder(null);
        missesPanel.addChartMouseListener((ChartMouseListener)new TierChartListener(LOCAL_DISK));
        this.localDiskMissesPlot = (CategoryPlot)missesPanel.getChart().getPlot();
        this.localDiskMissesPlot.getDomainAxis().setVisible(false);
        this.localDiskMissesPlot.getRenderer().setSeriesPaint(0, (Paint)LOCAL_DISK_COLOR);
        result.add((Component)missesPanel);
        result.setBorder((Border)BorderFactory.createTitledBorder("Cache Miss Rate by Tier"));
        return result;
    }

    private ChartPanel createBarChart(CategoryDataset dataset, boolean showLegend) {
        JFreeChart chart = ChartFactory.createBarChart((String)"", (String)"", (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)showLegend, (boolean)true, (boolean)false);
        chart.setAntiAlias(true);
        chart.setBackgroundPaint(null);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setForegroundAlpha(1.0f);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(true);
        renderer.setMaximumBarWidth(0.25);
        renderer.setShadowVisible(false);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPopupMenu(null);
        chartPanel.setOpaque(false);
        chartPanel.setMouseZoomable(false);
        chartPanel.setMouseWheelEnabled(false);
        chartPanel.setPreferredSize(CHART_MIN_SIZE);
        return chartPanel;
    }

    private static ChartPanel createCapacityBarChart(DefaultCategoryDataset dataset, boolean showLegend) {
        JFreeChart chart = ChartFactory.createBarChart((String)"", (String)"", (String)"", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)showLegend, (boolean)true, (boolean)false);
        chart.setAntiAlias(true);
        chart.setBackgroundPaint(null);
        CategoryPlot categoryplot = (CategoryPlot)chart.getPlot();
        BarRenderer renderer = (BarRenderer)categoryplot.getRenderer();
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new UtilizationToolTipGenerator());
        renderer.setDrawBarOutline(true);
        renderer.setMaximumBarWidth(0.25);
        renderer.setShadowVisible(false);
        categoryplot.setForegroundAlpha(1.0f);
        ((NumberAxis)categoryplot.getRangeAxis()).setNumberFormatOverride((NumberFormat)THIN_MEMORY_FORMAT);
        ((NumberAxis)categoryplot.getRangeAxis()).setStandardTickUnits(MEMORY_TICK_UNITS);
        ((NumberAxis)categoryplot.getRangeAxis()).setRangeType(RangeType.POSITIVE);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPopupMenu(null);
        chartPanel.setOpaque(false);
        chartPanel.setMouseZoomable(false);
        chartPanel.setMouseWheelEnabled(false);
        chartPanel.setPreferredSize(CHART_MIN_SIZE);
        chartPanel.setBorder((Border)BorderFactory.createTitledBorder("Utilization by Tier"));
        return chartPanel;
    }

    private static TickUnits createMemoryIntegerTickUnits() {
        TickUnits units = new TickUnits();
        ThinMemoryFormat numberFormat = THIN_MEMORY_FORMAT;
        units.add((TickUnit)new NumberTickUnit(1.0, (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit(8.0, (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit(16.0, (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit(32.0, (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit(64.0, (NumberFormat)numberFormat, 5));
        units.add((TickUnit)new NumberTickUnit(128.0, (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit(256.0, (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit(512.0, (NumberFormat)numberFormat, 5));
        long kbyte = 1024L;
        units.add((TickUnit)new NumberTickUnit((double)kbyte, (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(8L * kbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(16L * kbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(32L * kbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(64L * kbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(128L * kbyte), (NumberFormat)numberFormat, 5));
        units.add((TickUnit)new NumberTickUnit((double)(256L * kbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(512L * kbyte), (NumberFormat)numberFormat, 2));
        long mbyte = 0x100000L;
        units.add((TickUnit)new NumberTickUnit((double)mbyte, (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(8L * mbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(16L * mbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(32L * mbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(64L * mbyte), (NumberFormat)numberFormat, 5));
        units.add((TickUnit)new NumberTickUnit((double)(128L * mbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(256L * mbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(512L * mbyte), (NumberFormat)numberFormat, 5));
        long gbyte = 0x40000000L;
        units.add((TickUnit)new NumberTickUnit((double)gbyte, (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(8L * gbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(16L * gbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(32L * gbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(64L * gbyte), (NumberFormat)numberFormat, 5));
        units.add((TickUnit)new NumberTickUnit((double)(128L * gbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(256L * gbyte), (NumberFormat)numberFormat, 2));
        units.add((TickUnit)new NumberTickUnit((double)(512L * gbyte), (NumberFormat)numberFormat, 5));
        long tbyte = 0x10000000000L;
        units.add((TickUnit)new NumberTickUnit((double)tbyte, (NumberFormat)numberFormat));
        units.add((TickUnit)new NumberTickUnit((double)(8L * tbyte), (NumberFormat)numberFormat));
        units.add((TickUnit)new NumberTickUnit((double)(16L * tbyte), (NumberFormat)numberFormat));
        units.add((TickUnit)new NumberTickUnit((double)(32L * tbyte), (NumberFormat)numberFormat));
        units.add((TickUnit)new NumberTickUnit((double)(64L * tbyte), (NumberFormat)numberFormat));
        units.add((TickUnit)new NumberTickUnit((double)(128L * tbyte), (NumberFormat)numberFormat));
        units.add((TickUnit)new NumberTickUnit((double)(256L * tbyte), (NumberFormat)numberFormat));
        units.add((TickUnit)new NumberTickUnit((double)(512L * tbyte), (NumberFormat)numberFormat));
        return units;
    }

    private void selectTier(String tierName) {
        this.tierChooser.setSelectedItem((Object)tierName);
    }

    private String selectedTier() {
        return this.tierChooser.getSelectedItem().toString();
    }

    private void updateCacheSizeByTier() {
        String selectedCache = (String)this.selectedCacheChooser.getSelectedItem();
        if (selectedCache != null) {
            StandardCategoryToolTipGenerator tipGenerator;
            String selectedTier = this.selectedTier();
            CacheModelInstance cmi = this.cacheManagerInstance.getCacheModelInstance(selectedCache);
            if (cmi == null) {
                return;
            }
            boolean tcClustered = cmi.isTerracottaClustered();
            CacheTierSize tierSize = this.cacheSizes.get(cmi);
            long usedLocalHeap = tierSize.getLocalHeapSizeInBytes();
            long localHeapMissRate = tierSize.getLocalHeapMissRate();
            long localOffHeapRate = tierSize.getLocalOffHeapMissRate();
            long localDiskRate = tierSize.getLocalDiskMissRate();
            this.localHeapMissesDataset.clear();
            this.localOffHeapMissesDataset.clear();
            this.localDiskMissesDataset.clear();
            if (localHeapMissRate > 0L) {
                this.localHeapMissesDataset.setValue((double)localHeapMissRate, (Comparable)((Object)LOCAL_HEAP), (Comparable)((Object)MISS_RATE));
            }
            this.localHeapMissesLabel.setText("Misses/sec.: " + THIN_DECIMAL_FORMAT.format(localHeapMissRate));
            this.updateTierPlotSelectionGraphics((Plot)this.localHeapMissesPlot, selectedTier, LOCAL_HEAP);
            if (localOffHeapRate > 0L) {
                this.localOffHeapMissesDataset.setValue((double)localOffHeapRate, (Comparable)((Object)LOCAL_OFFHEAP), (Comparable)((Object)MISS_RATE));
            }
            this.localOffHeapMissesLabel.setText("Misses/sec.: " + THIN_DECIMAL_FORMAT.format(localOffHeapRate));
            this.updateTierPlotSelectionGraphics((Plot)this.localOffHeapMissesPlot, selectedTier, LOCAL_OFFHEAP);
            if (localDiskRate > 0L) {
                this.localDiskMissesDataset.setValue((double)localDiskRate, (Comparable)((Object)(tcClustered ? REMOTE : LOCAL_DISK)), (Comparable)((Object)MISS_RATE));
            }
            this.localDiskMissesPlot.getRenderer().setSeriesPaint(0, (Paint)(tcClustered ? REMOTE_COLOR : LOCAL_DISK_COLOR));
            this.localDiskMissesStatusView.setIndicator(tcClustered ? REMOTE_COLOR : LOCAL_DISK_COLOR);
            this.localDiskMissesStatusView.getLabel().setText(tcClustered ? REMOTE : LOCAL_DISK);
            this.localDiskMissesLabel.setText("Misses/sec.: " + THIN_DECIMAL_FORMAT.format(localDiskRate));
            this.updateTierPlotSelectionGraphics((Plot)this.localDiskMissesPlot, selectedTier, tcClustered ? REMOTE : LOCAL_DISK);
            long maxMissesUpper = this.determineMax(localHeapMissRate, localOffHeapRate, localDiskRate);
            this.setRangeAxisPlusExtra(maxMissesUpper, this.localHeapMissesPlot, this.localOffHeapMissesPlot, this.localDiskMissesPlot);
            this.cacheLocalHeapCapacityDataset.clear();
            this.cacheLocalHeapCapacityPlot.clearRangeMarkers();
            long reservedLocalHeap = tierSize.getMaxBytesLocalHeap();
            if (reservedLocalHeap > 0L) {
                this.cacheLocalHeapCapacityPlot.getRangeAxis().setRange(0.0, (double)reservedLocalHeap);
                this.addMaximumRangeValueMarker(this.cacheLocalHeapCapacityPlot, reservedLocalHeap);
            } else {
                this.cacheLocalHeapCapacityPlot.getRangeAxis().setAutoRange(true);
            }
            this.cacheLocalHeapCapacityDataset.setValue((double)usedLocalHeap, (Comparable)((Object)USED), (Comparable)((Object)LOCAL_HEAP));
            this.cacheLocalHeapCapacityLabel.setText(this.handleMaximum(reservedLocalHeap, (DecimalFormat)THIN_MEMORY_FORMAT) + "  Used: " + THIN_MEMORY_FORMAT.format(usedLocalHeap) + this.handleAvailable(reservedLocalHeap, usedLocalHeap, (DecimalFormat)THIN_MEMORY_FORMAT));
            ClientCacheManagerSizingPanel.updatePlotRangeAxis(this.cacheLocalHeapCapacityPlot);
            this.updateTierPlotSelectionGraphics((Plot)this.cacheLocalHeapCapacityPlot, selectedTier, LOCAL_HEAP);
            this.cacheLocalHeapCapacityTipGenerator.setup(LOCAL_HEAP, usedLocalHeap, 0L, reservedLocalHeap, tierSize.getLocalHeapSize());
            this.cacheLocalOffHeapCapacityDataset.clear();
            this.cacheLocalOffHeapCapacityPlot.clearRangeMarkers();
            long reservedLocalOffHeap = tierSize.getMaxBytesLocalOffHeap();
            if (reservedLocalOffHeap > 0L) {
                this.cacheLocalOffHeapCapacityPlot.getRangeAxis().setRange(0.0, (double)reservedLocalOffHeap);
                this.addMaximumRangeValueMarker(this.cacheLocalOffHeapCapacityPlot, reservedLocalOffHeap);
            } else {
                this.cacheLocalOffHeapCapacityPlot.getRangeAxis().setAutoRange(true);
            }
            long usedLocalOffHeap = tierSize.getLocalOffHeapSizeInBytes();
            this.cacheLocalOffHeapCapacityDataset.setValue((double)usedLocalOffHeap, (Comparable)((Object)USED), (Comparable)((Object)LOCAL_OFFHEAP));
            this.cacheLocalOffHeapCapacityLabel.setText(this.handleMaximum(reservedLocalOffHeap, (DecimalFormat)THIN_MEMORY_FORMAT) + "  Used: " + THIN_MEMORY_FORMAT.format(usedLocalOffHeap) + this.handleAvailable(reservedLocalOffHeap, usedLocalOffHeap, (DecimalFormat)THIN_MEMORY_FORMAT));
            ClientCacheManagerSizingPanel.updatePlotRangeAxis(this.cacheLocalOffHeapCapacityPlot);
            this.updateTierPlotSelectionGraphics((Plot)this.cacheLocalOffHeapCapacityPlot, selectedTier, LOCAL_OFFHEAP);
            this.cacheLocalOffHeapCapacityTipGenerator.setup(LOCAL_OFFHEAP, usedLocalOffHeap, 0L, reservedLocalOffHeap, tierSize.getLocalOffHeapSize());
            this.cacheLocalDiskCapacityDataset.clear();
            this.cacheLocalDiskCapacityPlot.clearRangeMarkers();
            long usedLocalDisk = tierSize.sizeInBytesForTier(tcClustered ? REMOTE : LOCAL_DISK);
            long reservedLocalDisk = tierSize.maxBytesForTier(tcClustered ? REMOTE : LOCAL_DISK);
            if (reservedLocalDisk > 0L) {
                this.cacheLocalDiskCapacityPlot.getRangeAxis().setRange(0.0, (double)Math.max(reservedLocalDisk, usedLocalDisk));
                this.addMaximumRangeValueMarker(this.cacheLocalDiskCapacityPlot, reservedLocalDisk);
            } else {
                this.cacheLocalDiskCapacityPlot.getRangeAxis().setAutoRange(true);
            }
            this.cacheLocalDiskCapacityDataset.setValue((double)usedLocalDisk, (Comparable)((Object)USED), (Comparable)((Object)(tcClustered ? REMOTE : LOCAL_DISK)));
            this.cacheLocalDiskCapacityStatusView.getLabel().setText(tcClustered ? "Remote (estimate)" : LOCAL_DISK);
            this.cacheLocalDiskCapacityStatusView.setIndicator(tcClustered ? REMOTE_COLOR : LOCAL_DISK_COLOR);
            this.cacheLocalDiskCapacityPlot.getRenderer().setSeriesPaint(0, (Paint)(tcClustered ? REMOTE_COLOR : LOCAL_DISK_COLOR));
            this.cacheLocalDiskCapacityLabel.setText(this.handleMaximum(reservedLocalDisk, (DecimalFormat)THIN_MEMORY_FORMAT) + "  Used: " + THIN_MEMORY_FORMAT.format(usedLocalDisk) + this.handleAvailable(reservedLocalDisk, usedLocalDisk, (DecimalFormat)THIN_MEMORY_FORMAT));
            this.cacheLocalDiskCapacityChartListener.setTier(tcClustered ? REMOTE : LOCAL_DISK);
            ClientCacheManagerSizingPanel.updatePlotRangeAxis(this.cacheLocalDiskCapacityPlot);
            this.updateTierPlotSelectionGraphics((Plot)this.cacheLocalDiskCapacityPlot, selectedTier, tcClustered ? REMOTE : LOCAL_DISK);
            if (tcClustered) {
                this.cacheRemoteCapacityTipGenerator.setup(REMOTE, tierSize.maxEntriesForTier(REMOTE), reservedLocalDisk, tierSize.entriesForTier(REMOTE), usedLocalDisk);
                tipGenerator = this.cacheRemoteCapacityTipGenerator;
            } else {
                this.cacheLocalDiskCapacityTipGenerator.setup(LOCAL_DISK, usedLocalDisk, 0L, reservedLocalDisk, tierSize.getLocalDiskSize());
                tipGenerator = this.cacheLocalDiskCapacityTipGenerator;
            }
            this.cacheLocalDiskCapacityPlot.getRenderer().setBaseToolTipGenerator((CategoryToolTipGenerator)tipGenerator);
            this.synchronizeRangeAxes(this.cacheLocalHeapCapacityPlot, this.cacheLocalOffHeapCapacityPlot, this.cacheLocalDiskCapacityPlot);
        }
    }

    private void synchronizeRangeAxes(CategoryPlot ... plots) {
        double upperBound = 0.0;
        for (CategoryPlot plot : plots) {
            upperBound = Math.max(upperBound, plot.getRangeAxis().getUpperBound());
        }
        upperBound = upperBound > 10.0 ? (upperBound += upperBound / 10.0) : (upperBound += 1.0);
        for (CategoryPlot plot : plots) {
            plot.getRangeAxis().setRange(0.0, upperBound);
        }
    }

    private String handleReserved(long reserved, DecimalFormat format) {
        if (reserved <= 0L) {
            return "  Reserved: " + format.format(0L);
        }
        return "";
    }

    private String handleMaximum(long max, DecimalFormat format) {
        if (max <= 0L) {
            return "  Max: " + format.format(0L);
        }
        return "";
    }

    private String handleAvailable(long max, long used, DecimalFormat format) {
        if (max > 0L && max - used > 0L) {
            return "  Available: " + format.format(max - used);
        }
        return "";
    }

    private void selectSlice(PiePlot plot, Comparable sliceKey) {
        List keys = plot.getDataset().getKeys();
        for (Comparable key : keys) {
            double explodePercent = 0.0;
            if (key.equals(sliceKey)) {
                explodePercent = 0.1;
                this.selectedCacheChooser.setSelectedItem((Object)key.toString());
            }
            plot.setExplodePercent(key, explodePercent);
        }
    }

    private boolean listeningToCacheChooser() {
        ArrayList<ActionListener> l = new ArrayList<ActionListener>(Arrays.asList(this.selectedCacheChooser.getActionListeners()));
        return l.contains(this.selectedCacheListener);
    }

    private void selectSliceQuietly(PiePlot plot, Comparable sliceKey) {
        boolean wasListening = this.listeningToCacheChooser();
        if (wasListening) {
            this.selectedCacheChooser.removeActionListener((ActionListener)this.selectedCacheListener);
        }
        this.selectSlice(plot, sliceKey);
        if (wasListening) {
            this.selectedCacheChooser.addActionListener((ActionListener)this.selectedCacheListener);
        }
    }

    private void updateTierUsageByCacheTable(String selectedCache) {
        int cacheTableRow = this.cacheTableRowForName(selectedCache);
        if (cacheTableRow != -1) {
            this.tierUsageByCacheTable.getSelectionModel().removeListSelectionListener(this.tierUsageByCacheTableSelectionListener);
            this.tierUsageByCacheTable.setSelectedRow(cacheTableRow);
            this.tierUsageByCacheTable.getSelectionModel().addListSelectionListener(this.tierUsageByCacheTableSelectionListener);
        }
    }

    private void selectCacheSlice(Comparable sliceKey) {
        if (!sliceKey.equals(AVAILABLE)) {
            this.selectSliceQuietly(this.tierUsageByCachePlot, sliceKey);
            this.updateTierUsageByCacheTable(sliceKey.toString());
            this.updateCacheSizeByTier();
            String cacheSummaryText = null;
            CacheModelInstance cmi = this.cacheManagerInstance.getCacheModelInstance(sliceKey.toString());
            if (cmi != null) {
                if (cmi.isPinned()) {
                    cacheSummaryText = " is pinned to " + cmi.getPinnedToStore();
                } else {
                    SettingsCacheModel scm = this.cacheManagerInstance.getSettingsCacheModel(cmi);
                    if (scm != null) {
                        cacheSummaryText = scm.hasSizeBasedLimits() ? " is size-based" : " is pool-based";
                    }
                }
            }
            this.cacheSummaryLabel.setText(cacheSummaryText);
        }
    }

    private int cacheTableRowForName(String cacheName) {
        for (int row = 0; row < this.tierUsageByCacheTableModel.getRowCount(); ++row) {
            String name = (String)this.tierUsageByCacheTable.getValueAt(row, 0);
            if (!cacheName.equals(name)) continue;
            return row;
        }
        return -1;
    }

    private long sizeInBytesForTier(String tierName) {
        long result = 0L;
        for (CacheModelInstance cmi : this.cacheManagerInstance.cacheModelInstances()) {
            CacheTierSize cts;
            if (cmi == null || tierName.equals(REMOTE) && !cmi.isTerracottaClustered() || tierName.equals(LOCAL_DISK) && cmi.isTerracottaClustered() || (cts = this.cacheSizes.get(cmi)) == null) continue;
            result += cts.sizeInBytesForTier(tierName);
        }
        return result;
    }

    private long sizeInBytesForTier(String cacheName, String tierName) {
        CacheTierSize cts;
        CacheModelInstance cmi = this.cacheManagerInstance.getCacheModelInstance(cacheName);
        if (cmi != null && (cts = this.cacheSizes.get(cmi)) != null) {
            return cts.sizeInBytesForTier(tierName);
        }
        return 0L;
    }

    private long entriesForTier(String cacheName, String tierName) {
        CacheTierSize cts;
        CacheModelInstance cmi = this.cacheManagerInstance.getCacheModelInstance(cacheName);
        if (cmi != null && (cts = this.cacheSizes.get(cmi)) != null) {
            return cts.entriesForTier(tierName);
        }
        return 0L;
    }

    private void refreshLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClientCacheManagerSizingPanel.this.refresh();
            }
        });
    }

    @Override
    public void cacheManagerInstanceChanged(CacheManagerInstance theCacheManagerInstance) {
    }

    @Override
    public void cacheModelInstanceAdded(CacheModelInstance cacheModelInstance) {
        this.refreshLater();
    }

    @Override
    public void cacheModelInstanceRemoved(CacheModelInstance cacheModelInstance) {
        this.refreshLater();
    }

    @Override
    public void cacheModelInstanceChanged(CacheModelInstance cacheModelInstance) {
    }

    @Override
    public void tearDown() {
        if (this.cacheManagerInstance != null) {
            this.cacheManagerInstance.removeCacheManagerInstanceListener(this);
        }
        super.tearDown();
    }

    private class CachePieToolTipGenerator
    extends StandardPieToolTipGenerator {
        public CachePieToolTipGenerator() {
            super("{0}: {1} ({2})", (NumberFormat)THIN_MEMORY_FORMAT, NumberFormat.getPercentInstance());
        }

        protected String generateSectionLabel(PieDataset dataset, Comparable key) {
            return super.generateSectionLabel(dataset, key);
        }
    }

    private class CachePieValuesGenerator
    extends StandardPieToolTipGenerator {
        protected String generateSectionLabel(PieDataset dataset, Comparable key) {
            return super.generateSectionLabel(dataset, key);
        }

        private Object[] getTableItemArray(PieDataset dataset, Comparable key) {
            double v;
            String selectedTier = ClientCacheManagerSizingPanel.this.selectedTier();
            String cacheName = key.toString();
            Object[] result = new Object[5];
            long totalUsed = ClientCacheManagerSizingPanel.this.sizeInBytesForTier(selectedTier);
            result[0] = cacheName;
            Long value = ClientCacheManagerSizingPanel.this.sizeInBytesForTier(cacheName, selectedTier);
            result[1] = value != null ? value : 0L;
            double percentOfUsed = 0.0;
            if (value != null && (v = value.doubleValue()) > 0.0) {
                percentOfUsed = v / (double)(totalUsed > 0L ? totalUsed : 1L);
            }
            result[2] = percentOfUsed;
            long entries = ClientCacheManagerSizingPanel.this.entriesForTier(cacheName, selectedTier);
            result[3] = entries;
            result[4] = (value != null ? value.doubleValue() : 0.0) / (double)(entries > 0L ? entries : 1L);
            return result;
        }
    }

    private class TierChartListener
    implements ChartMouseListener {
        private String tierName;

        private TierChartListener(String tierName) {
            this.tierName = tierName;
        }

        public void chartMouseClicked(ChartMouseEvent e) {
            ClientCacheManagerSizingPanel.this.selectTier(this.tierName);
        }

        public void chartMouseMoved(ChartMouseEvent e) {
        }

        private synchronized void setTier(String tierName) {
            this.tierName = tierName;
        }
    }

    private abstract class PieChartListener
    implements ChartMouseListener {
        private PieChartListener() {
        }

        public void chartMouseClicked(ChartMouseEvent e) {
            ChartEntity chartEntity = e.getEntity();
            if (chartEntity instanceof PieSectionEntity) {
                this.selectSection(((PieSectionEntity)chartEntity).getSectionKey());
            }
        }

        public void chartMouseMoved(ChartMouseEvent e) {
        }

        abstract void selectSection(Comparable var1);
    }

    private class TierUsageByCacheChartListener
    extends PieChartListener {
        private TierUsageByCacheChartListener() {
        }

        void selectSection(Comparable sectionKey) {
            ClientCacheManagerSizingPanel.this.refreshTimer.stop();
            ClientCacheManagerSizingPanel.this.selectCacheSlice(sectionKey);
            ClientCacheManagerSizingPanel.this.refreshTimer.start();
        }
    }

    private static class RemoteUtilizationToolTipGenerator
    extends StandardCategoryToolTipGenerator {
        private String tip;

        private RemoteUtilizationToolTipGenerator() {
        }

        void setup(String tierName, long maxEntries, long estimatedMaxSize, long entries, long estimatedSize) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><table cellspacing=0 cellpadding=0 border=0>");
            sb.append("<tr><td>");
            sb.append("<u>");
            sb.append(tierName);
            sb.append(":</u>");
            sb.append("</td></tr>");
            sb.append("<tr><td>");
            sb.append("used = ");
            sb.append(THIN_DECIMAL_FORMAT.format(entries));
            sb.append(" entries (~ ");
            sb.append(THIN_MEMORY_FORMAT.format(estimatedSize));
            sb.append(")");
            sb.append("</td></tr>");
            if (maxEntries > 0L) {
                sb.append("<tr><td>");
                sb.append("max = ");
                sb.append(THIN_DECIMAL_FORMAT.format(maxEntries));
                sb.append(" entries (~ ");
                sb.append(THIN_MEMORY_FORMAT.format(estimatedMaxSize));
                sb.append(")");
                sb.append("</td></tr>");
            }
            sb.append("</table></html>");
            this.tip = sb.toString();
        }

        public String generateToolTip(CategoryDataset dataset, int row, int column) {
            return this.tip != null ? this.tip : super.generateToolTip(dataset, row, column);
        }
    }

    private static class UtilizationToolTipGenerator
    extends StandardCategoryToolTipGenerator {
        private String tip;

        private UtilizationToolTipGenerator() {
        }

        void setup(String tierName, long used, long reserved, long max, long entries) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><table cellspacing=0 cellpadding=0 border=0>");
            sb.append("<tr><td>");
            sb.append("<u>");
            sb.append(tierName);
            sb.append(":</u>");
            sb.append("</td></tr>");
            sb.append("<tr><td>");
            sb.append("used = ");
            sb.append(THIN_MEMORY_FORMAT.format(used));
            sb.append(" (");
            sb.append(THIN_DECIMAL_FORMAT.format(entries));
            sb.append(" entries)");
            sb.append("</td></tr>");
            if (reserved > 0L) {
                sb.append("<tr><td>");
                sb.append("reserved = ");
                sb.append(THIN_MEMORY_FORMAT.format(reserved));
                sb.append("</td></tr>");
            }
            if (max > 0L) {
                sb.append("<tr><td>");
                sb.append("max = ");
                sb.append(THIN_MEMORY_FORMAT.format(max));
                sb.append("</td></tr>");
            }
            sb.append("</table></html>");
            this.tip = sb.toString();
        }

        public String generateToolTip(CategoryDataset dataset, int row, int column) {
            return this.tip != null ? this.tip : super.generateToolTip(dataset, row, column);
        }
    }

    private class SelectedCacheListener
    implements ActionListener {
        private SelectedCacheListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ClientCacheManagerSizingPanel.this.refreshTimer.stop();
            ClientCacheManagerSizingPanel.this.selectCacheSlice((Comparable)((Object)((String)ClientCacheManagerSizingPanel.this.selectedCacheChooser.getSelectedItem())));
            ClientCacheManagerSizingPanel.this.refreshTimer.start();
        }
    }

    private class CacheComboRenderer
    extends DefaultListCellRenderer {
        private CacheComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setIcon(ClientCacheManagerSizingPanel.this.cacheManagerInstance.isCacheTerracottaClustered(value.toString()) ? EhcachePresentationUtils.CLUSTERED_ICON : EhcachePresentationUtils.NON_CLUSTERED_ICON);
            }
            return result;
        }
    }

    private class EntryCountTableRenderer
    extends XTable.BaseRenderer {
        public EntryCountTableRenderer() {
            super((Format)THIN_DECIMAL_FORMAT);
            this.label.setHorizontalAlignment(4);
        }

        public void setValue(JTable table, int row, int col) {
            CacheModelInstance cmi;
            String cacheName = (String)table.getValueAt(row, 0);
            String selectedTier = ClientCacheManagerSizingPanel.this.selectedTier();
            if (selectedTier.equals(ClientCacheManagerSizingPanel.REMOTE)) {
                CacheModelInstance cmi2 = ClientCacheManagerSizingPanel.this.cacheManagerInstance.getCacheModelInstance(cacheName);
                if (cmi2 != null && !cmi2.isTerracottaClustered()) {
                    this.setText("na");
                    return;
                }
            } else if (selectedTier.equals(ClientCacheManagerSizingPanel.LOCAL_DISK) && (cmi = ClientCacheManagerSizingPanel.this.cacheManagerInstance.getCacheModelInstance(cacheName)) != null && cmi.isTerracottaClustered()) {
                this.setText("na");
                return;
            }
            super.setValue(table, row, col);
        }
    }

    private class PercentMemoryUsedRenderer
    extends XTable.PercentRenderer {
        private PercentMemoryUsedRenderer() {
        }

        public void setValue(JTable table, int row, int col) {
            CacheModelInstance cmi;
            String cacheName = (String)table.getValueAt(row, 0);
            String selectedTier = ClientCacheManagerSizingPanel.this.selectedTier();
            if (selectedTier.equals(ClientCacheManagerSizingPanel.LOCAL_DISK)) {
                CacheModelInstance cmi2 = ClientCacheManagerSizingPanel.this.cacheManagerInstance.getCacheModelInstance(cacheName);
                if (cmi2 != null && cmi2.isTerracottaClustered()) {
                    this.setText("na");
                    return;
                }
            } else if (selectedTier.equals(ClientCacheManagerSizingPanel.REMOTE) && (cmi = ClientCacheManagerSizingPanel.this.cacheManagerInstance.getCacheModelInstance(cacheName)) != null && !cmi.isTerracottaClustered()) {
                this.setText("na");
                return;
            }
            super.setValue(table, row, col);
        }
    }

    private class MemorySizeTableRenderer
    extends XTable.BaseRenderer {
        public MemorySizeTableRenderer() {
            super((Format)THIN_MEMORY_FORMAT);
            this.label.setHorizontalAlignment(4);
        }

        public void setValue(JTable table, int row, int col) {
            CacheModelInstance cmi;
            String cacheName = (String)table.getValueAt(row, 0);
            if (ClientCacheManagerSizingPanel.this.selectedTier().equals(ClientCacheManagerSizingPanel.LOCAL_DISK)) {
                CacheModelInstance cmi2 = ClientCacheManagerSizingPanel.this.cacheManagerInstance.getCacheModelInstance(cacheName);
                if (cmi2 != null && cmi2.isTerracottaClustered()) {
                    this.setText("na");
                    return;
                }
            } else if (ClientCacheManagerSizingPanel.this.selectedTier().equals(ClientCacheManagerSizingPanel.REMOTE) && (cmi = ClientCacheManagerSizingPanel.this.cacheManagerInstance.getCacheModelInstance(cacheName)) != null && !cmi.isTerracottaClustered()) {
                this.setText("na");
                return;
            }
            super.setValue(table, row, col);
        }
    }

    private class CacheNameRenderer
    extends XTable.BaseRenderer {
        private CacheNameRenderer() {
        }

        public void setValue(Object value) {
            super.setValue(value);
            String cacheName = value.toString();
            this.label.setIcon(ClientCacheManagerSizingPanel.this.cacheManagerInstance.isCacheTerracottaClustered(cacheName) ? EhcachePresentationUtils.CLUSTERED_ICON : EhcachePresentationUtils.NON_CLUSTERED_ICON);
        }
    }

    private class RefreshAction
    extends XAbstractAction {
        private RefreshAction() {
            super(BaseClusterModelPanel.bundle.getString("refresh"), (Icon)new ImageIcon(RefreshAction.class.getResource("/com/tc/admin/icons/refresh.gif")));
        }

        public void actionPerformed(ActionEvent ae) {
            ClientCacheManagerSizingPanel.this.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetSizesWorker
    extends BasicWorker<Map<CacheModelInstance, CacheTierSize>> {
        private GetSizesWorker() {
            super((Callable)new Callable<Map<CacheModelInstance, CacheTierSize>>(){

                @Override
                public Map<CacheModelInstance, CacheTierSize> call() throws Exception {
                    return ClientCacheManagerSizingPanel.this.cacheManagerInstance.getSizes();
                }
            });
            ClientCacheManagerSizingPanel.this.refreshAction.setEnabled(false);
        }

        protected void finished() {
            Exception e = this.getException();
            if (e != null) {
                Throwable rootCause = ExceptionHelper.getRootCause((Throwable)e);
                if (!(rootCause instanceof IOException)) {
                    ClientCacheManagerSizingPanel.this.appContext.log((Throwable)e);
                }
            } else {
                ClientCacheManagerSizingPanel.this.update((Map)this.getResult());
            }
            ClientCacheManagerSizingPanel.this.refreshAction.setEnabled(true);
        }
    }

    private class RefreshTimerAction
    implements ActionListener {
        private RefreshTimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ClientCacheManagerSizingPanel.this.refresh();
        }
    }
}

