/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.terracotta.modules.ehcache.presentation.SelectionModel;

public class CheckBoxNodeRenderer
implements TreeCellRenderer {
    private final CheckBoxRenderer checkBoxRenderer = new CheckBoxRenderer();
    private final DefaultTreeCellRenderer stdRenderer = new DefaultTreeCellRenderer();
    private final Color selectionForeground;
    private final Color selectionBackground;
    private final Color textForeground;
    private final Color textBackground;

    protected CheckBoxRenderer getRenderer() {
        return this.checkBoxRenderer;
    }

    public CheckBoxNodeRenderer() {
        Boolean booleanValue;
        Font fontValue = UIManager.getFont("Tree.font");
        if (fontValue != null) {
            this.checkBoxRenderer.setFont(fontValue);
        }
        this.checkBoxRenderer.setFocusPainted((booleanValue = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && booleanValue != false);
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object userObject;
        String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, false);
        this.checkBoxRenderer.setText(stringValue);
        this.checkBoxRenderer.setSelected(false);
        this.checkBoxRenderer.setEnabled(tree.isEnabled());
        if (selected) {
            this.checkBoxRenderer.setForeground(this.selectionForeground);
            this.checkBoxRenderer.setBackground(this.selectionBackground);
        } else {
            this.checkBoxRenderer.setForeground(this.textForeground);
            this.checkBoxRenderer.setBackground(this.textBackground);
        }
        if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof SelectionModel) {
            SelectionModel node = (SelectionModel)userObject;
            this.checkBoxRenderer.setText(node.getText());
            this.checkBoxRenderer.setSelected(node.isSelected());
            this.checkBoxRenderer.setEnabled(node.isEnabled());
            this.checkBoxRenderer.setIcon(node.getIcon());
            return this.checkBoxRenderer;
        }
        return this.stdRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    public static class CheckBoxRenderer
    extends JPanel {
        private JCheckBox checkBox = new JCheckBox();
        private JLabel label;
        private boolean enabled;

        private CheckBoxRenderer() {
            super(new FlowLayout(1, 0, 0));
            this.add(this.checkBox);
            this.label = new JLabel();
            this.add(this.label);
            this.label.setIconTextGap(1);
            this.checkBox.setOpaque(false);
            this.checkBox.setMargin(new Insets(0, 0, 0, 0));
            this.setOpaque(false);
            this.setEnabled(true);
            this.setBorder(null);
        }

        public void setSelected(boolean selected) {
            this.checkBox.setSelected(selected);
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        private void setText(String text) {
            this.label.setText(text);
        }

        public String getText() {
            return this.label.getText();
        }

        private void setIcon(Icon icon) {
            this.label.setIcon(icon);
        }

        public Icon getIcon() {
            return this.label.getIcon();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.checkBox.setEnabled(enabled);
            this.label.setEnabled(enabled);
        }

        private void setFocusPainted(boolean focusPainted) {
            this.checkBox.setFocusPainted(focusPainted);
        }

        public void addItemListener(ItemListener itemListener) {
            this.checkBox.addItemListener(itemListener);
        }
    }
}

