/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.terracotta.modules.ehcache.presentation.CheckBoxNodeRenderer;
import org.terracotta.modules.ehcache.presentation.SelectionModel;

public class CheckBoxNodeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private final CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
    private final JTree tree;

    public CheckBoxNodeEditor(JTree tree) {
        this.tree = tree;
    }

    public Object getCellEditorValue() {
        return this.renderer.getRenderer().isSelected();
    }

    public boolean isCellEditable(EventObject event) {
        Object node;
        MouseEvent mouseEvent;
        TreePath path;
        boolean result = false;
        if (event instanceof MouseEvent && (path = this.tree.getPathForLocation((mouseEvent = (MouseEvent)event).getX(), mouseEvent.getY())) != null && (node = path.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
            return userObject instanceof SelectionModel && ((SelectionModel)userObject).isEnabled();
        }
        return result;
    }

    public Component getTreeCellEditorComponent(JTree theTree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        Component result = this.renderer.getTreeCellRendererComponent(theTree, value, selected, expanded, leaf, row, true);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (CheckBoxNodeEditor.this.stopCellEditing()) {
                    CheckBoxNodeEditor.this.fireEditingStopped();
                }
            }
        };
        if (result instanceof CheckBoxNodeRenderer.CheckBoxRenderer) {
            ((CheckBoxNodeRenderer.CheckBoxRenderer)result).addItemListener(itemListener);
        }
        return result;
    }
}

