/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.XRootNode;
import com.tc.admin.common.XTreeNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.terracotta.modules.ehcache.presentation.AbstractViewPage;
import org.terracotta.modules.ehcache.presentation.ManageChannel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheViewPage
extends AbstractViewPage {
    private final Map<CacheModel, AbstractViewPage.CacheModelControl> cacheModelMap = new HashMap<CacheModel, AbstractViewPage.CacheModelControl>();
    private final Map<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> cacheModelInstanceMap = new HashMap<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl>();
    private final CacheModelControlListener cacheModelControlListener = new CacheModelControlListener();
    private final CacheModelInstanceControlListener cacheModelInstanceControlListener = new CacheModelInstanceControlListener();

    public CacheViewPage(ManageChannel channel, CacheManagerModel cacheManagerModel) {
        super(channel, cacheManagerModel);
        this.initialize();
        cacheManagerModel.addCacheManagerModelListener(this);
        cacheManagerModel.getEhcacheModel().addEhcacheModelListener(this);
    }

    @Override
    public Map<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> getSelection() {
        return new HashMap<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl>(this.cacheModelInstanceMap);
    }

    @Override
    public void setSelection(Map<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> selection) {
        if (selection != null) {
            for (Map.Entry<CacheModelInstance, AbstractViewPage.CacheModelInstanceControl> entry : selection.entrySet()) {
                AbstractViewPage.CacheModelInstanceControl cmic = this.cacheModelInstanceMap.get(entry.getKey());
                if (cmic == null) continue;
                cmic.setSelected(entry.getValue().isSelected());
            }
        }
    }

    @Override
    public void initialize() {
        XRootNode rootNode = (XRootNode)this.treeModel.getRoot();
        rootNode.tearDownChildren();
        this.treeModel.nodeStructureChanged((TreeNode)rootNode);
        this.cacheModelMap.clear();
        this.cacheModelInstanceMap.clear();
        int x = 0;
        Iterator<CacheModel> cacheModelIter = this.cacheManagerModel.cacheModelIterator();
        while (cacheModelIter.hasNext()) {
            CacheModel cacheModel = cacheModelIter.next();
            AbstractViewPage.CacheModelControl cmc = new AbstractViewPage.CacheModelControl(cacheModel){

                public void setSelectedAndChildren(boolean selected) {
                    this.setSelected(selected);
                    for (CacheModelInstance cacheModelInstance : CacheViewPage.this.cacheManagerModel.cacheModelInstances(this.cacheModel)) {
                        ((AbstractViewPage.CacheModelInstanceControl)CacheViewPage.this.cacheModelInstanceMap.get(cacheModelInstance)).setSelected(selected);
                    }
                }
            };
            XTreeNode parentNode = new XTreeNode((Object)cmc);
            this.treeModel.insertNodeInto((MutableTreeNode)parentNode, (MutableTreeNode)rootNode, x++);
            cmc.addActionListener(this.cacheModelControlListener);
            this.cacheModelMap.put(cacheModel, cmc);
            int y = 0;
            for (CacheModelInstance cacheModelInstance : this.cacheManagerModel.cacheModelInstances(cacheModel)) {
                String clientName = cacheModelInstance.getClientName();
                AbstractViewPage.CacheModelInstanceControl cacheModelInstanceControl = (AbstractViewPage)this.new AbstractViewPage.CacheModelInstanceControl(clientName, cacheModelInstance);
                XTreeNode xtn = new XTreeNode((Object)cacheModelInstanceControl);
                xtn.setIcon(cacheModelInstanceControl.getIcon());
                this.treeModel.insertNodeInto((MutableTreeNode)xtn, (MutableTreeNode)parentNode, y++);
                cacheModelInstanceControl.addActionListener(this.cacheModelInstanceControlListener);
                this.cacheModelInstanceMap.put(cacheModelInstance, cacheModelInstanceControl);
                cacheModelInstance.getCacheManagerInstance().addCacheManagerInstanceListener(this);
            }
        }
        this.tree.expandAll();
        this.handleAllSelector();
    }

    @Override
    public void selectAll(boolean select) {
        for (AbstractViewPage.CacheModelControl cacheModelControl : this.cacheModelMap.values()) {
            cacheModelControl.setSelectedAndChildren(select);
        }
        this.updateAllNodes();
        this.handleAllSelector();
    }

    @Override
    public void apply(Boolean applyToNewcomers) {
        boolean cmValue = this.channel.getValue(this.cacheManagerModel);
        if (this.isAllSelected() && !cmValue || this.isAllDeselected() && cmValue) {
            this.channel.setValue(this.cacheManagerModel, !cmValue, applyToNewcomers != null ? applyToNewcomers : false);
        } else {
            HashMap<CacheModel, Boolean> cacheModels = new HashMap<CacheModel, Boolean>();
            HashMap<CacheModelInstance, Boolean> cacheModelInstances = new HashMap<CacheModelInstance, Boolean>();
            for (CacheModel cacheModel : this.cacheModelMap.keySet()) {
                AbstractViewPage.CacheModelControl cmc = this.cacheModelMap.get(cacheModel);
                if (cmc.isSelected() && !this.channel.getValue(cacheModel)) {
                    cacheModels.put(cacheModel, Boolean.TRUE);
                } else {
                    for (CacheModelInstance cmi : this.cacheModelInstanceMap.keySet()) {
                        AbstractViewPage.CacheModelInstanceControl cmic = this.cacheModelInstanceMap.get(cmi);
                        if (cmic.isSelected() == this.channel.getValue(cmi)) continue;
                        cacheModelInstances.put(cmi, cmic.isSelected());
                    }
                }
                this.channel.setCacheViewValues(cacheModels, cacheModelInstances);
            }
        }
    }

    @Override
    public void handleAllSelector() {
        boolean allSelected = true;
        for (CacheModel cacheModel : this.cacheModelMap.keySet()) {
            AbstractViewPage.CacheModelControl cmc = this.cacheModelMap.get(cacheModel);
            if (cmc.isSelected()) continue;
            allSelected = false;
            break;
        }
        if (this.isAllSelected = allSelected) {
            this.isAllDeselected = false;
            this.isSomeSelected = true;
            this.firePropertyChange("ALL_SELECTED", allSelected, !allSelected);
        } else {
            boolean allDeselected = true;
            for (AbstractViewPage.CacheModelInstanceControl cmic : this.cacheModelInstanceMap.values()) {
                if (!cmic.isSelected()) continue;
                allDeselected = false;
                break;
            }
            if (this.isAllDeselected = allDeselected) {
                this.isAllSelected = false;
                this.isSomeSelected = false;
                this.firePropertyChange("ALL_DESELECTED", allDeselected, !allDeselected);
            } else {
                this.isSomeSelected = true;
                this.isAllDeselected = false;
                this.isAllSelected = false;
                this.firePropertyChange("SOME_SELECTED", true, false);
            }
        }
    }

    @Override
    public void tearDown() {
        this.cacheModelMap.clear();
        this.cacheModelInstanceMap.clear();
        super.tearDown();
    }

    private class CacheModelInstanceControlListener
    implements ActionListener {
        private CacheModelInstanceControlListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractViewPage.CacheModelInstanceControl cmic = (AbstractViewPage.CacheModelInstanceControl)e.getSource();
            boolean selected = cmic.isSelected();
            CacheModelInstance cmi = cmic.getCacheModelInstance();
            CacheModel cacheModel = CacheViewPage.this.cacheManagerModel.getCacheModel(cmi.getCacheName());
            AbstractViewPage.CacheModelControl cmc = (AbstractViewPage.CacheModelControl)CacheViewPage.this.cacheModelMap.get(cacheModel);
            if (!selected && cmc.isSelected()) {
                cmc.setSelectedQuietly(false);
            } else if (selected && !cmc.isSelected()) {
                boolean allEnabled = true;
                for (CacheModelInstance cacheModelInstance2 : CacheViewPage.this.cacheManagerModel.cacheModelInstances(cacheModel)) {
                    cmic = (AbstractViewPage.CacheModelInstanceControl)CacheViewPage.this.cacheModelInstanceMap.get(cacheModelInstance2);
                    if (cmic.isSelected()) continue;
                    allEnabled = false;
                    break;
                }
                cmc.setSelectedQuietly(allEnabled);
            }
            CacheViewPage.this.updateAllNodes();
            CacheViewPage.this.handleAllSelector();
        }
    }

    private class CacheModelControlListener
    implements ActionListener {
        private CacheModelControlListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractViewPage.CacheModelControl cmc = (AbstractViewPage.CacheModelControl)e.getSource();
            CacheModel cacheModel = cmc.getCacheModel();
            boolean selected = cmc.isSelected();
            for (CacheModelInstance cmi : CacheViewPage.this.cacheModelInstanceMap.keySet()) {
                AbstractViewPage.CacheModelInstanceControl cmic;
                if (!cmi.getCacheName().equals(cacheModel.getCacheName()) || (cmic = (AbstractViewPage.CacheModelInstanceControl)CacheViewPage.this.cacheModelInstanceMap.get(cmi)) == null || selected == cmic.isSelected()) continue;
                cmic.setSelectedQuietly(selected);
            }
            CacheViewPage.this.updateAllNodes();
            CacheViewPage.this.handleAllSelector();
        }
    }
}

