/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.BasicWorker;
import com.tc.admin.common.ExceptionHelper;
import com.tc.admin.common.XCheckBox;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XObjectTable;
import com.tc.admin.common.XScrollPane;
import com.tc.admin.common.XTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.terracotta.modules.ehcache.presentation.BooleanRenderer;
import org.terracotta.modules.ehcache.presentation.CacheInstanceTableModel;
import org.terracotta.modules.ehcache.presentation.CacheSummaryTableModel;
import org.terracotta.modules.ehcache.presentation.TopologyPanel;
import org.terracotta.modules.ehcache.presentation.TopologyPanelPage;
import org.terracotta.modules.ehcache.presentation.model.BaseMBeanModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceListener;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheTopologyPanel
extends TopologyPanelPage
implements CacheManagerModelListener,
CacheManagerInstanceListener,
ListSelectionListener,
PropertyChangeListener {
    private final TopologyPanel topologyPanel;
    private GridBagLayout layout;
    private Set<CacheModel> selectedCacheModels;
    private final CacheManagerModel cacheManagerModel;
    private CacheSummaryTableModel cacheSummaryTableModel;
    private XObjectTable cacheSummaryTable;
    private CacheInstanceTableModel cacheInstanceTableModel;
    private XObjectTable cacheInstanceTable;
    private XContainer cacheInstancePanelHolder;
    private XContainer cacheInstancePanel;

    public CacheTopologyPanel(TopologyPanel topologyPanel) {
        super(topologyPanel.getApplicationContext(), topologyPanel.getCacheManagerModel());
        this.topologyPanel = topologyPanel;
        this.cacheManagerModel = topologyPanel.getCacheManagerModel();
        this.setName(TopologyPanel.Mode.CACHE.toString());
    }

    public CacheTopologyPanel(TopologyPanel topologyPanel, Set<CacheModel> selectedCacheModels) {
        this(topologyPanel);
        this.selectedCacheModels = selectedCacheModels;
    }

    @Override
    public void setup() {
        super.setup();
        this.cacheManagerModel.addCacheManagerModelListener(this);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void init() {
        Iterator<BaseMBeanModel> iter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            iter.next().addCacheManagerInstanceListener(this);
        }
        iter = this.cacheManagerModel.cacheModelIterator();
        while (iter.hasNext()) {
            CacheModel cacheModel = (CacheModel)iter.next();
            this.cacheSummaryTableModel.add(cacheModel);
            cacheModel.addPropertyChangeListener(this);
        }
        this.cacheSummaryTableModel.fireTableDataChanged();
        if (this.selectedCacheModels != null) {
            this.cacheSummaryTable.setSelection((Object[])this.selectedCacheModels.toArray(new CacheModel[0]));
            this.selectedCacheModels = null;
        }
    }

    @Override
    protected XContainer createMainPanel() {
        this.layout = new GridBagLayout();
        XContainer panel = new XContainer((LayoutManager)this.layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)this.createCacheSummaryPanel(), (Object)gbc);
        ++gbc.gridy;
        this.cacheInstancePanel = this.createCacheInstancePanel();
        this.cacheInstancePanelHolder = new XContainer((LayoutManager)new BorderLayout());
        gbc.weighty = 0.0;
        panel.add((Component)this.cacheInstancePanelHolder, (Object)gbc);
        return panel;
    }

    private XContainer createSelectAllPanel(XTable table) {
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)new XLabel(), (Object)gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        XCheckBox selectAllToggle = new XCheckBox("Select/De-select All");
        panel.add((Component)selectAllToggle, (Object)gbc);
        selectAllToggle.addActionListener((ActionListener)new TopologyPanelPage.SelectAllToggleListener(table));
        return panel;
    }

    private XContainer createCacheSummaryPanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        panel.setBorder((Border)BorderFactory.createTitledBorder(bundle.getString("cache.summary")));
        this.cacheSummaryTableModel = new CacheSummaryTableModel();
        this.cacheSummaryTable = new XObjectTable((TableModel)((Object)this.cacheSummaryTableModel));
        this.cacheSummaryTable.setSelectionMode(2);
        this.cacheSummaryTable.getSelectionModel().addListSelectionListener(this);
        panel.add((Component)this.createSelectAllPanel((XTable)this.cacheSummaryTable), (Object)"South");
        panel.add((Component)new XScrollPane((Component)this.cacheSummaryTable));
        this.cacheSummaryTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)((Object)new BooleanRenderer()));
        JPopupMenu popup = this.topologyPanel.createPopup();
        this.cacheSummaryTable.setPopupMenu(popup);
        popup.addPopupMenuListener(new TopologyPanelPage.PopupMenuAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                CacheTopologyPanel.this.updateActions((XTable)CacheTopologyPanel.this.cacheSummaryTable);
            }
        });
        return panel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.cacheInstanceTableModel.clear();
            boolean showCacheInstancePanel = false;
            CacheModel cacheModel = null;
            int[] rows = this.cacheSummaryTable.getSelectedRows();
            if (rows.length == 1) {
                cacheModel = (CacheModel)this.cacheSummaryTableModel.getObjectAt(rows[0]);
                for (CacheModelInstance cacheModelInstance : cacheModel.cacheModelInstances()) {
                    this.cacheInstanceTableModel.add(cacheModelInstance);
                }
                this.cacheInstanceTableModel.fireTableDataChanged();
                String title = MessageFormat.format(bundle.getString("cache.detail"), cacheModel.getCacheName());
                this.cacheInstancePanel.setBorder((Border)BorderFactory.createTitledBorder(title));
                showCacheInstancePanel = true;
            }
            this.setCacheInstancePanelVisible(showCacheInstancePanel);
            this.updateActions((XTable)this.cacheSummaryTable);
        }
    }

    @Override
    public void updateActions(XTable table) {
        int cacheInstanceCount = 0;
        int clusteredCacheInstanceCount = 0;
        int enabled = 0;
        int statistics = 0;
        int bulkload = 0;
        boolean anySelected = false;
        if (table == this.cacheSummaryTable) {
            Set<CacheModel> cacheModels = this.getSelectedCacheModels();
            for (CacheModel cacheModel : cacheModels) {
                cacheInstanceCount += cacheModel.getInstanceCount();
                clusteredCacheInstanceCount += cacheModel.getTerracottaClusteredInstanceCount();
                enabled += cacheModel.getEnabledCount();
                statistics += cacheModel.getStatisticsEnabledCount();
                bulkload += cacheModel.getBulkLoadEnabledCount();
            }
            anySelected = cacheModels.size() > 0;
        } else {
            Set<CacheModelInstance> cacheModelInstances = this.getSelectedCacheModelInstances();
            cacheInstanceCount = cacheModelInstances.size();
            for (CacheModelInstance cmi : cacheModelInstances) {
                if (cmi.isEnabled()) {
                    ++enabled;
                }
                if (cmi.isStatisticsEnabled()) {
                    ++statistics;
                }
                if (cmi.isTerracottaClustered()) {
                    ++clusteredCacheInstanceCount;
                }
                if (!cmi.isBulkLoadEnabled()) continue;
                ++bulkload;
            }
            anySelected = cacheInstanceCount > 0;
        }
        this.topologyPanel.disableCachesAction.setEnabled(enabled > 0);
        this.topologyPanel.enableCachesAction.setEnabled(enabled < cacheInstanceCount);
        this.topologyPanel.disableStatisticsAction.setEnabled(statistics > 0);
        this.topologyPanel.enableStatisticsAction.setEnabled(statistics < cacheInstanceCount);
        this.topologyPanel.disableBulkLoadingAction.setEnabled(bulkload > 0);
        this.topologyPanel.enableBulkLoadingAction.setEnabled(bulkload < clusteredCacheInstanceCount);
        this.topologyPanel.clearCachesAction.setEnabled(enabled > 0);
        this.topologyPanel.showConfigAction.setEnabled(anySelected);
    }

    private void setCacheInstancePanelVisible(boolean visible) {
        if (visible) {
            if (this.cacheInstancePanel.getParent() == null) {
                this.cacheInstancePanelHolder.add((Component)this.cacheInstancePanel);
                GridBagConstraints gbc = this.layout.getConstraints((Component)this.cacheInstancePanelHolder);
                gbc.weighty = 1.0;
                this.layout.setConstraints((Component)this.cacheInstancePanelHolder, gbc);
            }
        } else if (this.cacheInstancePanel.getParent() != null) {
            this.cacheInstancePanelHolder.remove((Component)this.cacheInstancePanel);
            GridBagConstraints gbc = this.layout.getConstraints((Component)this.cacheInstancePanelHolder);
            gbc.weighty = 0.0;
            this.layout.setConstraints((Component)this.cacheInstancePanelHolder, gbc);
        }
        this.cacheInstancePanel.setVisible(visible);
        this.cacheInstancePanelHolder.revalidate();
        this.cacheInstancePanelHolder.repaint();
    }

    private XContainer createCacheInstancePanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        this.cacheInstanceTableModel = new CacheInstanceTableModel();
        this.cacheInstanceTable = new XObjectTable((TableModel)((Object)this.cacheInstanceTableModel));
        this.cacheInstanceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CacheTopologyPanel.this.updateActions((XTable)CacheTopologyPanel.this.cacheInstanceTable);
                }
            }
        });
        panel.add((Component)this.createSelectAllPanel((XTable)this.cacheInstanceTable), (Object)"South");
        panel.add((Component)new XScrollPane((Component)this.cacheInstanceTable));
        this.cacheInstanceTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)((Object)new BooleanRenderer()));
        this.cacheInstanceTable.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)((Object)new TopologyPanelPage.ModeRenderer()));
        JPopupMenu popup = this.topologyPanel.createPopup();
        this.cacheInstanceTable.setPopupMenu(popup);
        popup.addPopupMenuListener(new TopologyPanelPage.PopupMenuAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                CacheTopologyPanel.this.updateActions((XTable)CacheTopologyPanel.this.cacheInstanceTable);
            }
        });
        return panel;
    }

    @Override
    public void instanceAdded(CacheManagerInstance instance) {
        instance.addCacheManagerInstanceListener(this);
    }

    @Override
    public void instanceRemoved(CacheManagerInstance instance) {
        instance.removeCacheManagerInstanceListener(this);
        int row = this.cacheInstanceTableModel.getObjectIndex(instance);
        if (row != -1) {
            this.cacheInstanceTableModel.remove(instance);
            this.cacheInstanceTableModel.fireTableRowsDeleted(row, row);
        }
    }

    @Override
    public void cacheModelAdded(final CacheModel cacheModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CacheTopologyPanel.this.cacheSummaryTableModel.add(cacheModel);
                int row = CacheTopologyPanel.this.cacheSummaryTableModel.getRowCount() - 1;
                CacheTopologyPanel.this.cacheSummaryTableModel.fireTableRowsInserted(row, row);
                cacheModel.addPropertyChangeListener(CacheTopologyPanel.this);
            }
        });
    }

    @Override
    public void cacheModelRemoved(final CacheModel cacheModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row = CacheTopologyPanel.this.cacheSummaryTableModel.getObjectIndex(cacheModel);
                if (row != -1) {
                    CacheTopologyPanel.this.cacheSummaryTableModel.remove(cacheModel);
                    CacheTopologyPanel.this.cacheSummaryTableModel.fireTableRowsDeleted(row, row);
                }
                cacheModel.removePropertyChangeListener(CacheTopologyPanel.this);
            }
        });
    }

    @Override
    public void cacheModelChanged(final CacheModel cacheModel) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CacheTopologyPanel.this.updateCacheSummaryRow(cacheModel);
            }
        });
    }

    @Override
    public void clusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void clusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void clusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
    }

    public Set<CacheModel> getSelectedCacheModels() {
        return Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(this.cacheSummaryTable.getSelection())));
    }

    public Set<CacheModelInstance> getSelectedCacheModelInstances() {
        return Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(this.cacheInstanceTable.getSelection())));
    }

    public Set<CacheManagerInstance> getSelectedCacheManagerInstances() {
        HashSet<CacheManagerInstance> result = new HashSet<CacheManagerInstance>();
        for (CacheModelInstance cacheModelInstance : this.getSelectedCacheModelInstances()) {
            result.add(cacheModelInstance.getCacheManagerInstance());
        }
        return result;
    }

    private boolean isCacheModelSelected(CacheModel cacheModel) {
        HashSet<Object> cacheModelSelection = new HashSet<Object>(Arrays.asList(this.cacheSummaryTable.getSelection()));
        return cacheModelSelection.contains(cacheModel);
    }

    private void updateCacheSummaryRow(CacheModel cacheModel) {
        int row = this.cacheSummaryTableModel.getObjectIndex(cacheModel);
        if (row != -1) {
            this.cacheSummaryTableModel.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    public void cacheManagerInstanceChanged(CacheManagerInstance cacheManagerInstance) {
    }

    @Override
    public void cacheModelInstanceAdded(final CacheModelInstance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (CacheTopologyPanel.this.isCacheModelSelected(instance.getCacheModel())) {
                    CacheTopologyPanel.this.cacheInstanceTableModel.add(instance);
                    int row = CacheTopologyPanel.this.cacheInstanceTableModel.getRowCount() - 1;
                    CacheTopologyPanel.this.cacheInstanceTableModel.fireTableRowsInserted(row, row);
                }
                CacheTopologyPanel.this.updateCacheSummaryRow(instance.getCacheModel());
            }
        });
    }

    @Override
    public void cacheModelInstanceChanged(final CacheModelInstance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row;
                if (CacheTopologyPanel.this.isCacheModelSelected(instance.getCacheModel()) && (row = CacheTopologyPanel.this.cacheInstanceTableModel.getObjectIndex(instance)) != -1) {
                    CacheTopologyPanel.this.cacheInstanceTableModel.fireTableRowsUpdated(row, row);
                }
                CacheTopologyPanel.this.updateCacheSummaryRow(instance.getCacheModel());
            }
        });
    }

    @Override
    public void cacheModelInstanceRemoved(final CacheModelInstance instance) {
        final CacheModel cacheModel = instance.getCacheModel();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row;
                if (CacheTopologyPanel.this.isCacheModelSelected(cacheModel) && (row = CacheTopologyPanel.this.cacheInstanceTableModel.getObjectIndex(instance)) != -1) {
                    CacheTopologyPanel.this.cacheInstanceTableModel.remove(instance);
                    CacheTopologyPanel.this.cacheInstanceTableModel.fireTableRowsDeleted(row, row);
                }
                CacheTopologyPanel.this.updateCacheSummaryRow(cacheModel);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        CacheModel cacheModel;
        int row;
        Object source = evt.getSource();
        if (source instanceof CacheModel && (row = this.cacheSummaryTableModel.getObjectIndex(cacheModel = (CacheModel)source)) != -1) {
            this.cacheSummaryTableModel.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    protected BasicWorker<Void> createClearCachesWorker(JPopupMenu popupMenu) {
        return new ClearCachesWorker(popupMenu);
    }

    @Override
    protected BasicWorker<Void> createEnableCachesWorker(JPopupMenu popupMenu, boolean enable, boolean flush) {
        return new EnableCachesWorker(popupMenu, enable, flush);
    }

    @Override
    protected BasicWorker<Void> createStatisticsControlWorker(JPopupMenu popupMenu, boolean enable) {
        return new StatisticsControlWorker(popupMenu, enable);
    }

    @Override
    protected BasicWorker<Void> createBulkLoadControlWorker(JPopupMenu popupMenu, boolean bulkLoadEnabled) {
        return new BulkLoadControlWorker(popupMenu, bulkLoadEnabled);
    }

    @Override
    protected Callable<String> createConfigurationGenerator(JPopupMenu popupMenu) {
        return new ConfigurationGenerator(popupMenu);
    }

    @Override
    public void tearDown() {
        this.cacheManagerModel.removeCacheManagerModelListener(this);
        Iterator<BaseMBeanModel> iter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            iter.next().removeCacheManagerInstanceListener(this);
        }
        iter = this.cacheManagerModel.cacheModelIterator();
        while (iter.hasNext()) {
            ((CacheModel)iter.next()).removePropertyChangeListener(this);
        }
        super.tearDown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigurationGenerator
    implements Callable<String> {
        private final JPopupMenu popupMenu;

        private ConfigurationGenerator(JPopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }

        @Override
        public String call() throws Exception {
            if (this.popupMenu == CacheTopologyPanel.this.cacheSummaryTable.getPopupMenu()) {
                Set<CacheModel> cacheModels = CacheTopologyPanel.this.getSelectedCacheModels();
                if (cacheModels.size() == CacheTopologyPanel.this.cacheManagerModel.getCacheModelCount()) {
                    return CacheTopologyPanel.this.cacheManagerModel.generateActiveConfigDeclaration();
                }
                StringBuilder sb = new StringBuilder();
                for (CacheModel cacheModel : cacheModels) {
                    sb.append(cacheModel.generateActiveConfigDeclaration());
                    sb.append("\n");
                }
                return sb.toString();
            }
            CacheModel cacheModel = (CacheModel)CacheTopologyPanel.this.cacheSummaryTableModel.getObjectAt(CacheTopologyPanel.this.cacheSummaryTable.getSelectedRow());
            Set<CacheModelInstance> cacheModelInstances = CacheTopologyPanel.this.getSelectedCacheModelInstances();
            if (cacheModelInstances.size() == cacheModel.getInstanceCount()) {
                return cacheModel.generateActiveConfigDeclaration();
            }
            StringBuilder sb = new StringBuilder();
            for (CacheModelInstance cacheModelInstance : cacheModelInstances) {
                sb.append(cacheModelInstance.generateActiveConfigDeclaration());
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BulkLoadControlWorker
    extends BasicWorker<Void> {
        private BulkLoadControlWorker(final JPopupMenu popupMenu, final boolean enable) {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (popupMenu == CacheTopologyPanel.this.cacheSummaryTable.getPopupMenu()) {
                        Set<CacheModel> cacheModels = CacheTopologyPanel.this.getSelectedCacheModels();
                        if (cacheModels.size() == CacheTopologyPanel.this.cacheManagerModel.getCacheModelCount()) {
                            CacheTopologyPanel.this.cacheManagerModel.setBulkLoadEnabled(enable, true);
                        } else {
                            for (CacheModel cacheModel : cacheModels) {
                                cacheModel.setBulkLoadEnabled(enable);
                            }
                        }
                    } else {
                        CacheModel cacheModel = (CacheModel)CacheTopologyPanel.this.cacheSummaryTableModel.getObjectAt(CacheTopologyPanel.this.cacheSummaryTable.getSelectedRow());
                        Set<CacheModelInstance> cacheModelInstances = CacheTopologyPanel.this.getSelectedCacheModelInstances();
                        if (cacheModelInstances.size() == cacheModel.getInstanceCount()) {
                            cacheModel.setBulkLoadEnabled(enable);
                        } else {
                            for (CacheModelInstance cacheModelInstance : cacheModelInstances) {
                                if (cacheModelInstance.isTransactional()) continue;
                                cacheModelInstance.setBulkLoadEnabled(enable);
                            }
                        }
                    }
                    return null;
                }
            });
        }

        protected void finished() {
            Throwable rootCause;
            Exception e = this.getException();
            if (e != null && !((rootCause = ExceptionHelper.getRootCause((Throwable)e)) instanceof IOException)) {
                CacheTopologyPanel.this.appContext.log((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatisticsControlWorker
    extends BasicWorker<Void> {
        private StatisticsControlWorker(final JPopupMenu popupMenu, final boolean enable) {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (popupMenu == CacheTopologyPanel.this.cacheSummaryTable.getPopupMenu()) {
                        Set<CacheModel> cacheModels = CacheTopologyPanel.this.getSelectedCacheModels();
                        if (cacheModels.size() == CacheTopologyPanel.this.cacheManagerModel.getCacheModelCount()) {
                            CacheTopologyPanel.this.cacheManagerModel.setStatisticsEnabled(enable, true);
                        } else {
                            for (CacheModel cacheModel : cacheModels) {
                                cacheModel.setStatisticsEnabled(enable);
                            }
                        }
                    } else {
                        CacheModel cacheModel = (CacheModel)CacheTopologyPanel.this.cacheSummaryTableModel.getObjectAt(CacheTopologyPanel.this.cacheSummaryTable.getSelectedRow());
                        Set<CacheModelInstance> cacheModelInstances = CacheTopologyPanel.this.getSelectedCacheModelInstances();
                        if (cacheModelInstances.size() == cacheModel.getInstanceCount()) {
                            cacheModel.setStatisticsEnabled(enable);
                        } else {
                            for (CacheModelInstance cacheModelInstance : cacheModelInstances) {
                                cacheModelInstance.setStatisticsEnabled(enable);
                            }
                        }
                    }
                    return null;
                }
            });
        }

        protected void finished() {
            Throwable rootCause;
            Exception e = this.getException();
            if (e != null && !((rootCause = ExceptionHelper.getRootCause((Throwable)e)) instanceof IOException)) {
                CacheTopologyPanel.this.appContext.log((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnableCachesWorker
    extends BasicWorker<Void> {
        private EnableCachesWorker(final JPopupMenu popupMenu, final boolean enable, final boolean flush) {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    block4: {
                        Set<CacheModelInstance> cacheModelInstances;
                        block5: {
                            block2: {
                                Set<CacheModel> cacheModels;
                                block3: {
                                    if (popupMenu != CacheTopologyPanel.this.cacheSummaryTable.getPopupMenu()) break block2;
                                    cacheModels = CacheTopologyPanel.this.getSelectedCacheModels();
                                    if (cacheModels.size() != CacheTopologyPanel.this.cacheManagerModel.getCacheModelCount()) break block3;
                                    CacheTopologyPanel.this.cacheManagerModel.setCachesEnabled(enable, true);
                                    if (!flush) break block4;
                                    CacheTopologyPanel.this.cacheManagerModel.clearAllCaches();
                                    break block4;
                                }
                                for (CacheModel cacheModel : cacheModels) {
                                    cacheModel.setEnabled(enable);
                                    if (!flush) continue;
                                    cacheModel.removeAll();
                                }
                                break block4;
                            }
                            CacheModel cacheModel = (CacheModel)CacheTopologyPanel.this.cacheSummaryTableModel.getObjectAt(CacheTopologyPanel.this.cacheSummaryTable.getSelectedRow());
                            cacheModelInstances = CacheTopologyPanel.this.getSelectedCacheModelInstances();
                            if (cacheModelInstances.size() != cacheModel.getInstanceCount()) break block5;
                            cacheModel.setEnabled(enable);
                            if (!flush) break block4;
                            cacheModel.removeAll();
                            break block4;
                        }
                        for (CacheModelInstance cacheModelInstance : cacheModelInstances) {
                            cacheModelInstance.setEnabled(enable);
                            if (!flush) continue;
                            cacheModelInstance.removeAll();
                        }
                    }
                    return null;
                }
            });
        }

        protected void finished() {
            Throwable rootCause;
            Exception e = this.getException();
            if (e != null && !((rootCause = ExceptionHelper.getRootCause((Throwable)e)) instanceof IOException)) {
                CacheTopologyPanel.this.appContext.log((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClearCachesWorker
    extends BasicWorker<Void> {
        private ClearCachesWorker(final JPopupMenu popupMenu) {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (popupMenu == CacheTopologyPanel.this.cacheSummaryTable.getPopupMenu()) {
                        Set<CacheModel> cacheModels = CacheTopologyPanel.this.getSelectedCacheModels();
                        if (cacheModels.size() == CacheTopologyPanel.this.cacheManagerModel.getCacheModelCount()) {
                            CacheTopologyPanel.this.cacheManagerModel.clearAllCaches();
                        } else {
                            for (CacheModel cacheModel : cacheModels) {
                                cacheModel.removeAll();
                            }
                        }
                    } else {
                        CacheModel cacheModel = (CacheModel)CacheTopologyPanel.this.cacheSummaryTableModel.getObjectAt(CacheTopologyPanel.this.cacheSummaryTable.getSelectedRow());
                        Set<CacheModelInstance> cacheModelInstances = CacheTopologyPanel.this.getSelectedCacheModelInstances();
                        if (cacheModelInstances.size() == cacheModel.getInstanceCount()) {
                            cacheModel.removeAll();
                        } else {
                            for (CacheModelInstance cacheModelInstance : cacheModelInstances) {
                                cacheModelInstance.removeAll();
                            }
                        }
                    }
                    return null;
                }
            });
        }

        protected void finished() {
            Throwable rootCause;
            Exception e = this.getException();
            if (e != null && !((rootCause = ExceptionHelper.getRootCause((Throwable)e)) instanceof IOException)) {
                CacheTopologyPanel.this.appContext.log((Throwable)e);
            }
        }
    }
}

