/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ApplicationContext;
import com.tc.admin.common.XButton;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.model.IClient;
import com.tc.admin.model.IClusterNode;
import com.tc.admin.model.PolledAttributeListener;
import com.tc.admin.model.PolledAttributesResult;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.terracotta.modules.ehcache.presentation.BaseEhcacheStatsChartPanel;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.EhcacheStatsUtils;
import org.terracotta.modules.ehcache.presentation.ManageStatisticsMessage;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceListener;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

public class CacheModelStatsChartPanel
extends BaseEhcacheStatsChartPanel
implements CacheManagerModelListener,
CacheManagerInstanceListener {
    private final CacheModel cacheModel;
    private XLabel summaryLabel;
    private XButton manageStatsButton;

    public CacheModelStatsChartPanel(ApplicationContext appContext, CacheModel cacheModel) {
        super(appContext, cacheModel.getCacheManagerModel());
        this.cacheModel = cacheModel;
        this.setupSummaryPanel();
    }

    protected ObjectName getBeanName() throws MalformedObjectNameException {
        return EhcacheStatsUtils.getSampledCacheBeanName(this.cacheManagerModel.getName(), this.cacheModel.getCacheName());
    }

    public void setup() {
        super.setup();
        this.cacheManagerModel.addCacheManagerModelListener(this);
    }

    protected void init() {
        super.init();
        Iterator<CacheManagerInstance> iter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            iter.next().addCacheManagerInstanceListener(this);
        }
        this.handleSummaryText();
    }

    private void setupSummaryPanel() {
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.summaryLabel = new XLabel();
        panel.add((Component)this.summaryLabel, (Object)gbc);
        this.summaryLabel.setIcon(EhcachePresentationUtils.ALERT_ICON);
        ++gbc.gridx;
        this.manageStatsButton = new XButton("Manage Statistics...");
        panel.add((Component)this.manageStatsButton, (Object)gbc);
        this.manageStatsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CacheModelStatsChartPanel c = CacheModelStatsChartPanel.this;
                Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)((Object)c));
                ManageStatisticsMessage msg = new ManageStatisticsMessage(frame, CacheModelStatsChartPanel.this.appContext, CacheModelStatsChartPanel.this.cacheManagerModel);
                int result = JOptionPane.showConfirmDialog((Component)((Object)c), msg, msg.getTitle(), 2);
                if (result == 0) {
                    Boolean toNewcomers = null;
                    if (msg.hasApplyToNewcomersToggle()) {
                        toNewcomers = msg.shouldApplyToNewcomers();
                    }
                    msg.apply(toNewcomers);
                }
                msg.tearDown();
            }
        });
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)new XLabel(), (Object)gbc);
        this.add((Component)panel, "North");
    }

    private void handleSummaryText() {
        int statsEnabledCount = this.cacheManagerModel.getStatisticsEnabledCount(this.cacheModel);
        int cacheModelInstanceCount = this.cacheManagerModel.getCacheModelInstanceCount(this.cacheModel);
        String text = null;
        Icon icon = null;
        if (cacheModelInstanceCount > 0 && statsEnabledCount == 0) {
            text = "No cache instances have statistics enabled.";
            icon = EhcachePresentationUtils.ALERT_ICON;
        } else if (statsEnabledCount < cacheModelInstanceCount) {
            text = MessageFormat.format("Statistics enabled on {0} of {1} cache instances.", statsEnabledCount, cacheModelInstanceCount);
            icon = EhcachePresentationUtils.WARN_ICON;
        }
        this.summaryLabel.setText(text);
        this.summaryLabel.setIcon(icon);
        this.summaryLabel.setVisible(text != null);
        this.manageStatsButton.setVisible(text != null);
    }

    private void handleSummaryTextLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CacheModelStatsChartPanel.this.handleSummaryText();
            }
        });
    }

    public void attributesPolled(PolledAttributesResult result) {
        long searchCount = 0L;
        long averageSearchTime = 0L;
        long txCommitCount = 0L;
        long txRollbackCount = 0L;
        long writerQueueLength = 0L;
        int writerMaxQueueSize = 0;
        boolean hasAnyWriters = false;
        boolean transactional = false;
        boolean searchable = false;
        for (IClient client : this.clusterModel.getClients()) {
            Boolean b;
            ObjectName on = client.getTunneledBeanName(this.statsBeanObjectName);
            for (BaseEhcacheStatsChartPanel.ChartContentProvider chartProvider : this.chartProviders) {
                chartProvider.acceptPolledAttributeResult(result, client, on);
            }
            Number n = (Number)result.getPolledAttribute((IClusterNode)client, on, "CacheSearchRate");
            if (n != null) {
                searchCount += n.longValue();
            }
            if ((n = (Number)result.getPolledAttribute((IClusterNode)client, on, "CacheAverageSearchTime")) != null) {
                averageSearchTime += n.longValue();
            }
            if ((n = (Number)result.getPolledAttribute((IClusterNode)client, on, "TransactionCommitRate")) != null) {
                txCommitCount += n.longValue();
            }
            if ((n = (Number)result.getPolledAttribute((IClusterNode)client, on, "TransactionRollbackRate")) != null) {
                txRollbackCount += n.longValue();
            }
            if ((n = (Number)result.getPolledAttribute((IClusterNode)client, on, "WriterQueueLength")) != null) {
                writerQueueLength += n.longValue();
            }
            if ((n = (Number)result.getPolledAttribute((IClusterNode)client, on, "WriterMaxQueueSize")) != null) {
                writerMaxQueueSize += n.intValue();
            }
            if ((b = (Boolean)result.getPolledAttribute((IClusterNode)client, on, "HasWriteBehindWriter")) != null && b.booleanValue()) {
                hasAnyWriters = true;
            }
            if ((b = (Boolean)result.getPolledAttribute((IClusterNode)client, on, "Transactional")) != null && b.booleanValue()) {
                transactional = true;
            }
            if ((b = (Boolean)result.getPolledAttribute((IClusterNode)client, on, "Searchable")) == null || !b.booleanValue()) continue;
            searchable = b;
        }
        final long theSearchCount = searchCount;
        final long theAverageSearchTime = averageSearchTime;
        final long theTxCommitCount = txCommitCount;
        final long theTxRollbackCount = txRollbackCount;
        final long theWriterQueueLength = writerQueueLength;
        final int theWriterMaxQueueSize = writerMaxQueueSize;
        final boolean theHasAnyWriters = hasAnyWriters;
        final boolean theTransactional = transactional;
        final boolean theSearchable = searchable;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CacheModelStatsChartPanel.this.updateAllSeries(theSearchCount, theAverageSearchTime, theTxCommitCount, theTxRollbackCount, theWriterQueueLength, theWriterMaxQueueSize, theHasAnyWriters, theTransactional, theSearchable);
            }
        });
    }

    public void clientConnected(IClient client) {
        this.registerClientPolledAttributes(client);
    }

    private void registerClientPolledAttributes(IClient client) {
        ObjectName on = client.getTunneledBeanName(this.statsBeanObjectName);
        client.addPolledAttributeListener(on, POLLED_ATTRS_SET, (PolledAttributeListener)this);
    }

    private void deregisterClientPolledAttributes(IClient client) {
        ObjectName on = client.getTunneledBeanName(this.statsBeanObjectName);
        client.removePolledAttributeListener(on, POLLED_ATTRS_SET, (PolledAttributeListener)this);
    }

    public void clientDisconnected(IClient client) {
        this.deregisterClientPolledAttributes(client);
    }

    protected void addPolledAttributeListener() {
        for (IClient client : this.clusterModel.getClients()) {
            this.registerClientPolledAttributes(client);
        }
    }

    protected void removePolledAttributeListener() {
        for (IClient client : this.clusterModel.getClients()) {
            this.deregisterClientPolledAttributes(client);
        }
    }

    public void cacheManagerInstanceChanged(CacheManagerInstance cacheManagerInstance) {
    }

    public void cacheModelInstanceAdded(CacheModelInstance cacheModelInstance) {
        this.handleSummaryTextLater();
    }

    public void cacheModelInstanceChanged(CacheModelInstance cacheModelInstance) {
        this.handleSummaryTextLater();
    }

    public void cacheModelInstanceRemoved(CacheModelInstance cacheModelInstance) {
        this.handleSummaryTextLater();
    }

    public void cacheModelAdded(CacheModel cm) {
    }

    public void cacheModelRemoved(CacheModel cm) {
    }

    public void cacheModelChanged(CacheModel cm) {
    }

    public void clusteredCacheModelAdded(ClusteredCacheModel cm) {
    }

    public void clusteredCacheModelRemoved(ClusteredCacheModel cm) {
    }

    public void clusteredCacheModelChanged(ClusteredCacheModel cm) {
    }

    public void standaloneCacheModelAdded(StandaloneCacheModel cm) {
    }

    public void standaloneCacheModelRemoved(StandaloneCacheModel cm) {
    }

    public void standaloneCacheModelChanged(StandaloneCacheModel cm) {
    }

    public void instanceAdded(CacheManagerInstance instance) {
        instance.addCacheManagerInstanceListener(this);
        this.handleSummaryText();
    }

    public void instanceRemoved(CacheManagerInstance instance) {
        instance.removeCacheManagerInstanceListener(this);
        this.handleSummaryText();
    }

    public void tearDown() {
        this.cacheManagerModel.removeCacheManagerModelListener(this);
        Iterator<CacheManagerInstance> iter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            iter.next().removeCacheManagerInstanceListener(this);
        }
        super.tearDown();
    }
}

