/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.ExceptionHelper;
import com.tc.admin.common.XComboBox;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.lang.StringUtils;
import org.terracotta.modules.ehcache.presentation.EhcachePresentationUtils;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.SettingsCacheModel;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheModelMessage
extends XContainer
implements CacheManagerModelListener {
    private final CacheManagerModel cacheManagerModel;
    private XComboBox cacheManagerInstanceSelector;
    private ActionListener cacheManagerInstanceSelectorListener;
    private CacheManagerInstance lastSelectedCacheManagerInstance;
    private XComboBox cacheSettingsInstanceSelector;
    private ActionListener cacheSettingsInstanceSelectorListener;
    private CacheModelInstanceWrapper lastSelectedCacheSettingsInstance;
    private final DefaultComboBoxModel cacheSettingsComboModel;
    private XLabel errorLabel;
    private XContainer cacheSettingsPanel;
    private StringField maxBytesLocalDiskField;
    private StringField maxBytesLocalHeapField;
    private StringField maxBytesLocalOffHeapField;
    private LongField maxEntriesLocalHeapField;
    private LongField maxEntriesLocalDiskField;
    private LongField ttiField;
    private LongField ttlField;
    private IntegerField maxElementsInCacheField;
    private static final Icon ERROR_ICON = EhcachePresentationUtils.ALERT_ICON;
    private static final Icon BLANK_ICON = EhcachePresentationUtils.BLANK_ICON;
    private static final String EMPTY_ERROR_TEXT = "No Error";

    public CacheModelMessage(CacheManagerModel cacheManagerModel) {
        super((LayoutManager)new BorderLayout());
        this.cacheManagerModel = cacheManagerModel;
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        panel.add((Component)new XLabel("Cache Manager Instance:"), (Object)gbc);
        ++gbc.gridx;
        HashSet<CacheManagerInstance> cmis = new HashSet<CacheManagerInstance>();
        for (CacheManagerInstance cmi : cacheManagerModel.cacheManagerInstances()) {
            cmis.add(cmi);
        }
        this.cacheManagerInstanceSelector = new XComboBox(new DefaultComboBoxModel<CacheManagerInstance>(cmis.toArray(new CacheManagerInstance[0])));
        panel.add((Component)this.cacheManagerInstanceSelector, (Object)gbc);
        this.cacheManagerInstanceSelectorListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CacheModelMessage.this.cacheManagerInstanceSelector.removeActionListener(CacheModelMessage.this.cacheManagerInstanceSelectorListener);
                        CacheModelMessage.this.cacheSettingsInstanceSelector.removeActionListener(CacheModelMessage.this.cacheSettingsInstanceSelectorListener);
                        if (CacheModelMessage.this.canClose()) {
                            CacheModelMessage.this.cacheSettingsComboModel.removeAllElements();
                            CacheModelMessage.this.lastSelectedCacheManagerInstance = (CacheManagerInstance)CacheModelMessage.this.cacheManagerInstanceSelector.getSelectedItem();
                            List list = CacheModelMessage.this.getSettingsList(CacheModelMessage.this.lastSelectedCacheManagerInstance);
                            for (CacheModelInstanceWrapper cmiw : list) {
                                CacheModelMessage.this.cacheSettingsComboModel.addElement(cmiw);
                            }
                            CacheModelMessage.this.setupCacheSettingsPanel();
                        } else {
                            CacheModelMessage.this.cacheManagerInstanceSelector.setSelectedItem((Object)CacheModelMessage.this.lastSelectedCacheManagerInstance);
                        }
                        CacheModelMessage.this.cacheManagerInstanceSelector.addActionListener(CacheModelMessage.this.cacheManagerInstanceSelectorListener);
                        CacheModelMessage.this.cacheSettingsInstanceSelector.addActionListener(CacheModelMessage.this.cacheSettingsInstanceSelectorListener);
                    }
                });
            }
        };
        this.cacheManagerInstanceSelector.addActionListener(this.cacheManagerInstanceSelectorListener);
        this.lastSelectedCacheManagerInstance = (CacheManagerInstance)this.cacheManagerInstanceSelector.getSelectedItem();
        --gbc.gridx;
        ++gbc.gridy;
        panel.add((Component)new XLabel("Cache Instance:"), (Object)gbc);
        ++gbc.gridx;
        List<CacheModelInstanceWrapper> list = this.getSettingsList((CacheManagerInstance)this.cacheManagerInstanceSelector.getSelectedItem());
        this.cacheSettingsComboModel = new DefaultComboBoxModel<CacheModelInstanceWrapper>(list.toArray(new CacheModelInstanceWrapper[0]));
        this.cacheSettingsInstanceSelector = new XComboBox((ComboBoxModel)this.cacheSettingsComboModel);
        panel.add((Component)this.cacheSettingsInstanceSelector, (Object)gbc);
        this.cacheSettingsInstanceSelectorListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CacheModelMessage.this.cacheManagerInstanceSelector.removeActionListener(CacheModelMessage.this.cacheManagerInstanceSelectorListener);
                        CacheModelMessage.this.cacheSettingsInstanceSelector.removeActionListener(CacheModelMessage.this.cacheSettingsInstanceSelectorListener);
                        if (CacheModelMessage.this.canClose()) {
                            CacheModelMessage.this.lastSelectedCacheSettingsInstance = (CacheModelInstanceWrapper)CacheModelMessage.this.cacheSettingsInstanceSelector.getSelectedItem();
                            CacheModelMessage.this.setupCacheSettingsPanel();
                        } else {
                            CacheModelMessage.this.cacheSettingsInstanceSelector.setSelectedItem((Object)CacheModelMessage.this.lastSelectedCacheSettingsInstance);
                        }
                        CacheModelMessage.this.cacheManagerInstanceSelector.addActionListener(CacheModelMessage.this.cacheManagerInstanceSelectorListener);
                        CacheModelMessage.this.cacheSettingsInstanceSelector.addActionListener(CacheModelMessage.this.cacheSettingsInstanceSelectorListener);
                    }
                });
            }
        };
        this.cacheSettingsInstanceSelector.addActionListener(this.cacheSettingsInstanceSelectorListener);
        this.lastSelectedCacheSettingsInstance = (CacheModelInstanceWrapper)this.cacheSettingsInstanceSelector.getSelectedItem();
        --gbc.gridx;
        ++gbc.gridy;
        gbc.gridwidth = 0;
        this.errorLabel = new XLabel();
        panel.add((Component)this.errorLabel, (Object)gbc);
        this.setErrorText(null);
        ++gbc.gridy;
        gbc.gridheight = 0;
        this.cacheSettingsPanel = new XContainer((LayoutManager)new GridBagLayout());
        panel.add((Component)this.cacheSettingsPanel, (Object)gbc);
        this.setupCacheSettingsPanel();
        this.add((Component)panel);
        cacheManagerModel.addCacheManagerModelListener(this);
    }

    private CacheModelInstance getSelectedCacheModelInstance() {
        CacheModelInstanceWrapper wrapper = (CacheModelInstanceWrapper)this.cacheSettingsInstanceSelector.getSelectedItem();
        return wrapper != null ? wrapper.cmi : null;
    }

    private void setupCacheSettingsPanel() {
        this.setup(this.getSelectedCacheModelInstance());
    }

    private CacheManagerInstance getSelectedCacheManagerInstance() {
        return (CacheManagerInstance)this.cacheManagerInstanceSelector.getSelectedItem();
    }

    private XLabel newRightAdjustedLabel(String text) {
        XLabel label = new XLabel(text);
        label.setHorizontalAlignment(2);
        label.setHorizontalTextPosition(11);
        label.setIcon(BLANK_ICON);
        return label;
    }

    private void setup(CacheModelInstance cmi) {
        this.cacheSettingsPanel.removeAll();
        if (cmi != null) {
            XLabel label;
            boolean isClustered = cmi.isTerracottaClustered();
            CacheManagerInstance cacheManagerInstance = this.getSelectedCacheManagerInstance();
            SettingsCacheModel scm = cacheManagerInstance.getSettingsCacheModel(cmi);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(3, 3, 3, 3);
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.fill = 2;
            if (isClustered) {
                gbc.weightx = 0.0;
                label = this.newRightAdjustedLabel("MaxElementsInCache:");
                this.cacheSettingsPanel.add((Component)label, (Object)gbc);
                ++gbc.gridx;
                gbc.weightx = 1.0;
                this.maxElementsInCacheField = new IntegerField(cmi, "MaxElementsOnDisk", (int)scm.getMaxEntriesLocalDisk());
                this.cacheSettingsPanel.add((Component)((Object)this.maxElementsInCacheField), (Object)gbc);
                label.setLabelFor((Component)((Object)this.maxElementsInCacheField));
                --gbc.gridx;
                ++gbc.gridy;
            }
            if (cmi.getMaxEntriesLocalHeap() > 0L || !isClustered && cmi.getMaxEntriesLocalDisk() > 0L) {
                gbc.weightx = 0.0;
                label = this.newRightAdjustedLabel("MaxEntriesLocalHeap:");
                this.cacheSettingsPanel.add((Component)label, (Object)gbc);
                ++gbc.gridx;
                gbc.weightx = 1.0;
                this.maxEntriesLocalHeapField = new LongField(cmi, "MaxEntriesLocalHeap", cmi.getMaxEntriesLocalHeap());
                this.cacheSettingsPanel.add((Component)((Object)this.maxEntriesLocalHeapField), (Object)gbc);
                label.setLabelFor((Component)((Object)this.maxEntriesLocalHeapField));
                --gbc.gridx;
                ++gbc.gridy;
                if (!isClustered && cmi.getMaxEntriesLocalDisk() > 0L) {
                    gbc.weightx = 0.0;
                    label = this.newRightAdjustedLabel("MaxEntriesLocalDisk:");
                    this.cacheSettingsPanel.add((Component)label, (Object)gbc);
                    ++gbc.gridx;
                    gbc.weightx = 1.0;
                    this.maxEntriesLocalDiskField = new LongField(cmi, "MaxEntriesLocalDisk", cmi.getMaxEntriesLocalDisk());
                    this.cacheSettingsPanel.add((Component)((Object)this.maxEntriesLocalDiskField), (Object)gbc);
                    label.setLabelFor((Component)((Object)this.maxEntriesLocalDiskField));
                    --gbc.gridx;
                    ++gbc.gridy;
                }
            }
            if (cmi.getMaxEntriesLocalHeap() <= 0L && (cacheManagerInstance.getMaxBytesLocalHeap() <= 0L || cmi.getMaxBytesLocalHeap() > 0L)) {
                gbc.weightx = 0.0;
                label = this.newRightAdjustedLabel("MaxBytesLocalHeap:");
                this.cacheSettingsPanel.add((Component)label, (Object)gbc);
                ++gbc.gridx;
                gbc.weightx = 1.0;
                this.maxBytesLocalHeapField = new StringField(cmi, "MaxBytesLocalHeapAsString", cmi.getMaxBytesLocalHeapAsString());
                this.cacheSettingsPanel.add((Component)((Object)this.maxBytesLocalHeapField), (Object)gbc);
                label.setLabelFor((Component)((Object)this.maxBytesLocalHeapField));
                --gbc.gridx;
                ++gbc.gridy;
            }
            if (!(isClustered || cmi.getMaxEntriesLocalDisk() > 0L || cacheManagerInstance.getMaxBytesLocalDisk() > 0L && cmi.getMaxBytesLocalDisk() <= 0L)) {
                gbc.weightx = 0.0;
                label = this.newRightAdjustedLabel("MaxBytesLocalDisk:");
                this.cacheSettingsPanel.add((Component)label, (Object)gbc);
                ++gbc.gridx;
                gbc.weightx = 1.0;
                this.maxBytesLocalDiskField = new StringField(cmi, "MaxBytesLocalDiskAsString", cmi.getMaxBytesLocalDiskAsString());
                this.cacheSettingsPanel.add((Component)((Object)this.maxBytesLocalDiskField), (Object)gbc);
                label.setLabelFor((Component)((Object)this.maxBytesLocalDiskField));
                --gbc.gridx;
                ++gbc.gridy;
            }
            gbc.weightx = 0.0;
            label = this.newRightAdjustedLabel("TTI:");
            this.cacheSettingsPanel.add((Component)label, (Object)gbc);
            ++gbc.gridx;
            long tti = isClustered ? scm.getTimeToIdleSeconds() : cmi.getTimeToIdleSeconds();
            gbc.weightx = 1.0;
            this.ttiField = new LongField(cmi, "TimeToIdleSeconds", tti);
            this.cacheSettingsPanel.add((Component)((Object)this.ttiField), (Object)gbc);
            label.setLabelFor((Component)((Object)this.ttiField));
            --gbc.gridx;
            ++gbc.gridy;
            gbc.weightx = 0.0;
            label = this.newRightAdjustedLabel("TTL:");
            this.cacheSettingsPanel.add((Component)label, (Object)gbc);
            ++gbc.gridx;
            long ttl = isClustered ? scm.getTimeToLiveSeconds() : cmi.getTimeToLiveSeconds();
            gbc.weightx = 1.0;
            this.ttlField = new LongField(cmi, "TimeToLiveSeconds", ttl);
            this.cacheSettingsPanel.add((Component)((Object)this.ttlField), (Object)gbc);
            label.setLabelFor((Component)((Object)this.ttlField));
            this.cacheSettingsPanel.setBorder((Border)BorderFactory.createTitledBorder(cmi.toString()));
        }
        this.cacheSettingsPanel.revalidate();
        this.cacheSettingsPanel.repaint();
    }

    private void update(CacheModelInstance cmi) {
        if (cmi != null) {
            boolean isClustered = cmi.isTerracottaClustered();
            CacheManagerInstance cacheManagerInstance = this.getSelectedCacheManagerInstance();
            SettingsCacheModel scm = cacheManagerInstance.getSettingsCacheModel(cmi);
            if (isClustered) {
                this.maxElementsInCacheField.setValue((int)scm.getMaxEntriesLocalDisk());
            }
            if (cmi.getMaxEntriesLocalHeap() > 0L || !isClustered && cmi.getMaxEntriesLocalDisk() > 0L) {
                this.maxEntriesLocalHeapField.setValue(cmi.getMaxEntriesLocalHeap());
                if (!isClustered) {
                    this.maxEntriesLocalDiskField.setValue(cmi.getMaxEntriesLocalDisk());
                }
            } else {
                if (cacheManagerInstance.getMaxBytesLocalHeap() <= 0L || cmi.getMaxBytesLocalHeap() > 0L) {
                    this.maxBytesLocalHeapField.setValue(cmi.getMaxBytesLocalHeapAsString());
                }
                if (!(isClustered || cacheManagerInstance.getMaxBytesLocalDisk() > 0L && cmi.getMaxBytesLocalDisk() <= 0L)) {
                    this.maxBytesLocalDiskField.setValue(cmi.getMaxBytesLocalDiskAsString());
                }
            }
            long tti = isClustered ? scm.getTimeToIdleSeconds() : cmi.getTimeToIdleSeconds();
            this.ttiField.setValue(tti);
            long ttl = isClustered ? scm.getTimeToLiveSeconds() : cmi.getTimeToLiveSeconds();
            this.ttlField.setValue(ttl);
        }
    }

    private List<CacheModelInstanceWrapper> sort(List<CacheModelInstanceWrapper> list) {
        if (list != null) {
            Object[] a = list.toArray(new CacheModelInstanceWrapper[0]);
            Arrays.sort(a);
            list.clear();
            list.addAll(Arrays.asList(a));
        }
        return list;
    }

    private List<CacheModelInstanceWrapper> getSettingsList(CacheManagerInstance cacheManagerInstance) {
        ArrayList<CacheModelInstanceWrapper> result = new ArrayList<CacheModelInstanceWrapper>();
        for (CacheModelInstance cmi : cacheManagerInstance.cacheModelInstances()) {
            result.add(new CacheModelInstanceWrapper(cmi));
        }
        return this.sort(result);
    }

    private boolean hasChangesOrError() {
        for (Component c : this.cacheSettingsPanel.getComponents()) {
            StringField sf;
            if (!(c instanceof StringField) || !(sf = (StringField)((Object)c)).isChangedOrHasError()) continue;
            return true;
        }
        return false;
    }

    public boolean canClose() {
        if (this.hasChangesOrError()) {
            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, (Component)((Object)this));
            int result = JOptionPane.showConfirmDialog((Component)((Object)this), "There a unapplied changes. Would you like to apply them?", dialog.getTitle(), 1);
            switch (result) {
                case 2: {
                    return false;
                }
                case 0: {
                    return this.apply();
                }
            }
            return true;
        }
        return true;
    }

    private void setErrorText(String text) {
        boolean isEmpty = StringUtils.isEmpty((String)text);
        this.errorLabel.setText(text);
        this.errorLabel.setIcon(isEmpty ? null : ERROR_ICON);
        if (isEmpty) {
            this.errorLabel.setText(EMPTY_ERROR_TEXT);
            this.errorLabel.setForeground(this.errorLabel.getBackground());
        } else {
            this.errorLabel.setForeground(null);
        }
    }

    public boolean apply() {
        boolean result = true;
        this.setErrorText(null);
        for (Component c : this.cacheSettingsPanel.getComponents()) {
            if (!(c instanceof StringField)) continue;
            StringField sf = (StringField)((Object)c);
            XLabel label = (XLabel)sf.getClientProperty("labeledBy");
            if (!sf.testApply()) {
                if (StringUtils.equals((String)EMPTY_ERROR_TEXT, (String)this.errorLabel.getText())) {
                    this.setErrorText(sf.getToolTipText());
                    label.setIcon(ERROR_ICON);
                } else {
                    label.setIcon(BLANK_ICON);
                }
                result = false;
                continue;
            }
            label.setIcon(BLANK_ICON);
        }
        return result;
    }

    @Override
    public void instanceAdded(CacheManagerInstance instance) {
        this.updateCacheManageInstanceSelectorLater();
    }

    @Override
    public void instanceRemoved(CacheManagerInstance instance) {
        this.updateCacheManageInstanceSelectorLater();
    }

    @Override
    public void cacheModelAdded(CacheModel cacheModel) {
    }

    @Override
    public void cacheModelRemoved(CacheModel cacheModel) {
    }

    @Override
    public void cacheModelChanged(CacheModel cacheModel) {
        if (this.isShowing()) {
            CacheModelInstance cmi = this.getSelectedCacheModelInstance();
            if (cacheModel.getCacheName().equals(cmi.getCacheName())) {
                this.update(cmi);
            }
        }
    }

    @Override
    public void clusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void clusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void clusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
    }

    private void updateCacheManageInstanceSelectorLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CacheModelMessage.this.updateCacheManageInstanceSelector();
            }
        });
    }

    private void updateCacheManageInstanceSelector() {
        int selIndex = this.cacheManagerInstanceSelector.getSelectedIndex();
        this.cacheManagerInstanceSelector.setModel(new DefaultComboBoxModel<CacheManagerInstance>(this.cacheManagerModel.cacheManagerInstances().toArray(new CacheManagerInstance[0])));
        if (selIndex != -1 && selIndex < this.cacheManagerInstanceSelector.getItemCount()) {
            this.cacheManagerInstanceSelector.setSelectedIndex(selIndex);
        }
    }

    @Override
    public void standaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
    }

    public void tearDown() {
        if (this.cacheManagerModel != null) {
            this.cacheManagerModel.removeCacheManagerModelListener(this);
        }
        super.tearDown();
    }

    private static class CacheModelInstanceWrapper
    implements Comparable {
        CacheModelInstance cmi;

        CacheModelInstanceWrapper(CacheModelInstance cmi) {
            this.cmi = cmi;
        }

        public String toString() {
            return this.cmi.getCacheName();
        }

        public int compareTo(Object o) {
            if (!(o instanceof CacheModelInstanceWrapper)) {
                throw new IllegalArgumentException("Not a CacheModelInstanceWrapper");
            }
            CacheModelInstanceWrapper other = (CacheModelInstanceWrapper)o;
            return this.cmi.compareTo(other.cmi);
        }
    }

    private class IntegerField
    extends StringField {
        IntegerField(CacheModelInstance cmi, String attribute, int value) {
            super(cmi, attribute, Integer.toString(value));
        }

        void setValue(int value) {
            super.setValue(Integer.toString(value));
        }

        Object getValue() throws Exception {
            try {
                return Integer.parseInt(this.getText());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Cannot be converted to a integer");
            }
        }
    }

    private class LongField
    extends StringField {
        LongField(CacheModelInstance cmi, String attribute, long value) {
            super(cmi, attribute, Long.toString(value));
        }

        void setValue(long value) {
            super.setValue(Long.toString(value));
        }

        Object getValue() throws Exception {
            try {
                return Long.parseLong(this.getText());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Cannot be converted to a long");
            }
        }
    }

    private class StringField
    extends XTextField {
        private final CacheModelInstance cmi;
        private final String attribute;
        private String initialValue;

        StringField(CacheModelInstance cmi, String attribute, String value) {
            super(value);
            this.cmi = cmi;
            this.attribute = attribute;
            this.initialValue = value;
        }

        Object getValue() throws Exception {
            return this.getText();
        }

        void setValue(String value) {
            if (!this.getText().equals(value)) {
                this.initialValue = value;
                this.setText(this.initialValue);
            }
        }

        boolean hasError() {
            return !StringUtils.isEmpty((String)this.getToolTipText());
        }

        boolean isChanged() {
            return !this.initialValue.equals(this.getText());
        }

        boolean isChangedOrHasError() {
            return this.isChanged() || this.hasError();
        }

        boolean testApply() {
            return this.isChangedOrHasError() ? this.apply() : true;
        }

        boolean apply() {
            CacheManagerInstance cacheManagerInstance = CacheModelMessage.this.getSelectedCacheManagerInstance();
            this.initialValue = this.getText();
            try {
                cacheManagerInstance.setAttribute(this.cmi.getBeanName(), this.attribute, this.getValue());
                this.setToolTipText(null);
                return true;
            }
            catch (Exception e) {
                Throwable t = ExceptionHelper.getRootCause((Throwable)e);
                this.setToolTipText(t.getMessage());
                return false;
            }
        }
    }
}

