/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.presentation;

import com.tc.admin.common.BasicWorker;
import com.tc.admin.common.ExceptionHelper;
import com.tc.admin.common.XCheckBox;
import com.tc.admin.common.XContainer;
import com.tc.admin.common.XLabel;
import com.tc.admin.common.XObjectTable;
import com.tc.admin.common.XScrollPane;
import com.tc.admin.common.XTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.terracotta.modules.ehcache.presentation.BooleanRenderer;
import org.terracotta.modules.ehcache.presentation.NodeInstanceTableModel;
import org.terracotta.modules.ehcache.presentation.NodeSummaryTableModel;
import org.terracotta.modules.ehcache.presentation.TopologyPanel;
import org.terracotta.modules.ehcache.presentation.TopologyPanelPage;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstance;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerInstanceListener;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModel;
import org.terracotta.modules.ehcache.presentation.model.CacheManagerModelListener;
import org.terracotta.modules.ehcache.presentation.model.CacheModel;
import org.terracotta.modules.ehcache.presentation.model.CacheModelInstance;
import org.terracotta.modules.ehcache.presentation.model.ClusteredCacheModel;
import org.terracotta.modules.ehcache.presentation.model.StandaloneCacheModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManagerTopologyPanel
extends TopologyPanelPage
implements CacheManagerModelListener,
CacheManagerInstanceListener,
ListSelectionListener {
    private final CacheManagerModel cacheManagerModel;
    private final TopologyPanel topologyPanel;
    private GridBagLayout layout;
    private Set<CacheManagerInstance> selectedCacheManagerInstances;
    private NodeSummaryTableModel nodeSummaryTableModel;
    private XObjectTable nodeSummaryTable;
    private NodeInstanceTableModel nodeInstanceTableModel;
    private XObjectTable nodeInstanceTable;
    private XContainer nodeInstancePanelHolder;
    private XContainer nodeInstancePanel;

    public CacheManagerTopologyPanel(TopologyPanel topologyPanel) {
        super(topologyPanel.getApplicationContext(), topologyPanel.getCacheManagerModel());
        this.topologyPanel = topologyPanel;
        this.cacheManagerModel = topologyPanel.getCacheManagerModel();
        this.setName(TopologyPanel.Mode.CACHE_MANAGER.toString());
    }

    public CacheManagerTopologyPanel(TopologyPanel topologyPanel, Set<CacheManagerInstance> selectedCacheManagerInstances) {
        this(topologyPanel);
        this.selectedCacheManagerInstances = selectedCacheManagerInstances;
    }

    @Override
    public void setup() {
        super.setup();
        this.cacheManagerModel.addCacheManagerModelListener(this);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void resume() {
        super.resume();
    }

    @Override
    protected void init() {
        CacheManagerInstance instance;
        Iterator<CacheManagerInstance> iter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            CacheManagerInstance instance2 = iter.next();
            this.nodeSummaryTableModel.add(instance2);
            instance2.addCacheManagerInstanceListener(this);
        }
        this.nodeSummaryTableModel.fireTableDataChanged();
        if (this.selectedCacheManagerInstances != null) {
            this.nodeSummaryTable.setSelection((Object[])this.selectedCacheManagerInstances.toArray(new CacheManagerInstance[0]));
            this.selectedCacheManagerInstances = null;
        } else if (this.nodeSummaryTableModel.getRowCount() > 0 && (instance = (CacheManagerInstance)this.nodeSummaryTableModel.getObjectAt(0)).getInstanceCount() > 0) {
            this.nodeSummaryTable.setSelectedRow(0);
        }
    }

    @Override
    protected XContainer createMainPanel() {
        this.layout = new GridBagLayout();
        XContainer panel = new XContainer((LayoutManager)this.layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        panel.add((Component)this.createNodeSummaryPanel(), (Object)gbc);
        ++gbc.gridy;
        this.nodeInstancePanel = this.createNodeInstancePanel();
        this.nodeInstancePanelHolder = new XContainer((LayoutManager)new BorderLayout());
        gbc.weighty = 0.0;
        panel.add((Component)this.nodeInstancePanelHolder, (Object)gbc);
        return panel;
    }

    private XContainer createSelectAllPanel(XTable table) {
        XContainer panel = new XContainer((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)new XLabel(), (Object)gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        XCheckBox selectAllToggle = new XCheckBox("Select/De-select All");
        panel.add((Component)selectAllToggle, (Object)gbc);
        selectAllToggle.addActionListener((ActionListener)new TopologyPanelPage.SelectAllToggleListener(table));
        return panel;
    }

    private XContainer createNodeSummaryPanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        String title = MessageFormat.format(bundle.getString("node.summary"), this.cacheManagerModel.getName());
        panel.setBorder((Border)BorderFactory.createTitledBorder(title));
        this.nodeSummaryTableModel = new NodeSummaryTableModel();
        this.nodeSummaryTable = new XObjectTable((TableModel)((Object)this.nodeSummaryTableModel));
        this.nodeSummaryTable.setSelectionMode(2);
        this.nodeSummaryTable.getSelectionModel().addListSelectionListener(this);
        panel.add((Component)this.createSelectAllPanel((XTable)this.nodeSummaryTable), (Object)"South");
        panel.add((Component)new XScrollPane((Component)this.nodeSummaryTable));
        this.nodeSummaryTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)((Object)new BooleanRenderer()));
        JPopupMenu popup = this.topologyPanel.createPopup();
        this.nodeSummaryTable.setPopupMenu(popup);
        popup.addPopupMenuListener(new TopologyPanelPage.PopupMenuAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                CacheManagerTopologyPanel.this.updateActions((XTable)CacheManagerTopologyPanel.this.nodeSummaryTable);
            }
        });
        return panel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e == null || !e.getValueIsAdjusting()) {
            this.nodeInstanceTableModel.clear();
            boolean showNodeInstancePanel = false;
            CacheManagerInstance cacheManagerInstance = null;
            int[] rows = this.nodeSummaryTable.getSelectedRows();
            if (rows.length == 1 && (cacheManagerInstance = (CacheManagerInstance)this.nodeSummaryTableModel.getObjectAt(rows[0])).getInstanceCount() > 0) {
                Iterator<CacheModelInstance> iter = cacheManagerInstance.cacheModelInstanceIter();
                while (iter.hasNext()) {
                    this.nodeInstanceTableModel.add(iter.next());
                }
                this.nodeInstanceTableModel.fireTableDataChanged();
                String title = MessageFormat.format(bundle.getString("node.instance.detail"), this.cacheManagerModel.getName(), cacheManagerInstance.getClient());
                this.nodeInstancePanel.setBorder((Border)BorderFactory.createTitledBorder(title));
                showNodeInstancePanel = true;
            }
            this.setNodeInstancePanelVisible(showNodeInstancePanel);
            this.updateActions((XTable)this.nodeSummaryTable);
        }
    }

    @Override
    public void updateActions(XTable table) {
        int cacheInstanceCount = 0;
        int clusteredCacheInstanceCount = 0;
        int enabled = 0;
        int statistics = 0;
        int bulkload = 0;
        boolean anySelected = false;
        if (table == this.nodeSummaryTable) {
            Set<CacheManagerInstance> cacheManagerInstances = this.getSelectedCacheManagerInstances();
            for (CacheManagerInstance cmi : cacheManagerInstances) {
                cacheInstanceCount += cmi.getInstanceCount();
                clusteredCacheInstanceCount += cmi.getTerracottaClusteredInstanceCount();
                enabled += cmi.getEnabledCount();
                statistics += cmi.getStatisticsEnabledCount();
                bulkload += cmi.getBulkLoadEnabledCount();
            }
            anySelected = cacheManagerInstances.size() > 0;
        } else {
            Set<CacheModelInstance> cacheModelInstances = this.getSelectedCacheModelInstances();
            for (CacheModelInstance cmi : cacheModelInstances) {
                if (cmi.isEnabled()) {
                    ++enabled;
                }
                if (cmi.isStatisticsEnabled()) {
                    ++statistics;
                }
                if (cmi.isTerracottaClustered()) {
                    ++clusteredCacheInstanceCount;
                }
                if (!cmi.isBulkLoadEnabled()) continue;
                ++bulkload;
            }
            anySelected = cacheModelInstances.size() > 0;
        }
        this.topologyPanel.disableCachesAction.setEnabled(enabled > 0);
        this.topologyPanel.enableCachesAction.setEnabled(enabled < cacheInstanceCount);
        this.topologyPanel.disableStatisticsAction.setEnabled(statistics > 0);
        this.topologyPanel.enableStatisticsAction.setEnabled(statistics < cacheInstanceCount);
        this.topologyPanel.disableBulkLoadingAction.setEnabled(bulkload > 0);
        this.topologyPanel.enableBulkLoadingAction.setEnabled(bulkload < clusteredCacheInstanceCount);
        this.topologyPanel.clearCachesAction.setEnabled(enabled > 0);
        this.topologyPanel.showConfigAction.setEnabled(anySelected);
    }

    private void setNodeInstancePanelVisible(boolean visible) {
        if (visible) {
            if (this.nodeInstancePanel.getParent() == null) {
                this.nodeInstancePanelHolder.add((Component)this.nodeInstancePanel);
                GridBagConstraints gbc = this.layout.getConstraints((Component)this.nodeInstancePanelHolder);
                gbc.weighty = 1.0;
                this.layout.setConstraints((Component)this.nodeInstancePanelHolder, gbc);
            }
        } else if (this.nodeInstancePanel.getParent() != null) {
            this.nodeInstancePanelHolder.remove((Component)this.nodeInstancePanel);
            GridBagConstraints gbc = this.layout.getConstraints((Component)this.nodeInstancePanelHolder);
            gbc.weighty = 0.0;
            this.layout.setConstraints((Component)this.nodeInstancePanelHolder, gbc);
        }
        this.nodeInstancePanel.setVisible(visible);
        this.nodeInstancePanelHolder.revalidate();
        this.nodeInstancePanelHolder.repaint();
    }

    private XContainer createNodeInstancePanel() {
        XContainer panel = new XContainer((LayoutManager)new BorderLayout());
        this.nodeInstanceTableModel = new NodeInstanceTableModel();
        this.nodeInstanceTable = new XObjectTable((TableModel)((Object)this.nodeInstanceTableModel));
        this.nodeInstanceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CacheManagerTopologyPanel.this.updateActions((XTable)CacheManagerTopologyPanel.this.nodeInstanceTable);
                }
            }
        });
        panel.add((Component)this.createSelectAllPanel((XTable)this.nodeInstanceTable), (Object)"South");
        panel.add((Component)new XScrollPane((Component)this.nodeInstanceTable));
        this.nodeInstanceTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)((Object)new BooleanRenderer()));
        this.nodeInstanceTable.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)((Object)new TopologyPanelPage.ModeRenderer()));
        JPopupMenu popup = this.topologyPanel.createPopup();
        this.nodeInstanceTable.setPopupMenu(popup);
        popup.addPopupMenuListener(new TopologyPanelPage.PopupMenuAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                CacheManagerTopologyPanel.this.updateActions((XTable)CacheManagerTopologyPanel.this.nodeInstanceTable);
            }
        });
        return panel;
    }

    @Override
    public void instanceAdded(final CacheManagerInstance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CacheManagerTopologyPanel.this.nodeSummaryTableModel.add(instance);
                int row = CacheManagerTopologyPanel.this.nodeSummaryTableModel.getRowCount() - 1;
                CacheManagerTopologyPanel.this.nodeSummaryTableModel.fireTableRowsInserted(row, row);
                if (row == 0 && instance.getInstanceCount() > 0) {
                    CacheManagerTopologyPanel.this.nodeSummaryTable.setSelectedRow(0);
                }
                instance.addCacheManagerInstanceListener(CacheManagerTopologyPanel.this);
            }
        });
    }

    @Override
    public void instanceRemoved(final CacheManagerInstance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row = CacheManagerTopologyPanel.this.nodeSummaryTableModel.getObjectIndex(instance);
                if (row != -1) {
                    CacheManagerTopologyPanel.this.nodeSummaryTableModel.remove(instance);
                    CacheManagerTopologyPanel.this.nodeSummaryTableModel.fireTableRowsDeleted(row, row);
                }
                instance.removeCacheManagerInstanceListener(CacheManagerTopologyPanel.this);
            }
        });
    }

    @Override
    public void cacheModelAdded(CacheModel cacheModel) {
    }

    @Override
    public void cacheModelRemoved(CacheModel cacheModel) {
    }

    @Override
    public void cacheModelChanged(CacheModel cacheModel) {
    }

    public Set<CacheManagerInstance> getSelectedCacheManagerInstances() {
        return Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(this.nodeSummaryTable.getSelection())));
    }

    public Set<CacheModelInstance> getSelectedCacheModelInstances() {
        return Collections.unmodifiableSet(new HashSet<Object>(Arrays.asList(this.nodeInstanceTable.getSelection())));
    }

    public Set<CacheModel> getSelectedCacheModels() {
        HashSet<CacheModel> result = new HashSet<CacheModel>();
        for (CacheModelInstance cmi : this.getSelectedCacheModelInstances()) {
            result.add(cmi.getCacheModel());
        }
        return result;
    }

    private boolean isCacheManagerInstanceSelected(CacheManagerInstance instance) {
        HashSet<Object> nodeSummarySelection = new HashSet<Object>(Arrays.asList(this.nodeSummaryTable.getSelection()));
        return nodeSummarySelection.contains(instance);
    }

    private void updateCacheManagerInstanceRow(CacheManagerInstance instance) {
        int row = this.nodeSummaryTableModel.getObjectIndex(instance);
        if (row != -1) {
            this.nodeSummaryTableModel.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    public void cacheManagerInstanceChanged(CacheManagerInstance cacheManagerInstance) {
    }

    @Override
    public void cacheModelInstanceAdded(final CacheModelInstance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CacheManagerInstance cacheManagerInstance = instance.getCacheManagerInstance();
                if (CacheManagerTopologyPanel.this.isCacheManagerInstanceSelected(cacheManagerInstance)) {
                    CacheManagerTopologyPanel.this.nodeInstanceTableModel.add(instance);
                    int row = CacheManagerTopologyPanel.this.nodeInstanceTableModel.getRowCount() - 1;
                    CacheManagerTopologyPanel.this.nodeInstanceTableModel.fireTableRowsInserted(row, row);
                    CacheManagerTopologyPanel.this.setNodeInstancePanelVisible(true);
                }
                CacheManagerTopologyPanel.this.updateCacheManagerInstanceRow(cacheManagerInstance);
            }
        });
    }

    @Override
    public void cacheModelInstanceChanged(final CacheModelInstance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row;
                if (CacheManagerTopologyPanel.this.isCacheManagerInstanceSelected(instance.getCacheManagerInstance()) && (row = CacheManagerTopologyPanel.this.nodeInstanceTableModel.getObjectIndex(instance)) != -1) {
                    CacheManagerTopologyPanel.this.nodeInstanceTableModel.fireTableRowsUpdated(row, row);
                }
                CacheManagerTopologyPanel.this.updateCacheManagerInstanceRow(instance.getCacheManagerInstance());
            }
        });
    }

    @Override
    public void cacheModelInstanceRemoved(final CacheModelInstance instance) {
        final CacheManagerInstance parent = instance.getCacheManagerInstance();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int row;
                if (CacheManagerTopologyPanel.this.isCacheManagerInstanceSelected(parent) && (row = CacheManagerTopologyPanel.this.nodeInstanceTableModel.getObjectIndex(instance)) != -1) {
                    CacheManagerTopologyPanel.this.nodeInstanceTableModel.remove(instance);
                    CacheManagerTopologyPanel.this.nodeInstanceTableModel.fireTableRowsDeleted(row, row);
                    if (CacheManagerTopologyPanel.this.nodeInstanceTableModel.getRowCount() == 0) {
                        CacheManagerTopologyPanel.this.setNodeInstancePanelVisible(false);
                    }
                }
                CacheManagerTopologyPanel.this.updateCacheManagerInstanceRow(parent);
            }
        });
    }

    @Override
    public void clusteredCacheModelAdded(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void clusteredCacheModelRemoved(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void clusteredCacheModelChanged(ClusteredCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelAdded(StandaloneCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelRemoved(StandaloneCacheModel cacheModel) {
    }

    @Override
    public void standaloneCacheModelChanged(StandaloneCacheModel cacheModel) {
    }

    @Override
    protected BasicWorker<Void> createClearCachesWorker(JPopupMenu popupMenu) {
        return new ClearCachesWorker(popupMenu);
    }

    @Override
    protected BasicWorker<Void> createEnableCachesWorker(JPopupMenu popupMenu, boolean enable, boolean flush) {
        return new EnableCachesWorker(popupMenu, enable, flush);
    }

    @Override
    protected BasicWorker<Void> createStatisticsControlWorker(JPopupMenu popupMenu, boolean enable) {
        return new StatisticsControlWorker(popupMenu, enable);
    }

    @Override
    protected BasicWorker<Void> createBulkLoadControlWorker(JPopupMenu popupMenu, boolean bulkLoadEnabled) {
        return new BulkLoadControlWorker(popupMenu, bulkLoadEnabled);
    }

    @Override
    protected Callable<String> createConfigurationGenerator(JPopupMenu popupMenu) {
        return new ConfigurationGenerator(popupMenu);
    }

    @Override
    public void tearDown() {
        this.cacheManagerModel.removeCacheManagerModelListener(this);
        Iterator<CacheManagerInstance> iter = this.cacheManagerModel.cacheManagerInstanceIterator();
        while (iter.hasNext()) {
            iter.next().removeCacheManagerInstanceListener(this);
        }
        this.nodeSummaryTableModel.clear();
        this.nodeInstanceTableModel.clear();
        super.tearDown();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigurationGenerator
    implements Callable<String> {
        final JPopupMenu popupMenu;

        private ConfigurationGenerator(JPopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }

        @Override
        public String call() throws Exception {
            if (this.popupMenu == CacheManagerTopologyPanel.this.nodeSummaryTable.getPopupMenu()) {
                Set<CacheManagerInstance> cacheManagerInstances = CacheManagerTopologyPanel.this.getSelectedCacheManagerInstances();
                if (cacheManagerInstances.size() == CacheManagerTopologyPanel.this.cacheManagerModel.getInstanceCount()) {
                    return CacheManagerTopologyPanel.this.cacheManagerModel.generateActiveConfigDeclaration();
                }
                StringBuilder sb = new StringBuilder();
                for (CacheManagerInstance cacheManagerInstance : cacheManagerInstances) {
                    sb.append(cacheManagerInstance.generateActiveConfigDeclaration());
                    sb.append("\n");
                }
                return sb.toString();
            }
            CacheManagerInstance cacheManagerInstance = (CacheManagerInstance)CacheManagerTopologyPanel.this.nodeSummaryTableModel.getObjectAt(CacheManagerTopologyPanel.this.nodeSummaryTable.getSelectedRow());
            Set<CacheModelInstance> cacheModelInstances = CacheManagerTopologyPanel.this.getSelectedCacheModelInstances();
            if (cacheModelInstances.size() == cacheManagerInstance.getInstanceCount()) {
                return cacheManagerInstance.generateActiveConfigDeclaration();
            }
            StringBuilder sb = new StringBuilder();
            for (CacheModelInstance cacheModelInstance : cacheModelInstances) {
                sb.append(cacheModelInstance.generateActiveConfigDeclaration());
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BulkLoadControlWorker
    extends BasicWorker<Void> {
        private BulkLoadControlWorker(final JPopupMenu popupMenu, final boolean enable) {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (popupMenu == CacheManagerTopologyPanel.this.nodeSummaryTable.getPopupMenu()) {
                        Set<CacheManagerInstance> cacheManagerInstances = CacheManagerTopologyPanel.this.getSelectedCacheManagerInstances();
                        if (cacheManagerInstances.size() == CacheManagerTopologyPanel.this.cacheManagerModel.getInstanceCount()) {
                            CacheManagerTopologyPanel.this.cacheManagerModel.setBulkLoadEnabled(enable, true);
                        } else {
                            for (CacheManagerInstance cacheManagerInstance : cacheManagerInstances) {
                                cacheManagerInstance.setCachesBulkLoadEnabled(enable);
                            }
                        }
                    } else {
                        CacheManagerInstance cacheManagerInstance = (CacheManagerInstance)CacheManagerTopologyPanel.this.nodeSummaryTableModel.getObjectAt(CacheManagerTopologyPanel.this.nodeSummaryTable.getSelectedRow());
                        Set<CacheModelInstance> cacheModelInstances = CacheManagerTopologyPanel.this.getSelectedCacheModelInstances();
                        if (cacheModelInstances.size() == cacheManagerInstance.getInstanceCount()) {
                            cacheManagerInstance.setCachesBulkLoadEnabled(enable);
                        } else {
                            for (CacheModelInstance cacheModelInstance : cacheModelInstances) {
                                if (cacheModelInstance.isTransactional()) continue;
                                cacheModelInstance.setBulkLoadEnabled(enable);
                            }
                        }
                    }
                    return null;
                }
            });
        }

        protected void finished() {
            Throwable rootCause;
            Exception e = this.getException();
            if (e != null && !((rootCause = ExceptionHelper.getRootCause((Throwable)e)) instanceof IOException)) {
                CacheManagerTopologyPanel.this.appContext.log((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatisticsControlWorker
    extends BasicWorker<Void> {
        private StatisticsControlWorker(final JPopupMenu popupMenu, final boolean enable) {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (popupMenu == CacheManagerTopologyPanel.this.nodeSummaryTable.getPopupMenu()) {
                        Set<CacheManagerInstance> cacheManagerInstances = CacheManagerTopologyPanel.this.getSelectedCacheManagerInstances();
                        if (cacheManagerInstances.size() == CacheManagerTopologyPanel.this.cacheManagerModel.getInstanceCount()) {
                            CacheManagerTopologyPanel.this.cacheManagerModel.setStatisticsEnabled(enable, true);
                        } else {
                            for (CacheManagerInstance cacheManagerInstance : cacheManagerInstances) {
                                cacheManagerInstance.setStatisticsEnabled(enable);
                            }
                        }
                    } else {
                        CacheManagerInstance cacheManagerInstance = (CacheManagerInstance)CacheManagerTopologyPanel.this.nodeSummaryTableModel.getObjectAt(CacheManagerTopologyPanel.this.nodeSummaryTable.getSelectedRow());
                        Set<CacheModelInstance> cacheModelInstances = CacheManagerTopologyPanel.this.getSelectedCacheModelInstances();
                        if (cacheModelInstances.size() == cacheManagerInstance.getInstanceCount()) {
                            cacheManagerInstance.setStatisticsEnabled(enable);
                        } else {
                            for (CacheModelInstance cacheModelInstance : cacheModelInstances) {
                                cacheModelInstance.setStatisticsEnabled(enable);
                            }
                        }
                    }
                    return null;
                }
            });
        }

        protected void finished() {
            Throwable rootCause;
            Exception e = this.getException();
            if (e != null && !((rootCause = ExceptionHelper.getRootCause((Throwable)e)) instanceof IOException)) {
                CacheManagerTopologyPanel.this.appContext.log((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnableCachesWorker
    extends BasicWorker<Void> {
        private EnableCachesWorker(final JPopupMenu popupMenu, final boolean enable, final boolean flush) {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    block6: {
                        block4: {
                            Set<CacheManagerInstance> cacheManagerInstances;
                            block5: {
                                if (popupMenu != CacheManagerTopologyPanel.this.nodeSummaryTable.getPopupMenu()) break block4;
                                cacheManagerInstances = CacheManagerTopologyPanel.this.getSelectedCacheManagerInstances();
                                if (cacheManagerInstances.size() != CacheManagerTopologyPanel.this.cacheManagerModel.getInstanceCount()) break block5;
                                CacheManagerTopologyPanel.this.cacheManagerModel.setCachesEnabled(enable, true);
                                if (!flush) break block6;
                                CacheManagerTopologyPanel.this.cacheManagerModel.clearAllCaches();
                                break block6;
                            }
                            for (CacheManagerInstance cacheManagerInstance : cacheManagerInstances) {
                                cacheManagerInstance.setCachesEnabled(enable);
                            }
                            break block6;
                        }
                        CacheManagerInstance cacheManagerInstance = (CacheManagerInstance)CacheManagerTopologyPanel.this.nodeSummaryTableModel.getObjectAt(CacheManagerTopologyPanel.this.nodeSummaryTable.getSelectedRow());
                        Set<CacheModelInstance> cacheModelInstances = CacheManagerTopologyPanel.this.getSelectedCacheModelInstances();
                        if (cacheModelInstances.size() == cacheManagerInstance.getInstanceCount()) {
                            cacheManagerInstance.setCachesEnabled(enable);
                        } else {
                            for (CacheModelInstance cacheModelInstance : cacheModelInstances) {
                                cacheModelInstance.setEnabled(enable);
                            }
                        }
                    }
                    return null;
                }
            });
        }

        protected void finished() {
            Throwable rootCause;
            Exception e = this.getException();
            if (e != null && !((rootCause = ExceptionHelper.getRootCause((Throwable)e)) instanceof IOException)) {
                CacheManagerTopologyPanel.this.appContext.log((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClearCachesWorker
    extends BasicWorker<Void> {
        private ClearCachesWorker(final JPopupMenu popupMenu) {
            super((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (popupMenu == CacheManagerTopologyPanel.this.nodeSummaryTable.getPopupMenu()) {
                        Set<CacheManagerInstance> cacheManagerInstances = CacheManagerTopologyPanel.this.getSelectedCacheManagerInstances();
                        if (cacheManagerInstances.size() == CacheManagerTopologyPanel.this.cacheManagerModel.getInstanceCount()) {
                            CacheManagerTopologyPanel.this.cacheManagerModel.clearAllCaches();
                        } else {
                            for (CacheManagerInstance cacheManagerInstance : cacheManagerInstances) {
                                cacheManagerInstance.clearAll();
                            }
                        }
                    } else {
                        CacheManagerInstance cacheManagerInstance = (CacheManagerInstance)CacheManagerTopologyPanel.this.nodeSummaryTableModel.getObjectAt(CacheManagerTopologyPanel.this.nodeSummaryTable.getSelectedRow());
                        Set<CacheModelInstance> cacheModelInstances = CacheManagerTopologyPanel.this.getSelectedCacheModelInstances();
                        if (cacheModelInstances.size() == cacheManagerInstance.getInstanceCount()) {
                            cacheManagerInstance.clearAll();
                        } else {
                            for (CacheModelInstance cacheModelInstance : cacheModelInstances) {
                                cacheModelInstance.removeAll();
                            }
                        }
                    }
                    return null;
                }
            });
        }

        protected void finished() {
            Throwable rootCause;
            Exception e = this.getException();
            if (e != null && !((rootCause = ExceptionHelper.getRootCause((Throwable)e)) instanceof IOException)) {
                CacheManagerTopologyPanel.this.appContext.log((Throwable)e);
            }
        }
    }
}

